/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.inspector2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetConfigurationResponse extends Inspector2Response implements
        ToCopyableBuilder<GetConfigurationResponse.Builder, GetConfigurationResponse> {
    private static final SdkField<Ec2ConfigurationState> EC2_CONFIGURATION_FIELD = SdkField
            .<Ec2ConfigurationState> builder(MarshallingType.SDK_POJO).memberName("ec2Configuration")
            .getter(getter(GetConfigurationResponse::ec2Configuration)).setter(setter(Builder::ec2Configuration))
            .constructor(Ec2ConfigurationState::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ec2Configuration").build()).build();

    private static final SdkField<EcrConfigurationState> ECR_CONFIGURATION_FIELD = SdkField
            .<EcrConfigurationState> builder(MarshallingType.SDK_POJO).memberName("ecrConfiguration")
            .getter(getter(GetConfigurationResponse::ecrConfiguration)).setter(setter(Builder::ecrConfiguration))
            .constructor(EcrConfigurationState::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ecrConfiguration").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EC2_CONFIGURATION_FIELD,
            ECR_CONFIGURATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final Ec2ConfigurationState ec2Configuration;

    private final EcrConfigurationState ecrConfiguration;

    private GetConfigurationResponse(BuilderImpl builder) {
        super(builder);
        this.ec2Configuration = builder.ec2Configuration;
        this.ecrConfiguration = builder.ecrConfiguration;
    }

    /**
     * <p>
     * Specifies how the Amazon EC2 automated scan mode is currently configured for your environment.
     * </p>
     * 
     * @return Specifies how the Amazon EC2 automated scan mode is currently configured for your environment.
     */
    public final Ec2ConfigurationState ec2Configuration() {
        return ec2Configuration;
    }

    /**
     * <p>
     * Specifies how the ECR automated re-scan duration is currently configured for your environment.
     * </p>
     * 
     * @return Specifies how the ECR automated re-scan duration is currently configured for your environment.
     */
    public final EcrConfigurationState ecrConfiguration() {
        return ecrConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(ec2Configuration());
        hashCode = 31 * hashCode + Objects.hashCode(ecrConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetConfigurationResponse)) {
            return false;
        }
        GetConfigurationResponse other = (GetConfigurationResponse) obj;
        return Objects.equals(ec2Configuration(), other.ec2Configuration())
                && Objects.equals(ecrConfiguration(), other.ecrConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetConfigurationResponse").add("Ec2Configuration", ec2Configuration())
                .add("EcrConfiguration", ecrConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ec2Configuration":
            return Optional.ofNullable(clazz.cast(ec2Configuration()));
        case "ecrConfiguration":
            return Optional.ofNullable(clazz.cast(ecrConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ec2Configuration", EC2_CONFIGURATION_FIELD);
        map.put("ecrConfiguration", ECR_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetConfigurationResponse, T> g) {
        return obj -> g.apply((GetConfigurationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Inspector2Response.Builder, SdkPojo, CopyableBuilder<Builder, GetConfigurationResponse> {
        /**
         * <p>
         * Specifies how the Amazon EC2 automated scan mode is currently configured for your environment.
         * </p>
         * 
         * @param ec2Configuration
         *        Specifies how the Amazon EC2 automated scan mode is currently configured for your environment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ec2Configuration(Ec2ConfigurationState ec2Configuration);

        /**
         * <p>
         * Specifies how the Amazon EC2 automated scan mode is currently configured for your environment.
         * </p>
         * This is a convenience method that creates an instance of the {@link Ec2ConfigurationState.Builder} avoiding
         * the need to create one manually via {@link Ec2ConfigurationState#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Ec2ConfigurationState.Builder#build()} is called immediately and
         * its result is passed to {@link #ec2Configuration(Ec2ConfigurationState)}.
         * 
         * @param ec2Configuration
         *        a consumer that will call methods on {@link Ec2ConfigurationState.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ec2Configuration(Ec2ConfigurationState)
         */
        default Builder ec2Configuration(Consumer<Ec2ConfigurationState.Builder> ec2Configuration) {
            return ec2Configuration(Ec2ConfigurationState.builder().applyMutation(ec2Configuration).build());
        }

        /**
         * <p>
         * Specifies how the ECR automated re-scan duration is currently configured for your environment.
         * </p>
         * 
         * @param ecrConfiguration
         *        Specifies how the ECR automated re-scan duration is currently configured for your environment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ecrConfiguration(EcrConfigurationState ecrConfiguration);

        /**
         * <p>
         * Specifies how the ECR automated re-scan duration is currently configured for your environment.
         * </p>
         * This is a convenience method that creates an instance of the {@link EcrConfigurationState.Builder} avoiding
         * the need to create one manually via {@link EcrConfigurationState#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link EcrConfigurationState.Builder#build()} is called immediately and
         * its result is passed to {@link #ecrConfiguration(EcrConfigurationState)}.
         * 
         * @param ecrConfiguration
         *        a consumer that will call methods on {@link EcrConfigurationState.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ecrConfiguration(EcrConfigurationState)
         */
        default Builder ecrConfiguration(Consumer<EcrConfigurationState.Builder> ecrConfiguration) {
            return ecrConfiguration(EcrConfigurationState.builder().applyMutation(ecrConfiguration).build());
        }
    }

    static final class BuilderImpl extends Inspector2Response.BuilderImpl implements Builder {
        private Ec2ConfigurationState ec2Configuration;

        private EcrConfigurationState ecrConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(GetConfigurationResponse model) {
            super(model);
            ec2Configuration(model.ec2Configuration);
            ecrConfiguration(model.ecrConfiguration);
        }

        public final Ec2ConfigurationState.Builder getEc2Configuration() {
            return ec2Configuration != null ? ec2Configuration.toBuilder() : null;
        }

        public final void setEc2Configuration(Ec2ConfigurationState.BuilderImpl ec2Configuration) {
            this.ec2Configuration = ec2Configuration != null ? ec2Configuration.build() : null;
        }

        @Override
        public final Builder ec2Configuration(Ec2ConfigurationState ec2Configuration) {
            this.ec2Configuration = ec2Configuration;
            return this;
        }

        public final EcrConfigurationState.Builder getEcrConfiguration() {
            return ecrConfiguration != null ? ecrConfiguration.toBuilder() : null;
        }

        public final void setEcrConfiguration(EcrConfigurationState.BuilderImpl ecrConfiguration) {
            this.ecrConfiguration = ecrConfiguration != null ? ecrConfiguration.build() : null;
        }

        @Override
        public final Builder ecrConfiguration(EcrConfigurationState ecrConfiguration) {
            this.ecrConfiguration = ecrConfiguration;
            return this;
        }

        @Override
        public GetConfigurationResponse build() {
            return new GetConfigurationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
