/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.inspector2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetSbomExportResponse extends Inspector2Response implements
        ToCopyableBuilder<GetSbomExportResponse.Builder, GetSbomExportResponse> {
    private static final SdkField<String> ERROR_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("errorCode").getter(getter(GetSbomExportResponse::errorCodeAsString)).setter(setter(Builder::errorCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errorCode").build()).build();

    private static final SdkField<String> ERROR_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("errorMessage").getter(getter(GetSbomExportResponse::errorMessage)).setter(setter(Builder::errorMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errorMessage").build()).build();

    private static final SdkField<ResourceFilterCriteria> FILTER_CRITERIA_FIELD = SdkField
            .<ResourceFilterCriteria> builder(MarshallingType.SDK_POJO).memberName("filterCriteria")
            .getter(getter(GetSbomExportResponse::filterCriteria)).setter(setter(Builder::filterCriteria))
            .constructor(ResourceFilterCriteria::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filterCriteria").build()).build();

    private static final SdkField<String> FORMAT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("format")
            .getter(getter(GetSbomExportResponse::formatAsString)).setter(setter(Builder::format))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("format").build()).build();

    private static final SdkField<String> REPORT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("reportId").getter(getter(GetSbomExportResponse::reportId)).setter(setter(Builder::reportId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("reportId").build()).build();

    private static final SdkField<Destination> S3_DESTINATION_FIELD = SdkField.<Destination> builder(MarshallingType.SDK_POJO)
            .memberName("s3Destination").getter(getter(GetSbomExportResponse::s3Destination))
            .setter(setter(Builder::s3Destination)).constructor(Destination::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("s3Destination").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(GetSbomExportResponse::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ERROR_CODE_FIELD,
            ERROR_MESSAGE_FIELD, FILTER_CRITERIA_FIELD, FORMAT_FIELD, REPORT_ID_FIELD, S3_DESTINATION_FIELD, STATUS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String errorCode;

    private final String errorMessage;

    private final ResourceFilterCriteria filterCriteria;

    private final String format;

    private final String reportId;

    private final Destination s3Destination;

    private final String status;

    private GetSbomExportResponse(BuilderImpl builder) {
        super(builder);
        this.errorCode = builder.errorCode;
        this.errorMessage = builder.errorMessage;
        this.filterCriteria = builder.filterCriteria;
        this.format = builder.format;
        this.reportId = builder.reportId;
        this.s3Destination = builder.s3Destination;
        this.status = builder.status;
    }

    /**
     * <p>
     * An error code.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #errorCode} will
     * return {@link ReportingErrorCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #errorCodeAsString}.
     * </p>
     * 
     * @return An error code.
     * @see ReportingErrorCode
     */
    public final ReportingErrorCode errorCode() {
        return ReportingErrorCode.fromValue(errorCode);
    }

    /**
     * <p>
     * An error code.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #errorCode} will
     * return {@link ReportingErrorCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #errorCodeAsString}.
     * </p>
     * 
     * @return An error code.
     * @see ReportingErrorCode
     */
    public final String errorCodeAsString() {
        return errorCode;
    }

    /**
     * <p>
     * An error message.
     * </p>
     * 
     * @return An error message.
     */
    public final String errorMessage() {
        return errorMessage;
    }

    /**
     * <p>
     * Contains details about the resource filter criteria used for the software bill of materials (SBOM) report.
     * </p>
     * 
     * @return Contains details about the resource filter criteria used for the software bill of materials (SBOM)
     *         report.
     */
    public final ResourceFilterCriteria filterCriteria() {
        return filterCriteria;
    }

    /**
     * <p>
     * The format of the software bill of materials (SBOM) report.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #format} will
     * return {@link SbomReportFormat#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #formatAsString}.
     * </p>
     * 
     * @return The format of the software bill of materials (SBOM) report.
     * @see SbomReportFormat
     */
    public final SbomReportFormat format() {
        return SbomReportFormat.fromValue(format);
    }

    /**
     * <p>
     * The format of the software bill of materials (SBOM) report.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #format} will
     * return {@link SbomReportFormat#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #formatAsString}.
     * </p>
     * 
     * @return The format of the software bill of materials (SBOM) report.
     * @see SbomReportFormat
     */
    public final String formatAsString() {
        return format;
    }

    /**
     * <p>
     * The report ID of the software bill of materials (SBOM) report.
     * </p>
     * 
     * @return The report ID of the software bill of materials (SBOM) report.
     */
    public final String reportId() {
        return reportId;
    }

    /**
     * <p>
     * Contains details of the Amazon S3 bucket and KMS key used to export findings
     * </p>
     * 
     * @return Contains details of the Amazon S3 bucket and KMS key used to export findings
     */
    public final Destination s3Destination() {
        return s3Destination;
    }

    /**
     * <p>
     * The status of the software bill of materials (SBOM) report.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ExternalReportStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the software bill of materials (SBOM) report.
     * @see ExternalReportStatus
     */
    public final ExternalReportStatus status() {
        return ExternalReportStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the software bill of materials (SBOM) report.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ExternalReportStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the software bill of materials (SBOM) report.
     * @see ExternalReportStatus
     */
    public final String statusAsString() {
        return status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(errorCodeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(errorMessage());
        hashCode = 31 * hashCode + Objects.hashCode(filterCriteria());
        hashCode = 31 * hashCode + Objects.hashCode(formatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(reportId());
        hashCode = 31 * hashCode + Objects.hashCode(s3Destination());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetSbomExportResponse)) {
            return false;
        }
        GetSbomExportResponse other = (GetSbomExportResponse) obj;
        return Objects.equals(errorCodeAsString(), other.errorCodeAsString())
                && Objects.equals(errorMessage(), other.errorMessage())
                && Objects.equals(filterCriteria(), other.filterCriteria())
                && Objects.equals(formatAsString(), other.formatAsString()) && Objects.equals(reportId(), other.reportId())
                && Objects.equals(s3Destination(), other.s3Destination())
                && Objects.equals(statusAsString(), other.statusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetSbomExportResponse").add("ErrorCode", errorCodeAsString())
                .add("ErrorMessage", errorMessage()).add("FilterCriteria", filterCriteria()).add("Format", formatAsString())
                .add("ReportId", reportId()).add("S3Destination", s3Destination()).add("Status", statusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "errorCode":
            return Optional.ofNullable(clazz.cast(errorCodeAsString()));
        case "errorMessage":
            return Optional.ofNullable(clazz.cast(errorMessage()));
        case "filterCriteria":
            return Optional.ofNullable(clazz.cast(filterCriteria()));
        case "format":
            return Optional.ofNullable(clazz.cast(formatAsString()));
        case "reportId":
            return Optional.ofNullable(clazz.cast(reportId()));
        case "s3Destination":
            return Optional.ofNullable(clazz.cast(s3Destination()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("errorCode", ERROR_CODE_FIELD);
        map.put("errorMessage", ERROR_MESSAGE_FIELD);
        map.put("filterCriteria", FILTER_CRITERIA_FIELD);
        map.put("format", FORMAT_FIELD);
        map.put("reportId", REPORT_ID_FIELD);
        map.put("s3Destination", S3_DESTINATION_FIELD);
        map.put("status", STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetSbomExportResponse, T> g) {
        return obj -> g.apply((GetSbomExportResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Inspector2Response.Builder, SdkPojo, CopyableBuilder<Builder, GetSbomExportResponse> {
        /**
         * <p>
         * An error code.
         * </p>
         * 
         * @param errorCode
         *        An error code.
         * @see ReportingErrorCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ReportingErrorCode
         */
        Builder errorCode(String errorCode);

        /**
         * <p>
         * An error code.
         * </p>
         * 
         * @param errorCode
         *        An error code.
         * @see ReportingErrorCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ReportingErrorCode
         */
        Builder errorCode(ReportingErrorCode errorCode);

        /**
         * <p>
         * An error message.
         * </p>
         * 
         * @param errorMessage
         *        An error message.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errorMessage(String errorMessage);

        /**
         * <p>
         * Contains details about the resource filter criteria used for the software bill of materials (SBOM) report.
         * </p>
         * 
         * @param filterCriteria
         *        Contains details about the resource filter criteria used for the software bill of materials (SBOM)
         *        report.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filterCriteria(ResourceFilterCriteria filterCriteria);

        /**
         * <p>
         * Contains details about the resource filter criteria used for the software bill of materials (SBOM) report.
         * </p>
         * This is a convenience method that creates an instance of the {@link ResourceFilterCriteria.Builder} avoiding
         * the need to create one manually via {@link ResourceFilterCriteria#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ResourceFilterCriteria.Builder#build()} is called immediately and
         * its result is passed to {@link #filterCriteria(ResourceFilterCriteria)}.
         * 
         * @param filterCriteria
         *        a consumer that will call methods on {@link ResourceFilterCriteria.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #filterCriteria(ResourceFilterCriteria)
         */
        default Builder filterCriteria(Consumer<ResourceFilterCriteria.Builder> filterCriteria) {
            return filterCriteria(ResourceFilterCriteria.builder().applyMutation(filterCriteria).build());
        }

        /**
         * <p>
         * The format of the software bill of materials (SBOM) report.
         * </p>
         * 
         * @param format
         *        The format of the software bill of materials (SBOM) report.
         * @see SbomReportFormat
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SbomReportFormat
         */
        Builder format(String format);

        /**
         * <p>
         * The format of the software bill of materials (SBOM) report.
         * </p>
         * 
         * @param format
         *        The format of the software bill of materials (SBOM) report.
         * @see SbomReportFormat
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SbomReportFormat
         */
        Builder format(SbomReportFormat format);

        /**
         * <p>
         * The report ID of the software bill of materials (SBOM) report.
         * </p>
         * 
         * @param reportId
         *        The report ID of the software bill of materials (SBOM) report.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reportId(String reportId);

        /**
         * <p>
         * Contains details of the Amazon S3 bucket and KMS key used to export findings
         * </p>
         * 
         * @param s3Destination
         *        Contains details of the Amazon S3 bucket and KMS key used to export findings
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3Destination(Destination s3Destination);

        /**
         * <p>
         * Contains details of the Amazon S3 bucket and KMS key used to export findings
         * </p>
         * This is a convenience method that creates an instance of the {@link Destination.Builder} avoiding the need to
         * create one manually via {@link Destination#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Destination.Builder#build()} is called immediately and its result
         * is passed to {@link #s3Destination(Destination)}.
         * 
         * @param s3Destination
         *        a consumer that will call methods on {@link Destination.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #s3Destination(Destination)
         */
        default Builder s3Destination(Consumer<Destination.Builder> s3Destination) {
            return s3Destination(Destination.builder().applyMutation(s3Destination).build());
        }

        /**
         * <p>
         * The status of the software bill of materials (SBOM) report.
         * </p>
         * 
         * @param status
         *        The status of the software bill of materials (SBOM) report.
         * @see ExternalReportStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ExternalReportStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the software bill of materials (SBOM) report.
         * </p>
         * 
         * @param status
         *        The status of the software bill of materials (SBOM) report.
         * @see ExternalReportStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ExternalReportStatus
         */
        Builder status(ExternalReportStatus status);
    }

    static final class BuilderImpl extends Inspector2Response.BuilderImpl implements Builder {
        private String errorCode;

        private String errorMessage;

        private ResourceFilterCriteria filterCriteria;

        private String format;

        private String reportId;

        private Destination s3Destination;

        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(GetSbomExportResponse model) {
            super(model);
            errorCode(model.errorCode);
            errorMessage(model.errorMessage);
            filterCriteria(model.filterCriteria);
            format(model.format);
            reportId(model.reportId);
            s3Destination(model.s3Destination);
            status(model.status);
        }

        public final String getErrorCode() {
            return errorCode;
        }

        public final void setErrorCode(String errorCode) {
            this.errorCode = errorCode;
        }

        @Override
        public final Builder errorCode(String errorCode) {
            this.errorCode = errorCode;
            return this;
        }

        @Override
        public final Builder errorCode(ReportingErrorCode errorCode) {
            this.errorCode(errorCode == null ? null : errorCode.toString());
            return this;
        }

        public final String getErrorMessage() {
            return errorMessage;
        }

        public final void setErrorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
        }

        @Override
        public final Builder errorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
            return this;
        }

        public final ResourceFilterCriteria.Builder getFilterCriteria() {
            return filterCriteria != null ? filterCriteria.toBuilder() : null;
        }

        public final void setFilterCriteria(ResourceFilterCriteria.BuilderImpl filterCriteria) {
            this.filterCriteria = filterCriteria != null ? filterCriteria.build() : null;
        }

        @Override
        public final Builder filterCriteria(ResourceFilterCriteria filterCriteria) {
            this.filterCriteria = filterCriteria;
            return this;
        }

        public final String getFormat() {
            return format;
        }

        public final void setFormat(String format) {
            this.format = format;
        }

        @Override
        public final Builder format(String format) {
            this.format = format;
            return this;
        }

        @Override
        public final Builder format(SbomReportFormat format) {
            this.format(format == null ? null : format.toString());
            return this;
        }

        public final String getReportId() {
            return reportId;
        }

        public final void setReportId(String reportId) {
            this.reportId = reportId;
        }

        @Override
        public final Builder reportId(String reportId) {
            this.reportId = reportId;
            return this;
        }

        public final Destination.Builder getS3Destination() {
            return s3Destination != null ? s3Destination.toBuilder() : null;
        }

        public final void setS3Destination(Destination.BuilderImpl s3Destination) {
            this.s3Destination = s3Destination != null ? s3Destination.build() : null;
        }

        @Override
        public final Builder s3Destination(Destination s3Destination) {
            this.s3Destination = s3Destination;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ExternalReportStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        @Override
        public GetSbomExportResponse build() {
            return new GetSbomExportResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
