/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.inspector2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about the Amazon Inspector score given to a finding.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class InspectorScoreDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<InspectorScoreDetails.Builder, InspectorScoreDetails> {
    private static final SdkField<CvssScoreDetails> ADJUSTED_CVSS_FIELD = SdkField
            .<CvssScoreDetails> builder(MarshallingType.SDK_POJO).memberName("adjustedCvss")
            .getter(getter(InspectorScoreDetails::adjustedCvss)).setter(setter(Builder::adjustedCvss))
            .constructor(CvssScoreDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("adjustedCvss").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ADJUSTED_CVSS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final CvssScoreDetails adjustedCvss;

    private InspectorScoreDetails(BuilderImpl builder) {
        this.adjustedCvss = builder.adjustedCvss;
    }

    /**
     * <p>
     * An object that contains details about the CVSS score given to a finding.
     * </p>
     * 
     * @return An object that contains details about the CVSS score given to a finding.
     */
    public final CvssScoreDetails adjustedCvss() {
        return adjustedCvss;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(adjustedCvss());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InspectorScoreDetails)) {
            return false;
        }
        InspectorScoreDetails other = (InspectorScoreDetails) obj;
        return Objects.equals(adjustedCvss(), other.adjustedCvss());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("InspectorScoreDetails").add("AdjustedCvss", adjustedCvss()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "adjustedCvss":
            return Optional.ofNullable(clazz.cast(adjustedCvss()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("adjustedCvss", ADJUSTED_CVSS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<InspectorScoreDetails, T> g) {
        return obj -> g.apply((InspectorScoreDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, InspectorScoreDetails> {
        /**
         * <p>
         * An object that contains details about the CVSS score given to a finding.
         * </p>
         * 
         * @param adjustedCvss
         *        An object that contains details about the CVSS score given to a finding.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder adjustedCvss(CvssScoreDetails adjustedCvss);

        /**
         * <p>
         * An object that contains details about the CVSS score given to a finding.
         * </p>
         * This is a convenience method that creates an instance of the {@link CvssScoreDetails.Builder} avoiding the
         * need to create one manually via {@link CvssScoreDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CvssScoreDetails.Builder#build()} is called immediately and its
         * result is passed to {@link #adjustedCvss(CvssScoreDetails)}.
         * 
         * @param adjustedCvss
         *        a consumer that will call methods on {@link CvssScoreDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #adjustedCvss(CvssScoreDetails)
         */
        default Builder adjustedCvss(Consumer<CvssScoreDetails.Builder> adjustedCvss) {
            return adjustedCvss(CvssScoreDetails.builder().applyMutation(adjustedCvss).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private CvssScoreDetails adjustedCvss;

        private BuilderImpl() {
        }

        private BuilderImpl(InspectorScoreDetails model) {
            adjustedCvss(model.adjustedCvss);
        }

        public final CvssScoreDetails.Builder getAdjustedCvss() {
            return adjustedCvss != null ? adjustedCvss.toBuilder() : null;
        }

        public final void setAdjustedCvss(CvssScoreDetails.BuilderImpl adjustedCvss) {
            this.adjustedCvss = adjustedCvss != null ? adjustedCvss.build() : null;
        }

        @Override
        public final Builder adjustedCvss(CvssScoreDetails adjustedCvss) {
            this.adjustedCvss = adjustedCvss;
            return this;
        }

        @Override
        public InspectorScoreDetails build() {
            return new InspectorScoreDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
