/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.inspector2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The Amazon Web Services Lambda function metadata.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LambdaFunctionMetadata implements SdkPojo, Serializable,
        ToCopyableBuilder<LambdaFunctionMetadata.Builder, LambdaFunctionMetadata> {
    private static final SdkField<String> FUNCTION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("functionName").getter(getter(LambdaFunctionMetadata::functionName))
            .setter(setter(Builder::functionName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("functionName").build()).build();

    private static final SdkField<Map<String, String>> FUNCTION_TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("functionTags")
            .getter(getter(LambdaFunctionMetadata::functionTags))
            .setter(setter(Builder::functionTags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("functionTags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<List<String>> LAYERS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("layers")
            .getter(getter(LambdaFunctionMetadata::layers))
            .setter(setter(Builder::layers))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("layers").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> RUNTIME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("runtime")
            .getter(getter(LambdaFunctionMetadata::runtimeAsString)).setter(setter(Builder::runtime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("runtime").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FUNCTION_NAME_FIELD,
            FUNCTION_TAGS_FIELD, LAYERS_FIELD, RUNTIME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String functionName;

    private final Map<String, String> functionTags;

    private final List<String> layers;

    private final String runtime;

    private LambdaFunctionMetadata(BuilderImpl builder) {
        this.functionName = builder.functionName;
        this.functionTags = builder.functionTags;
        this.layers = builder.layers;
        this.runtime = builder.runtime;
    }

    /**
     * <p>
     * The name of a function.
     * </p>
     * 
     * @return The name of a function.
     */
    public final String functionName() {
        return functionName;
    }

    /**
     * For responses, this returns true if the service returned a value for the FunctionTags property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasFunctionTags() {
        return functionTags != null && !(functionTags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The resource tags on an Amazon Web Services Lambda function.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFunctionTags} method.
     * </p>
     * 
     * @return The resource tags on an Amazon Web Services Lambda function.
     */
    public final Map<String, String> functionTags() {
        return functionTags;
    }

    /**
     * For responses, this returns true if the service returned a value for the Layers property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasLayers() {
        return layers != null && !(layers instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The layers for an Amazon Web Services Lambda function. A Lambda function can have up to five layers.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasLayers} method.
     * </p>
     * 
     * @return The layers for an Amazon Web Services Lambda function. A Lambda function can have up to five layers.
     */
    public final List<String> layers() {
        return layers;
    }

    /**
     * <p>
     * An Amazon Web Services Lambda function's runtime.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #runtime} will
     * return {@link Runtime#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #runtimeAsString}.
     * </p>
     * 
     * @return An Amazon Web Services Lambda function's runtime.
     * @see Runtime
     */
    public final Runtime runtime() {
        return Runtime.fromValue(runtime);
    }

    /**
     * <p>
     * An Amazon Web Services Lambda function's runtime.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #runtime} will
     * return {@link Runtime#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #runtimeAsString}.
     * </p>
     * 
     * @return An Amazon Web Services Lambda function's runtime.
     * @see Runtime
     */
    public final String runtimeAsString() {
        return runtime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(functionName());
        hashCode = 31 * hashCode + Objects.hashCode(hasFunctionTags() ? functionTags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasLayers() ? layers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(runtimeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LambdaFunctionMetadata)) {
            return false;
        }
        LambdaFunctionMetadata other = (LambdaFunctionMetadata) obj;
        return Objects.equals(functionName(), other.functionName()) && hasFunctionTags() == other.hasFunctionTags()
                && Objects.equals(functionTags(), other.functionTags()) && hasLayers() == other.hasLayers()
                && Objects.equals(layers(), other.layers()) && Objects.equals(runtimeAsString(), other.runtimeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("LambdaFunctionMetadata").add("FunctionName", functionName())
                .add("FunctionTags", hasFunctionTags() ? functionTags() : null).add("Layers", hasLayers() ? layers() : null)
                .add("Runtime", runtimeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "functionName":
            return Optional.ofNullable(clazz.cast(functionName()));
        case "functionTags":
            return Optional.ofNullable(clazz.cast(functionTags()));
        case "layers":
            return Optional.ofNullable(clazz.cast(layers()));
        case "runtime":
            return Optional.ofNullable(clazz.cast(runtimeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("functionName", FUNCTION_NAME_FIELD);
        map.put("functionTags", FUNCTION_TAGS_FIELD);
        map.put("layers", LAYERS_FIELD);
        map.put("runtime", RUNTIME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<LambdaFunctionMetadata, T> g) {
        return obj -> g.apply((LambdaFunctionMetadata) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LambdaFunctionMetadata> {
        /**
         * <p>
         * The name of a function.
         * </p>
         * 
         * @param functionName
         *        The name of a function.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder functionName(String functionName);

        /**
         * <p>
         * The resource tags on an Amazon Web Services Lambda function.
         * </p>
         * 
         * @param functionTags
         *        The resource tags on an Amazon Web Services Lambda function.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder functionTags(Map<String, String> functionTags);

        /**
         * <p>
         * The layers for an Amazon Web Services Lambda function. A Lambda function can have up to five layers.
         * </p>
         * 
         * @param layers
         *        The layers for an Amazon Web Services Lambda function. A Lambda function can have up to five layers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder layers(Collection<String> layers);

        /**
         * <p>
         * The layers for an Amazon Web Services Lambda function. A Lambda function can have up to five layers.
         * </p>
         * 
         * @param layers
         *        The layers for an Amazon Web Services Lambda function. A Lambda function can have up to five layers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder layers(String... layers);

        /**
         * <p>
         * An Amazon Web Services Lambda function's runtime.
         * </p>
         * 
         * @param runtime
         *        An Amazon Web Services Lambda function's runtime.
         * @see Runtime
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Runtime
         */
        Builder runtime(String runtime);

        /**
         * <p>
         * An Amazon Web Services Lambda function's runtime.
         * </p>
         * 
         * @param runtime
         *        An Amazon Web Services Lambda function's runtime.
         * @see Runtime
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Runtime
         */
        Builder runtime(Runtime runtime);
    }

    static final class BuilderImpl implements Builder {
        private String functionName;

        private Map<String, String> functionTags = DefaultSdkAutoConstructMap.getInstance();

        private List<String> layers = DefaultSdkAutoConstructList.getInstance();

        private String runtime;

        private BuilderImpl() {
        }

        private BuilderImpl(LambdaFunctionMetadata model) {
            functionName(model.functionName);
            functionTags(model.functionTags);
            layers(model.layers);
            runtime(model.runtime);
        }

        public final String getFunctionName() {
            return functionName;
        }

        public final void setFunctionName(String functionName) {
            this.functionName = functionName;
        }

        @Override
        public final Builder functionName(String functionName) {
            this.functionName = functionName;
            return this;
        }

        public final Map<String, String> getFunctionTags() {
            if (functionTags instanceof SdkAutoConstructMap) {
                return null;
            }
            return functionTags;
        }

        public final void setFunctionTags(Map<String, String> functionTags) {
            this.functionTags = TagMapCopier.copy(functionTags);
        }

        @Override
        public final Builder functionTags(Map<String, String> functionTags) {
            this.functionTags = TagMapCopier.copy(functionTags);
            return this;
        }

        public final Collection<String> getLayers() {
            if (layers instanceof SdkAutoConstructList) {
                return null;
            }
            return layers;
        }

        public final void setLayers(Collection<String> layers) {
            this.layers = LambdaLayerListCopier.copy(layers);
        }

        @Override
        public final Builder layers(Collection<String> layers) {
            this.layers = LambdaLayerListCopier.copy(layers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder layers(String... layers) {
            layers(Arrays.asList(layers));
            return this;
        }

        public final String getRuntime() {
            return runtime;
        }

        public final void setRuntime(String runtime) {
            this.runtime = runtime;
        }

        @Override
        public final Builder runtime(String runtime) {
            this.runtime = runtime;
            return this;
        }

        @Override
        public final Builder runtime(Runtime runtime) {
            this.runtime(runtime == null ? null : runtime.toString());
            return this;
        }

        @Override
        public LambdaFunctionMetadata build() {
            return new LambdaFunctionMetadata(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
