/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.inspector2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListAccountPermissionsResponse extends Inspector2Response implements
        ToCopyableBuilder<ListAccountPermissionsResponse.Builder, ListAccountPermissionsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListAccountPermissionsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final SdkField<List<Permission>> PERMISSIONS_FIELD = SdkField
            .<List<Permission>> builder(MarshallingType.LIST)
            .memberName("permissions")
            .getter(getter(ListAccountPermissionsResponse::permissions))
            .setter(setter(Builder::permissions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("permissions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Permission> builder(MarshallingType.SDK_POJO)
                                            .constructor(Permission::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD,
            PERMISSIONS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String nextToken;

    private final List<Permission> permissions;

    private ListAccountPermissionsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.permissions = builder.permissions;
    }

    /**
     * <p>
     * A token to use for paginating results that are returned in the response. Set the value of this parameter to null
     * for the first request to a list action. For subsequent calls, use the <code>NextToken</code> value returned from
     * the previous request to continue listing results after the first page.
     * </p>
     * 
     * @return A token to use for paginating results that are returned in the response. Set the value of this parameter
     *         to null for the first request to a list action. For subsequent calls, use the <code>NextToken</code>
     *         value returned from the previous request to continue listing results after the first page.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the Permissions property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasPermissions() {
        return permissions != null && !(permissions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Contains details on the permissions an account has to configure Amazon Inspector.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPermissions} method.
     * </p>
     * 
     * @return Contains details on the permissions an account has to configure Amazon Inspector.
     */
    public final List<Permission> permissions() {
        return permissions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasPermissions() ? permissions() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAccountPermissionsResponse)) {
            return false;
        }
        ListAccountPermissionsResponse other = (ListAccountPermissionsResponse) obj;
        return Objects.equals(nextToken(), other.nextToken()) && hasPermissions() == other.hasPermissions()
                && Objects.equals(permissions(), other.permissions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListAccountPermissionsResponse").add("NextToken", nextToken())
                .add("Permissions", hasPermissions() ? permissions() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "permissions":
            return Optional.ofNullable(clazz.cast(permissions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("permissions", PERMISSIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListAccountPermissionsResponse, T> g) {
        return obj -> g.apply((ListAccountPermissionsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Inspector2Response.Builder, SdkPojo,
            CopyableBuilder<Builder, ListAccountPermissionsResponse> {
        /**
         * <p>
         * A token to use for paginating results that are returned in the response. Set the value of this parameter to
         * null for the first request to a list action. For subsequent calls, use the <code>NextToken</code> value
         * returned from the previous request to continue listing results after the first page.
         * </p>
         * 
         * @param nextToken
         *        A token to use for paginating results that are returned in the response. Set the value of this
         *        parameter to null for the first request to a list action. For subsequent calls, use the
         *        <code>NextToken</code> value returned from the previous request to continue listing results after the
         *        first page.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * Contains details on the permissions an account has to configure Amazon Inspector.
         * </p>
         * 
         * @param permissions
         *        Contains details on the permissions an account has to configure Amazon Inspector.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder permissions(Collection<Permission> permissions);

        /**
         * <p>
         * Contains details on the permissions an account has to configure Amazon Inspector.
         * </p>
         * 
         * @param permissions
         *        Contains details on the permissions an account has to configure Amazon Inspector.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder permissions(Permission... permissions);

        /**
         * <p>
         * Contains details on the permissions an account has to configure Amazon Inspector.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.inspector2.model.Permission.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.inspector2.model.Permission#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.inspector2.model.Permission.Builder#build()} is called immediately and
         * its result is passed to {@link #permissions(List<Permission>)}.
         * 
         * @param permissions
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.inspector2.model.Permission.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #permissions(java.util.Collection<Permission>)
         */
        Builder permissions(Consumer<Permission.Builder>... permissions);
    }

    static final class BuilderImpl extends Inspector2Response.BuilderImpl implements Builder {
        private String nextToken;

        private List<Permission> permissions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListAccountPermissionsResponse model) {
            super(model);
            nextToken(model.nextToken);
            permissions(model.permissions);
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<Permission.Builder> getPermissions() {
            List<Permission.Builder> result = PermissionsCopier.copyToBuilder(this.permissions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPermissions(Collection<Permission.BuilderImpl> permissions) {
            this.permissions = PermissionsCopier.copyFromBuilder(permissions);
        }

        @Override
        public final Builder permissions(Collection<Permission> permissions) {
            this.permissions = PermissionsCopier.copy(permissions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder permissions(Permission... permissions) {
            permissions(Arrays.asList(permissions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder permissions(Consumer<Permission.Builder>... permissions) {
            permissions(Stream.of(permissions).map(c -> Permission.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListAccountPermissionsResponse build() {
            return new ListAccountPermissionsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
