/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.inspector2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListCisScansRequest extends Inspector2Request implements
        ToCopyableBuilder<ListCisScansRequest.Builder, ListCisScansRequest> {
    private static final SdkField<String> DETAIL_LEVEL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("detailLevel").getter(getter(ListCisScansRequest::detailLevelAsString))
            .setter(setter(Builder::detailLevel))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("detailLevel").build()).build();

    private static final SdkField<ListCisScansFilterCriteria> FILTER_CRITERIA_FIELD = SdkField
            .<ListCisScansFilterCriteria> builder(MarshallingType.SDK_POJO).memberName("filterCriteria")
            .getter(getter(ListCisScansRequest::filterCriteria)).setter(setter(Builder::filterCriteria))
            .constructor(ListCisScansFilterCriteria::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filterCriteria").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxResults").getter(getter(ListCisScansRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxResults").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListCisScansRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final SdkField<String> SORT_BY_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("sortBy")
            .getter(getter(ListCisScansRequest::sortByAsString)).setter(setter(Builder::sortBy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sortBy").build()).build();

    private static final SdkField<String> SORT_ORDER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("sortOrder").getter(getter(ListCisScansRequest::sortOrderAsString)).setter(setter(Builder::sortOrder))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sortOrder").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DETAIL_LEVEL_FIELD,
            FILTER_CRITERIA_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD, SORT_BY_FIELD, SORT_ORDER_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String detailLevel;

    private final ListCisScansFilterCriteria filterCriteria;

    private final Integer maxResults;

    private final String nextToken;

    private final String sortBy;

    private final String sortOrder;

    private ListCisScansRequest(BuilderImpl builder) {
        super(builder);
        this.detailLevel = builder.detailLevel;
        this.filterCriteria = builder.filterCriteria;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
        this.sortBy = builder.sortBy;
        this.sortOrder = builder.sortOrder;
    }

    /**
     * <p>
     * The detail applied to the CIS scan.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #detailLevel} will
     * return {@link ListCisScansDetailLevel#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #detailLevelAsString}.
     * </p>
     * 
     * @return The detail applied to the CIS scan.
     * @see ListCisScansDetailLevel
     */
    public final ListCisScansDetailLevel detailLevel() {
        return ListCisScansDetailLevel.fromValue(detailLevel);
    }

    /**
     * <p>
     * The detail applied to the CIS scan.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #detailLevel} will
     * return {@link ListCisScansDetailLevel#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #detailLevelAsString}.
     * </p>
     * 
     * @return The detail applied to the CIS scan.
     * @see ListCisScansDetailLevel
     */
    public final String detailLevelAsString() {
        return detailLevel;
    }

    /**
     * <p>
     * The CIS scan filter criteria.
     * </p>
     * 
     * @return The CIS scan filter criteria.
     */
    public final ListCisScansFilterCriteria filterCriteria() {
        return filterCriteria;
    }

    /**
     * <p>
     * The maximum number of results to be returned.
     * </p>
     * 
     * @return The maximum number of results to be returned.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * The pagination token from a previous request that's used to retrieve the next page of results.
     * </p>
     * 
     * @return The pagination token from a previous request that's used to retrieve the next page of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The CIS scans sort by order.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sortBy} will
     * return {@link ListCisScansSortBy#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #sortByAsString}.
     * </p>
     * 
     * @return The CIS scans sort by order.
     * @see ListCisScansSortBy
     */
    public final ListCisScansSortBy sortBy() {
        return ListCisScansSortBy.fromValue(sortBy);
    }

    /**
     * <p>
     * The CIS scans sort by order.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sortBy} will
     * return {@link ListCisScansSortBy#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #sortByAsString}.
     * </p>
     * 
     * @return The CIS scans sort by order.
     * @see ListCisScansSortBy
     */
    public final String sortByAsString() {
        return sortBy;
    }

    /**
     * <p>
     * The CIS scans sort order.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sortOrder} will
     * return {@link CisSortOrder#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #sortOrderAsString}.
     * </p>
     * 
     * @return The CIS scans sort order.
     * @see CisSortOrder
     */
    public final CisSortOrder sortOrder() {
        return CisSortOrder.fromValue(sortOrder);
    }

    /**
     * <p>
     * The CIS scans sort order.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sortOrder} will
     * return {@link CisSortOrder#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #sortOrderAsString}.
     * </p>
     * 
     * @return The CIS scans sort order.
     * @see CisSortOrder
     */
    public final String sortOrderAsString() {
        return sortOrder;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(detailLevelAsString());
        hashCode = 31 * hashCode + Objects.hashCode(filterCriteria());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(sortByAsString());
        hashCode = 31 * hashCode + Objects.hashCode(sortOrderAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListCisScansRequest)) {
            return false;
        }
        ListCisScansRequest other = (ListCisScansRequest) obj;
        return Objects.equals(detailLevelAsString(), other.detailLevelAsString())
                && Objects.equals(filterCriteria(), other.filterCriteria()) && Objects.equals(maxResults(), other.maxResults())
                && Objects.equals(nextToken(), other.nextToken()) && Objects.equals(sortByAsString(), other.sortByAsString())
                && Objects.equals(sortOrderAsString(), other.sortOrderAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListCisScansRequest").add("DetailLevel", detailLevelAsString())
                .add("FilterCriteria", filterCriteria()).add("MaxResults", maxResults()).add("NextToken", nextToken())
                .add("SortBy", sortByAsString()).add("SortOrder", sortOrderAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "detailLevel":
            return Optional.ofNullable(clazz.cast(detailLevelAsString()));
        case "filterCriteria":
            return Optional.ofNullable(clazz.cast(filterCriteria()));
        case "maxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "sortBy":
            return Optional.ofNullable(clazz.cast(sortByAsString()));
        case "sortOrder":
            return Optional.ofNullable(clazz.cast(sortOrderAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("detailLevel", DETAIL_LEVEL_FIELD);
        map.put("filterCriteria", FILTER_CRITERIA_FIELD);
        map.put("maxResults", MAX_RESULTS_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("sortBy", SORT_BY_FIELD);
        map.put("sortOrder", SORT_ORDER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListCisScansRequest, T> g) {
        return obj -> g.apply((ListCisScansRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Inspector2Request.Builder, SdkPojo, CopyableBuilder<Builder, ListCisScansRequest> {
        /**
         * <p>
         * The detail applied to the CIS scan.
         * </p>
         * 
         * @param detailLevel
         *        The detail applied to the CIS scan.
         * @see ListCisScansDetailLevel
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ListCisScansDetailLevel
         */
        Builder detailLevel(String detailLevel);

        /**
         * <p>
         * The detail applied to the CIS scan.
         * </p>
         * 
         * @param detailLevel
         *        The detail applied to the CIS scan.
         * @see ListCisScansDetailLevel
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ListCisScansDetailLevel
         */
        Builder detailLevel(ListCisScansDetailLevel detailLevel);

        /**
         * <p>
         * The CIS scan filter criteria.
         * </p>
         * 
         * @param filterCriteria
         *        The CIS scan filter criteria.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filterCriteria(ListCisScansFilterCriteria filterCriteria);

        /**
         * <p>
         * The CIS scan filter criteria.
         * </p>
         * This is a convenience method that creates an instance of the {@link ListCisScansFilterCriteria.Builder}
         * avoiding the need to create one manually via {@link ListCisScansFilterCriteria#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ListCisScansFilterCriteria.Builder#build()} is called immediately
         * and its result is passed to {@link #filterCriteria(ListCisScansFilterCriteria)}.
         * 
         * @param filterCriteria
         *        a consumer that will call methods on {@link ListCisScansFilterCriteria.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #filterCriteria(ListCisScansFilterCriteria)
         */
        default Builder filterCriteria(Consumer<ListCisScansFilterCriteria.Builder> filterCriteria) {
            return filterCriteria(ListCisScansFilterCriteria.builder().applyMutation(filterCriteria).build());
        }

        /**
         * <p>
         * The maximum number of results to be returned.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of results to be returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * The pagination token from a previous request that's used to retrieve the next page of results.
         * </p>
         * 
         * @param nextToken
         *        The pagination token from a previous request that's used to retrieve the next page of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The CIS scans sort by order.
         * </p>
         * 
         * @param sortBy
         *        The CIS scans sort by order.
         * @see ListCisScansSortBy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ListCisScansSortBy
         */
        Builder sortBy(String sortBy);

        /**
         * <p>
         * The CIS scans sort by order.
         * </p>
         * 
         * @param sortBy
         *        The CIS scans sort by order.
         * @see ListCisScansSortBy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ListCisScansSortBy
         */
        Builder sortBy(ListCisScansSortBy sortBy);

        /**
         * <p>
         * The CIS scans sort order.
         * </p>
         * 
         * @param sortOrder
         *        The CIS scans sort order.
         * @see CisSortOrder
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CisSortOrder
         */
        Builder sortOrder(String sortOrder);

        /**
         * <p>
         * The CIS scans sort order.
         * </p>
         * 
         * @param sortOrder
         *        The CIS scans sort order.
         * @see CisSortOrder
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CisSortOrder
         */
        Builder sortOrder(CisSortOrder sortOrder);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Inspector2Request.BuilderImpl implements Builder {
        private String detailLevel;

        private ListCisScansFilterCriteria filterCriteria;

        private Integer maxResults;

        private String nextToken;

        private String sortBy;

        private String sortOrder;

        private BuilderImpl() {
        }

        private BuilderImpl(ListCisScansRequest model) {
            super(model);
            detailLevel(model.detailLevel);
            filterCriteria(model.filterCriteria);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
            sortBy(model.sortBy);
            sortOrder(model.sortOrder);
        }

        public final String getDetailLevel() {
            return detailLevel;
        }

        public final void setDetailLevel(String detailLevel) {
            this.detailLevel = detailLevel;
        }

        @Override
        public final Builder detailLevel(String detailLevel) {
            this.detailLevel = detailLevel;
            return this;
        }

        @Override
        public final Builder detailLevel(ListCisScansDetailLevel detailLevel) {
            this.detailLevel(detailLevel == null ? null : detailLevel.toString());
            return this;
        }

        public final ListCisScansFilterCriteria.Builder getFilterCriteria() {
            return filterCriteria != null ? filterCriteria.toBuilder() : null;
        }

        public final void setFilterCriteria(ListCisScansFilterCriteria.BuilderImpl filterCriteria) {
            this.filterCriteria = filterCriteria != null ? filterCriteria.build() : null;
        }

        @Override
        public final Builder filterCriteria(ListCisScansFilterCriteria filterCriteria) {
            this.filterCriteria = filterCriteria;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final String getSortBy() {
            return sortBy;
        }

        public final void setSortBy(String sortBy) {
            this.sortBy = sortBy;
        }

        @Override
        public final Builder sortBy(String sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        @Override
        public final Builder sortBy(ListCisScansSortBy sortBy) {
            this.sortBy(sortBy == null ? null : sortBy.toString());
            return this;
        }

        public final String getSortOrder() {
            return sortOrder;
        }

        public final void setSortOrder(String sortOrder) {
            this.sortOrder = sortOrder;
        }

        @Override
        public final Builder sortOrder(String sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        @Override
        public final Builder sortOrder(CisSortOrder sortOrder) {
            this.sortOrder(sortOrder == null ? null : sortOrder.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListCisScansRequest build() {
            return new ListCisScansRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
