/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.inspector2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListCoverageStatisticsResponse extends Inspector2Response implements
        ToCopyableBuilder<ListCoverageStatisticsResponse.Builder, ListCoverageStatisticsResponse> {
    private static final SdkField<List<Counts>> COUNTS_BY_GROUP_FIELD = SdkField
            .<List<Counts>> builder(MarshallingType.LIST)
            .memberName("countsByGroup")
            .getter(getter(ListCoverageStatisticsResponse::countsByGroup))
            .setter(setter(Builder::countsByGroup))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("countsByGroup").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Counts> builder(MarshallingType.SDK_POJO)
                                            .constructor(Counts::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListCoverageStatisticsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final SdkField<Long> TOTAL_COUNTS_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("totalCounts").getter(getter(ListCoverageStatisticsResponse::totalCounts))
            .setter(setter(Builder::totalCounts))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("totalCounts").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COUNTS_BY_GROUP_FIELD,
            NEXT_TOKEN_FIELD, TOTAL_COUNTS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<Counts> countsByGroup;

    private final String nextToken;

    private final Long totalCounts;

    private ListCoverageStatisticsResponse(BuilderImpl builder) {
        super(builder);
        this.countsByGroup = builder.countsByGroup;
        this.nextToken = builder.nextToken;
        this.totalCounts = builder.totalCounts;
    }

    /**
     * For responses, this returns true if the service returned a value for the CountsByGroup property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasCountsByGroup() {
        return countsByGroup != null && !(countsByGroup instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array with the number for each group.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCountsByGroup} method.
     * </p>
     * 
     * @return An array with the number for each group.
     */
    public final List<Counts> countsByGroup() {
        return countsByGroup;
    }

    /**
     * <p>
     * A token to use for paginating results that are returned in the response. Set the value of this parameter to null
     * for the first request to a list action. For subsequent calls, use the <code>NextToken</code> value returned from
     * the previous request to continue listing results after the first page.
     * </p>
     * 
     * @return A token to use for paginating results that are returned in the response. Set the value of this parameter
     *         to null for the first request to a list action. For subsequent calls, use the <code>NextToken</code>
     *         value returned from the previous request to continue listing results after the first page.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The total number for all groups.
     * </p>
     * 
     * @return The total number for all groups.
     */
    public final Long totalCounts() {
        return totalCounts;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasCountsByGroup() ? countsByGroup() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(totalCounts());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListCoverageStatisticsResponse)) {
            return false;
        }
        ListCoverageStatisticsResponse other = (ListCoverageStatisticsResponse) obj;
        return hasCountsByGroup() == other.hasCountsByGroup() && Objects.equals(countsByGroup(), other.countsByGroup())
                && Objects.equals(nextToken(), other.nextToken()) && Objects.equals(totalCounts(), other.totalCounts());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListCoverageStatisticsResponse")
                .add("CountsByGroup", hasCountsByGroup() ? countsByGroup() : null).add("NextToken", nextToken())
                .add("TotalCounts", totalCounts()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "countsByGroup":
            return Optional.ofNullable(clazz.cast(countsByGroup()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "totalCounts":
            return Optional.ofNullable(clazz.cast(totalCounts()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("countsByGroup", COUNTS_BY_GROUP_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("totalCounts", TOTAL_COUNTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListCoverageStatisticsResponse, T> g) {
        return obj -> g.apply((ListCoverageStatisticsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Inspector2Response.Builder, SdkPojo,
            CopyableBuilder<Builder, ListCoverageStatisticsResponse> {
        /**
         * <p>
         * An array with the number for each group.
         * </p>
         * 
         * @param countsByGroup
         *        An array with the number for each group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder countsByGroup(Collection<Counts> countsByGroup);

        /**
         * <p>
         * An array with the number for each group.
         * </p>
         * 
         * @param countsByGroup
         *        An array with the number for each group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder countsByGroup(Counts... countsByGroup);

        /**
         * <p>
         * An array with the number for each group.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.inspector2.model.Counts.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.inspector2.model.Counts#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.inspector2.model.Counts.Builder#build()} is called immediately and its
         * result is passed to {@link #countsByGroup(List<Counts>)}.
         * 
         * @param countsByGroup
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.inspector2.model.Counts.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #countsByGroup(java.util.Collection<Counts>)
         */
        Builder countsByGroup(Consumer<Counts.Builder>... countsByGroup);

        /**
         * <p>
         * A token to use for paginating results that are returned in the response. Set the value of this parameter to
         * null for the first request to a list action. For subsequent calls, use the <code>NextToken</code> value
         * returned from the previous request to continue listing results after the first page.
         * </p>
         * 
         * @param nextToken
         *        A token to use for paginating results that are returned in the response. Set the value of this
         *        parameter to null for the first request to a list action. For subsequent calls, use the
         *        <code>NextToken</code> value returned from the previous request to continue listing results after the
         *        first page.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The total number for all groups.
         * </p>
         * 
         * @param totalCounts
         *        The total number for all groups.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder totalCounts(Long totalCounts);
    }

    static final class BuilderImpl extends Inspector2Response.BuilderImpl implements Builder {
        private List<Counts> countsByGroup = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private Long totalCounts;

        private BuilderImpl() {
        }

        private BuilderImpl(ListCoverageStatisticsResponse model) {
            super(model);
            countsByGroup(model.countsByGroup);
            nextToken(model.nextToken);
            totalCounts(model.totalCounts);
        }

        public final List<Counts.Builder> getCountsByGroup() {
            List<Counts.Builder> result = CountsListCopier.copyToBuilder(this.countsByGroup);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCountsByGroup(Collection<Counts.BuilderImpl> countsByGroup) {
            this.countsByGroup = CountsListCopier.copyFromBuilder(countsByGroup);
        }

        @Override
        public final Builder countsByGroup(Collection<Counts> countsByGroup) {
            this.countsByGroup = CountsListCopier.copy(countsByGroup);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder countsByGroup(Counts... countsByGroup) {
            countsByGroup(Arrays.asList(countsByGroup));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder countsByGroup(Consumer<Counts.Builder>... countsByGroup) {
            countsByGroup(Stream.of(countsByGroup).map(c -> Counts.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Long getTotalCounts() {
            return totalCounts;
        }

        public final void setTotalCounts(Long totalCounts) {
            this.totalCounts = totalCounts;
        }

        @Override
        public final Builder totalCounts(Long totalCounts) {
            this.totalCounts = totalCounts;
            return this;
        }

        @Override
        public ListCoverageStatisticsResponse build() {
            return new ListCoverageStatisticsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
