/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.inspector2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListFiltersRequest extends Inspector2Request implements
        ToCopyableBuilder<ListFiltersRequest.Builder, ListFiltersRequest> {
    private static final SdkField<String> ACTION_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("action")
            .getter(getter(ListFiltersRequest::actionAsString)).setter(setter(Builder::action))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("action").build()).build();

    private static final SdkField<List<String>> ARNS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("arns")
            .getter(getter(ListFiltersRequest::arns))
            .setter(setter(Builder::arns))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arns").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxResults").getter(getter(ListFiltersRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxResults").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListFiltersRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTION_FIELD, ARNS_FIELD,
            MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String action;

    private final List<String> arns;

    private final Integer maxResults;

    private final String nextToken;

    private ListFiltersRequest(BuilderImpl builder) {
        super(builder);
        this.action = builder.action;
        this.arns = builder.arns;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * The action the filter applies to matched findings.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #action} will
     * return {@link FilterAction#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #actionAsString}.
     * </p>
     * 
     * @return The action the filter applies to matched findings.
     * @see FilterAction
     */
    public final FilterAction action() {
        return FilterAction.fromValue(action);
    }

    /**
     * <p>
     * The action the filter applies to matched findings.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #action} will
     * return {@link FilterAction#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #actionAsString}.
     * </p>
     * 
     * @return The action the filter applies to matched findings.
     * @see FilterAction
     */
    public final String actionAsString() {
        return action;
    }

    /**
     * For responses, this returns true if the service returned a value for the Arns property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasArns() {
        return arns != null && !(arns instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The Amazon resource number (ARN) of the filter.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasArns} method.
     * </p>
     * 
     * @return The Amazon resource number (ARN) of the filter.
     */
    public final List<String> arns() {
        return arns;
    }

    /**
     * <p>
     * The maximum number of results the response can return. If your request would return more than the maximum the
     * response will return a <code>nextToken</code> value, use this value when you call the action again to get the
     * remaining results.
     * </p>
     * 
     * @return The maximum number of results the response can return. If your request would return more than the maximum
     *         the response will return a <code>nextToken</code> value, use this value when you call the action again to
     *         get the remaining results.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * A token to use for paginating results that are returned in the response. Set the value of this parameter to null
     * for the first request to a list action. If your response returns more than the <code>maxResults</code> maximum
     * value it will also return a <code>nextToken</code> value. For subsequent calls, use the <code>nextToken</code>
     * value returned from the previous request to continue listing results after the first page.
     * </p>
     * 
     * @return A token to use for paginating results that are returned in the response. Set the value of this parameter
     *         to null for the first request to a list action. If your response returns more than the
     *         <code>maxResults</code> maximum value it will also return a <code>nextToken</code> value. For subsequent
     *         calls, use the <code>nextToken</code> value returned from the previous request to continue listing
     *         results after the first page.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(actionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasArns() ? arns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListFiltersRequest)) {
            return false;
        }
        ListFiltersRequest other = (ListFiltersRequest) obj;
        return Objects.equals(actionAsString(), other.actionAsString()) && hasArns() == other.hasArns()
                && Objects.equals(arns(), other.arns()) && Objects.equals(maxResults(), other.maxResults())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListFiltersRequest").add("Action", actionAsString()).add("Arns", hasArns() ? arns() : null)
                .add("MaxResults", maxResults()).add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "action":
            return Optional.ofNullable(clazz.cast(actionAsString()));
        case "arns":
            return Optional.ofNullable(clazz.cast(arns()));
        case "maxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("action", ACTION_FIELD);
        map.put("arns", ARNS_FIELD);
        map.put("maxResults", MAX_RESULTS_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListFiltersRequest, T> g) {
        return obj -> g.apply((ListFiltersRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Inspector2Request.Builder, SdkPojo, CopyableBuilder<Builder, ListFiltersRequest> {
        /**
         * <p>
         * The action the filter applies to matched findings.
         * </p>
         * 
         * @param action
         *        The action the filter applies to matched findings.
         * @see FilterAction
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FilterAction
         */
        Builder action(String action);

        /**
         * <p>
         * The action the filter applies to matched findings.
         * </p>
         * 
         * @param action
         *        The action the filter applies to matched findings.
         * @see FilterAction
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FilterAction
         */
        Builder action(FilterAction action);

        /**
         * <p>
         * The Amazon resource number (ARN) of the filter.
         * </p>
         * 
         * @param arns
         *        The Amazon resource number (ARN) of the filter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arns(Collection<String> arns);

        /**
         * <p>
         * The Amazon resource number (ARN) of the filter.
         * </p>
         * 
         * @param arns
         *        The Amazon resource number (ARN) of the filter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arns(String... arns);

        /**
         * <p>
         * The maximum number of results the response can return. If your request would return more than the maximum the
         * response will return a <code>nextToken</code> value, use this value when you call the action again to get the
         * remaining results.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of results the response can return. If your request would return more than the
         *        maximum the response will return a <code>nextToken</code> value, use this value when you call the
         *        action again to get the remaining results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * A token to use for paginating results that are returned in the response. Set the value of this parameter to
         * null for the first request to a list action. If your response returns more than the <code>maxResults</code>
         * maximum value it will also return a <code>nextToken</code> value. For subsequent calls, use the
         * <code>nextToken</code> value returned from the previous request to continue listing results after the first
         * page.
         * </p>
         * 
         * @param nextToken
         *        A token to use for paginating results that are returned in the response. Set the value of this
         *        parameter to null for the first request to a list action. If your response returns more than the
         *        <code>maxResults</code> maximum value it will also return a <code>nextToken</code> value. For
         *        subsequent calls, use the <code>nextToken</code> value returned from the previous request to continue
         *        listing results after the first page.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Inspector2Request.BuilderImpl implements Builder {
        private String action;

        private List<String> arns = DefaultSdkAutoConstructList.getInstance();

        private Integer maxResults;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListFiltersRequest model) {
            super(model);
            action(model.action);
            arns(model.arns);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
        }

        public final String getAction() {
            return action;
        }

        public final void setAction(String action) {
            this.action = action;
        }

        @Override
        public final Builder action(String action) {
            this.action = action;
            return this;
        }

        @Override
        public final Builder action(FilterAction action) {
            this.action(action == null ? null : action.toString());
            return this;
        }

        public final Collection<String> getArns() {
            if (arns instanceof SdkAutoConstructList) {
                return null;
            }
            return arns;
        }

        public final void setArns(Collection<String> arns) {
            this.arns = FilterArnListCopier.copy(arns);
        }

        @Override
        public final Builder arns(Collection<String> arns) {
            this.arns = FilterArnListCopier.copy(arns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder arns(String... arns) {
            arns(Arrays.asList(arns));
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListFiltersRequest build() {
            return new ListFiltersRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
