/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.inspector2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A monthly schedule.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MonthlySchedule implements SdkPojo, Serializable, ToCopyableBuilder<MonthlySchedule.Builder, MonthlySchedule> {
    private static final SdkField<String> DAY_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("day")
            .getter(getter(MonthlySchedule::dayAsString)).setter(setter(Builder::day))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("day").build()).build();

    private static final SdkField<Time> START_TIME_FIELD = SdkField.<Time> builder(MarshallingType.SDK_POJO)
            .memberName("startTime").getter(getter(MonthlySchedule::startTime)).setter(setter(Builder::startTime))
            .constructor(Time::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startTime").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DAY_FIELD, START_TIME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String day;

    private final Time startTime;

    private MonthlySchedule(BuilderImpl builder) {
        this.day = builder.day;
        this.startTime = builder.startTime;
    }

    /**
     * <p>
     * The monthly schedule's day.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #day} will return
     * {@link Day#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from {@link #dayAsString}.
     * </p>
     * 
     * @return The monthly schedule's day.
     * @see Day
     */
    public final Day day() {
        return Day.fromValue(day);
    }

    /**
     * <p>
     * The monthly schedule's day.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #day} will return
     * {@link Day#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from {@link #dayAsString}.
     * </p>
     * 
     * @return The monthly schedule's day.
     * @see Day
     */
    public final String dayAsString() {
        return day;
    }

    /**
     * <p>
     * The monthly schedule's start time.
     * </p>
     * 
     * @return The monthly schedule's start time.
     */
    public final Time startTime() {
        return startTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(dayAsString());
        hashCode = 31 * hashCode + Objects.hashCode(startTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MonthlySchedule)) {
            return false;
        }
        MonthlySchedule other = (MonthlySchedule) obj;
        return Objects.equals(dayAsString(), other.dayAsString()) && Objects.equals(startTime(), other.startTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("MonthlySchedule").add("Day", dayAsString()).add("StartTime", startTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "day":
            return Optional.ofNullable(clazz.cast(dayAsString()));
        case "startTime":
            return Optional.ofNullable(clazz.cast(startTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("day", DAY_FIELD);
        map.put("startTime", START_TIME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<MonthlySchedule, T> g) {
        return obj -> g.apply((MonthlySchedule) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MonthlySchedule> {
        /**
         * <p>
         * The monthly schedule's day.
         * </p>
         * 
         * @param day
         *        The monthly schedule's day.
         * @see Day
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Day
         */
        Builder day(String day);

        /**
         * <p>
         * The monthly schedule's day.
         * </p>
         * 
         * @param day
         *        The monthly schedule's day.
         * @see Day
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Day
         */
        Builder day(Day day);

        /**
         * <p>
         * The monthly schedule's start time.
         * </p>
         * 
         * @param startTime
         *        The monthly schedule's start time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTime(Time startTime);

        /**
         * <p>
         * The monthly schedule's start time.
         * </p>
         * This is a convenience method that creates an instance of the {@link Time.Builder} avoiding the need to create
         * one manually via {@link Time#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Time.Builder#build()} is called immediately and its result is
         * passed to {@link #startTime(Time)}.
         * 
         * @param startTime
         *        a consumer that will call methods on {@link Time.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #startTime(Time)
         */
        default Builder startTime(Consumer<Time.Builder> startTime) {
            return startTime(Time.builder().applyMutation(startTime).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String day;

        private Time startTime;

        private BuilderImpl() {
        }

        private BuilderImpl(MonthlySchedule model) {
            day(model.day);
            startTime(model.startTime);
        }

        public final String getDay() {
            return day;
        }

        public final void setDay(String day) {
            this.day = day;
        }

        @Override
        public final Builder day(String day) {
            this.day = day;
            return this;
        }

        @Override
        public final Builder day(Day day) {
            this.day(day == null ? null : day.toString());
            return this;
        }

        public final Time.Builder getStartTime() {
            return startTime != null ? startTime.toBuilder() : null;
        }

        public final void setStartTime(Time.BuilderImpl startTime) {
            this.startTime = startTime != null ? startTime.build() : null;
        }

        @Override
        public final Builder startTime(Time startTime) {
            this.startTime = startTime;
            return this;
        }

        @Override
        public MonthlySchedule build() {
            return new MonthlySchedule(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
