/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.inspector2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the details of a network reachability finding.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class NetworkReachabilityDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<NetworkReachabilityDetails.Builder, NetworkReachabilityDetails> {
    private static final SdkField<NetworkPath> NETWORK_PATH_FIELD = SdkField.<NetworkPath> builder(MarshallingType.SDK_POJO)
            .memberName("networkPath").getter(getter(NetworkReachabilityDetails::networkPath))
            .setter(setter(Builder::networkPath)).constructor(NetworkPath::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("networkPath").build()).build();

    private static final SdkField<PortRange> OPEN_PORT_RANGE_FIELD = SdkField.<PortRange> builder(MarshallingType.SDK_POJO)
            .memberName("openPortRange").getter(getter(NetworkReachabilityDetails::openPortRange))
            .setter(setter(Builder::openPortRange)).constructor(PortRange::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("openPortRange").build()).build();

    private static final SdkField<String> PROTOCOL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("protocol").getter(getter(NetworkReachabilityDetails::protocolAsString))
            .setter(setter(Builder::protocol))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("protocol").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NETWORK_PATH_FIELD,
            OPEN_PORT_RANGE_FIELD, PROTOCOL_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final NetworkPath networkPath;

    private final PortRange openPortRange;

    private final String protocol;

    private NetworkReachabilityDetails(BuilderImpl builder) {
        this.networkPath = builder.networkPath;
        this.openPortRange = builder.openPortRange;
        this.protocol = builder.protocol;
    }

    /**
     * <p>
     * An object that contains details about a network path associated with a finding.
     * </p>
     * 
     * @return An object that contains details about a network path associated with a finding.
     */
    public final NetworkPath networkPath() {
        return networkPath;
    }

    /**
     * <p>
     * An object that contains details about the open port range associated with a finding.
     * </p>
     * 
     * @return An object that contains details about the open port range associated with a finding.
     */
    public final PortRange openPortRange() {
        return openPortRange;
    }

    /**
     * <p>
     * The protocol associated with a finding.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #protocol} will
     * return {@link NetworkProtocol#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #protocolAsString}.
     * </p>
     * 
     * @return The protocol associated with a finding.
     * @see NetworkProtocol
     */
    public final NetworkProtocol protocol() {
        return NetworkProtocol.fromValue(protocol);
    }

    /**
     * <p>
     * The protocol associated with a finding.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #protocol} will
     * return {@link NetworkProtocol#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #protocolAsString}.
     * </p>
     * 
     * @return The protocol associated with a finding.
     * @see NetworkProtocol
     */
    public final String protocolAsString() {
        return protocol;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(networkPath());
        hashCode = 31 * hashCode + Objects.hashCode(openPortRange());
        hashCode = 31 * hashCode + Objects.hashCode(protocolAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NetworkReachabilityDetails)) {
            return false;
        }
        NetworkReachabilityDetails other = (NetworkReachabilityDetails) obj;
        return Objects.equals(networkPath(), other.networkPath()) && Objects.equals(openPortRange(), other.openPortRange())
                && Objects.equals(protocolAsString(), other.protocolAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("NetworkReachabilityDetails").add("NetworkPath", networkPath())
                .add("OpenPortRange", openPortRange()).add("Protocol", protocolAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "networkPath":
            return Optional.ofNullable(clazz.cast(networkPath()));
        case "openPortRange":
            return Optional.ofNullable(clazz.cast(openPortRange()));
        case "protocol":
            return Optional.ofNullable(clazz.cast(protocolAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("networkPath", NETWORK_PATH_FIELD);
        map.put("openPortRange", OPEN_PORT_RANGE_FIELD);
        map.put("protocol", PROTOCOL_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<NetworkReachabilityDetails, T> g) {
        return obj -> g.apply((NetworkReachabilityDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, NetworkReachabilityDetails> {
        /**
         * <p>
         * An object that contains details about a network path associated with a finding.
         * </p>
         * 
         * @param networkPath
         *        An object that contains details about a network path associated with a finding.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkPath(NetworkPath networkPath);

        /**
         * <p>
         * An object that contains details about a network path associated with a finding.
         * </p>
         * This is a convenience method that creates an instance of the {@link NetworkPath.Builder} avoiding the need to
         * create one manually via {@link NetworkPath#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link NetworkPath.Builder#build()} is called immediately and its result
         * is passed to {@link #networkPath(NetworkPath)}.
         * 
         * @param networkPath
         *        a consumer that will call methods on {@link NetworkPath.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #networkPath(NetworkPath)
         */
        default Builder networkPath(Consumer<NetworkPath.Builder> networkPath) {
            return networkPath(NetworkPath.builder().applyMutation(networkPath).build());
        }

        /**
         * <p>
         * An object that contains details about the open port range associated with a finding.
         * </p>
         * 
         * @param openPortRange
         *        An object that contains details about the open port range associated with a finding.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder openPortRange(PortRange openPortRange);

        /**
         * <p>
         * An object that contains details about the open port range associated with a finding.
         * </p>
         * This is a convenience method that creates an instance of the {@link PortRange.Builder} avoiding the need to
         * create one manually via {@link PortRange#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PortRange.Builder#build()} is called immediately and its result
         * is passed to {@link #openPortRange(PortRange)}.
         * 
         * @param openPortRange
         *        a consumer that will call methods on {@link PortRange.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #openPortRange(PortRange)
         */
        default Builder openPortRange(Consumer<PortRange.Builder> openPortRange) {
            return openPortRange(PortRange.builder().applyMutation(openPortRange).build());
        }

        /**
         * <p>
         * The protocol associated with a finding.
         * </p>
         * 
         * @param protocol
         *        The protocol associated with a finding.
         * @see NetworkProtocol
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NetworkProtocol
         */
        Builder protocol(String protocol);

        /**
         * <p>
         * The protocol associated with a finding.
         * </p>
         * 
         * @param protocol
         *        The protocol associated with a finding.
         * @see NetworkProtocol
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NetworkProtocol
         */
        Builder protocol(NetworkProtocol protocol);
    }

    static final class BuilderImpl implements Builder {
        private NetworkPath networkPath;

        private PortRange openPortRange;

        private String protocol;

        private BuilderImpl() {
        }

        private BuilderImpl(NetworkReachabilityDetails model) {
            networkPath(model.networkPath);
            openPortRange(model.openPortRange);
            protocol(model.protocol);
        }

        public final NetworkPath.Builder getNetworkPath() {
            return networkPath != null ? networkPath.toBuilder() : null;
        }

        public final void setNetworkPath(NetworkPath.BuilderImpl networkPath) {
            this.networkPath = networkPath != null ? networkPath.build() : null;
        }

        @Override
        public final Builder networkPath(NetworkPath networkPath) {
            this.networkPath = networkPath;
            return this;
        }

        public final PortRange.Builder getOpenPortRange() {
            return openPortRange != null ? openPortRange.toBuilder() : null;
        }

        public final void setOpenPortRange(PortRange.BuilderImpl openPortRange) {
            this.openPortRange = openPortRange != null ? openPortRange.build() : null;
        }

        @Override
        public final Builder openPortRange(PortRange openPortRange) {
            this.openPortRange = openPortRange;
            return this;
        }

        public final String getProtocol() {
            return protocol;
        }

        public final void setProtocol(String protocol) {
            this.protocol = protocol;
        }

        @Override
        public final Builder protocol(String protocol) {
            this.protocol = protocol;
            return this;
        }

        @Override
        public final Builder protocol(NetworkProtocol protocol) {
            this.protocol(protocol == null ? null : protocol.toString());
            return this;
        }

        @Override
        public NetworkReachabilityDetails build() {
            return new NetworkReachabilityDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
