/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.inspector2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains details about the resource involved in the finding.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ResourceDetails implements SdkPojo, Serializable, ToCopyableBuilder<ResourceDetails.Builder, ResourceDetails> {
    private static final SdkField<AwsEc2InstanceDetails> AWS_EC2_INSTANCE_FIELD = SdkField
            .<AwsEc2InstanceDetails> builder(MarshallingType.SDK_POJO).memberName("awsEc2Instance")
            .getter(getter(ResourceDetails::awsEc2Instance)).setter(setter(Builder::awsEc2Instance))
            .constructor(AwsEc2InstanceDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("awsEc2Instance").build()).build();

    private static final SdkField<AwsEcrContainerImageDetails> AWS_ECR_CONTAINER_IMAGE_FIELD = SdkField
            .<AwsEcrContainerImageDetails> builder(MarshallingType.SDK_POJO).memberName("awsEcrContainerImage")
            .getter(getter(ResourceDetails::awsEcrContainerImage)).setter(setter(Builder::awsEcrContainerImage))
            .constructor(AwsEcrContainerImageDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("awsEcrContainerImage").build())
            .build();

    private static final SdkField<AwsLambdaFunctionDetails> AWS_LAMBDA_FUNCTION_FIELD = SdkField
            .<AwsLambdaFunctionDetails> builder(MarshallingType.SDK_POJO).memberName("awsLambdaFunction")
            .getter(getter(ResourceDetails::awsLambdaFunction)).setter(setter(Builder::awsLambdaFunction))
            .constructor(AwsLambdaFunctionDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("awsLambdaFunction").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AWS_EC2_INSTANCE_FIELD,
            AWS_ECR_CONTAINER_IMAGE_FIELD, AWS_LAMBDA_FUNCTION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final AwsEc2InstanceDetails awsEc2Instance;

    private final AwsEcrContainerImageDetails awsEcrContainerImage;

    private final AwsLambdaFunctionDetails awsLambdaFunction;

    private ResourceDetails(BuilderImpl builder) {
        this.awsEc2Instance = builder.awsEc2Instance;
        this.awsEcrContainerImage = builder.awsEcrContainerImage;
        this.awsLambdaFunction = builder.awsLambdaFunction;
    }

    /**
     * <p>
     * An object that contains details about the Amazon EC2 instance involved in the finding.
     * </p>
     * 
     * @return An object that contains details about the Amazon EC2 instance involved in the finding.
     */
    public final AwsEc2InstanceDetails awsEc2Instance() {
        return awsEc2Instance;
    }

    /**
     * <p>
     * An object that contains details about the Amazon ECR container image involved in the finding.
     * </p>
     * 
     * @return An object that contains details about the Amazon ECR container image involved in the finding.
     */
    public final AwsEcrContainerImageDetails awsEcrContainerImage() {
        return awsEcrContainerImage;
    }

    /**
     * <p>
     * A summary of the information about an Amazon Web Services Lambda function affected by a finding.
     * </p>
     * 
     * @return A summary of the information about an Amazon Web Services Lambda function affected by a finding.
     */
    public final AwsLambdaFunctionDetails awsLambdaFunction() {
        return awsLambdaFunction;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(awsEc2Instance());
        hashCode = 31 * hashCode + Objects.hashCode(awsEcrContainerImage());
        hashCode = 31 * hashCode + Objects.hashCode(awsLambdaFunction());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResourceDetails)) {
            return false;
        }
        ResourceDetails other = (ResourceDetails) obj;
        return Objects.equals(awsEc2Instance(), other.awsEc2Instance())
                && Objects.equals(awsEcrContainerImage(), other.awsEcrContainerImage())
                && Objects.equals(awsLambdaFunction(), other.awsLambdaFunction());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ResourceDetails").add("AwsEc2Instance", awsEc2Instance())
                .add("AwsEcrContainerImage", awsEcrContainerImage()).add("AwsLambdaFunction", awsLambdaFunction()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "awsEc2Instance":
            return Optional.ofNullable(clazz.cast(awsEc2Instance()));
        case "awsEcrContainerImage":
            return Optional.ofNullable(clazz.cast(awsEcrContainerImage()));
        case "awsLambdaFunction":
            return Optional.ofNullable(clazz.cast(awsLambdaFunction()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("awsEc2Instance", AWS_EC2_INSTANCE_FIELD);
        map.put("awsEcrContainerImage", AWS_ECR_CONTAINER_IMAGE_FIELD);
        map.put("awsLambdaFunction", AWS_LAMBDA_FUNCTION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ResourceDetails, T> g) {
        return obj -> g.apply((ResourceDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ResourceDetails> {
        /**
         * <p>
         * An object that contains details about the Amazon EC2 instance involved in the finding.
         * </p>
         * 
         * @param awsEc2Instance
         *        An object that contains details about the Amazon EC2 instance involved in the finding.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsEc2Instance(AwsEc2InstanceDetails awsEc2Instance);

        /**
         * <p>
         * An object that contains details about the Amazon EC2 instance involved in the finding.
         * </p>
         * This is a convenience method that creates an instance of the {@link AwsEc2InstanceDetails.Builder} avoiding
         * the need to create one manually via {@link AwsEc2InstanceDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AwsEc2InstanceDetails.Builder#build()} is called immediately and
         * its result is passed to {@link #awsEc2Instance(AwsEc2InstanceDetails)}.
         * 
         * @param awsEc2Instance
         *        a consumer that will call methods on {@link AwsEc2InstanceDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #awsEc2Instance(AwsEc2InstanceDetails)
         */
        default Builder awsEc2Instance(Consumer<AwsEc2InstanceDetails.Builder> awsEc2Instance) {
            return awsEc2Instance(AwsEc2InstanceDetails.builder().applyMutation(awsEc2Instance).build());
        }

        /**
         * <p>
         * An object that contains details about the Amazon ECR container image involved in the finding.
         * </p>
         * 
         * @param awsEcrContainerImage
         *        An object that contains details about the Amazon ECR container image involved in the finding.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsEcrContainerImage(AwsEcrContainerImageDetails awsEcrContainerImage);

        /**
         * <p>
         * An object that contains details about the Amazon ECR container image involved in the finding.
         * </p>
         * This is a convenience method that creates an instance of the {@link AwsEcrContainerImageDetails.Builder}
         * avoiding the need to create one manually via {@link AwsEcrContainerImageDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AwsEcrContainerImageDetails.Builder#build()} is called
         * immediately and its result is passed to {@link #awsEcrContainerImage(AwsEcrContainerImageDetails)}.
         * 
         * @param awsEcrContainerImage
         *        a consumer that will call methods on {@link AwsEcrContainerImageDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #awsEcrContainerImage(AwsEcrContainerImageDetails)
         */
        default Builder awsEcrContainerImage(Consumer<AwsEcrContainerImageDetails.Builder> awsEcrContainerImage) {
            return awsEcrContainerImage(AwsEcrContainerImageDetails.builder().applyMutation(awsEcrContainerImage).build());
        }

        /**
         * <p>
         * A summary of the information about an Amazon Web Services Lambda function affected by a finding.
         * </p>
         * 
         * @param awsLambdaFunction
         *        A summary of the information about an Amazon Web Services Lambda function affected by a finding.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsLambdaFunction(AwsLambdaFunctionDetails awsLambdaFunction);

        /**
         * <p>
         * A summary of the information about an Amazon Web Services Lambda function affected by a finding.
         * </p>
         * This is a convenience method that creates an instance of the {@link AwsLambdaFunctionDetails.Builder}
         * avoiding the need to create one manually via {@link AwsLambdaFunctionDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AwsLambdaFunctionDetails.Builder#build()} is called immediately
         * and its result is passed to {@link #awsLambdaFunction(AwsLambdaFunctionDetails)}.
         * 
         * @param awsLambdaFunction
         *        a consumer that will call methods on {@link AwsLambdaFunctionDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #awsLambdaFunction(AwsLambdaFunctionDetails)
         */
        default Builder awsLambdaFunction(Consumer<AwsLambdaFunctionDetails.Builder> awsLambdaFunction) {
            return awsLambdaFunction(AwsLambdaFunctionDetails.builder().applyMutation(awsLambdaFunction).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private AwsEc2InstanceDetails awsEc2Instance;

        private AwsEcrContainerImageDetails awsEcrContainerImage;

        private AwsLambdaFunctionDetails awsLambdaFunction;

        private BuilderImpl() {
        }

        private BuilderImpl(ResourceDetails model) {
            awsEc2Instance(model.awsEc2Instance);
            awsEcrContainerImage(model.awsEcrContainerImage);
            awsLambdaFunction(model.awsLambdaFunction);
        }

        public final AwsEc2InstanceDetails.Builder getAwsEc2Instance() {
            return awsEc2Instance != null ? awsEc2Instance.toBuilder() : null;
        }

        public final void setAwsEc2Instance(AwsEc2InstanceDetails.BuilderImpl awsEc2Instance) {
            this.awsEc2Instance = awsEc2Instance != null ? awsEc2Instance.build() : null;
        }

        @Override
        public final Builder awsEc2Instance(AwsEc2InstanceDetails awsEc2Instance) {
            this.awsEc2Instance = awsEc2Instance;
            return this;
        }

        public final AwsEcrContainerImageDetails.Builder getAwsEcrContainerImage() {
            return awsEcrContainerImage != null ? awsEcrContainerImage.toBuilder() : null;
        }

        public final void setAwsEcrContainerImage(AwsEcrContainerImageDetails.BuilderImpl awsEcrContainerImage) {
            this.awsEcrContainerImage = awsEcrContainerImage != null ? awsEcrContainerImage.build() : null;
        }

        @Override
        public final Builder awsEcrContainerImage(AwsEcrContainerImageDetails awsEcrContainerImage) {
            this.awsEcrContainerImage = awsEcrContainerImage;
            return this;
        }

        public final AwsLambdaFunctionDetails.Builder getAwsLambdaFunction() {
            return awsLambdaFunction != null ? awsLambdaFunction.toBuilder() : null;
        }

        public final void setAwsLambdaFunction(AwsLambdaFunctionDetails.BuilderImpl awsLambdaFunction) {
            this.awsLambdaFunction = awsLambdaFunction != null ? awsLambdaFunction.build() : null;
        }

        @Override
        public final Builder awsLambdaFunction(AwsLambdaFunctionDetails awsLambdaFunction) {
            this.awsLambdaFunction = awsLambdaFunction;
            return this;
        }

        @Override
        public ResourceDetails build() {
            return new ResourceDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
