/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.inspector2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The status of the scan.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ScanStatus implements SdkPojo, Serializable, ToCopyableBuilder<ScanStatus.Builder, ScanStatus> {
    private static final SdkField<String> REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("reason")
            .getter(getter(ScanStatus::reasonAsString)).setter(setter(Builder::reason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("reason").build()).build();

    private static final SdkField<String> STATUS_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("statusCode").getter(getter(ScanStatus::statusCodeAsString)).setter(setter(Builder::statusCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusCode").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REASON_FIELD,
            STATUS_CODE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String reason;

    private final String statusCodeValue;

    private ScanStatus(BuilderImpl builder) {
        this.reason = builder.reason;
        this.statusCodeValue = builder.statusCodeValue;
    }

    /**
     * <p>
     * The scan status. Possible return values and descriptions are:
     * </p>
     * <p>
     * <code>PENDING_INITIAL_SCAN</code> - This resource has been identified for scanning, results will be available
     * soon.
     * </p>
     * <p>
     * <code>ACCESS_DENIED</code> - Resource access policy restricting Amazon Inspector access. Please update the IAM
     * policy.
     * </p>
     * <p>
     * <code>INTERNAL_ERROR</code> - Amazon Inspector has encountered an internal error for this resource. Amazon
     * Inspector service will automatically resolve the issue and resume the scanning. No action required from the user.
     * </p>
     * <p>
     * <code>UNMANAGED_EC2_INSTANCE</code> - The EC2 instance is not managed by SSM, please use the following SSM
     * automation to remediate the issue: <a href=
     * "https://docs.aws.amazon.com/systems-manager-automation-runbooks/latest/userguide/automation-awssupport-troubleshoot-managed-instance.html"
     * >https://docs.aws.amazon.com/systems-manager-automation-runbooks/latest/userguide/automation-awssupport-
     * troubleshoot-managed-instance.html</a>. Once the instance becomes managed by SSM, Inspector will automatically
     * begin scanning this instance.
     * </p>
     * <p>
     * <code>UNSUPPORTED_OS</code> - Amazon Inspector does not support this OS, architecture, or image manifest type at
     * this time. To see a complete list of supported operating systems see: <a
     * href=" https://docs.aws.amazon.com/inspector/latest/user/supported.html"
     * >https://docs.aws.amazon.com/inspector/latest/user/supported.html</a>.
     * </p>
     * <p>
     * <code>SCAN_ELIGIBILITY_EXPIRED</code> - The configured scan duration has lapsed for this image.
     * </p>
     * <p>
     * <code>RESOURCE_TERMINATED</code> - This resource has been terminated. The findings and coverage associated with
     * this resource are in the process of being cleaned up.
     * </p>
     * <p>
     * <code>SUCCESSFUL</code> - The scan was successful.
     * </p>
     * <p>
     * <code>NO_RESOURCES_FOUND</code> - Reserved for future use.
     * </p>
     * <p>
     * <code>IMAGE_SIZE_EXCEEDED</code> - Reserved for future use.
     * </p>
     * <p>
     * <code>SCAN_FREQUENCY_MANUAL</code> - This image will not be covered by Amazon Inspector due to the repository
     * scan frequency configuration.
     * </p>
     * <p>
     * <code>SCAN_FREQUENCY_SCAN_ON_PUSH </code>- This image will be scanned one time and will not new findings because
     * of the scan frequency configuration.
     * </p>
     * <p>
     * <code>EC2_INSTANCE_STOPPED</code> - This EC2 instance is in a stopped state, therefore, Amazon Inspector will
     * pause scanning. The existing findings will continue to exist until the instance is terminated. Once the instance
     * is re-started, Inspector will automatically start scanning the instance again. Please note that you will not be
     * charged for this instance while it’s in a stopped state.
     * </p>
     * <p>
     * <code>PENDING_DISABLE</code> - This resource is pending cleanup during disablement. The customer will not be
     * billed while a resource is in the pending disable status.
     * </p>
     * <p>
     * <code>NO INVENTORY</code> - Amazon Inspector couldn’t find software application inventory to scan for
     * vulnerabilities. This might be caused due to required Amazon Inspector associations being deleted or failing to
     * run on your resource. Please verify the status of <code>InspectorInventoryCollection-do-not-delete</code>
     * association in the SSM console for the resource. Additionally, you can verify the instance’s inventory in the SSM
     * Fleet Manager console.
     * </p>
     * <p>
     * <code>STALE_INVENTORY</code> - Amazon Inspector wasn’t able to collect an updated software application inventory
     * in the last 7 days. Please confirm the required Amazon Inspector associations still exist and you can still see
     * an updated inventory in the SSM console.
     * </p>
     * <p>
     * <code>EXCLUDED_BY_TAG</code> - This resource was not scanned because it has been excluded by a tag.
     * </p>
     * <p>
     * <code>UNSUPPORTED_RUNTIME</code> - The function was not scanned because it has an unsupported runtime. To see a
     * complete list of supported runtimes see: <a
     * href=" https://docs.aws.amazon.com/inspector/latest/user/supported.html"
     * >https://docs.aws.amazon.com/inspector/latest/user/supported.html</a>.
     * </p>
     * <p>
     * <code>UNSUPPORTED_MEDIA_TYPE </code>- The ECR image has an unsupported media type.
     * </p>
     * <p>
     * <code>UNSUPPORTED_CONFIG_FILE</code> - Reserved for future use.
     * </p>
     * <p>
     * <code>DEEP_INSPECTION_PACKAGE_COLLECTION_LIMIT_EXCEEDED</code> - The instance has exceeded the 5000 package limit
     * for Amazon Inspector Deep inspection. To resume Deep inspection for this instance you can try to adjust the
     * custom paths associated with the account.
     * </p>
     * <p>
     * <code>DEEP_INSPECTION_DAILY_SSM_INVENTORY_LIMIT_EXCEEDED</code> - The SSM agent couldn't send inventory to Amazon
     * Inspector because the SSM quota for Inventory data collected per instance per day has already been reached for
     * this instance.
     * </p>
     * <p>
     * <code>DEEP_INSPECTION_COLLECTION_TIME_LIMIT_EXCEEDED</code> - Amazon Inspector failed to extract the package
     * inventory because the package collection time exceeding the maximum threshold of 15 minutes.
     * </p>
     * <p>
     * <code>DEEP_INSPECTION_NO_INVENTORY</code> The Amazon Inspector plugin hasn't yet been able to collect an
     * inventory of packages for this instance. This is usually the result of a pending scan, however, if this status
     * persists after 6 hours, use SSM to ensure that the required Amazon Inspector associations exist and are running
     * for the instance.
     * </p>
     * <p/>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #reason} will
     * return {@link ScanStatusReason#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #reasonAsString}.
     * </p>
     * 
     * @return The scan status. Possible return values and descriptions are: </p>
     *         <p>
     *         <code>PENDING_INITIAL_SCAN</code> - This resource has been identified for scanning, results will be
     *         available soon.
     *         </p>
     *         <p>
     *         <code>ACCESS_DENIED</code> - Resource access policy restricting Amazon Inspector access. Please update
     *         the IAM policy.
     *         </p>
     *         <p>
     *         <code>INTERNAL_ERROR</code> - Amazon Inspector has encountered an internal error for this resource.
     *         Amazon Inspector service will automatically resolve the issue and resume the scanning. No action required
     *         from the user.
     *         </p>
     *         <p>
     *         <code>UNMANAGED_EC2_INSTANCE</code> - The EC2 instance is not managed by SSM, please use the following
     *         SSM automation to remediate the issue: <a href=
     *         "https://docs.aws.amazon.com/systems-manager-automation-runbooks/latest/userguide/automation-awssupport-troubleshoot-managed-instance.html"
     *         >https://docs.aws.amazon.com/systems-manager-automation-runbooks/latest/userguide/automation-awssupport-
     *         troubleshoot-managed-instance.html</a>. Once the instance becomes managed by SSM, Inspector will
     *         automatically begin scanning this instance.
     *         </p>
     *         <p>
     *         <code>UNSUPPORTED_OS</code> - Amazon Inspector does not support this OS, architecture, or image manifest
     *         type at this time. To see a complete list of supported operating systems see: <a
     *         href=" https://docs.aws.amazon.com/inspector/latest/user/supported.html"
     *         >https://docs.aws.amazon.com/inspector/latest/user/supported.html</a>.
     *         </p>
     *         <p>
     *         <code>SCAN_ELIGIBILITY_EXPIRED</code> - The configured scan duration has lapsed for this image.
     *         </p>
     *         <p>
     *         <code>RESOURCE_TERMINATED</code> - This resource has been terminated. The findings and coverage
     *         associated with this resource are in the process of being cleaned up.
     *         </p>
     *         <p>
     *         <code>SUCCESSFUL</code> - The scan was successful.
     *         </p>
     *         <p>
     *         <code>NO_RESOURCES_FOUND</code> - Reserved for future use.
     *         </p>
     *         <p>
     *         <code>IMAGE_SIZE_EXCEEDED</code> - Reserved for future use.
     *         </p>
     *         <p>
     *         <code>SCAN_FREQUENCY_MANUAL</code> - This image will not be covered by Amazon Inspector due to the
     *         repository scan frequency configuration.
     *         </p>
     *         <p>
     *         <code>SCAN_FREQUENCY_SCAN_ON_PUSH </code>- This image will be scanned one time and will not new findings
     *         because of the scan frequency configuration.
     *         </p>
     *         <p>
     *         <code>EC2_INSTANCE_STOPPED</code> - This EC2 instance is in a stopped state, therefore, Amazon Inspector
     *         will pause scanning. The existing findings will continue to exist until the instance is terminated. Once
     *         the instance is re-started, Inspector will automatically start scanning the instance again. Please note
     *         that you will not be charged for this instance while it’s in a stopped state.
     *         </p>
     *         <p>
     *         <code>PENDING_DISABLE</code> - This resource is pending cleanup during disablement. The customer will not
     *         be billed while a resource is in the pending disable status.
     *         </p>
     *         <p>
     *         <code>NO INVENTORY</code> - Amazon Inspector couldn’t find software application inventory to scan for
     *         vulnerabilities. This might be caused due to required Amazon Inspector associations being deleted or
     *         failing to run on your resource. Please verify the status of
     *         <code>InspectorInventoryCollection-do-not-delete</code> association in the SSM console for the resource.
     *         Additionally, you can verify the instance’s inventory in the SSM Fleet Manager console.
     *         </p>
     *         <p>
     *         <code>STALE_INVENTORY</code> - Amazon Inspector wasn’t able to collect an updated software application
     *         inventory in the last 7 days. Please confirm the required Amazon Inspector associations still exist and
     *         you can still see an updated inventory in the SSM console.
     *         </p>
     *         <p>
     *         <code>EXCLUDED_BY_TAG</code> - This resource was not scanned because it has been excluded by a tag.
     *         </p>
     *         <p>
     *         <code>UNSUPPORTED_RUNTIME</code> - The function was not scanned because it has an unsupported runtime. To
     *         see a complete list of supported runtimes see: <a
     *         href=" https://docs.aws.amazon.com/inspector/latest/user/supported.html"
     *         >https://docs.aws.amazon.com/inspector/latest/user/supported.html</a>.
     *         </p>
     *         <p>
     *         <code>UNSUPPORTED_MEDIA_TYPE </code>- The ECR image has an unsupported media type.
     *         </p>
     *         <p>
     *         <code>UNSUPPORTED_CONFIG_FILE</code> - Reserved for future use.
     *         </p>
     *         <p>
     *         <code>DEEP_INSPECTION_PACKAGE_COLLECTION_LIMIT_EXCEEDED</code> - The instance has exceeded the 5000
     *         package limit for Amazon Inspector Deep inspection. To resume Deep inspection for this instance you can
     *         try to adjust the custom paths associated with the account.
     *         </p>
     *         <p>
     *         <code>DEEP_INSPECTION_DAILY_SSM_INVENTORY_LIMIT_EXCEEDED</code> - The SSM agent couldn't send inventory
     *         to Amazon Inspector because the SSM quota for Inventory data collected per instance per day has already
     *         been reached for this instance.
     *         </p>
     *         <p>
     *         <code>DEEP_INSPECTION_COLLECTION_TIME_LIMIT_EXCEEDED</code> - Amazon Inspector failed to extract the
     *         package inventory because the package collection time exceeding the maximum threshold of 15 minutes.
     *         </p>
     *         <p>
     *         <code>DEEP_INSPECTION_NO_INVENTORY</code> The Amazon Inspector plugin hasn't yet been able to collect an
     *         inventory of packages for this instance. This is usually the result of a pending scan, however, if this
     *         status persists after 6 hours, use SSM to ensure that the required Amazon Inspector associations exist
     *         and are running for the instance.
     *         </p>
     * @see ScanStatusReason
     */
    public final ScanStatusReason reason() {
        return ScanStatusReason.fromValue(reason);
    }

    /**
     * <p>
     * The scan status. Possible return values and descriptions are:
     * </p>
     * <p>
     * <code>PENDING_INITIAL_SCAN</code> - This resource has been identified for scanning, results will be available
     * soon.
     * </p>
     * <p>
     * <code>ACCESS_DENIED</code> - Resource access policy restricting Amazon Inspector access. Please update the IAM
     * policy.
     * </p>
     * <p>
     * <code>INTERNAL_ERROR</code> - Amazon Inspector has encountered an internal error for this resource. Amazon
     * Inspector service will automatically resolve the issue and resume the scanning. No action required from the user.
     * </p>
     * <p>
     * <code>UNMANAGED_EC2_INSTANCE</code> - The EC2 instance is not managed by SSM, please use the following SSM
     * automation to remediate the issue: <a href=
     * "https://docs.aws.amazon.com/systems-manager-automation-runbooks/latest/userguide/automation-awssupport-troubleshoot-managed-instance.html"
     * >https://docs.aws.amazon.com/systems-manager-automation-runbooks/latest/userguide/automation-awssupport-
     * troubleshoot-managed-instance.html</a>. Once the instance becomes managed by SSM, Inspector will automatically
     * begin scanning this instance.
     * </p>
     * <p>
     * <code>UNSUPPORTED_OS</code> - Amazon Inspector does not support this OS, architecture, or image manifest type at
     * this time. To see a complete list of supported operating systems see: <a
     * href=" https://docs.aws.amazon.com/inspector/latest/user/supported.html"
     * >https://docs.aws.amazon.com/inspector/latest/user/supported.html</a>.
     * </p>
     * <p>
     * <code>SCAN_ELIGIBILITY_EXPIRED</code> - The configured scan duration has lapsed for this image.
     * </p>
     * <p>
     * <code>RESOURCE_TERMINATED</code> - This resource has been terminated. The findings and coverage associated with
     * this resource are in the process of being cleaned up.
     * </p>
     * <p>
     * <code>SUCCESSFUL</code> - The scan was successful.
     * </p>
     * <p>
     * <code>NO_RESOURCES_FOUND</code> - Reserved for future use.
     * </p>
     * <p>
     * <code>IMAGE_SIZE_EXCEEDED</code> - Reserved for future use.
     * </p>
     * <p>
     * <code>SCAN_FREQUENCY_MANUAL</code> - This image will not be covered by Amazon Inspector due to the repository
     * scan frequency configuration.
     * </p>
     * <p>
     * <code>SCAN_FREQUENCY_SCAN_ON_PUSH </code>- This image will be scanned one time and will not new findings because
     * of the scan frequency configuration.
     * </p>
     * <p>
     * <code>EC2_INSTANCE_STOPPED</code> - This EC2 instance is in a stopped state, therefore, Amazon Inspector will
     * pause scanning. The existing findings will continue to exist until the instance is terminated. Once the instance
     * is re-started, Inspector will automatically start scanning the instance again. Please note that you will not be
     * charged for this instance while it’s in a stopped state.
     * </p>
     * <p>
     * <code>PENDING_DISABLE</code> - This resource is pending cleanup during disablement. The customer will not be
     * billed while a resource is in the pending disable status.
     * </p>
     * <p>
     * <code>NO INVENTORY</code> - Amazon Inspector couldn’t find software application inventory to scan for
     * vulnerabilities. This might be caused due to required Amazon Inspector associations being deleted or failing to
     * run on your resource. Please verify the status of <code>InspectorInventoryCollection-do-not-delete</code>
     * association in the SSM console for the resource. Additionally, you can verify the instance’s inventory in the SSM
     * Fleet Manager console.
     * </p>
     * <p>
     * <code>STALE_INVENTORY</code> - Amazon Inspector wasn’t able to collect an updated software application inventory
     * in the last 7 days. Please confirm the required Amazon Inspector associations still exist and you can still see
     * an updated inventory in the SSM console.
     * </p>
     * <p>
     * <code>EXCLUDED_BY_TAG</code> - This resource was not scanned because it has been excluded by a tag.
     * </p>
     * <p>
     * <code>UNSUPPORTED_RUNTIME</code> - The function was not scanned because it has an unsupported runtime. To see a
     * complete list of supported runtimes see: <a
     * href=" https://docs.aws.amazon.com/inspector/latest/user/supported.html"
     * >https://docs.aws.amazon.com/inspector/latest/user/supported.html</a>.
     * </p>
     * <p>
     * <code>UNSUPPORTED_MEDIA_TYPE </code>- The ECR image has an unsupported media type.
     * </p>
     * <p>
     * <code>UNSUPPORTED_CONFIG_FILE</code> - Reserved for future use.
     * </p>
     * <p>
     * <code>DEEP_INSPECTION_PACKAGE_COLLECTION_LIMIT_EXCEEDED</code> - The instance has exceeded the 5000 package limit
     * for Amazon Inspector Deep inspection. To resume Deep inspection for this instance you can try to adjust the
     * custom paths associated with the account.
     * </p>
     * <p>
     * <code>DEEP_INSPECTION_DAILY_SSM_INVENTORY_LIMIT_EXCEEDED</code> - The SSM agent couldn't send inventory to Amazon
     * Inspector because the SSM quota for Inventory data collected per instance per day has already been reached for
     * this instance.
     * </p>
     * <p>
     * <code>DEEP_INSPECTION_COLLECTION_TIME_LIMIT_EXCEEDED</code> - Amazon Inspector failed to extract the package
     * inventory because the package collection time exceeding the maximum threshold of 15 minutes.
     * </p>
     * <p>
     * <code>DEEP_INSPECTION_NO_INVENTORY</code> The Amazon Inspector plugin hasn't yet been able to collect an
     * inventory of packages for this instance. This is usually the result of a pending scan, however, if this status
     * persists after 6 hours, use SSM to ensure that the required Amazon Inspector associations exist and are running
     * for the instance.
     * </p>
     * <p/>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #reason} will
     * return {@link ScanStatusReason#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #reasonAsString}.
     * </p>
     * 
     * @return The scan status. Possible return values and descriptions are: </p>
     *         <p>
     *         <code>PENDING_INITIAL_SCAN</code> - This resource has been identified for scanning, results will be
     *         available soon.
     *         </p>
     *         <p>
     *         <code>ACCESS_DENIED</code> - Resource access policy restricting Amazon Inspector access. Please update
     *         the IAM policy.
     *         </p>
     *         <p>
     *         <code>INTERNAL_ERROR</code> - Amazon Inspector has encountered an internal error for this resource.
     *         Amazon Inspector service will automatically resolve the issue and resume the scanning. No action required
     *         from the user.
     *         </p>
     *         <p>
     *         <code>UNMANAGED_EC2_INSTANCE</code> - The EC2 instance is not managed by SSM, please use the following
     *         SSM automation to remediate the issue: <a href=
     *         "https://docs.aws.amazon.com/systems-manager-automation-runbooks/latest/userguide/automation-awssupport-troubleshoot-managed-instance.html"
     *         >https://docs.aws.amazon.com/systems-manager-automation-runbooks/latest/userguide/automation-awssupport-
     *         troubleshoot-managed-instance.html</a>. Once the instance becomes managed by SSM, Inspector will
     *         automatically begin scanning this instance.
     *         </p>
     *         <p>
     *         <code>UNSUPPORTED_OS</code> - Amazon Inspector does not support this OS, architecture, or image manifest
     *         type at this time. To see a complete list of supported operating systems see: <a
     *         href=" https://docs.aws.amazon.com/inspector/latest/user/supported.html"
     *         >https://docs.aws.amazon.com/inspector/latest/user/supported.html</a>.
     *         </p>
     *         <p>
     *         <code>SCAN_ELIGIBILITY_EXPIRED</code> - The configured scan duration has lapsed for this image.
     *         </p>
     *         <p>
     *         <code>RESOURCE_TERMINATED</code> - This resource has been terminated. The findings and coverage
     *         associated with this resource are in the process of being cleaned up.
     *         </p>
     *         <p>
     *         <code>SUCCESSFUL</code> - The scan was successful.
     *         </p>
     *         <p>
     *         <code>NO_RESOURCES_FOUND</code> - Reserved for future use.
     *         </p>
     *         <p>
     *         <code>IMAGE_SIZE_EXCEEDED</code> - Reserved for future use.
     *         </p>
     *         <p>
     *         <code>SCAN_FREQUENCY_MANUAL</code> - This image will not be covered by Amazon Inspector due to the
     *         repository scan frequency configuration.
     *         </p>
     *         <p>
     *         <code>SCAN_FREQUENCY_SCAN_ON_PUSH </code>- This image will be scanned one time and will not new findings
     *         because of the scan frequency configuration.
     *         </p>
     *         <p>
     *         <code>EC2_INSTANCE_STOPPED</code> - This EC2 instance is in a stopped state, therefore, Amazon Inspector
     *         will pause scanning. The existing findings will continue to exist until the instance is terminated. Once
     *         the instance is re-started, Inspector will automatically start scanning the instance again. Please note
     *         that you will not be charged for this instance while it’s in a stopped state.
     *         </p>
     *         <p>
     *         <code>PENDING_DISABLE</code> - This resource is pending cleanup during disablement. The customer will not
     *         be billed while a resource is in the pending disable status.
     *         </p>
     *         <p>
     *         <code>NO INVENTORY</code> - Amazon Inspector couldn’t find software application inventory to scan for
     *         vulnerabilities. This might be caused due to required Amazon Inspector associations being deleted or
     *         failing to run on your resource. Please verify the status of
     *         <code>InspectorInventoryCollection-do-not-delete</code> association in the SSM console for the resource.
     *         Additionally, you can verify the instance’s inventory in the SSM Fleet Manager console.
     *         </p>
     *         <p>
     *         <code>STALE_INVENTORY</code> - Amazon Inspector wasn’t able to collect an updated software application
     *         inventory in the last 7 days. Please confirm the required Amazon Inspector associations still exist and
     *         you can still see an updated inventory in the SSM console.
     *         </p>
     *         <p>
     *         <code>EXCLUDED_BY_TAG</code> - This resource was not scanned because it has been excluded by a tag.
     *         </p>
     *         <p>
     *         <code>UNSUPPORTED_RUNTIME</code> - The function was not scanned because it has an unsupported runtime. To
     *         see a complete list of supported runtimes see: <a
     *         href=" https://docs.aws.amazon.com/inspector/latest/user/supported.html"
     *         >https://docs.aws.amazon.com/inspector/latest/user/supported.html</a>.
     *         </p>
     *         <p>
     *         <code>UNSUPPORTED_MEDIA_TYPE </code>- The ECR image has an unsupported media type.
     *         </p>
     *         <p>
     *         <code>UNSUPPORTED_CONFIG_FILE</code> - Reserved for future use.
     *         </p>
     *         <p>
     *         <code>DEEP_INSPECTION_PACKAGE_COLLECTION_LIMIT_EXCEEDED</code> - The instance has exceeded the 5000
     *         package limit for Amazon Inspector Deep inspection. To resume Deep inspection for this instance you can
     *         try to adjust the custom paths associated with the account.
     *         </p>
     *         <p>
     *         <code>DEEP_INSPECTION_DAILY_SSM_INVENTORY_LIMIT_EXCEEDED</code> - The SSM agent couldn't send inventory
     *         to Amazon Inspector because the SSM quota for Inventory data collected per instance per day has already
     *         been reached for this instance.
     *         </p>
     *         <p>
     *         <code>DEEP_INSPECTION_COLLECTION_TIME_LIMIT_EXCEEDED</code> - Amazon Inspector failed to extract the
     *         package inventory because the package collection time exceeding the maximum threshold of 15 minutes.
     *         </p>
     *         <p>
     *         <code>DEEP_INSPECTION_NO_INVENTORY</code> The Amazon Inspector plugin hasn't yet been able to collect an
     *         inventory of packages for this instance. This is usually the result of a pending scan, however, if this
     *         status persists after 6 hours, use SSM to ensure that the required Amazon Inspector associations exist
     *         and are running for the instance.
     *         </p>
     * @see ScanStatusReason
     */
    public final String reasonAsString() {
        return reason;
    }

    /**
     * <p>
     * The status code of the scan.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #statusCode} will
     * return {@link ScanStatusCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusCodeAsString}.
     * </p>
     * 
     * @return The status code of the scan.
     * @see ScanStatusCode
     */
    public final ScanStatusCode statusCode() {
        return ScanStatusCode.fromValue(statusCodeValue);
    }

    /**
     * <p>
     * The status code of the scan.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #statusCode} will
     * return {@link ScanStatusCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusCodeAsString}.
     * </p>
     * 
     * @return The status code of the scan.
     * @see ScanStatusCode
     */
    public final String statusCodeAsString() {
        return statusCodeValue;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(reasonAsString());
        hashCode = 31 * hashCode + Objects.hashCode(statusCodeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ScanStatus)) {
            return false;
        }
        ScanStatus other = (ScanStatus) obj;
        return Objects.equals(reasonAsString(), other.reasonAsString())
                && Objects.equals(statusCodeAsString(), other.statusCodeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ScanStatus").add("Reason", reasonAsString()).add("StatusCode", statusCodeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "reason":
            return Optional.ofNullable(clazz.cast(reasonAsString()));
        case "statusCode":
            return Optional.ofNullable(clazz.cast(statusCodeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("reason", REASON_FIELD);
        map.put("statusCode", STATUS_CODE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ScanStatus, T> g) {
        return obj -> g.apply((ScanStatus) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ScanStatus> {
        /**
         * <p>
         * The scan status. Possible return values and descriptions are:
         * </p>
         * <p>
         * <code>PENDING_INITIAL_SCAN</code> - This resource has been identified for scanning, results will be available
         * soon.
         * </p>
         * <p>
         * <code>ACCESS_DENIED</code> - Resource access policy restricting Amazon Inspector access. Please update the
         * IAM policy.
         * </p>
         * <p>
         * <code>INTERNAL_ERROR</code> - Amazon Inspector has encountered an internal error for this resource. Amazon
         * Inspector service will automatically resolve the issue and resume the scanning. No action required from the
         * user.
         * </p>
         * <p>
         * <code>UNMANAGED_EC2_INSTANCE</code> - The EC2 instance is not managed by SSM, please use the following SSM
         * automation to remediate the issue: <a href=
         * "https://docs.aws.amazon.com/systems-manager-automation-runbooks/latest/userguide/automation-awssupport-troubleshoot-managed-instance.html"
         * >https://docs.aws.amazon.com/systems-manager-automation-runbooks/latest/userguide/automation-awssupport-
         * troubleshoot-managed-instance.html</a>. Once the instance becomes managed by SSM, Inspector will
         * automatically begin scanning this instance.
         * </p>
         * <p>
         * <code>UNSUPPORTED_OS</code> - Amazon Inspector does not support this OS, architecture, or image manifest type
         * at this time. To see a complete list of supported operating systems see: <a
         * href=" https://docs.aws.amazon.com/inspector/latest/user/supported.html"
         * >https://docs.aws.amazon.com/inspector/latest/user/supported.html</a>.
         * </p>
         * <p>
         * <code>SCAN_ELIGIBILITY_EXPIRED</code> - The configured scan duration has lapsed for this image.
         * </p>
         * <p>
         * <code>RESOURCE_TERMINATED</code> - This resource has been terminated. The findings and coverage associated
         * with this resource are in the process of being cleaned up.
         * </p>
         * <p>
         * <code>SUCCESSFUL</code> - The scan was successful.
         * </p>
         * <p>
         * <code>NO_RESOURCES_FOUND</code> - Reserved for future use.
         * </p>
         * <p>
         * <code>IMAGE_SIZE_EXCEEDED</code> - Reserved for future use.
         * </p>
         * <p>
         * <code>SCAN_FREQUENCY_MANUAL</code> - This image will not be covered by Amazon Inspector due to the repository
         * scan frequency configuration.
         * </p>
         * <p>
         * <code>SCAN_FREQUENCY_SCAN_ON_PUSH </code>- This image will be scanned one time and will not new findings
         * because of the scan frequency configuration.
         * </p>
         * <p>
         * <code>EC2_INSTANCE_STOPPED</code> - This EC2 instance is in a stopped state, therefore, Amazon Inspector will
         * pause scanning. The existing findings will continue to exist until the instance is terminated. Once the
         * instance is re-started, Inspector will automatically start scanning the instance again. Please note that you
         * will not be charged for this instance while it’s in a stopped state.
         * </p>
         * <p>
         * <code>PENDING_DISABLE</code> - This resource is pending cleanup during disablement. The customer will not be
         * billed while a resource is in the pending disable status.
         * </p>
         * <p>
         * <code>NO INVENTORY</code> - Amazon Inspector couldn’t find software application inventory to scan for
         * vulnerabilities. This might be caused due to required Amazon Inspector associations being deleted or failing
         * to run on your resource. Please verify the status of <code>InspectorInventoryCollection-do-not-delete</code>
         * association in the SSM console for the resource. Additionally, you can verify the instance’s inventory in the
         * SSM Fleet Manager console.
         * </p>
         * <p>
         * <code>STALE_INVENTORY</code> - Amazon Inspector wasn’t able to collect an updated software application
         * inventory in the last 7 days. Please confirm the required Amazon Inspector associations still exist and you
         * can still see an updated inventory in the SSM console.
         * </p>
         * <p>
         * <code>EXCLUDED_BY_TAG</code> - This resource was not scanned because it has been excluded by a tag.
         * </p>
         * <p>
         * <code>UNSUPPORTED_RUNTIME</code> - The function was not scanned because it has an unsupported runtime. To see
         * a complete list of supported runtimes see: <a
         * href=" https://docs.aws.amazon.com/inspector/latest/user/supported.html"
         * >https://docs.aws.amazon.com/inspector/latest/user/supported.html</a>.
         * </p>
         * <p>
         * <code>UNSUPPORTED_MEDIA_TYPE </code>- The ECR image has an unsupported media type.
         * </p>
         * <p>
         * <code>UNSUPPORTED_CONFIG_FILE</code> - Reserved for future use.
         * </p>
         * <p>
         * <code>DEEP_INSPECTION_PACKAGE_COLLECTION_LIMIT_EXCEEDED</code> - The instance has exceeded the 5000 package
         * limit for Amazon Inspector Deep inspection. To resume Deep inspection for this instance you can try to adjust
         * the custom paths associated with the account.
         * </p>
         * <p>
         * <code>DEEP_INSPECTION_DAILY_SSM_INVENTORY_LIMIT_EXCEEDED</code> - The SSM agent couldn't send inventory to
         * Amazon Inspector because the SSM quota for Inventory data collected per instance per day has already been
         * reached for this instance.
         * </p>
         * <p>
         * <code>DEEP_INSPECTION_COLLECTION_TIME_LIMIT_EXCEEDED</code> - Amazon Inspector failed to extract the package
         * inventory because the package collection time exceeding the maximum threshold of 15 minutes.
         * </p>
         * <p>
         * <code>DEEP_INSPECTION_NO_INVENTORY</code> The Amazon Inspector plugin hasn't yet been able to collect an
         * inventory of packages for this instance. This is usually the result of a pending scan, however, if this
         * status persists after 6 hours, use SSM to ensure that the required Amazon Inspector associations exist and
         * are running for the instance.
         * </p>
         * <p/>
         * 
         * @param reason
         *        The scan status. Possible return values and descriptions are:
         *        </p>
         *        <p>
         *        <code>PENDING_INITIAL_SCAN</code> - This resource has been identified for scanning, results will be
         *        available soon.
         *        </p>
         *        <p>
         *        <code>ACCESS_DENIED</code> - Resource access policy restricting Amazon Inspector access. Please update
         *        the IAM policy.
         *        </p>
         *        <p>
         *        <code>INTERNAL_ERROR</code> - Amazon Inspector has encountered an internal error for this resource.
         *        Amazon Inspector service will automatically resolve the issue and resume the scanning. No action
         *        required from the user.
         *        </p>
         *        <p>
         *        <code>UNMANAGED_EC2_INSTANCE</code> - The EC2 instance is not managed by SSM, please use the following
         *        SSM automation to remediate the issue: <a href=
         *        "https://docs.aws.amazon.com/systems-manager-automation-runbooks/latest/userguide/automation-awssupport-troubleshoot-managed-instance.html"
         *        >https://docs.aws.amazon.com/systems-manager-automation-runbooks/latest/userguide/automation-
         *        awssupport-troubleshoot-managed-instance.html</a>. Once the instance becomes managed by SSM, Inspector
         *        will automatically begin scanning this instance.
         *        </p>
         *        <p>
         *        <code>UNSUPPORTED_OS</code> - Amazon Inspector does not support this OS, architecture, or image
         *        manifest type at this time. To see a complete list of supported operating systems see: <a
         *        href=" https://docs.aws.amazon.com/inspector/latest/user/supported.html"
         *        >https://docs.aws.amazon.com/inspector/latest/user/supported.html</a>.
         *        </p>
         *        <p>
         *        <code>SCAN_ELIGIBILITY_EXPIRED</code> - The configured scan duration has lapsed for this image.
         *        </p>
         *        <p>
         *        <code>RESOURCE_TERMINATED</code> - This resource has been terminated. The findings and coverage
         *        associated with this resource are in the process of being cleaned up.
         *        </p>
         *        <p>
         *        <code>SUCCESSFUL</code> - The scan was successful.
         *        </p>
         *        <p>
         *        <code>NO_RESOURCES_FOUND</code> - Reserved for future use.
         *        </p>
         *        <p>
         *        <code>IMAGE_SIZE_EXCEEDED</code> - Reserved for future use.
         *        </p>
         *        <p>
         *        <code>SCAN_FREQUENCY_MANUAL</code> - This image will not be covered by Amazon Inspector due to the
         *        repository scan frequency configuration.
         *        </p>
         *        <p>
         *        <code>SCAN_FREQUENCY_SCAN_ON_PUSH </code>- This image will be scanned one time and will not new
         *        findings because of the scan frequency configuration.
         *        </p>
         *        <p>
         *        <code>EC2_INSTANCE_STOPPED</code> - This EC2 instance is in a stopped state, therefore, Amazon
         *        Inspector will pause scanning. The existing findings will continue to exist until the instance is
         *        terminated. Once the instance is re-started, Inspector will automatically start scanning the instance
         *        again. Please note that you will not be charged for this instance while it’s in a stopped state.
         *        </p>
         *        <p>
         *        <code>PENDING_DISABLE</code> - This resource is pending cleanup during disablement. The customer will
         *        not be billed while a resource is in the pending disable status.
         *        </p>
         *        <p>
         *        <code>NO INVENTORY</code> - Amazon Inspector couldn’t find software application inventory to scan for
         *        vulnerabilities. This might be caused due to required Amazon Inspector associations being deleted or
         *        failing to run on your resource. Please verify the status of
         *        <code>InspectorInventoryCollection-do-not-delete</code> association in the SSM console for the
         *        resource. Additionally, you can verify the instance’s inventory in the SSM Fleet Manager console.
         *        </p>
         *        <p>
         *        <code>STALE_INVENTORY</code> - Amazon Inspector wasn’t able to collect an updated software application
         *        inventory in the last 7 days. Please confirm the required Amazon Inspector associations still exist
         *        and you can still see an updated inventory in the SSM console.
         *        </p>
         *        <p>
         *        <code>EXCLUDED_BY_TAG</code> - This resource was not scanned because it has been excluded by a tag.
         *        </p>
         *        <p>
         *        <code>UNSUPPORTED_RUNTIME</code> - The function was not scanned because it has an unsupported runtime.
         *        To see a complete list of supported runtimes see: <a
         *        href=" https://docs.aws.amazon.com/inspector/latest/user/supported.html"
         *        >https://docs.aws.amazon.com/inspector/latest/user/supported.html</a>.
         *        </p>
         *        <p>
         *        <code>UNSUPPORTED_MEDIA_TYPE </code>- The ECR image has an unsupported media type.
         *        </p>
         *        <p>
         *        <code>UNSUPPORTED_CONFIG_FILE</code> - Reserved for future use.
         *        </p>
         *        <p>
         *        <code>DEEP_INSPECTION_PACKAGE_COLLECTION_LIMIT_EXCEEDED</code> - The instance has exceeded the 5000
         *        package limit for Amazon Inspector Deep inspection. To resume Deep inspection for this instance you
         *        can try to adjust the custom paths associated with the account.
         *        </p>
         *        <p>
         *        <code>DEEP_INSPECTION_DAILY_SSM_INVENTORY_LIMIT_EXCEEDED</code> - The SSM agent couldn't send
         *        inventory to Amazon Inspector because the SSM quota for Inventory data collected per instance per day
         *        has already been reached for this instance.
         *        </p>
         *        <p>
         *        <code>DEEP_INSPECTION_COLLECTION_TIME_LIMIT_EXCEEDED</code> - Amazon Inspector failed to extract the
         *        package inventory because the package collection time exceeding the maximum threshold of 15 minutes.
         *        </p>
         *        <p>
         *        <code>DEEP_INSPECTION_NO_INVENTORY</code> The Amazon Inspector plugin hasn't yet been able to collect
         *        an inventory of packages for this instance. This is usually the result of a pending scan, however, if
         *        this status persists after 6 hours, use SSM to ensure that the required Amazon Inspector associations
         *        exist and are running for the instance.
         *        </p>
         * @see ScanStatusReason
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ScanStatusReason
         */
        Builder reason(String reason);

        /**
         * <p>
         * The scan status. Possible return values and descriptions are:
         * </p>
         * <p>
         * <code>PENDING_INITIAL_SCAN</code> - This resource has been identified for scanning, results will be available
         * soon.
         * </p>
         * <p>
         * <code>ACCESS_DENIED</code> - Resource access policy restricting Amazon Inspector access. Please update the
         * IAM policy.
         * </p>
         * <p>
         * <code>INTERNAL_ERROR</code> - Amazon Inspector has encountered an internal error for this resource. Amazon
         * Inspector service will automatically resolve the issue and resume the scanning. No action required from the
         * user.
         * </p>
         * <p>
         * <code>UNMANAGED_EC2_INSTANCE</code> - The EC2 instance is not managed by SSM, please use the following SSM
         * automation to remediate the issue: <a href=
         * "https://docs.aws.amazon.com/systems-manager-automation-runbooks/latest/userguide/automation-awssupport-troubleshoot-managed-instance.html"
         * >https://docs.aws.amazon.com/systems-manager-automation-runbooks/latest/userguide/automation-awssupport-
         * troubleshoot-managed-instance.html</a>. Once the instance becomes managed by SSM, Inspector will
         * automatically begin scanning this instance.
         * </p>
         * <p>
         * <code>UNSUPPORTED_OS</code> - Amazon Inspector does not support this OS, architecture, or image manifest type
         * at this time. To see a complete list of supported operating systems see: <a
         * href=" https://docs.aws.amazon.com/inspector/latest/user/supported.html"
         * >https://docs.aws.amazon.com/inspector/latest/user/supported.html</a>.
         * </p>
         * <p>
         * <code>SCAN_ELIGIBILITY_EXPIRED</code> - The configured scan duration has lapsed for this image.
         * </p>
         * <p>
         * <code>RESOURCE_TERMINATED</code> - This resource has been terminated. The findings and coverage associated
         * with this resource are in the process of being cleaned up.
         * </p>
         * <p>
         * <code>SUCCESSFUL</code> - The scan was successful.
         * </p>
         * <p>
         * <code>NO_RESOURCES_FOUND</code> - Reserved for future use.
         * </p>
         * <p>
         * <code>IMAGE_SIZE_EXCEEDED</code> - Reserved for future use.
         * </p>
         * <p>
         * <code>SCAN_FREQUENCY_MANUAL</code> - This image will not be covered by Amazon Inspector due to the repository
         * scan frequency configuration.
         * </p>
         * <p>
         * <code>SCAN_FREQUENCY_SCAN_ON_PUSH </code>- This image will be scanned one time and will not new findings
         * because of the scan frequency configuration.
         * </p>
         * <p>
         * <code>EC2_INSTANCE_STOPPED</code> - This EC2 instance is in a stopped state, therefore, Amazon Inspector will
         * pause scanning. The existing findings will continue to exist until the instance is terminated. Once the
         * instance is re-started, Inspector will automatically start scanning the instance again. Please note that you
         * will not be charged for this instance while it’s in a stopped state.
         * </p>
         * <p>
         * <code>PENDING_DISABLE</code> - This resource is pending cleanup during disablement. The customer will not be
         * billed while a resource is in the pending disable status.
         * </p>
         * <p>
         * <code>NO INVENTORY</code> - Amazon Inspector couldn’t find software application inventory to scan for
         * vulnerabilities. This might be caused due to required Amazon Inspector associations being deleted or failing
         * to run on your resource. Please verify the status of <code>InspectorInventoryCollection-do-not-delete</code>
         * association in the SSM console for the resource. Additionally, you can verify the instance’s inventory in the
         * SSM Fleet Manager console.
         * </p>
         * <p>
         * <code>STALE_INVENTORY</code> - Amazon Inspector wasn’t able to collect an updated software application
         * inventory in the last 7 days. Please confirm the required Amazon Inspector associations still exist and you
         * can still see an updated inventory in the SSM console.
         * </p>
         * <p>
         * <code>EXCLUDED_BY_TAG</code> - This resource was not scanned because it has been excluded by a tag.
         * </p>
         * <p>
         * <code>UNSUPPORTED_RUNTIME</code> - The function was not scanned because it has an unsupported runtime. To see
         * a complete list of supported runtimes see: <a
         * href=" https://docs.aws.amazon.com/inspector/latest/user/supported.html"
         * >https://docs.aws.amazon.com/inspector/latest/user/supported.html</a>.
         * </p>
         * <p>
         * <code>UNSUPPORTED_MEDIA_TYPE </code>- The ECR image has an unsupported media type.
         * </p>
         * <p>
         * <code>UNSUPPORTED_CONFIG_FILE</code> - Reserved for future use.
         * </p>
         * <p>
         * <code>DEEP_INSPECTION_PACKAGE_COLLECTION_LIMIT_EXCEEDED</code> - The instance has exceeded the 5000 package
         * limit for Amazon Inspector Deep inspection. To resume Deep inspection for this instance you can try to adjust
         * the custom paths associated with the account.
         * </p>
         * <p>
         * <code>DEEP_INSPECTION_DAILY_SSM_INVENTORY_LIMIT_EXCEEDED</code> - The SSM agent couldn't send inventory to
         * Amazon Inspector because the SSM quota for Inventory data collected per instance per day has already been
         * reached for this instance.
         * </p>
         * <p>
         * <code>DEEP_INSPECTION_COLLECTION_TIME_LIMIT_EXCEEDED</code> - Amazon Inspector failed to extract the package
         * inventory because the package collection time exceeding the maximum threshold of 15 minutes.
         * </p>
         * <p>
         * <code>DEEP_INSPECTION_NO_INVENTORY</code> The Amazon Inspector plugin hasn't yet been able to collect an
         * inventory of packages for this instance. This is usually the result of a pending scan, however, if this
         * status persists after 6 hours, use SSM to ensure that the required Amazon Inspector associations exist and
         * are running for the instance.
         * </p>
         * <p/>
         * 
         * @param reason
         *        The scan status. Possible return values and descriptions are:
         *        </p>
         *        <p>
         *        <code>PENDING_INITIAL_SCAN</code> - This resource has been identified for scanning, results will be
         *        available soon.
         *        </p>
         *        <p>
         *        <code>ACCESS_DENIED</code> - Resource access policy restricting Amazon Inspector access. Please update
         *        the IAM policy.
         *        </p>
         *        <p>
         *        <code>INTERNAL_ERROR</code> - Amazon Inspector has encountered an internal error for this resource.
         *        Amazon Inspector service will automatically resolve the issue and resume the scanning. No action
         *        required from the user.
         *        </p>
         *        <p>
         *        <code>UNMANAGED_EC2_INSTANCE</code> - The EC2 instance is not managed by SSM, please use the following
         *        SSM automation to remediate the issue: <a href=
         *        "https://docs.aws.amazon.com/systems-manager-automation-runbooks/latest/userguide/automation-awssupport-troubleshoot-managed-instance.html"
         *        >https://docs.aws.amazon.com/systems-manager-automation-runbooks/latest/userguide/automation-
         *        awssupport-troubleshoot-managed-instance.html</a>. Once the instance becomes managed by SSM, Inspector
         *        will automatically begin scanning this instance.
         *        </p>
         *        <p>
         *        <code>UNSUPPORTED_OS</code> - Amazon Inspector does not support this OS, architecture, or image
         *        manifest type at this time. To see a complete list of supported operating systems see: <a
         *        href=" https://docs.aws.amazon.com/inspector/latest/user/supported.html"
         *        >https://docs.aws.amazon.com/inspector/latest/user/supported.html</a>.
         *        </p>
         *        <p>
         *        <code>SCAN_ELIGIBILITY_EXPIRED</code> - The configured scan duration has lapsed for this image.
         *        </p>
         *        <p>
         *        <code>RESOURCE_TERMINATED</code> - This resource has been terminated. The findings and coverage
         *        associated with this resource are in the process of being cleaned up.
         *        </p>
         *        <p>
         *        <code>SUCCESSFUL</code> - The scan was successful.
         *        </p>
         *        <p>
         *        <code>NO_RESOURCES_FOUND</code> - Reserved for future use.
         *        </p>
         *        <p>
         *        <code>IMAGE_SIZE_EXCEEDED</code> - Reserved for future use.
         *        </p>
         *        <p>
         *        <code>SCAN_FREQUENCY_MANUAL</code> - This image will not be covered by Amazon Inspector due to the
         *        repository scan frequency configuration.
         *        </p>
         *        <p>
         *        <code>SCAN_FREQUENCY_SCAN_ON_PUSH </code>- This image will be scanned one time and will not new
         *        findings because of the scan frequency configuration.
         *        </p>
         *        <p>
         *        <code>EC2_INSTANCE_STOPPED</code> - This EC2 instance is in a stopped state, therefore, Amazon
         *        Inspector will pause scanning. The existing findings will continue to exist until the instance is
         *        terminated. Once the instance is re-started, Inspector will automatically start scanning the instance
         *        again. Please note that you will not be charged for this instance while it’s in a stopped state.
         *        </p>
         *        <p>
         *        <code>PENDING_DISABLE</code> - This resource is pending cleanup during disablement. The customer will
         *        not be billed while a resource is in the pending disable status.
         *        </p>
         *        <p>
         *        <code>NO INVENTORY</code> - Amazon Inspector couldn’t find software application inventory to scan for
         *        vulnerabilities. This might be caused due to required Amazon Inspector associations being deleted or
         *        failing to run on your resource. Please verify the status of
         *        <code>InspectorInventoryCollection-do-not-delete</code> association in the SSM console for the
         *        resource. Additionally, you can verify the instance’s inventory in the SSM Fleet Manager console.
         *        </p>
         *        <p>
         *        <code>STALE_INVENTORY</code> - Amazon Inspector wasn’t able to collect an updated software application
         *        inventory in the last 7 days. Please confirm the required Amazon Inspector associations still exist
         *        and you can still see an updated inventory in the SSM console.
         *        </p>
         *        <p>
         *        <code>EXCLUDED_BY_TAG</code> - This resource was not scanned because it has been excluded by a tag.
         *        </p>
         *        <p>
         *        <code>UNSUPPORTED_RUNTIME</code> - The function was not scanned because it has an unsupported runtime.
         *        To see a complete list of supported runtimes see: <a
         *        href=" https://docs.aws.amazon.com/inspector/latest/user/supported.html"
         *        >https://docs.aws.amazon.com/inspector/latest/user/supported.html</a>.
         *        </p>
         *        <p>
         *        <code>UNSUPPORTED_MEDIA_TYPE </code>- The ECR image has an unsupported media type.
         *        </p>
         *        <p>
         *        <code>UNSUPPORTED_CONFIG_FILE</code> - Reserved for future use.
         *        </p>
         *        <p>
         *        <code>DEEP_INSPECTION_PACKAGE_COLLECTION_LIMIT_EXCEEDED</code> - The instance has exceeded the 5000
         *        package limit for Amazon Inspector Deep inspection. To resume Deep inspection for this instance you
         *        can try to adjust the custom paths associated with the account.
         *        </p>
         *        <p>
         *        <code>DEEP_INSPECTION_DAILY_SSM_INVENTORY_LIMIT_EXCEEDED</code> - The SSM agent couldn't send
         *        inventory to Amazon Inspector because the SSM quota for Inventory data collected per instance per day
         *        has already been reached for this instance.
         *        </p>
         *        <p>
         *        <code>DEEP_INSPECTION_COLLECTION_TIME_LIMIT_EXCEEDED</code> - Amazon Inspector failed to extract the
         *        package inventory because the package collection time exceeding the maximum threshold of 15 minutes.
         *        </p>
         *        <p>
         *        <code>DEEP_INSPECTION_NO_INVENTORY</code> The Amazon Inspector plugin hasn't yet been able to collect
         *        an inventory of packages for this instance. This is usually the result of a pending scan, however, if
         *        this status persists after 6 hours, use SSM to ensure that the required Amazon Inspector associations
         *        exist and are running for the instance.
         *        </p>
         * @see ScanStatusReason
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ScanStatusReason
         */
        Builder reason(ScanStatusReason reason);

        /**
         * <p>
         * The status code of the scan.
         * </p>
         * 
         * @param statusCodeValue
         *        The status code of the scan.
         * @see ScanStatusCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ScanStatusCode
         */
        Builder statusCode(String statusCodeValue);

        /**
         * <p>
         * The status code of the scan.
         * </p>
         * 
         * @param statusCodeValue
         *        The status code of the scan.
         * @see ScanStatusCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ScanStatusCode
         */
        Builder statusCode(ScanStatusCode statusCodeValue);
    }

    static final class BuilderImpl implements Builder {
        private String reason;

        private String statusCodeValue;

        private BuilderImpl() {
        }

        private BuilderImpl(ScanStatus model) {
            reason(model.reason);
            statusCode(model.statusCodeValue);
        }

        public final String getReason() {
            return reason;
        }

        public final void setReason(String reason) {
            this.reason = reason;
        }

        @Override
        public final Builder reason(String reason) {
            this.reason = reason;
            return this;
        }

        @Override
        public final Builder reason(ScanStatusReason reason) {
            this.reason(reason == null ? null : reason.toString());
            return this;
        }

        public final String getStatusCode() {
            return statusCodeValue;
        }

        public final void setStatusCode(String statusCodeValue) {
            this.statusCodeValue = statusCodeValue;
        }

        @Override
        public final Builder statusCode(String statusCodeValue) {
            this.statusCodeValue = statusCodeValue;
            return this;
        }

        @Override
        public final Builder statusCode(ScanStatusCode statusCodeValue) {
            this.statusCode(statusCodeValue == null ? null : statusCodeValue.toString());
            return this;
        }

        @Override
        public ScanStatus build() {
            return new ScanStatus(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
