/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.inspector2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Details on the criteria used to define the filter for a vulnerability search.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SearchVulnerabilitiesFilterCriteria implements SdkPojo, Serializable,
        ToCopyableBuilder<SearchVulnerabilitiesFilterCriteria.Builder, SearchVulnerabilitiesFilterCriteria> {
    private static final SdkField<List<String>> VULNERABILITY_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("vulnerabilityIds")
            .getter(getter(SearchVulnerabilitiesFilterCriteria::vulnerabilityIds))
            .setter(setter(Builder::vulnerabilityIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vulnerabilityIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VULNERABILITY_IDS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<String> vulnerabilityIds;

    private SearchVulnerabilitiesFilterCriteria(BuilderImpl builder) {
        this.vulnerabilityIds = builder.vulnerabilityIds;
    }

    /**
     * For responses, this returns true if the service returned a value for the VulnerabilityIds property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasVulnerabilityIds() {
        return vulnerabilityIds != null && !(vulnerabilityIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The IDs for specific vulnerabilities.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasVulnerabilityIds} method.
     * </p>
     * 
     * @return The IDs for specific vulnerabilities.
     */
    public final List<String> vulnerabilityIds() {
        return vulnerabilityIds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasVulnerabilityIds() ? vulnerabilityIds() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SearchVulnerabilitiesFilterCriteria)) {
            return false;
        }
        SearchVulnerabilitiesFilterCriteria other = (SearchVulnerabilitiesFilterCriteria) obj;
        return hasVulnerabilityIds() == other.hasVulnerabilityIds()
                && Objects.equals(vulnerabilityIds(), other.vulnerabilityIds());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SearchVulnerabilitiesFilterCriteria")
                .add("VulnerabilityIds", hasVulnerabilityIds() ? vulnerabilityIds() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "vulnerabilityIds":
            return Optional.ofNullable(clazz.cast(vulnerabilityIds()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("vulnerabilityIds", VULNERABILITY_IDS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SearchVulnerabilitiesFilterCriteria, T> g) {
        return obj -> g.apply((SearchVulnerabilitiesFilterCriteria) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SearchVulnerabilitiesFilterCriteria> {
        /**
         * <p>
         * The IDs for specific vulnerabilities.
         * </p>
         * 
         * @param vulnerabilityIds
         *        The IDs for specific vulnerabilities.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vulnerabilityIds(Collection<String> vulnerabilityIds);

        /**
         * <p>
         * The IDs for specific vulnerabilities.
         * </p>
         * 
         * @param vulnerabilityIds
         *        The IDs for specific vulnerabilities.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vulnerabilityIds(String... vulnerabilityIds);
    }

    static final class BuilderImpl implements Builder {
        private List<String> vulnerabilityIds = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(SearchVulnerabilitiesFilterCriteria model) {
            vulnerabilityIds(model.vulnerabilityIds);
        }

        public final Collection<String> getVulnerabilityIds() {
            if (vulnerabilityIds instanceof SdkAutoConstructList) {
                return null;
            }
            return vulnerabilityIds;
        }

        public final void setVulnerabilityIds(Collection<String> vulnerabilityIds) {
            this.vulnerabilityIds = VulnIdListCopier.copy(vulnerabilityIds);
        }

        @Override
        public final Builder vulnerabilityIds(Collection<String> vulnerabilityIds) {
            this.vulnerabilityIds = VulnIdListCopier.copy(vulnerabilityIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vulnerabilityIds(String... vulnerabilityIds) {
            vulnerabilityIds(Arrays.asList(vulnerabilityIds));
            return this;
        }

        @Override
        public SearchVulnerabilitiesFilterCriteria build() {
            return new SearchVulnerabilitiesFilterCriteria(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
