/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.inspector2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Details about the step associated with a finding.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Step implements SdkPojo, Serializable, ToCopyableBuilder<Step.Builder, Step> {
    private static final SdkField<String> COMPONENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("componentId").getter(getter(Step::componentId)).setter(setter(Builder::componentId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("componentId").build()).build();

    private static final SdkField<String> COMPONENT_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("componentType").getter(getter(Step::componentType)).setter(setter(Builder::componentType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("componentType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMPONENT_ID_FIELD,
            COMPONENT_TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String componentId;

    private final String componentType;

    private Step(BuilderImpl builder) {
        this.componentId = builder.componentId;
        this.componentType = builder.componentType;
    }

    /**
     * <p>
     * The component ID.
     * </p>
     * 
     * @return The component ID.
     */
    public final String componentId() {
        return componentId;
    }

    /**
     * <p>
     * The component type.
     * </p>
     * 
     * @return The component type.
     */
    public final String componentType() {
        return componentType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(componentId());
        hashCode = 31 * hashCode + Objects.hashCode(componentType());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Step)) {
            return false;
        }
        Step other = (Step) obj;
        return Objects.equals(componentId(), other.componentId()) && Objects.equals(componentType(), other.componentType());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Step").add("ComponentId", componentId()).add("ComponentType", componentType()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "componentId":
            return Optional.ofNullable(clazz.cast(componentId()));
        case "componentType":
            return Optional.ofNullable(clazz.cast(componentType()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("componentId", COMPONENT_ID_FIELD);
        map.put("componentType", COMPONENT_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Step, T> g) {
        return obj -> g.apply((Step) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Step> {
        /**
         * <p>
         * The component ID.
         * </p>
         * 
         * @param componentId
         *        The component ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder componentId(String componentId);

        /**
         * <p>
         * The component type.
         * </p>
         * 
         * @param componentType
         *        The component type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder componentType(String componentType);
    }

    static final class BuilderImpl implements Builder {
        private String componentId;

        private String componentType;

        private BuilderImpl() {
        }

        private BuilderImpl(Step model) {
            componentId(model.componentId);
            componentType(model.componentType);
        }

        public final String getComponentId() {
            return componentId;
        }

        public final void setComponentId(String componentId) {
            this.componentId = componentId;
        }

        @Override
        public final Builder componentId(String componentId) {
            this.componentId = componentId;
            return this;
        }

        public final String getComponentType() {
            return componentType;
        }

        public final void setComponentType(String componentType) {
            this.componentType = componentType;
        }

        @Override
        public final Builder componentType(String componentType) {
            this.componentType = componentType;
            return this;
        }

        @Override
        public Step build() {
            return new Step(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
