/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.inspector2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The stop CIS message progress.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class StopCisMessageProgress implements SdkPojo, Serializable,
        ToCopyableBuilder<StopCisMessageProgress.Builder, StopCisMessageProgress> {
    private static final SdkField<Integer> ERROR_CHECKS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("errorChecks").getter(getter(StopCisMessageProgress::errorChecks)).setter(setter(Builder::errorChecks))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errorChecks").build()).build();

    private static final SdkField<Integer> FAILED_CHECKS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("failedChecks").getter(getter(StopCisMessageProgress::failedChecks))
            .setter(setter(Builder::failedChecks))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failedChecks").build()).build();

    private static final SdkField<Integer> INFORMATIONAL_CHECKS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("informationalChecks").getter(getter(StopCisMessageProgress::informationalChecks))
            .setter(setter(Builder::informationalChecks))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("informationalChecks").build())
            .build();

    private static final SdkField<Integer> NOT_APPLICABLE_CHECKS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("notApplicableChecks").getter(getter(StopCisMessageProgress::notApplicableChecks))
            .setter(setter(Builder::notApplicableChecks))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("notApplicableChecks").build())
            .build();

    private static final SdkField<Integer> NOT_EVALUATED_CHECKS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("notEvaluatedChecks").getter(getter(StopCisMessageProgress::notEvaluatedChecks))
            .setter(setter(Builder::notEvaluatedChecks))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("notEvaluatedChecks").build())
            .build();

    private static final SdkField<Integer> SUCCESSFUL_CHECKS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("successfulChecks").getter(getter(StopCisMessageProgress::successfulChecks))
            .setter(setter(Builder::successfulChecks))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("successfulChecks").build()).build();

    private static final SdkField<Integer> TOTAL_CHECKS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("totalChecks").getter(getter(StopCisMessageProgress::totalChecks)).setter(setter(Builder::totalChecks))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("totalChecks").build()).build();

    private static final SdkField<Integer> UNKNOWN_CHECKS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("unknownChecks").getter(getter(StopCisMessageProgress::unknownChecks))
            .setter(setter(Builder::unknownChecks))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("unknownChecks").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ERROR_CHECKS_FIELD,
            FAILED_CHECKS_FIELD, INFORMATIONAL_CHECKS_FIELD, NOT_APPLICABLE_CHECKS_FIELD, NOT_EVALUATED_CHECKS_FIELD,
            SUCCESSFUL_CHECKS_FIELD, TOTAL_CHECKS_FIELD, UNKNOWN_CHECKS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Integer errorChecks;

    private final Integer failedChecks;

    private final Integer informationalChecks;

    private final Integer notApplicableChecks;

    private final Integer notEvaluatedChecks;

    private final Integer successfulChecks;

    private final Integer totalChecks;

    private final Integer unknownChecks;

    private StopCisMessageProgress(BuilderImpl builder) {
        this.errorChecks = builder.errorChecks;
        this.failedChecks = builder.failedChecks;
        this.informationalChecks = builder.informationalChecks;
        this.notApplicableChecks = builder.notApplicableChecks;
        this.notEvaluatedChecks = builder.notEvaluatedChecks;
        this.successfulChecks = builder.successfulChecks;
        this.totalChecks = builder.totalChecks;
        this.unknownChecks = builder.unknownChecks;
    }

    /**
     * <p>
     * The progress' error checks.
     * </p>
     * 
     * @return The progress' error checks.
     */
    public final Integer errorChecks() {
        return errorChecks;
    }

    /**
     * <p>
     * The progress' failed checks.
     * </p>
     * 
     * @return The progress' failed checks.
     */
    public final Integer failedChecks() {
        return failedChecks;
    }

    /**
     * <p>
     * The progress' informational checks.
     * </p>
     * 
     * @return The progress' informational checks.
     */
    public final Integer informationalChecks() {
        return informationalChecks;
    }

    /**
     * <p>
     * The progress' not applicable checks.
     * </p>
     * 
     * @return The progress' not applicable checks.
     */
    public final Integer notApplicableChecks() {
        return notApplicableChecks;
    }

    /**
     * <p>
     * The progress' not evaluated checks.
     * </p>
     * 
     * @return The progress' not evaluated checks.
     */
    public final Integer notEvaluatedChecks() {
        return notEvaluatedChecks;
    }

    /**
     * <p>
     * The progress' successful checks.
     * </p>
     * 
     * @return The progress' successful checks.
     */
    public final Integer successfulChecks() {
        return successfulChecks;
    }

    /**
     * <p>
     * The progress' total checks.
     * </p>
     * 
     * @return The progress' total checks.
     */
    public final Integer totalChecks() {
        return totalChecks;
    }

    /**
     * <p>
     * The progress' unknown checks.
     * </p>
     * 
     * @return The progress' unknown checks.
     */
    public final Integer unknownChecks() {
        return unknownChecks;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(errorChecks());
        hashCode = 31 * hashCode + Objects.hashCode(failedChecks());
        hashCode = 31 * hashCode + Objects.hashCode(informationalChecks());
        hashCode = 31 * hashCode + Objects.hashCode(notApplicableChecks());
        hashCode = 31 * hashCode + Objects.hashCode(notEvaluatedChecks());
        hashCode = 31 * hashCode + Objects.hashCode(successfulChecks());
        hashCode = 31 * hashCode + Objects.hashCode(totalChecks());
        hashCode = 31 * hashCode + Objects.hashCode(unknownChecks());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StopCisMessageProgress)) {
            return false;
        }
        StopCisMessageProgress other = (StopCisMessageProgress) obj;
        return Objects.equals(errorChecks(), other.errorChecks()) && Objects.equals(failedChecks(), other.failedChecks())
                && Objects.equals(informationalChecks(), other.informationalChecks())
                && Objects.equals(notApplicableChecks(), other.notApplicableChecks())
                && Objects.equals(notEvaluatedChecks(), other.notEvaluatedChecks())
                && Objects.equals(successfulChecks(), other.successfulChecks())
                && Objects.equals(totalChecks(), other.totalChecks()) && Objects.equals(unknownChecks(), other.unknownChecks());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StopCisMessageProgress").add("ErrorChecks", errorChecks()).add("FailedChecks", failedChecks())
                .add("InformationalChecks", informationalChecks()).add("NotApplicableChecks", notApplicableChecks())
                .add("NotEvaluatedChecks", notEvaluatedChecks()).add("SuccessfulChecks", successfulChecks())
                .add("TotalChecks", totalChecks()).add("UnknownChecks", unknownChecks()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "errorChecks":
            return Optional.ofNullable(clazz.cast(errorChecks()));
        case "failedChecks":
            return Optional.ofNullable(clazz.cast(failedChecks()));
        case "informationalChecks":
            return Optional.ofNullable(clazz.cast(informationalChecks()));
        case "notApplicableChecks":
            return Optional.ofNullable(clazz.cast(notApplicableChecks()));
        case "notEvaluatedChecks":
            return Optional.ofNullable(clazz.cast(notEvaluatedChecks()));
        case "successfulChecks":
            return Optional.ofNullable(clazz.cast(successfulChecks()));
        case "totalChecks":
            return Optional.ofNullable(clazz.cast(totalChecks()));
        case "unknownChecks":
            return Optional.ofNullable(clazz.cast(unknownChecks()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("errorChecks", ERROR_CHECKS_FIELD);
        map.put("failedChecks", FAILED_CHECKS_FIELD);
        map.put("informationalChecks", INFORMATIONAL_CHECKS_FIELD);
        map.put("notApplicableChecks", NOT_APPLICABLE_CHECKS_FIELD);
        map.put("notEvaluatedChecks", NOT_EVALUATED_CHECKS_FIELD);
        map.put("successfulChecks", SUCCESSFUL_CHECKS_FIELD);
        map.put("totalChecks", TOTAL_CHECKS_FIELD);
        map.put("unknownChecks", UNKNOWN_CHECKS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StopCisMessageProgress, T> g) {
        return obj -> g.apply((StopCisMessageProgress) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, StopCisMessageProgress> {
        /**
         * <p>
         * The progress' error checks.
         * </p>
         * 
         * @param errorChecks
         *        The progress' error checks.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errorChecks(Integer errorChecks);

        /**
         * <p>
         * The progress' failed checks.
         * </p>
         * 
         * @param failedChecks
         *        The progress' failed checks.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failedChecks(Integer failedChecks);

        /**
         * <p>
         * The progress' informational checks.
         * </p>
         * 
         * @param informationalChecks
         *        The progress' informational checks.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder informationalChecks(Integer informationalChecks);

        /**
         * <p>
         * The progress' not applicable checks.
         * </p>
         * 
         * @param notApplicableChecks
         *        The progress' not applicable checks.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder notApplicableChecks(Integer notApplicableChecks);

        /**
         * <p>
         * The progress' not evaluated checks.
         * </p>
         * 
         * @param notEvaluatedChecks
         *        The progress' not evaluated checks.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder notEvaluatedChecks(Integer notEvaluatedChecks);

        /**
         * <p>
         * The progress' successful checks.
         * </p>
         * 
         * @param successfulChecks
         *        The progress' successful checks.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder successfulChecks(Integer successfulChecks);

        /**
         * <p>
         * The progress' total checks.
         * </p>
         * 
         * @param totalChecks
         *        The progress' total checks.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder totalChecks(Integer totalChecks);

        /**
         * <p>
         * The progress' unknown checks.
         * </p>
         * 
         * @param unknownChecks
         *        The progress' unknown checks.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder unknownChecks(Integer unknownChecks);
    }

    static final class BuilderImpl implements Builder {
        private Integer errorChecks;

        private Integer failedChecks;

        private Integer informationalChecks;

        private Integer notApplicableChecks;

        private Integer notEvaluatedChecks;

        private Integer successfulChecks;

        private Integer totalChecks;

        private Integer unknownChecks;

        private BuilderImpl() {
        }

        private BuilderImpl(StopCisMessageProgress model) {
            errorChecks(model.errorChecks);
            failedChecks(model.failedChecks);
            informationalChecks(model.informationalChecks);
            notApplicableChecks(model.notApplicableChecks);
            notEvaluatedChecks(model.notEvaluatedChecks);
            successfulChecks(model.successfulChecks);
            totalChecks(model.totalChecks);
            unknownChecks(model.unknownChecks);
        }

        public final Integer getErrorChecks() {
            return errorChecks;
        }

        public final void setErrorChecks(Integer errorChecks) {
            this.errorChecks = errorChecks;
        }

        @Override
        public final Builder errorChecks(Integer errorChecks) {
            this.errorChecks = errorChecks;
            return this;
        }

        public final Integer getFailedChecks() {
            return failedChecks;
        }

        public final void setFailedChecks(Integer failedChecks) {
            this.failedChecks = failedChecks;
        }

        @Override
        public final Builder failedChecks(Integer failedChecks) {
            this.failedChecks = failedChecks;
            return this;
        }

        public final Integer getInformationalChecks() {
            return informationalChecks;
        }

        public final void setInformationalChecks(Integer informationalChecks) {
            this.informationalChecks = informationalChecks;
        }

        @Override
        public final Builder informationalChecks(Integer informationalChecks) {
            this.informationalChecks = informationalChecks;
            return this;
        }

        public final Integer getNotApplicableChecks() {
            return notApplicableChecks;
        }

        public final void setNotApplicableChecks(Integer notApplicableChecks) {
            this.notApplicableChecks = notApplicableChecks;
        }

        @Override
        public final Builder notApplicableChecks(Integer notApplicableChecks) {
            this.notApplicableChecks = notApplicableChecks;
            return this;
        }

        public final Integer getNotEvaluatedChecks() {
            return notEvaluatedChecks;
        }

        public final void setNotEvaluatedChecks(Integer notEvaluatedChecks) {
            this.notEvaluatedChecks = notEvaluatedChecks;
        }

        @Override
        public final Builder notEvaluatedChecks(Integer notEvaluatedChecks) {
            this.notEvaluatedChecks = notEvaluatedChecks;
            return this;
        }

        public final Integer getSuccessfulChecks() {
            return successfulChecks;
        }

        public final void setSuccessfulChecks(Integer successfulChecks) {
            this.successfulChecks = successfulChecks;
        }

        @Override
        public final Builder successfulChecks(Integer successfulChecks) {
            this.successfulChecks = successfulChecks;
            return this;
        }

        public final Integer getTotalChecks() {
            return totalChecks;
        }

        public final void setTotalChecks(Integer totalChecks) {
            this.totalChecks = totalChecks;
        }

        @Override
        public final Builder totalChecks(Integer totalChecks) {
            this.totalChecks = totalChecks;
            return this;
        }

        public final Integer getUnknownChecks() {
            return unknownChecks;
        }

        public final void setUnknownChecks(Integer unknownChecks) {
            this.unknownChecks = unknownChecks;
        }

        @Override
        public final Builder unknownChecks(Integer unknownChecks) {
            this.unknownChecks = unknownChecks;
            return this;
        }

        @Override
        public StopCisMessageProgress build() {
            return new StopCisMessageProgress(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
