/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.inspector2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The stop CIS session message.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class StopCisSessionMessage implements SdkPojo, Serializable,
        ToCopyableBuilder<StopCisSessionMessage.Builder, StopCisSessionMessage> {
    private static final SdkField<String> BENCHMARK_PROFILE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("benchmarkProfile").getter(getter(StopCisSessionMessage::benchmarkProfile))
            .setter(setter(Builder::benchmarkProfile))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("benchmarkProfile").build()).build();

    private static final SdkField<String> BENCHMARK_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("benchmarkVersion").getter(getter(StopCisSessionMessage::benchmarkVersion))
            .setter(setter(Builder::benchmarkVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("benchmarkVersion").build()).build();

    private static final SdkField<ComputePlatform> COMPUTE_PLATFORM_FIELD = SdkField
            .<ComputePlatform> builder(MarshallingType.SDK_POJO).memberName("computePlatform")
            .getter(getter(StopCisSessionMessage::computePlatform)).setter(setter(Builder::computePlatform))
            .constructor(ComputePlatform::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("computePlatform").build()).build();

    private static final SdkField<StopCisMessageProgress> PROGRESS_FIELD = SdkField
            .<StopCisMessageProgress> builder(MarshallingType.SDK_POJO).memberName("progress")
            .getter(getter(StopCisSessionMessage::progress)).setter(setter(Builder::progress))
            .constructor(StopCisMessageProgress::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("progress").build()).build();

    private static final SdkField<String> REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("reason")
            .getter(getter(StopCisSessionMessage::reason)).setter(setter(Builder::reason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("reason").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(StopCisSessionMessage::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BENCHMARK_PROFILE_FIELD,
            BENCHMARK_VERSION_FIELD, COMPUTE_PLATFORM_FIELD, PROGRESS_FIELD, REASON_FIELD, STATUS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String benchmarkProfile;

    private final String benchmarkVersion;

    private final ComputePlatform computePlatform;

    private final StopCisMessageProgress progress;

    private final String reason;

    private final String status;

    private StopCisSessionMessage(BuilderImpl builder) {
        this.benchmarkProfile = builder.benchmarkProfile;
        this.benchmarkVersion = builder.benchmarkVersion;
        this.computePlatform = builder.computePlatform;
        this.progress = builder.progress;
        this.reason = builder.reason;
        this.status = builder.status;
    }

    /**
     * <p>
     * The message benchmark profile.
     * </p>
     * 
     * @return The message benchmark profile.
     */
    public final String benchmarkProfile() {
        return benchmarkProfile;
    }

    /**
     * <p>
     * The message benchmark version.
     * </p>
     * 
     * @return The message benchmark version.
     */
    public final String benchmarkVersion() {
        return benchmarkVersion;
    }

    /**
     * <p>
     * The message compute platform.
     * </p>
     * 
     * @return The message compute platform.
     */
    public final ComputePlatform computePlatform() {
        return computePlatform;
    }

    /**
     * <p>
     * The progress of the message.
     * </p>
     * 
     * @return The progress of the message.
     */
    public final StopCisMessageProgress progress() {
        return progress;
    }

    /**
     * <p>
     * The reason for the message.
     * </p>
     * 
     * @return The reason for the message.
     */
    public final String reason() {
        return reason;
    }

    /**
     * <p>
     * The status of the message.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link StopCisSessionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the message.
     * @see StopCisSessionStatus
     */
    public final StopCisSessionStatus status() {
        return StopCisSessionStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the message.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link StopCisSessionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the message.
     * @see StopCisSessionStatus
     */
    public final String statusAsString() {
        return status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(benchmarkProfile());
        hashCode = 31 * hashCode + Objects.hashCode(benchmarkVersion());
        hashCode = 31 * hashCode + Objects.hashCode(computePlatform());
        hashCode = 31 * hashCode + Objects.hashCode(progress());
        hashCode = 31 * hashCode + Objects.hashCode(reason());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StopCisSessionMessage)) {
            return false;
        }
        StopCisSessionMessage other = (StopCisSessionMessage) obj;
        return Objects.equals(benchmarkProfile(), other.benchmarkProfile())
                && Objects.equals(benchmarkVersion(), other.benchmarkVersion())
                && Objects.equals(computePlatform(), other.computePlatform()) && Objects.equals(progress(), other.progress())
                && Objects.equals(reason(), other.reason()) && Objects.equals(statusAsString(), other.statusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StopCisSessionMessage").add("BenchmarkProfile", benchmarkProfile())
                .add("BenchmarkVersion", benchmarkVersion()).add("ComputePlatform", computePlatform())
                .add("Progress", progress()).add("Reason", reason()).add("Status", statusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "benchmarkProfile":
            return Optional.ofNullable(clazz.cast(benchmarkProfile()));
        case "benchmarkVersion":
            return Optional.ofNullable(clazz.cast(benchmarkVersion()));
        case "computePlatform":
            return Optional.ofNullable(clazz.cast(computePlatform()));
        case "progress":
            return Optional.ofNullable(clazz.cast(progress()));
        case "reason":
            return Optional.ofNullable(clazz.cast(reason()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("benchmarkProfile", BENCHMARK_PROFILE_FIELD);
        map.put("benchmarkVersion", BENCHMARK_VERSION_FIELD);
        map.put("computePlatform", COMPUTE_PLATFORM_FIELD);
        map.put("progress", PROGRESS_FIELD);
        map.put("reason", REASON_FIELD);
        map.put("status", STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StopCisSessionMessage, T> g) {
        return obj -> g.apply((StopCisSessionMessage) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, StopCisSessionMessage> {
        /**
         * <p>
         * The message benchmark profile.
         * </p>
         * 
         * @param benchmarkProfile
         *        The message benchmark profile.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder benchmarkProfile(String benchmarkProfile);

        /**
         * <p>
         * The message benchmark version.
         * </p>
         * 
         * @param benchmarkVersion
         *        The message benchmark version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder benchmarkVersion(String benchmarkVersion);

        /**
         * <p>
         * The message compute platform.
         * </p>
         * 
         * @param computePlatform
         *        The message compute platform.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder computePlatform(ComputePlatform computePlatform);

        /**
         * <p>
         * The message compute platform.
         * </p>
         * This is a convenience method that creates an instance of the {@link ComputePlatform.Builder} avoiding the
         * need to create one manually via {@link ComputePlatform#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ComputePlatform.Builder#build()} is called immediately and its
         * result is passed to {@link #computePlatform(ComputePlatform)}.
         * 
         * @param computePlatform
         *        a consumer that will call methods on {@link ComputePlatform.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #computePlatform(ComputePlatform)
         */
        default Builder computePlatform(Consumer<ComputePlatform.Builder> computePlatform) {
            return computePlatform(ComputePlatform.builder().applyMutation(computePlatform).build());
        }

        /**
         * <p>
         * The progress of the message.
         * </p>
         * 
         * @param progress
         *        The progress of the message.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder progress(StopCisMessageProgress progress);

        /**
         * <p>
         * The progress of the message.
         * </p>
         * This is a convenience method that creates an instance of the {@link StopCisMessageProgress.Builder} avoiding
         * the need to create one manually via {@link StopCisMessageProgress#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link StopCisMessageProgress.Builder#build()} is called immediately and
         * its result is passed to {@link #progress(StopCisMessageProgress)}.
         * 
         * @param progress
         *        a consumer that will call methods on {@link StopCisMessageProgress.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #progress(StopCisMessageProgress)
         */
        default Builder progress(Consumer<StopCisMessageProgress.Builder> progress) {
            return progress(StopCisMessageProgress.builder().applyMutation(progress).build());
        }

        /**
         * <p>
         * The reason for the message.
         * </p>
         * 
         * @param reason
         *        The reason for the message.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reason(String reason);

        /**
         * <p>
         * The status of the message.
         * </p>
         * 
         * @param status
         *        The status of the message.
         * @see StopCisSessionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StopCisSessionStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the message.
         * </p>
         * 
         * @param status
         *        The status of the message.
         * @see StopCisSessionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StopCisSessionStatus
         */
        Builder status(StopCisSessionStatus status);
    }

    static final class BuilderImpl implements Builder {
        private String benchmarkProfile;

        private String benchmarkVersion;

        private ComputePlatform computePlatform;

        private StopCisMessageProgress progress;

        private String reason;

        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(StopCisSessionMessage model) {
            benchmarkProfile(model.benchmarkProfile);
            benchmarkVersion(model.benchmarkVersion);
            computePlatform(model.computePlatform);
            progress(model.progress);
            reason(model.reason);
            status(model.status);
        }

        public final String getBenchmarkProfile() {
            return benchmarkProfile;
        }

        public final void setBenchmarkProfile(String benchmarkProfile) {
            this.benchmarkProfile = benchmarkProfile;
        }

        @Override
        public final Builder benchmarkProfile(String benchmarkProfile) {
            this.benchmarkProfile = benchmarkProfile;
            return this;
        }

        public final String getBenchmarkVersion() {
            return benchmarkVersion;
        }

        public final void setBenchmarkVersion(String benchmarkVersion) {
            this.benchmarkVersion = benchmarkVersion;
        }

        @Override
        public final Builder benchmarkVersion(String benchmarkVersion) {
            this.benchmarkVersion = benchmarkVersion;
            return this;
        }

        public final ComputePlatform.Builder getComputePlatform() {
            return computePlatform != null ? computePlatform.toBuilder() : null;
        }

        public final void setComputePlatform(ComputePlatform.BuilderImpl computePlatform) {
            this.computePlatform = computePlatform != null ? computePlatform.build() : null;
        }

        @Override
        public final Builder computePlatform(ComputePlatform computePlatform) {
            this.computePlatform = computePlatform;
            return this;
        }

        public final StopCisMessageProgress.Builder getProgress() {
            return progress != null ? progress.toBuilder() : null;
        }

        public final void setProgress(StopCisMessageProgress.BuilderImpl progress) {
            this.progress = progress != null ? progress.build() : null;
        }

        @Override
        public final Builder progress(StopCisMessageProgress progress) {
            this.progress = progress;
            return this;
        }

        public final String getReason() {
            return reason;
        }

        public final void setReason(String reason) {
            this.reason = reason;
        }

        @Override
        public final Builder reason(String reason) {
            this.reason = reason;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(StopCisSessionStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        @Override
        public StopCisSessionMessage build() {
            return new StopCisSessionMessage(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
