/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.inspector2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class StopCisSessionRequest extends Inspector2Request implements
        ToCopyableBuilder<StopCisSessionRequest.Builder, StopCisSessionRequest> {
    private static final SdkField<StopCisSessionMessage> MESSAGE_FIELD = SdkField
            .<StopCisSessionMessage> builder(MarshallingType.SDK_POJO).memberName("message")
            .getter(getter(StopCisSessionRequest::message)).setter(setter(Builder::message))
            .constructor(StopCisSessionMessage::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("message").build()).build();

    private static final SdkField<String> SCAN_JOB_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("scanJobId").getter(getter(StopCisSessionRequest::scanJobId)).setter(setter(Builder::scanJobId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scanJobId").build()).build();

    private static final SdkField<String> SESSION_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("sessionToken").getter(getter(StopCisSessionRequest::sessionToken)).setter(setter(Builder::sessionToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sessionToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MESSAGE_FIELD,
            SCAN_JOB_ID_FIELD, SESSION_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final StopCisSessionMessage message;

    private final String scanJobId;

    private final String sessionToken;

    private StopCisSessionRequest(BuilderImpl builder) {
        super(builder);
        this.message = builder.message;
        this.scanJobId = builder.scanJobId;
        this.sessionToken = builder.sessionToken;
    }

    /**
     * <p>
     * The stop CIS session message.
     * </p>
     * 
     * @return The stop CIS session message.
     */
    public final StopCisSessionMessage message() {
        return message;
    }

    /**
     * <p>
     * A unique identifier for the scan job.
     * </p>
     * 
     * @return A unique identifier for the scan job.
     */
    public final String scanJobId() {
        return scanJobId;
    }

    /**
     * <p>
     * The unique token that identifies the CIS session.
     * </p>
     * 
     * @return The unique token that identifies the CIS session.
     */
    public final String sessionToken() {
        return sessionToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(message());
        hashCode = 31 * hashCode + Objects.hashCode(scanJobId());
        hashCode = 31 * hashCode + Objects.hashCode(sessionToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StopCisSessionRequest)) {
            return false;
        }
        StopCisSessionRequest other = (StopCisSessionRequest) obj;
        return Objects.equals(message(), other.message()) && Objects.equals(scanJobId(), other.scanJobId())
                && Objects.equals(sessionToken(), other.sessionToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StopCisSessionRequest").add("Message", message()).add("ScanJobId", scanJobId())
                .add("SessionToken", sessionToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "message":
            return Optional.ofNullable(clazz.cast(message()));
        case "scanJobId":
            return Optional.ofNullable(clazz.cast(scanJobId()));
        case "sessionToken":
            return Optional.ofNullable(clazz.cast(sessionToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("message", MESSAGE_FIELD);
        map.put("scanJobId", SCAN_JOB_ID_FIELD);
        map.put("sessionToken", SESSION_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StopCisSessionRequest, T> g) {
        return obj -> g.apply((StopCisSessionRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Inspector2Request.Builder, SdkPojo, CopyableBuilder<Builder, StopCisSessionRequest> {
        /**
         * <p>
         * The stop CIS session message.
         * </p>
         * 
         * @param message
         *        The stop CIS session message.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder message(StopCisSessionMessage message);

        /**
         * <p>
         * The stop CIS session message.
         * </p>
         * This is a convenience method that creates an instance of the {@link StopCisSessionMessage.Builder} avoiding
         * the need to create one manually via {@link StopCisSessionMessage#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link StopCisSessionMessage.Builder#build()} is called immediately and
         * its result is passed to {@link #message(StopCisSessionMessage)}.
         * 
         * @param message
         *        a consumer that will call methods on {@link StopCisSessionMessage.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #message(StopCisSessionMessage)
         */
        default Builder message(Consumer<StopCisSessionMessage.Builder> message) {
            return message(StopCisSessionMessage.builder().applyMutation(message).build());
        }

        /**
         * <p>
         * A unique identifier for the scan job.
         * </p>
         * 
         * @param scanJobId
         *        A unique identifier for the scan job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scanJobId(String scanJobId);

        /**
         * <p>
         * The unique token that identifies the CIS session.
         * </p>
         * 
         * @param sessionToken
         *        The unique token that identifies the CIS session.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sessionToken(String sessionToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Inspector2Request.BuilderImpl implements Builder {
        private StopCisSessionMessage message;

        private String scanJobId;

        private String sessionToken;

        private BuilderImpl() {
        }

        private BuilderImpl(StopCisSessionRequest model) {
            super(model);
            message(model.message);
            scanJobId(model.scanJobId);
            sessionToken(model.sessionToken);
        }

        public final StopCisSessionMessage.Builder getMessage() {
            return message != null ? message.toBuilder() : null;
        }

        public final void setMessage(StopCisSessionMessage.BuilderImpl message) {
            this.message = message != null ? message.build() : null;
        }

        @Override
        public final Builder message(StopCisSessionMessage message) {
            this.message = message;
            return this;
        }

        public final String getScanJobId() {
            return scanJobId;
        }

        public final void setScanJobId(String scanJobId) {
            this.scanJobId = scanJobId;
        }

        @Override
        public final Builder scanJobId(String scanJobId) {
            this.scanJobId = scanJobId;
            return this;
        }

        public final String getSessionToken() {
            return sessionToken;
        }

        public final void setSessionToken(String sessionToken) {
            this.sessionToken = sessionToken;
        }

        @Override
        public final Builder sessionToken(String sessionToken) {
            this.sessionToken = sessionToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StopCisSessionRequest build() {
            return new StopCisSessionRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
