/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.inspector2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Updates CIS targets.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateCisTargets implements SdkPojo, Serializable,
        ToCopyableBuilder<UpdateCisTargets.Builder, UpdateCisTargets> {
    private static final SdkField<List<String>> ACCOUNT_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("accountIds")
            .getter(getter(UpdateCisTargets::accountIds))
            .setter(setter(Builder::accountIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accountIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Map<String, List<String>>> TARGET_RESOURCE_TAGS_FIELD = SdkField
            .<Map<String, List<String>>> builder(MarshallingType.MAP)
            .memberName("targetResourceTags")
            .getter(getter(UpdateCisTargets::targetResourceTags))
            .setter(setter(Builder::targetResourceTags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetResourceTags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<List<String>> builder(MarshallingType.LIST)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build(),
                                                    ListTrait
                                                            .builder()
                                                            .memberLocationName(null)
                                                            .memberFieldInfo(
                                                                    SdkField.<String> builder(MarshallingType.STRING)
                                                                            .traits(LocationTrait.builder()
                                                                                    .location(MarshallLocation.PAYLOAD)
                                                                                    .locationName("member").build()).build())
                                                            .build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_IDS_FIELD,
            TARGET_RESOURCE_TAGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<String> accountIds;

    private final Map<String, List<String>> targetResourceTags;

    private UpdateCisTargets(BuilderImpl builder) {
        this.accountIds = builder.accountIds;
        this.targetResourceTags = builder.targetResourceTags;
    }

    /**
     * For responses, this returns true if the service returned a value for the AccountIds property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasAccountIds() {
        return accountIds != null && !(accountIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The target account ids.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAccountIds} method.
     * </p>
     * 
     * @return The target account ids.
     */
    public final List<String> accountIds() {
        return accountIds;
    }

    /**
     * For responses, this returns true if the service returned a value for the TargetResourceTags property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasTargetResourceTags() {
        return targetResourceTags != null && !(targetResourceTags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The target resource tags.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTargetResourceTags} method.
     * </p>
     * 
     * @return The target resource tags.
     */
    public final Map<String, List<String>> targetResourceTags() {
        return targetResourceTags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasAccountIds() ? accountIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasTargetResourceTags() ? targetResourceTags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateCisTargets)) {
            return false;
        }
        UpdateCisTargets other = (UpdateCisTargets) obj;
        return hasAccountIds() == other.hasAccountIds() && Objects.equals(accountIds(), other.accountIds())
                && hasTargetResourceTags() == other.hasTargetResourceTags()
                && Objects.equals(targetResourceTags(), other.targetResourceTags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateCisTargets").add("AccountIds", hasAccountIds() ? accountIds() : null)
                .add("TargetResourceTags", hasTargetResourceTags() ? targetResourceTags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "accountIds":
            return Optional.ofNullable(clazz.cast(accountIds()));
        case "targetResourceTags":
            return Optional.ofNullable(clazz.cast(targetResourceTags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("accountIds", ACCOUNT_IDS_FIELD);
        map.put("targetResourceTags", TARGET_RESOURCE_TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateCisTargets, T> g) {
        return obj -> g.apply((UpdateCisTargets) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, UpdateCisTargets> {
        /**
         * <p>
         * The target account ids.
         * </p>
         * 
         * @param accountIds
         *        The target account ids.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountIds(Collection<String> accountIds);

        /**
         * <p>
         * The target account ids.
         * </p>
         * 
         * @param accountIds
         *        The target account ids.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountIds(String... accountIds);

        /**
         * <p>
         * The target resource tags.
         * </p>
         * 
         * @param targetResourceTags
         *        The target resource tags.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetResourceTags(Map<String, ? extends Collection<String>> targetResourceTags);
    }

    static final class BuilderImpl implements Builder {
        private List<String> accountIds = DefaultSdkAutoConstructList.getInstance();

        private Map<String, List<String>> targetResourceTags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateCisTargets model) {
            accountIds(model.accountIds);
            targetResourceTags(model.targetResourceTags);
        }

        public final Collection<String> getAccountIds() {
            if (accountIds instanceof SdkAutoConstructList) {
                return null;
            }
            return accountIds;
        }

        public final void setAccountIds(Collection<String> accountIds) {
            this.accountIds = TargetAccountListCopier.copy(accountIds);
        }

        @Override
        public final Builder accountIds(Collection<String> accountIds) {
            this.accountIds = TargetAccountListCopier.copy(accountIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accountIds(String... accountIds) {
            accountIds(Arrays.asList(accountIds));
            return this;
        }

        public final Map<String, ? extends Collection<String>> getTargetResourceTags() {
            if (targetResourceTags instanceof SdkAutoConstructMap) {
                return null;
            }
            return targetResourceTags;
        }

        public final void setTargetResourceTags(Map<String, ? extends Collection<String>> targetResourceTags) {
            this.targetResourceTags = TargetResourceTagsCopier.copy(targetResourceTags);
        }

        @Override
        public final Builder targetResourceTags(Map<String, ? extends Collection<String>> targetResourceTags) {
            this.targetResourceTags = TargetResourceTagsCopier.copy(targetResourceTags);
            return this;
        }

        @Override
        public UpdateCisTargets build() {
            return new UpdateCisTargets(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
