/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.inspector2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains usage information about the cost of Amazon Inspector operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Usage implements SdkPojo, Serializable, ToCopyableBuilder<Usage.Builder, Usage> {
    private static final SdkField<String> CURRENCY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("currency").getter(getter(Usage::currencyAsString)).setter(setter(Builder::currency))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("currency").build()).build();

    private static final SdkField<Double> ESTIMATED_MONTHLY_COST_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("estimatedMonthlyCost").getter(getter(Usage::estimatedMonthlyCost))
            .setter(setter(Builder::estimatedMonthlyCost))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("estimatedMonthlyCost").build())
            .build();

    private static final SdkField<Double> TOTAL_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE).memberName("total")
            .getter(getter(Usage::total)).setter(setter(Builder::total))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("total").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("type")
            .getter(getter(Usage::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CURRENCY_FIELD,
            ESTIMATED_MONTHLY_COST_FIELD, TOTAL_FIELD, TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String currency;

    private final Double estimatedMonthlyCost;

    private final Double total;

    private final String type;

    private Usage(BuilderImpl builder) {
        this.currency = builder.currency;
        this.estimatedMonthlyCost = builder.estimatedMonthlyCost;
        this.total = builder.total;
        this.type = builder.type;
    }

    /**
     * <p>
     * The currency type used when calculating usage data.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #currency} will
     * return {@link Currency#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #currencyAsString}.
     * </p>
     * 
     * @return The currency type used when calculating usage data.
     * @see Currency
     */
    public final Currency currency() {
        return Currency.fromValue(currency);
    }

    /**
     * <p>
     * The currency type used when calculating usage data.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #currency} will
     * return {@link Currency#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #currencyAsString}.
     * </p>
     * 
     * @return The currency type used when calculating usage data.
     * @see Currency
     */
    public final String currencyAsString() {
        return currency;
    }

    /**
     * <p>
     * The estimated monthly cost of Amazon Inspector.
     * </p>
     * 
     * @return The estimated monthly cost of Amazon Inspector.
     */
    public final Double estimatedMonthlyCost() {
        return estimatedMonthlyCost;
    }

    /**
     * <p>
     * The total of usage.
     * </p>
     * 
     * @return The total of usage.
     */
    public final Double total() {
        return total;
    }

    /**
     * <p>
     * The type scan.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link UsageType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type scan.
     * @see UsageType
     */
    public final UsageType type() {
        return UsageType.fromValue(type);
    }

    /**
     * <p>
     * The type scan.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link UsageType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type scan.
     * @see UsageType
     */
    public final String typeAsString() {
        return type;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(currencyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(estimatedMonthlyCost());
        hashCode = 31 * hashCode + Objects.hashCode(total());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Usage)) {
            return false;
        }
        Usage other = (Usage) obj;
        return Objects.equals(currencyAsString(), other.currencyAsString())
                && Objects.equals(estimatedMonthlyCost(), other.estimatedMonthlyCost()) && Objects.equals(total(), other.total())
                && Objects.equals(typeAsString(), other.typeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Usage").add("Currency", currencyAsString()).add("EstimatedMonthlyCost", estimatedMonthlyCost())
                .add("Total", total()).add("Type", typeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "currency":
            return Optional.ofNullable(clazz.cast(currencyAsString()));
        case "estimatedMonthlyCost":
            return Optional.ofNullable(clazz.cast(estimatedMonthlyCost()));
        case "total":
            return Optional.ofNullable(clazz.cast(total()));
        case "type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("currency", CURRENCY_FIELD);
        map.put("estimatedMonthlyCost", ESTIMATED_MONTHLY_COST_FIELD);
        map.put("total", TOTAL_FIELD);
        map.put("type", TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Usage, T> g) {
        return obj -> g.apply((Usage) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Usage> {
        /**
         * <p>
         * The currency type used when calculating usage data.
         * </p>
         * 
         * @param currency
         *        The currency type used when calculating usage data.
         * @see Currency
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Currency
         */
        Builder currency(String currency);

        /**
         * <p>
         * The currency type used when calculating usage data.
         * </p>
         * 
         * @param currency
         *        The currency type used when calculating usage data.
         * @see Currency
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Currency
         */
        Builder currency(Currency currency);

        /**
         * <p>
         * The estimated monthly cost of Amazon Inspector.
         * </p>
         * 
         * @param estimatedMonthlyCost
         *        The estimated monthly cost of Amazon Inspector.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder estimatedMonthlyCost(Double estimatedMonthlyCost);

        /**
         * <p>
         * The total of usage.
         * </p>
         * 
         * @param total
         *        The total of usage.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder total(Double total);

        /**
         * <p>
         * The type scan.
         * </p>
         * 
         * @param type
         *        The type scan.
         * @see UsageType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see UsageType
         */
        Builder type(String type);

        /**
         * <p>
         * The type scan.
         * </p>
         * 
         * @param type
         *        The type scan.
         * @see UsageType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see UsageType
         */
        Builder type(UsageType type);
    }

    static final class BuilderImpl implements Builder {
        private String currency;

        private Double estimatedMonthlyCost;

        private Double total;

        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(Usage model) {
            currency(model.currency);
            estimatedMonthlyCost(model.estimatedMonthlyCost);
            total(model.total);
            type(model.type);
        }

        public final String getCurrency() {
            return currency;
        }

        public final void setCurrency(String currency) {
            this.currency = currency;
        }

        @Override
        public final Builder currency(String currency) {
            this.currency = currency;
            return this;
        }

        @Override
        public final Builder currency(Currency currency) {
            this.currency(currency == null ? null : currency.toString());
            return this;
        }

        public final Double getEstimatedMonthlyCost() {
            return estimatedMonthlyCost;
        }

        public final void setEstimatedMonthlyCost(Double estimatedMonthlyCost) {
            this.estimatedMonthlyCost = estimatedMonthlyCost;
        }

        @Override
        public final Builder estimatedMonthlyCost(Double estimatedMonthlyCost) {
            this.estimatedMonthlyCost = estimatedMonthlyCost;
            return this;
        }

        public final Double getTotal() {
            return total;
        }

        public final void setTotal(Double total) {
            this.total = total;
        }

        @Override
        public final Builder total(Double total) {
            this.total = total;
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(UsageType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        @Override
        public Usage build() {
            return new Usage(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
