/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.inspector2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.inspector2.model.CodeFilePath;
import software.amazon.awssdk.services.inspector2.model.CweListCopier;
import software.amazon.awssdk.services.inspector2.model.DetectorTagListCopier;
import software.amazon.awssdk.services.inspector2.model.ReferenceUrlsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CodeVulnerabilityDetails
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CodeVulnerabilityDetails> {
    private static final SdkField<List<String>> CWES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("cwes").getter(CodeVulnerabilityDetails.getter(CodeVulnerabilityDetails::cwes)).setter(CodeVulnerabilityDetails.setter(Builder::cwes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cwes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> DETECTOR_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("detectorId").getter(CodeVulnerabilityDetails.getter(CodeVulnerabilityDetails::detectorId)).setter(CodeVulnerabilityDetails.setter(Builder::detectorId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("detectorId").build()}).build();
    private static final SdkField<String> DETECTOR_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("detectorName").getter(CodeVulnerabilityDetails.getter(CodeVulnerabilityDetails::detectorName)).setter(CodeVulnerabilityDetails.setter(Builder::detectorName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("detectorName").build()}).build();
    private static final SdkField<List<String>> DETECTOR_TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("detectorTags").getter(CodeVulnerabilityDetails.getter(CodeVulnerabilityDetails::detectorTags)).setter(CodeVulnerabilityDetails.setter(Builder::detectorTags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("detectorTags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<CodeFilePath> FILE_PATH_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("filePath").getter(CodeVulnerabilityDetails.getter(CodeVulnerabilityDetails::filePath)).setter(CodeVulnerabilityDetails.setter(Builder::filePath)).constructor(CodeFilePath::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filePath").build()}).build();
    private static final SdkField<List<String>> REFERENCE_URLS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("referenceUrls").getter(CodeVulnerabilityDetails.getter(CodeVulnerabilityDetails::referenceUrls)).setter(CodeVulnerabilityDetails.setter(Builder::referenceUrls)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("referenceUrls").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> RULE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ruleId").getter(CodeVulnerabilityDetails.getter(CodeVulnerabilityDetails::ruleId)).setter(CodeVulnerabilityDetails.setter(Builder::ruleId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ruleId").build()}).build();
    private static final SdkField<String> SOURCE_LAMBDA_LAYER_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sourceLambdaLayerArn").getter(CodeVulnerabilityDetails.getter(CodeVulnerabilityDetails::sourceLambdaLayerArn)).setter(CodeVulnerabilityDetails.setter(Builder::sourceLambdaLayerArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceLambdaLayerArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CWES_FIELD, DETECTOR_ID_FIELD, DETECTOR_NAME_FIELD, DETECTOR_TAGS_FIELD, FILE_PATH_FIELD, REFERENCE_URLS_FIELD, RULE_ID_FIELD, SOURCE_LAMBDA_LAYER_ARN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CodeVulnerabilityDetails.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<String> cwes;
    private final String detectorId;
    private final String detectorName;
    private final List<String> detectorTags;
    private final CodeFilePath filePath;
    private final List<String> referenceUrls;
    private final String ruleId;
    private final String sourceLambdaLayerArn;

    private CodeVulnerabilityDetails(BuilderImpl builder) {
        this.cwes = builder.cwes;
        this.detectorId = builder.detectorId;
        this.detectorName = builder.detectorName;
        this.detectorTags = builder.detectorTags;
        this.filePath = builder.filePath;
        this.referenceUrls = builder.referenceUrls;
        this.ruleId = builder.ruleId;
        this.sourceLambdaLayerArn = builder.sourceLambdaLayerArn;
    }

    public final boolean hasCwes() {
        return this.cwes != null && !(this.cwes instanceof SdkAutoConstructList);
    }

    public final List<String> cwes() {
        return this.cwes;
    }

    public final String detectorId() {
        return this.detectorId;
    }

    public final String detectorName() {
        return this.detectorName;
    }

    public final boolean hasDetectorTags() {
        return this.detectorTags != null && !(this.detectorTags instanceof SdkAutoConstructList);
    }

    public final List<String> detectorTags() {
        return this.detectorTags;
    }

    public final CodeFilePath filePath() {
        return this.filePath;
    }

    public final boolean hasReferenceUrls() {
        return this.referenceUrls != null && !(this.referenceUrls instanceof SdkAutoConstructList);
    }

    public final List<String> referenceUrls() {
        return this.referenceUrls;
    }

    public final String ruleId() {
        return this.ruleId;
    }

    public final String sourceLambdaLayerArn() {
        return this.sourceLambdaLayerArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCwes() ? this.cwes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.detectorId());
        hashCode = 31 * hashCode + Objects.hashCode(this.detectorName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDetectorTags() ? this.detectorTags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.filePath());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasReferenceUrls() ? this.referenceUrls() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.ruleId());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceLambdaLayerArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CodeVulnerabilityDetails)) {
            return false;
        }
        CodeVulnerabilityDetails other = (CodeVulnerabilityDetails)obj;
        return this.hasCwes() == other.hasCwes() && Objects.equals(this.cwes(), other.cwes()) && Objects.equals(this.detectorId(), other.detectorId()) && Objects.equals(this.detectorName(), other.detectorName()) && this.hasDetectorTags() == other.hasDetectorTags() && Objects.equals(this.detectorTags(), other.detectorTags()) && Objects.equals(this.filePath(), other.filePath()) && this.hasReferenceUrls() == other.hasReferenceUrls() && Objects.equals(this.referenceUrls(), other.referenceUrls()) && Objects.equals(this.ruleId(), other.ruleId()) && Objects.equals(this.sourceLambdaLayerArn(), other.sourceLambdaLayerArn());
    }

    public final String toString() {
        return ToString.builder((String)"CodeVulnerabilityDetails").add("Cwes", this.hasCwes() ? this.cwes() : null).add("DetectorId", (Object)this.detectorId()).add("DetectorName", (Object)this.detectorName()).add("DetectorTags", this.hasDetectorTags() ? this.detectorTags() : null).add("FilePath", (Object)this.filePath()).add("ReferenceUrls", this.hasReferenceUrls() ? this.referenceUrls() : null).add("RuleId", (Object)this.ruleId()).add("SourceLambdaLayerArn", (Object)this.sourceLambdaLayerArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "cwes": {
                return Optional.ofNullable(clazz.cast(this.cwes()));
            }
            case "detectorId": {
                return Optional.ofNullable(clazz.cast(this.detectorId()));
            }
            case "detectorName": {
                return Optional.ofNullable(clazz.cast(this.detectorName()));
            }
            case "detectorTags": {
                return Optional.ofNullable(clazz.cast(this.detectorTags()));
            }
            case "filePath": {
                return Optional.ofNullable(clazz.cast(this.filePath()));
            }
            case "referenceUrls": {
                return Optional.ofNullable(clazz.cast(this.referenceUrls()));
            }
            case "ruleId": {
                return Optional.ofNullable(clazz.cast(this.ruleId()));
            }
            case "sourceLambdaLayerArn": {
                return Optional.ofNullable(clazz.cast(this.sourceLambdaLayerArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("cwes", CWES_FIELD);
        map.put("detectorId", DETECTOR_ID_FIELD);
        map.put("detectorName", DETECTOR_NAME_FIELD);
        map.put("detectorTags", DETECTOR_TAGS_FIELD);
        map.put("filePath", FILE_PATH_FIELD);
        map.put("referenceUrls", REFERENCE_URLS_FIELD);
        map.put("ruleId", RULE_ID_FIELD);
        map.put("sourceLambdaLayerArn", SOURCE_LAMBDA_LAYER_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CodeVulnerabilityDetails, T> g) {
        return obj -> g.apply((CodeVulnerabilityDetails)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> cwes = DefaultSdkAutoConstructList.getInstance();
        private String detectorId;
        private String detectorName;
        private List<String> detectorTags = DefaultSdkAutoConstructList.getInstance();
        private CodeFilePath filePath;
        private List<String> referenceUrls = DefaultSdkAutoConstructList.getInstance();
        private String ruleId;
        private String sourceLambdaLayerArn;

        private BuilderImpl() {
        }

        private BuilderImpl(CodeVulnerabilityDetails model) {
            this.cwes(model.cwes);
            this.detectorId(model.detectorId);
            this.detectorName(model.detectorName);
            this.detectorTags(model.detectorTags);
            this.filePath(model.filePath);
            this.referenceUrls(model.referenceUrls);
            this.ruleId(model.ruleId);
            this.sourceLambdaLayerArn(model.sourceLambdaLayerArn);
        }

        public final Collection<String> getCwes() {
            if (this.cwes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.cwes;
        }

        public final void setCwes(Collection<String> cwes) {
            this.cwes = CweListCopier.copy(cwes);
        }

        @Override
        public final Builder cwes(Collection<String> cwes) {
            this.cwes = CweListCopier.copy(cwes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cwes(String ... cwes) {
            this.cwes(Arrays.asList(cwes));
            return this;
        }

        public final String getDetectorId() {
            return this.detectorId;
        }

        public final void setDetectorId(String detectorId) {
            this.detectorId = detectorId;
        }

        @Override
        public final Builder detectorId(String detectorId) {
            this.detectorId = detectorId;
            return this;
        }

        public final String getDetectorName() {
            return this.detectorName;
        }

        public final void setDetectorName(String detectorName) {
            this.detectorName = detectorName;
        }

        @Override
        public final Builder detectorName(String detectorName) {
            this.detectorName = detectorName;
            return this;
        }

        public final Collection<String> getDetectorTags() {
            if (this.detectorTags instanceof SdkAutoConstructList) {
                return null;
            }
            return this.detectorTags;
        }

        public final void setDetectorTags(Collection<String> detectorTags) {
            this.detectorTags = DetectorTagListCopier.copy(detectorTags);
        }

        @Override
        public final Builder detectorTags(Collection<String> detectorTags) {
            this.detectorTags = DetectorTagListCopier.copy(detectorTags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder detectorTags(String ... detectorTags) {
            this.detectorTags(Arrays.asList(detectorTags));
            return this;
        }

        public final CodeFilePath.Builder getFilePath() {
            return this.filePath != null ? this.filePath.toBuilder() : null;
        }

        public final void setFilePath(CodeFilePath.BuilderImpl filePath) {
            this.filePath = filePath != null ? filePath.build() : null;
        }

        @Override
        public final Builder filePath(CodeFilePath filePath) {
            this.filePath = filePath;
            return this;
        }

        public final Collection<String> getReferenceUrls() {
            if (this.referenceUrls instanceof SdkAutoConstructList) {
                return null;
            }
            return this.referenceUrls;
        }

        public final void setReferenceUrls(Collection<String> referenceUrls) {
            this.referenceUrls = ReferenceUrlsCopier.copy(referenceUrls);
        }

        @Override
        public final Builder referenceUrls(Collection<String> referenceUrls) {
            this.referenceUrls = ReferenceUrlsCopier.copy(referenceUrls);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder referenceUrls(String ... referenceUrls) {
            this.referenceUrls(Arrays.asList(referenceUrls));
            return this;
        }

        public final String getRuleId() {
            return this.ruleId;
        }

        public final void setRuleId(String ruleId) {
            this.ruleId = ruleId;
        }

        @Override
        public final Builder ruleId(String ruleId) {
            this.ruleId = ruleId;
            return this;
        }

        public final String getSourceLambdaLayerArn() {
            return this.sourceLambdaLayerArn;
        }

        public final void setSourceLambdaLayerArn(String sourceLambdaLayerArn) {
            this.sourceLambdaLayerArn = sourceLambdaLayerArn;
        }

        @Override
        public final Builder sourceLambdaLayerArn(String sourceLambdaLayerArn) {
            this.sourceLambdaLayerArn = sourceLambdaLayerArn;
            return this;
        }

        public CodeVulnerabilityDetails build() {
            return new CodeVulnerabilityDetails(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CodeVulnerabilityDetails> {
        public Builder cwes(Collection<String> var1);

        public Builder cwes(String ... var1);

        public Builder detectorId(String var1);

        public Builder detectorName(String var1);

        public Builder detectorTags(Collection<String> var1);

        public Builder detectorTags(String ... var1);

        public Builder filePath(CodeFilePath var1);

        default public Builder filePath(Consumer<CodeFilePath.Builder> filePath) {
            return this.filePath((CodeFilePath)((CodeFilePath.Builder)CodeFilePath.builder().applyMutation(filePath)).build());
        }

        public Builder referenceUrls(Collection<String> var1);

        public Builder referenceUrls(String ... var1);

        public Builder ruleId(String var1);

        public Builder sourceLambdaLayerArn(String var1);
    }
}

