/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.inspector2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.inspector2.model.ImageLayerSortBy;
import software.amazon.awssdk.services.inspector2.model.SortOrder;
import software.amazon.awssdk.services.inspector2.model.StringFilter;
import software.amazon.awssdk.services.inspector2.model.StringFilterListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ImageLayerAggregation
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ImageLayerAggregation> {
    private static final SdkField<List<StringFilter>> LAYER_HASHES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("layerHashes").getter(ImageLayerAggregation.getter(ImageLayerAggregation::layerHashes)).setter(ImageLayerAggregation.setter(Builder::layerHashes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("layerHashes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(StringFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<StringFilter>> REPOSITORIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("repositories").getter(ImageLayerAggregation.getter(ImageLayerAggregation::repositories)).setter(ImageLayerAggregation.setter(Builder::repositories)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("repositories").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(StringFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<StringFilter>> RESOURCE_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("resourceIds").getter(ImageLayerAggregation.getter(ImageLayerAggregation::resourceIds)).setter(ImageLayerAggregation.setter(Builder::resourceIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(StringFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> SORT_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sortBy").getter(ImageLayerAggregation.getter(ImageLayerAggregation::sortByAsString)).setter(ImageLayerAggregation.setter(Builder::sortBy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sortBy").build()}).build();
    private static final SdkField<String> SORT_ORDER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sortOrder").getter(ImageLayerAggregation.getter(ImageLayerAggregation::sortOrderAsString)).setter(ImageLayerAggregation.setter(Builder::sortOrder)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sortOrder").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LAYER_HASHES_FIELD, REPOSITORIES_FIELD, RESOURCE_IDS_FIELD, SORT_BY_FIELD, SORT_ORDER_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ImageLayerAggregation.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<StringFilter> layerHashes;
    private final List<StringFilter> repositories;
    private final List<StringFilter> resourceIds;
    private final String sortBy;
    private final String sortOrder;

    private ImageLayerAggregation(BuilderImpl builder) {
        this.layerHashes = builder.layerHashes;
        this.repositories = builder.repositories;
        this.resourceIds = builder.resourceIds;
        this.sortBy = builder.sortBy;
        this.sortOrder = builder.sortOrder;
    }

    public final boolean hasLayerHashes() {
        return this.layerHashes != null && !(this.layerHashes instanceof SdkAutoConstructList);
    }

    public final List<StringFilter> layerHashes() {
        return this.layerHashes;
    }

    public final boolean hasRepositories() {
        return this.repositories != null && !(this.repositories instanceof SdkAutoConstructList);
    }

    public final List<StringFilter> repositories() {
        return this.repositories;
    }

    public final boolean hasResourceIds() {
        return this.resourceIds != null && !(this.resourceIds instanceof SdkAutoConstructList);
    }

    public final List<StringFilter> resourceIds() {
        return this.resourceIds;
    }

    public final ImageLayerSortBy sortBy() {
        return ImageLayerSortBy.fromValue(this.sortBy);
    }

    public final String sortByAsString() {
        return this.sortBy;
    }

    public final SortOrder sortOrder() {
        return SortOrder.fromValue(this.sortOrder);
    }

    public final String sortOrderAsString() {
        return this.sortOrder;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasLayerHashes() ? this.layerHashes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRepositories() ? this.repositories() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasResourceIds() ? this.resourceIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.sortByAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.sortOrderAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ImageLayerAggregation)) {
            return false;
        }
        ImageLayerAggregation other = (ImageLayerAggregation)obj;
        return this.hasLayerHashes() == other.hasLayerHashes() && Objects.equals(this.layerHashes(), other.layerHashes()) && this.hasRepositories() == other.hasRepositories() && Objects.equals(this.repositories(), other.repositories()) && this.hasResourceIds() == other.hasResourceIds() && Objects.equals(this.resourceIds(), other.resourceIds()) && Objects.equals(this.sortByAsString(), other.sortByAsString()) && Objects.equals(this.sortOrderAsString(), other.sortOrderAsString());
    }

    public final String toString() {
        return ToString.builder((String)"ImageLayerAggregation").add("LayerHashes", this.hasLayerHashes() ? this.layerHashes() : null).add("Repositories", this.hasRepositories() ? this.repositories() : null).add("ResourceIds", this.hasResourceIds() ? this.resourceIds() : null).add("SortBy", (Object)this.sortByAsString()).add("SortOrder", (Object)this.sortOrderAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "layerHashes": {
                return Optional.ofNullable(clazz.cast(this.layerHashes()));
            }
            case "repositories": {
                return Optional.ofNullable(clazz.cast(this.repositories()));
            }
            case "resourceIds": {
                return Optional.ofNullable(clazz.cast(this.resourceIds()));
            }
            case "sortBy": {
                return Optional.ofNullable(clazz.cast(this.sortByAsString()));
            }
            case "sortOrder": {
                return Optional.ofNullable(clazz.cast(this.sortOrderAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("layerHashes", LAYER_HASHES_FIELD);
        map.put("repositories", REPOSITORIES_FIELD);
        map.put("resourceIds", RESOURCE_IDS_FIELD);
        map.put("sortBy", SORT_BY_FIELD);
        map.put("sortOrder", SORT_ORDER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ImageLayerAggregation, T> g) {
        return obj -> g.apply((ImageLayerAggregation)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<StringFilter> layerHashes = DefaultSdkAutoConstructList.getInstance();
        private List<StringFilter> repositories = DefaultSdkAutoConstructList.getInstance();
        private List<StringFilter> resourceIds = DefaultSdkAutoConstructList.getInstance();
        private String sortBy;
        private String sortOrder;

        private BuilderImpl() {
        }

        private BuilderImpl(ImageLayerAggregation model) {
            this.layerHashes(model.layerHashes);
            this.repositories(model.repositories);
            this.resourceIds(model.resourceIds);
            this.sortBy(model.sortBy);
            this.sortOrder(model.sortOrder);
        }

        public final List<StringFilter.Builder> getLayerHashes() {
            List<StringFilter.Builder> result = StringFilterListCopier.copyToBuilder(this.layerHashes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setLayerHashes(Collection<StringFilter.BuilderImpl> layerHashes) {
            this.layerHashes = StringFilterListCopier.copyFromBuilder(layerHashes);
        }

        @Override
        public final Builder layerHashes(Collection<StringFilter> layerHashes) {
            this.layerHashes = StringFilterListCopier.copy(layerHashes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder layerHashes(StringFilter ... layerHashes) {
            this.layerHashes(Arrays.asList(layerHashes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder layerHashes(Consumer<StringFilter.Builder> ... layerHashes) {
            this.layerHashes(Stream.of(layerHashes).map(c -> (StringFilter)((StringFilter.Builder)StringFilter.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<StringFilter.Builder> getRepositories() {
            List<StringFilter.Builder> result = StringFilterListCopier.copyToBuilder(this.repositories);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRepositories(Collection<StringFilter.BuilderImpl> repositories) {
            this.repositories = StringFilterListCopier.copyFromBuilder(repositories);
        }

        @Override
        public final Builder repositories(Collection<StringFilter> repositories) {
            this.repositories = StringFilterListCopier.copy(repositories);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder repositories(StringFilter ... repositories) {
            this.repositories(Arrays.asList(repositories));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder repositories(Consumer<StringFilter.Builder> ... repositories) {
            this.repositories(Stream.of(repositories).map(c -> (StringFilter)((StringFilter.Builder)StringFilter.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<StringFilter.Builder> getResourceIds() {
            List<StringFilter.Builder> result = StringFilterListCopier.copyToBuilder(this.resourceIds);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setResourceIds(Collection<StringFilter.BuilderImpl> resourceIds) {
            this.resourceIds = StringFilterListCopier.copyFromBuilder(resourceIds);
        }

        @Override
        public final Builder resourceIds(Collection<StringFilter> resourceIds) {
            this.resourceIds = StringFilterListCopier.copy(resourceIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceIds(StringFilter ... resourceIds) {
            this.resourceIds(Arrays.asList(resourceIds));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceIds(Consumer<StringFilter.Builder> ... resourceIds) {
            this.resourceIds(Stream.of(resourceIds).map(c -> (StringFilter)((StringFilter.Builder)StringFilter.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getSortBy() {
            return this.sortBy;
        }

        public final void setSortBy(String sortBy) {
            this.sortBy = sortBy;
        }

        @Override
        public final Builder sortBy(String sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        @Override
        public final Builder sortBy(ImageLayerSortBy sortBy) {
            this.sortBy(sortBy == null ? null : sortBy.toString());
            return this;
        }

        public final String getSortOrder() {
            return this.sortOrder;
        }

        public final void setSortOrder(String sortOrder) {
            this.sortOrder = sortOrder;
        }

        @Override
        public final Builder sortOrder(String sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        @Override
        public final Builder sortOrder(SortOrder sortOrder) {
            this.sortOrder(sortOrder == null ? null : sortOrder.toString());
            return this;
        }

        public ImageLayerAggregation build() {
            return new ImageLayerAggregation(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ImageLayerAggregation> {
        public Builder layerHashes(Collection<StringFilter> var1);

        public Builder layerHashes(StringFilter ... var1);

        public Builder layerHashes(Consumer<StringFilter.Builder> ... var1);

        public Builder repositories(Collection<StringFilter> var1);

        public Builder repositories(StringFilter ... var1);

        public Builder repositories(Consumer<StringFilter.Builder> ... var1);

        public Builder resourceIds(Collection<StringFilter> var1);

        public Builder resourceIds(StringFilter ... var1);

        public Builder resourceIds(Consumer<StringFilter.Builder> ... var1);

        public Builder sortBy(String var1);

        public Builder sortBy(ImageLayerSortBy var1);

        public Builder sortOrder(String var1);

        public Builder sortOrder(SortOrder var1);
    }
}

