/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.inspector2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.inspector2.model.NetworkPath;
import software.amazon.awssdk.services.inspector2.model.NetworkProtocol;
import software.amazon.awssdk.services.inspector2.model.PortRange;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class NetworkReachabilityDetails
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, NetworkReachabilityDetails> {
    private static final SdkField<NetworkPath> NETWORK_PATH_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("networkPath").getter(NetworkReachabilityDetails.getter(NetworkReachabilityDetails::networkPath)).setter(NetworkReachabilityDetails.setter(Builder::networkPath)).constructor(NetworkPath::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("networkPath").build()}).build();
    private static final SdkField<PortRange> OPEN_PORT_RANGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("openPortRange").getter(NetworkReachabilityDetails.getter(NetworkReachabilityDetails::openPortRange)).setter(NetworkReachabilityDetails.setter(Builder::openPortRange)).constructor(PortRange::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("openPortRange").build()}).build();
    private static final SdkField<String> PROTOCOL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("protocol").getter(NetworkReachabilityDetails.getter(NetworkReachabilityDetails::protocolAsString)).setter(NetworkReachabilityDetails.setter(Builder::protocol)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("protocol").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NETWORK_PATH_FIELD, OPEN_PORT_RANGE_FIELD, PROTOCOL_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = NetworkReachabilityDetails.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final NetworkPath networkPath;
    private final PortRange openPortRange;
    private final String protocol;

    private NetworkReachabilityDetails(BuilderImpl builder) {
        this.networkPath = builder.networkPath;
        this.openPortRange = builder.openPortRange;
        this.protocol = builder.protocol;
    }

    public final NetworkPath networkPath() {
        return this.networkPath;
    }

    public final PortRange openPortRange() {
        return this.openPortRange;
    }

    public final NetworkProtocol protocol() {
        return NetworkProtocol.fromValue(this.protocol);
    }

    public final String protocolAsString() {
        return this.protocol;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.networkPath());
        hashCode = 31 * hashCode + Objects.hashCode(this.openPortRange());
        hashCode = 31 * hashCode + Objects.hashCode(this.protocolAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NetworkReachabilityDetails)) {
            return false;
        }
        NetworkReachabilityDetails other = (NetworkReachabilityDetails)obj;
        return Objects.equals(this.networkPath(), other.networkPath()) && Objects.equals(this.openPortRange(), other.openPortRange()) && Objects.equals(this.protocolAsString(), other.protocolAsString());
    }

    public final String toString() {
        return ToString.builder((String)"NetworkReachabilityDetails").add("NetworkPath", (Object)this.networkPath()).add("OpenPortRange", (Object)this.openPortRange()).add("Protocol", (Object)this.protocolAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "networkPath": {
                return Optional.ofNullable(clazz.cast(this.networkPath()));
            }
            case "openPortRange": {
                return Optional.ofNullable(clazz.cast(this.openPortRange()));
            }
            case "protocol": {
                return Optional.ofNullable(clazz.cast(this.protocolAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("networkPath", NETWORK_PATH_FIELD);
        map.put("openPortRange", OPEN_PORT_RANGE_FIELD);
        map.put("protocol", PROTOCOL_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<NetworkReachabilityDetails, T> g) {
        return obj -> g.apply((NetworkReachabilityDetails)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private NetworkPath networkPath;
        private PortRange openPortRange;
        private String protocol;

        private BuilderImpl() {
        }

        private BuilderImpl(NetworkReachabilityDetails model) {
            this.networkPath(model.networkPath);
            this.openPortRange(model.openPortRange);
            this.protocol(model.protocol);
        }

        public final NetworkPath.Builder getNetworkPath() {
            return this.networkPath != null ? this.networkPath.toBuilder() : null;
        }

        public final void setNetworkPath(NetworkPath.BuilderImpl networkPath) {
            this.networkPath = networkPath != null ? networkPath.build() : null;
        }

        @Override
        public final Builder networkPath(NetworkPath networkPath) {
            this.networkPath = networkPath;
            return this;
        }

        public final PortRange.Builder getOpenPortRange() {
            return this.openPortRange != null ? this.openPortRange.toBuilder() : null;
        }

        public final void setOpenPortRange(PortRange.BuilderImpl openPortRange) {
            this.openPortRange = openPortRange != null ? openPortRange.build() : null;
        }

        @Override
        public final Builder openPortRange(PortRange openPortRange) {
            this.openPortRange = openPortRange;
            return this;
        }

        public final String getProtocol() {
            return this.protocol;
        }

        public final void setProtocol(String protocol) {
            this.protocol = protocol;
        }

        @Override
        public final Builder protocol(String protocol) {
            this.protocol = protocol;
            return this;
        }

        @Override
        public final Builder protocol(NetworkProtocol protocol) {
            this.protocol(protocol == null ? null : protocol.toString());
            return this;
        }

        public NetworkReachabilityDetails build() {
            return new NetworkReachabilityDetails(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, NetworkReachabilityDetails> {
        public Builder networkPath(NetworkPath var1);

        default public Builder networkPath(Consumer<NetworkPath.Builder> networkPath) {
            return this.networkPath((NetworkPath)((NetworkPath.Builder)NetworkPath.builder().applyMutation(networkPath)).build());
        }

        public Builder openPortRange(PortRange var1);

        default public Builder openPortRange(Consumer<PortRange.Builder> openPortRange) {
            return this.openPortRange((PortRange)((PortRange.Builder)PortRange.builder().applyMutation(openPortRange)).build());
        }

        public Builder protocol(String var1);

        public Builder protocol(NetworkProtocol var1);
    }
}

