/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.inspector2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.inspector2.model.CheckIdFilterListCopier;
import software.amazon.awssdk.services.inspector2.model.CisNumberFilter;
import software.amazon.awssdk.services.inspector2.model.CisNumberFilterListCopier;
import software.amazon.awssdk.services.inspector2.model.CisSecurityLevelFilter;
import software.amazon.awssdk.services.inspector2.model.CisSecurityLevelFilterListCopier;
import software.amazon.awssdk.services.inspector2.model.CisStringFilter;
import software.amazon.awssdk.services.inspector2.model.OneAccountIdFilterListCopier;
import software.amazon.awssdk.services.inspector2.model.PlatformFilterListCopier;
import software.amazon.awssdk.services.inspector2.model.TitleFilterListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CisScanResultsAggregatedByChecksFilterCriteria
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CisScanResultsAggregatedByChecksFilterCriteria> {
    private static final SdkField<List<CisStringFilter>> ACCOUNT_ID_FILTERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("accountIdFilters").getter(CisScanResultsAggregatedByChecksFilterCriteria.getter(CisScanResultsAggregatedByChecksFilterCriteria::accountIdFilters)).setter(CisScanResultsAggregatedByChecksFilterCriteria.setter(Builder::accountIdFilters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accountIdFilters").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CisStringFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<CisStringFilter>> CHECK_ID_FILTERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("checkIdFilters").getter(CisScanResultsAggregatedByChecksFilterCriteria.getter(CisScanResultsAggregatedByChecksFilterCriteria::checkIdFilters)).setter(CisScanResultsAggregatedByChecksFilterCriteria.setter(Builder::checkIdFilters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("checkIdFilters").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CisStringFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<CisNumberFilter>> FAILED_RESOURCES_FILTERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("failedResourcesFilters").getter(CisScanResultsAggregatedByChecksFilterCriteria.getter(CisScanResultsAggregatedByChecksFilterCriteria::failedResourcesFilters)).setter(CisScanResultsAggregatedByChecksFilterCriteria.setter(Builder::failedResourcesFilters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failedResourcesFilters").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CisNumberFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<CisStringFilter>> PLATFORM_FILTERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("platformFilters").getter(CisScanResultsAggregatedByChecksFilterCriteria.getter(CisScanResultsAggregatedByChecksFilterCriteria::platformFilters)).setter(CisScanResultsAggregatedByChecksFilterCriteria.setter(Builder::platformFilters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("platformFilters").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CisStringFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<CisSecurityLevelFilter>> SECURITY_LEVEL_FILTERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("securityLevelFilters").getter(CisScanResultsAggregatedByChecksFilterCriteria.getter(CisScanResultsAggregatedByChecksFilterCriteria::securityLevelFilters)).setter(CisScanResultsAggregatedByChecksFilterCriteria.setter(Builder::securityLevelFilters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("securityLevelFilters").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CisSecurityLevelFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<CisStringFilter>> TITLE_FILTERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("titleFilters").getter(CisScanResultsAggregatedByChecksFilterCriteria.getter(CisScanResultsAggregatedByChecksFilterCriteria::titleFilters)).setter(CisScanResultsAggregatedByChecksFilterCriteria.setter(Builder::titleFilters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("titleFilters").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CisStringFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_ID_FILTERS_FIELD, CHECK_ID_FILTERS_FIELD, FAILED_RESOURCES_FILTERS_FIELD, PLATFORM_FILTERS_FIELD, SECURITY_LEVEL_FILTERS_FIELD, TITLE_FILTERS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CisScanResultsAggregatedByChecksFilterCriteria.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<CisStringFilter> accountIdFilters;
    private final List<CisStringFilter> checkIdFilters;
    private final List<CisNumberFilter> failedResourcesFilters;
    private final List<CisStringFilter> platformFilters;
    private final List<CisSecurityLevelFilter> securityLevelFilters;
    private final List<CisStringFilter> titleFilters;

    private CisScanResultsAggregatedByChecksFilterCriteria(BuilderImpl builder) {
        this.accountIdFilters = builder.accountIdFilters;
        this.checkIdFilters = builder.checkIdFilters;
        this.failedResourcesFilters = builder.failedResourcesFilters;
        this.platformFilters = builder.platformFilters;
        this.securityLevelFilters = builder.securityLevelFilters;
        this.titleFilters = builder.titleFilters;
    }

    public final boolean hasAccountIdFilters() {
        return this.accountIdFilters != null && !(this.accountIdFilters instanceof SdkAutoConstructList);
    }

    public final List<CisStringFilter> accountIdFilters() {
        return this.accountIdFilters;
    }

    public final boolean hasCheckIdFilters() {
        return this.checkIdFilters != null && !(this.checkIdFilters instanceof SdkAutoConstructList);
    }

    public final List<CisStringFilter> checkIdFilters() {
        return this.checkIdFilters;
    }

    public final boolean hasFailedResourcesFilters() {
        return this.failedResourcesFilters != null && !(this.failedResourcesFilters instanceof SdkAutoConstructList);
    }

    public final List<CisNumberFilter> failedResourcesFilters() {
        return this.failedResourcesFilters;
    }

    public final boolean hasPlatformFilters() {
        return this.platformFilters != null && !(this.platformFilters instanceof SdkAutoConstructList);
    }

    public final List<CisStringFilter> platformFilters() {
        return this.platformFilters;
    }

    public final boolean hasSecurityLevelFilters() {
        return this.securityLevelFilters != null && !(this.securityLevelFilters instanceof SdkAutoConstructList);
    }

    public final List<CisSecurityLevelFilter> securityLevelFilters() {
        return this.securityLevelFilters;
    }

    public final boolean hasTitleFilters() {
        return this.titleFilters != null && !(this.titleFilters instanceof SdkAutoConstructList);
    }

    public final List<CisStringFilter> titleFilters() {
        return this.titleFilters;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAccountIdFilters() ? this.accountIdFilters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCheckIdFilters() ? this.checkIdFilters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFailedResourcesFilters() ? this.failedResourcesFilters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPlatformFilters() ? this.platformFilters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSecurityLevelFilters() ? this.securityLevelFilters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTitleFilters() ? this.titleFilters() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CisScanResultsAggregatedByChecksFilterCriteria)) {
            return false;
        }
        CisScanResultsAggregatedByChecksFilterCriteria other = (CisScanResultsAggregatedByChecksFilterCriteria)obj;
        return this.hasAccountIdFilters() == other.hasAccountIdFilters() && Objects.equals(this.accountIdFilters(), other.accountIdFilters()) && this.hasCheckIdFilters() == other.hasCheckIdFilters() && Objects.equals(this.checkIdFilters(), other.checkIdFilters()) && this.hasFailedResourcesFilters() == other.hasFailedResourcesFilters() && Objects.equals(this.failedResourcesFilters(), other.failedResourcesFilters()) && this.hasPlatformFilters() == other.hasPlatformFilters() && Objects.equals(this.platformFilters(), other.platformFilters()) && this.hasSecurityLevelFilters() == other.hasSecurityLevelFilters() && Objects.equals(this.securityLevelFilters(), other.securityLevelFilters()) && this.hasTitleFilters() == other.hasTitleFilters() && Objects.equals(this.titleFilters(), other.titleFilters());
    }

    public final String toString() {
        return ToString.builder((String)"CisScanResultsAggregatedByChecksFilterCriteria").add("AccountIdFilters", this.hasAccountIdFilters() ? this.accountIdFilters() : null).add("CheckIdFilters", this.hasCheckIdFilters() ? this.checkIdFilters() : null).add("FailedResourcesFilters", this.hasFailedResourcesFilters() ? this.failedResourcesFilters() : null).add("PlatformFilters", this.hasPlatformFilters() ? this.platformFilters() : null).add("SecurityLevelFilters", this.hasSecurityLevelFilters() ? this.securityLevelFilters() : null).add("TitleFilters", this.hasTitleFilters() ? this.titleFilters() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "accountIdFilters": {
                return Optional.ofNullable(clazz.cast(this.accountIdFilters()));
            }
            case "checkIdFilters": {
                return Optional.ofNullable(clazz.cast(this.checkIdFilters()));
            }
            case "failedResourcesFilters": {
                return Optional.ofNullable(clazz.cast(this.failedResourcesFilters()));
            }
            case "platformFilters": {
                return Optional.ofNullable(clazz.cast(this.platformFilters()));
            }
            case "securityLevelFilters": {
                return Optional.ofNullable(clazz.cast(this.securityLevelFilters()));
            }
            case "titleFilters": {
                return Optional.ofNullable(clazz.cast(this.titleFilters()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("accountIdFilters", ACCOUNT_ID_FILTERS_FIELD);
        map.put("checkIdFilters", CHECK_ID_FILTERS_FIELD);
        map.put("failedResourcesFilters", FAILED_RESOURCES_FILTERS_FIELD);
        map.put("platformFilters", PLATFORM_FILTERS_FIELD);
        map.put("securityLevelFilters", SECURITY_LEVEL_FILTERS_FIELD);
        map.put("titleFilters", TITLE_FILTERS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CisScanResultsAggregatedByChecksFilterCriteria, T> g) {
        return obj -> g.apply((CisScanResultsAggregatedByChecksFilterCriteria)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<CisStringFilter> accountIdFilters = DefaultSdkAutoConstructList.getInstance();
        private List<CisStringFilter> checkIdFilters = DefaultSdkAutoConstructList.getInstance();
        private List<CisNumberFilter> failedResourcesFilters = DefaultSdkAutoConstructList.getInstance();
        private List<CisStringFilter> platformFilters = DefaultSdkAutoConstructList.getInstance();
        private List<CisSecurityLevelFilter> securityLevelFilters = DefaultSdkAutoConstructList.getInstance();
        private List<CisStringFilter> titleFilters = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CisScanResultsAggregatedByChecksFilterCriteria model) {
            this.accountIdFilters(model.accountIdFilters);
            this.checkIdFilters(model.checkIdFilters);
            this.failedResourcesFilters(model.failedResourcesFilters);
            this.platformFilters(model.platformFilters);
            this.securityLevelFilters(model.securityLevelFilters);
            this.titleFilters(model.titleFilters);
        }

        public final List<CisStringFilter.Builder> getAccountIdFilters() {
            List<CisStringFilter.Builder> result = OneAccountIdFilterListCopier.copyToBuilder(this.accountIdFilters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAccountIdFilters(Collection<CisStringFilter.BuilderImpl> accountIdFilters) {
            this.accountIdFilters = OneAccountIdFilterListCopier.copyFromBuilder(accountIdFilters);
        }

        @Override
        public final Builder accountIdFilters(Collection<CisStringFilter> accountIdFilters) {
            this.accountIdFilters = OneAccountIdFilterListCopier.copy(accountIdFilters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accountIdFilters(CisStringFilter ... accountIdFilters) {
            this.accountIdFilters(Arrays.asList(accountIdFilters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accountIdFilters(Consumer<CisStringFilter.Builder> ... accountIdFilters) {
            this.accountIdFilters(Stream.of(accountIdFilters).map(c -> (CisStringFilter)((CisStringFilter.Builder)CisStringFilter.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<CisStringFilter.Builder> getCheckIdFilters() {
            List<CisStringFilter.Builder> result = CheckIdFilterListCopier.copyToBuilder(this.checkIdFilters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCheckIdFilters(Collection<CisStringFilter.BuilderImpl> checkIdFilters) {
            this.checkIdFilters = CheckIdFilterListCopier.copyFromBuilder(checkIdFilters);
        }

        @Override
        public final Builder checkIdFilters(Collection<CisStringFilter> checkIdFilters) {
            this.checkIdFilters = CheckIdFilterListCopier.copy(checkIdFilters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder checkIdFilters(CisStringFilter ... checkIdFilters) {
            this.checkIdFilters(Arrays.asList(checkIdFilters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder checkIdFilters(Consumer<CisStringFilter.Builder> ... checkIdFilters) {
            this.checkIdFilters(Stream.of(checkIdFilters).map(c -> (CisStringFilter)((CisStringFilter.Builder)CisStringFilter.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<CisNumberFilter.Builder> getFailedResourcesFilters() {
            List<CisNumberFilter.Builder> result = CisNumberFilterListCopier.copyToBuilder(this.failedResourcesFilters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFailedResourcesFilters(Collection<CisNumberFilter.BuilderImpl> failedResourcesFilters) {
            this.failedResourcesFilters = CisNumberFilterListCopier.copyFromBuilder(failedResourcesFilters);
        }

        @Override
        public final Builder failedResourcesFilters(Collection<CisNumberFilter> failedResourcesFilters) {
            this.failedResourcesFilters = CisNumberFilterListCopier.copy(failedResourcesFilters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder failedResourcesFilters(CisNumberFilter ... failedResourcesFilters) {
            this.failedResourcesFilters(Arrays.asList(failedResourcesFilters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder failedResourcesFilters(Consumer<CisNumberFilter.Builder> ... failedResourcesFilters) {
            this.failedResourcesFilters(Stream.of(failedResourcesFilters).map(c -> (CisNumberFilter)((CisNumberFilter.Builder)CisNumberFilter.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<CisStringFilter.Builder> getPlatformFilters() {
            List<CisStringFilter.Builder> result = PlatformFilterListCopier.copyToBuilder(this.platformFilters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPlatformFilters(Collection<CisStringFilter.BuilderImpl> platformFilters) {
            this.platformFilters = PlatformFilterListCopier.copyFromBuilder(platformFilters);
        }

        @Override
        public final Builder platformFilters(Collection<CisStringFilter> platformFilters) {
            this.platformFilters = PlatformFilterListCopier.copy(platformFilters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder platformFilters(CisStringFilter ... platformFilters) {
            this.platformFilters(Arrays.asList(platformFilters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder platformFilters(Consumer<CisStringFilter.Builder> ... platformFilters) {
            this.platformFilters(Stream.of(platformFilters).map(c -> (CisStringFilter)((CisStringFilter.Builder)CisStringFilter.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<CisSecurityLevelFilter.Builder> getSecurityLevelFilters() {
            List<CisSecurityLevelFilter.Builder> result = CisSecurityLevelFilterListCopier.copyToBuilder(this.securityLevelFilters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSecurityLevelFilters(Collection<CisSecurityLevelFilter.BuilderImpl> securityLevelFilters) {
            this.securityLevelFilters = CisSecurityLevelFilterListCopier.copyFromBuilder(securityLevelFilters);
        }

        @Override
        public final Builder securityLevelFilters(Collection<CisSecurityLevelFilter> securityLevelFilters) {
            this.securityLevelFilters = CisSecurityLevelFilterListCopier.copy(securityLevelFilters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityLevelFilters(CisSecurityLevelFilter ... securityLevelFilters) {
            this.securityLevelFilters(Arrays.asList(securityLevelFilters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityLevelFilters(Consumer<CisSecurityLevelFilter.Builder> ... securityLevelFilters) {
            this.securityLevelFilters(Stream.of(securityLevelFilters).map(c -> (CisSecurityLevelFilter)((CisSecurityLevelFilter.Builder)CisSecurityLevelFilter.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<CisStringFilter.Builder> getTitleFilters() {
            List<CisStringFilter.Builder> result = TitleFilterListCopier.copyToBuilder(this.titleFilters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTitleFilters(Collection<CisStringFilter.BuilderImpl> titleFilters) {
            this.titleFilters = TitleFilterListCopier.copyFromBuilder(titleFilters);
        }

        @Override
        public final Builder titleFilters(Collection<CisStringFilter> titleFilters) {
            this.titleFilters = TitleFilterListCopier.copy(titleFilters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder titleFilters(CisStringFilter ... titleFilters) {
            this.titleFilters(Arrays.asList(titleFilters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder titleFilters(Consumer<CisStringFilter.Builder> ... titleFilters) {
            this.titleFilters(Stream.of(titleFilters).map(c -> (CisStringFilter)((CisStringFilter.Builder)CisStringFilter.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public CisScanResultsAggregatedByChecksFilterCriteria build() {
            return new CisScanResultsAggregatedByChecksFilterCriteria(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CisScanResultsAggregatedByChecksFilterCriteria> {
        public Builder accountIdFilters(Collection<CisStringFilter> var1);

        public Builder accountIdFilters(CisStringFilter ... var1);

        public Builder accountIdFilters(Consumer<CisStringFilter.Builder> ... var1);

        public Builder checkIdFilters(Collection<CisStringFilter> var1);

        public Builder checkIdFilters(CisStringFilter ... var1);

        public Builder checkIdFilters(Consumer<CisStringFilter.Builder> ... var1);

        public Builder failedResourcesFilters(Collection<CisNumberFilter> var1);

        public Builder failedResourcesFilters(CisNumberFilter ... var1);

        public Builder failedResourcesFilters(Consumer<CisNumberFilter.Builder> ... var1);

        public Builder platformFilters(Collection<CisStringFilter> var1);

        public Builder platformFilters(CisStringFilter ... var1);

        public Builder platformFilters(Consumer<CisStringFilter.Builder> ... var1);

        public Builder securityLevelFilters(Collection<CisSecurityLevelFilter> var1);

        public Builder securityLevelFilters(CisSecurityLevelFilter ... var1);

        public Builder securityLevelFilters(Consumer<CisSecurityLevelFilter.Builder> ... var1);

        public Builder titleFilters(Collection<CisStringFilter> var1);

        public Builder titleFilters(CisStringFilter ... var1);

        public Builder titleFilters(Consumer<CisStringFilter.Builder> ... var1);
    }
}

