/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.inspector2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.inspector2.model.Ec2InstanceSortBy;
import software.amazon.awssdk.services.inspector2.model.MapFilter;
import software.amazon.awssdk.services.inspector2.model.MapFilterListCopier;
import software.amazon.awssdk.services.inspector2.model.SortOrder;
import software.amazon.awssdk.services.inspector2.model.StringFilter;
import software.amazon.awssdk.services.inspector2.model.StringFilterListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Ec2InstanceAggregation
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Ec2InstanceAggregation> {
    private static final SdkField<List<StringFilter>> AMIS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("amis").getter(Ec2InstanceAggregation.getter(Ec2InstanceAggregation::amis)).setter(Ec2InstanceAggregation.setter(Builder::amis)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("amis").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(StringFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<StringFilter>> INSTANCE_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("instanceIds").getter(Ec2InstanceAggregation.getter(Ec2InstanceAggregation::instanceIds)).setter(Ec2InstanceAggregation.setter(Builder::instanceIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("instanceIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(StringFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<MapFilter>> INSTANCE_TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("instanceTags").getter(Ec2InstanceAggregation.getter(Ec2InstanceAggregation::instanceTags)).setter(Ec2InstanceAggregation.setter(Builder::instanceTags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("instanceTags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(MapFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<StringFilter>> OPERATING_SYSTEMS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("operatingSystems").getter(Ec2InstanceAggregation.getter(Ec2InstanceAggregation::operatingSystems)).setter(Ec2InstanceAggregation.setter(Builder::operatingSystems)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("operatingSystems").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(StringFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> SORT_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sortBy").getter(Ec2InstanceAggregation.getter(Ec2InstanceAggregation::sortByAsString)).setter(Ec2InstanceAggregation.setter(Builder::sortBy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sortBy").build()}).build();
    private static final SdkField<String> SORT_ORDER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sortOrder").getter(Ec2InstanceAggregation.getter(Ec2InstanceAggregation::sortOrderAsString)).setter(Ec2InstanceAggregation.setter(Builder::sortOrder)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sortOrder").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AMIS_FIELD, INSTANCE_IDS_FIELD, INSTANCE_TAGS_FIELD, OPERATING_SYSTEMS_FIELD, SORT_BY_FIELD, SORT_ORDER_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Ec2InstanceAggregation.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<StringFilter> amis;
    private final List<StringFilter> instanceIds;
    private final List<MapFilter> instanceTags;
    private final List<StringFilter> operatingSystems;
    private final String sortBy;
    private final String sortOrder;

    private Ec2InstanceAggregation(BuilderImpl builder) {
        this.amis = builder.amis;
        this.instanceIds = builder.instanceIds;
        this.instanceTags = builder.instanceTags;
        this.operatingSystems = builder.operatingSystems;
        this.sortBy = builder.sortBy;
        this.sortOrder = builder.sortOrder;
    }

    public final boolean hasAmis() {
        return this.amis != null && !(this.amis instanceof SdkAutoConstructList);
    }

    public final List<StringFilter> amis() {
        return this.amis;
    }

    public final boolean hasInstanceIds() {
        return this.instanceIds != null && !(this.instanceIds instanceof SdkAutoConstructList);
    }

    public final List<StringFilter> instanceIds() {
        return this.instanceIds;
    }

    public final boolean hasInstanceTags() {
        return this.instanceTags != null && !(this.instanceTags instanceof SdkAutoConstructList);
    }

    public final List<MapFilter> instanceTags() {
        return this.instanceTags;
    }

    public final boolean hasOperatingSystems() {
        return this.operatingSystems != null && !(this.operatingSystems instanceof SdkAutoConstructList);
    }

    public final List<StringFilter> operatingSystems() {
        return this.operatingSystems;
    }

    public final Ec2InstanceSortBy sortBy() {
        return Ec2InstanceSortBy.fromValue(this.sortBy);
    }

    public final String sortByAsString() {
        return this.sortBy;
    }

    public final SortOrder sortOrder() {
        return SortOrder.fromValue(this.sortOrder);
    }

    public final String sortOrderAsString() {
        return this.sortOrder;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAmis() ? this.amis() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasInstanceIds() ? this.instanceIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasInstanceTags() ? this.instanceTags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasOperatingSystems() ? this.operatingSystems() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.sortByAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.sortOrderAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Ec2InstanceAggregation)) {
            return false;
        }
        Ec2InstanceAggregation other = (Ec2InstanceAggregation)obj;
        return this.hasAmis() == other.hasAmis() && Objects.equals(this.amis(), other.amis()) && this.hasInstanceIds() == other.hasInstanceIds() && Objects.equals(this.instanceIds(), other.instanceIds()) && this.hasInstanceTags() == other.hasInstanceTags() && Objects.equals(this.instanceTags(), other.instanceTags()) && this.hasOperatingSystems() == other.hasOperatingSystems() && Objects.equals(this.operatingSystems(), other.operatingSystems()) && Objects.equals(this.sortByAsString(), other.sortByAsString()) && Objects.equals(this.sortOrderAsString(), other.sortOrderAsString());
    }

    public final String toString() {
        return ToString.builder((String)"Ec2InstanceAggregation").add("Amis", this.hasAmis() ? this.amis() : null).add("InstanceIds", this.hasInstanceIds() ? this.instanceIds() : null).add("InstanceTags", this.hasInstanceTags() ? this.instanceTags() : null).add("OperatingSystems", this.hasOperatingSystems() ? this.operatingSystems() : null).add("SortBy", (Object)this.sortByAsString()).add("SortOrder", (Object)this.sortOrderAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "amis": {
                return Optional.ofNullable(clazz.cast(this.amis()));
            }
            case "instanceIds": {
                return Optional.ofNullable(clazz.cast(this.instanceIds()));
            }
            case "instanceTags": {
                return Optional.ofNullable(clazz.cast(this.instanceTags()));
            }
            case "operatingSystems": {
                return Optional.ofNullable(clazz.cast(this.operatingSystems()));
            }
            case "sortBy": {
                return Optional.ofNullable(clazz.cast(this.sortByAsString()));
            }
            case "sortOrder": {
                return Optional.ofNullable(clazz.cast(this.sortOrderAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("amis", AMIS_FIELD);
        map.put("instanceIds", INSTANCE_IDS_FIELD);
        map.put("instanceTags", INSTANCE_TAGS_FIELD);
        map.put("operatingSystems", OPERATING_SYSTEMS_FIELD);
        map.put("sortBy", SORT_BY_FIELD);
        map.put("sortOrder", SORT_ORDER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Ec2InstanceAggregation, T> g) {
        return obj -> g.apply((Ec2InstanceAggregation)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<StringFilter> amis = DefaultSdkAutoConstructList.getInstance();
        private List<StringFilter> instanceIds = DefaultSdkAutoConstructList.getInstance();
        private List<MapFilter> instanceTags = DefaultSdkAutoConstructList.getInstance();
        private List<StringFilter> operatingSystems = DefaultSdkAutoConstructList.getInstance();
        private String sortBy;
        private String sortOrder;

        private BuilderImpl() {
        }

        private BuilderImpl(Ec2InstanceAggregation model) {
            this.amis(model.amis);
            this.instanceIds(model.instanceIds);
            this.instanceTags(model.instanceTags);
            this.operatingSystems(model.operatingSystems);
            this.sortBy(model.sortBy);
            this.sortOrder(model.sortOrder);
        }

        public final List<StringFilter.Builder> getAmis() {
            List<StringFilter.Builder> result = StringFilterListCopier.copyToBuilder(this.amis);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAmis(Collection<StringFilter.BuilderImpl> amis) {
            this.amis = StringFilterListCopier.copyFromBuilder(amis);
        }

        @Override
        public final Builder amis(Collection<StringFilter> amis) {
            this.amis = StringFilterListCopier.copy(amis);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder amis(StringFilter ... amis) {
            this.amis(Arrays.asList(amis));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder amis(Consumer<StringFilter.Builder> ... amis) {
            this.amis(Stream.of(amis).map(c -> (StringFilter)((StringFilter.Builder)StringFilter.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<StringFilter.Builder> getInstanceIds() {
            List<StringFilter.Builder> result = StringFilterListCopier.copyToBuilder(this.instanceIds);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setInstanceIds(Collection<StringFilter.BuilderImpl> instanceIds) {
            this.instanceIds = StringFilterListCopier.copyFromBuilder(instanceIds);
        }

        @Override
        public final Builder instanceIds(Collection<StringFilter> instanceIds) {
            this.instanceIds = StringFilterListCopier.copy(instanceIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceIds(StringFilter ... instanceIds) {
            this.instanceIds(Arrays.asList(instanceIds));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceIds(Consumer<StringFilter.Builder> ... instanceIds) {
            this.instanceIds(Stream.of(instanceIds).map(c -> (StringFilter)((StringFilter.Builder)StringFilter.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<MapFilter.Builder> getInstanceTags() {
            List<MapFilter.Builder> result = MapFilterListCopier.copyToBuilder(this.instanceTags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setInstanceTags(Collection<MapFilter.BuilderImpl> instanceTags) {
            this.instanceTags = MapFilterListCopier.copyFromBuilder(instanceTags);
        }

        @Override
        public final Builder instanceTags(Collection<MapFilter> instanceTags) {
            this.instanceTags = MapFilterListCopier.copy(instanceTags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceTags(MapFilter ... instanceTags) {
            this.instanceTags(Arrays.asList(instanceTags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceTags(Consumer<MapFilter.Builder> ... instanceTags) {
            this.instanceTags(Stream.of(instanceTags).map(c -> (MapFilter)((MapFilter.Builder)MapFilter.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<StringFilter.Builder> getOperatingSystems() {
            List<StringFilter.Builder> result = StringFilterListCopier.copyToBuilder(this.operatingSystems);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setOperatingSystems(Collection<StringFilter.BuilderImpl> operatingSystems) {
            this.operatingSystems = StringFilterListCopier.copyFromBuilder(operatingSystems);
        }

        @Override
        public final Builder operatingSystems(Collection<StringFilter> operatingSystems) {
            this.operatingSystems = StringFilterListCopier.copy(operatingSystems);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder operatingSystems(StringFilter ... operatingSystems) {
            this.operatingSystems(Arrays.asList(operatingSystems));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder operatingSystems(Consumer<StringFilter.Builder> ... operatingSystems) {
            this.operatingSystems(Stream.of(operatingSystems).map(c -> (StringFilter)((StringFilter.Builder)StringFilter.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getSortBy() {
            return this.sortBy;
        }

        public final void setSortBy(String sortBy) {
            this.sortBy = sortBy;
        }

        @Override
        public final Builder sortBy(String sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        @Override
        public final Builder sortBy(Ec2InstanceSortBy sortBy) {
            this.sortBy(sortBy == null ? null : sortBy.toString());
            return this;
        }

        public final String getSortOrder() {
            return this.sortOrder;
        }

        public final void setSortOrder(String sortOrder) {
            this.sortOrder = sortOrder;
        }

        @Override
        public final Builder sortOrder(String sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        @Override
        public final Builder sortOrder(SortOrder sortOrder) {
            this.sortOrder(sortOrder == null ? null : sortOrder.toString());
            return this;
        }

        public Ec2InstanceAggregation build() {
            return new Ec2InstanceAggregation(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Ec2InstanceAggregation> {
        public Builder amis(Collection<StringFilter> var1);

        public Builder amis(StringFilter ... var1);

        public Builder amis(Consumer<StringFilter.Builder> ... var1);

        public Builder instanceIds(Collection<StringFilter> var1);

        public Builder instanceIds(StringFilter ... var1);

        public Builder instanceIds(Consumer<StringFilter.Builder> ... var1);

        public Builder instanceTags(Collection<MapFilter> var1);

        public Builder instanceTags(MapFilter ... var1);

        public Builder instanceTags(Consumer<MapFilter.Builder> ... var1);

        public Builder operatingSystems(Collection<StringFilter> var1);

        public Builder operatingSystems(StringFilter ... var1);

        public Builder operatingSystems(Consumer<StringFilter.Builder> ... var1);

        public Builder sortBy(String var1);

        public Builder sortBy(Ec2InstanceSortBy var1);

        public Builder sortOrder(String var1);

        public Builder sortOrder(SortOrder var1);
    }
}

