/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.inspector2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.inspector2.model.FindingDetail;
import software.amazon.awssdk.services.inspector2.model.FindingDetailsCopier;
import software.amazon.awssdk.services.inspector2.model.FindingDetailsError;
import software.amazon.awssdk.services.inspector2.model.FindingDetailsErrorListCopier;
import software.amazon.awssdk.services.inspector2.model.Inspector2Response;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchGetFindingDetailsResponse
extends Inspector2Response
implements ToCopyableBuilder<Builder, BatchGetFindingDetailsResponse> {
    private static final SdkField<List<FindingDetailsError>> ERRORS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("errors").getter(BatchGetFindingDetailsResponse.getter(BatchGetFindingDetailsResponse::errors)).setter(BatchGetFindingDetailsResponse.setter(Builder::errors)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errors").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(FindingDetailsError::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<FindingDetail>> FINDING_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("findingDetails").getter(BatchGetFindingDetailsResponse.getter(BatchGetFindingDetailsResponse::findingDetails)).setter(BatchGetFindingDetailsResponse.setter(Builder::findingDetails)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("findingDetails").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(FindingDetail::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ERRORS_FIELD, FINDING_DETAILS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = BatchGetFindingDetailsResponse.memberNameToFieldInitializer();
    private final List<FindingDetailsError> errors;
    private final List<FindingDetail> findingDetails;

    private BatchGetFindingDetailsResponse(BuilderImpl builder) {
        super(builder);
        this.errors = builder.errors;
        this.findingDetails = builder.findingDetails;
    }

    public final boolean hasErrors() {
        return this.errors != null && !(this.errors instanceof SdkAutoConstructList);
    }

    public final List<FindingDetailsError> errors() {
        return this.errors;
    }

    public final boolean hasFindingDetails() {
        return this.findingDetails != null && !(this.findingDetails instanceof SdkAutoConstructList);
    }

    public final List<FindingDetail> findingDetails() {
        return this.findingDetails;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasErrors() ? this.errors() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFindingDetails() ? this.findingDetails() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchGetFindingDetailsResponse)) {
            return false;
        }
        BatchGetFindingDetailsResponse other = (BatchGetFindingDetailsResponse)((Object)obj);
        return this.hasErrors() == other.hasErrors() && Objects.equals(this.errors(), other.errors()) && this.hasFindingDetails() == other.hasFindingDetails() && Objects.equals(this.findingDetails(), other.findingDetails());
    }

    public final String toString() {
        return ToString.builder((String)"BatchGetFindingDetailsResponse").add("Errors", this.hasErrors() ? this.errors() : null).add("FindingDetails", this.hasFindingDetails() ? this.findingDetails() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "errors": {
                return Optional.ofNullable(clazz.cast(this.errors()));
            }
            case "findingDetails": {
                return Optional.ofNullable(clazz.cast(this.findingDetails()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("errors", ERRORS_FIELD);
        map.put("findingDetails", FINDING_DETAILS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BatchGetFindingDetailsResponse, T> g) {
        return obj -> g.apply((BatchGetFindingDetailsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Inspector2Response.BuilderImpl
    implements Builder {
        private List<FindingDetailsError> errors = DefaultSdkAutoConstructList.getInstance();
        private List<FindingDetail> findingDetails = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchGetFindingDetailsResponse model) {
            super(model);
            this.errors(model.errors);
            this.findingDetails(model.findingDetails);
        }

        public final List<FindingDetailsError.Builder> getErrors() {
            List<FindingDetailsError.Builder> result = FindingDetailsErrorListCopier.copyToBuilder(this.errors);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setErrors(Collection<FindingDetailsError.BuilderImpl> errors) {
            this.errors = FindingDetailsErrorListCopier.copyFromBuilder(errors);
        }

        @Override
        public final Builder errors(Collection<FindingDetailsError> errors) {
            this.errors = FindingDetailsErrorListCopier.copy(errors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errors(FindingDetailsError ... errors) {
            this.errors(Arrays.asList(errors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errors(Consumer<FindingDetailsError.Builder> ... errors) {
            this.errors(Stream.of(errors).map(c -> (FindingDetailsError)((FindingDetailsError.Builder)FindingDetailsError.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<FindingDetail.Builder> getFindingDetails() {
            List<FindingDetail.Builder> result = FindingDetailsCopier.copyToBuilder(this.findingDetails);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFindingDetails(Collection<FindingDetail.BuilderImpl> findingDetails) {
            this.findingDetails = FindingDetailsCopier.copyFromBuilder(findingDetails);
        }

        @Override
        public final Builder findingDetails(Collection<FindingDetail> findingDetails) {
            this.findingDetails = FindingDetailsCopier.copy(findingDetails);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder findingDetails(FindingDetail ... findingDetails) {
            this.findingDetails(Arrays.asList(findingDetails));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder findingDetails(Consumer<FindingDetail.Builder> ... findingDetails) {
            this.findingDetails(Stream.of(findingDetails).map(c -> (FindingDetail)((FindingDetail.Builder)FindingDetail.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public BatchGetFindingDetailsResponse build() {
            return new BatchGetFindingDetailsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends Inspector2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, BatchGetFindingDetailsResponse> {
        public Builder errors(Collection<FindingDetailsError> var1);

        public Builder errors(FindingDetailsError ... var1);

        public Builder errors(Consumer<FindingDetailsError.Builder> ... var1);

        public Builder findingDetails(Collection<FindingDetail> var1);

        public Builder findingDetails(FindingDetail ... var1);

        public Builder findingDetails(Consumer<FindingDetail.Builder> ... var1);
    }
}

