/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.inspector2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.inspector2.model.ClusterDetails;
import software.amazon.awssdk.services.inspector2.model.ClusterInformationClusterDetailsListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ClusterInformation
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ClusterInformation> {
    private static final SdkField<String> CLUSTER_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clusterArn").getter(ClusterInformation.getter(ClusterInformation::clusterArn)).setter(ClusterInformation.setter(Builder::clusterArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clusterArn").build()}).build();
    private static final SdkField<List<ClusterDetails>> CLUSTER_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("clusterDetails").getter(ClusterInformation.getter(ClusterInformation::clusterDetails)).setter(ClusterInformation.setter(Builder::clusterDetails)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clusterDetails").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ClusterDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLUSTER_ARN_FIELD, CLUSTER_DETAILS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ClusterInformation.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String clusterArn;
    private final List<ClusterDetails> clusterDetails;

    private ClusterInformation(BuilderImpl builder) {
        this.clusterArn = builder.clusterArn;
        this.clusterDetails = builder.clusterDetails;
    }

    public final String clusterArn() {
        return this.clusterArn;
    }

    public final boolean hasClusterDetails() {
        return this.clusterDetails != null && !(this.clusterDetails instanceof SdkAutoConstructList);
    }

    public final List<ClusterDetails> clusterDetails() {
        return this.clusterDetails;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.clusterArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasClusterDetails() ? this.clusterDetails() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ClusterInformation)) {
            return false;
        }
        ClusterInformation other = (ClusterInformation)obj;
        return Objects.equals(this.clusterArn(), other.clusterArn()) && this.hasClusterDetails() == other.hasClusterDetails() && Objects.equals(this.clusterDetails(), other.clusterDetails());
    }

    public final String toString() {
        return ToString.builder((String)"ClusterInformation").add("ClusterArn", (Object)this.clusterArn()).add("ClusterDetails", this.hasClusterDetails() ? this.clusterDetails() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "clusterArn": {
                return Optional.ofNullable(clazz.cast(this.clusterArn()));
            }
            case "clusterDetails": {
                return Optional.ofNullable(clazz.cast(this.clusterDetails()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("clusterArn", CLUSTER_ARN_FIELD);
        map.put("clusterDetails", CLUSTER_DETAILS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ClusterInformation, T> g) {
        return obj -> g.apply((ClusterInformation)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String clusterArn;
        private List<ClusterDetails> clusterDetails = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ClusterInformation model) {
            this.clusterArn(model.clusterArn);
            this.clusterDetails(model.clusterDetails);
        }

        public final String getClusterArn() {
            return this.clusterArn;
        }

        public final void setClusterArn(String clusterArn) {
            this.clusterArn = clusterArn;
        }

        @Override
        public final Builder clusterArn(String clusterArn) {
            this.clusterArn = clusterArn;
            return this;
        }

        public final List<ClusterDetails.Builder> getClusterDetails() {
            List<ClusterDetails.Builder> result = ClusterInformationClusterDetailsListCopier.copyToBuilder(this.clusterDetails);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setClusterDetails(Collection<ClusterDetails.BuilderImpl> clusterDetails) {
            this.clusterDetails = ClusterInformationClusterDetailsListCopier.copyFromBuilder(clusterDetails);
        }

        @Override
        public final Builder clusterDetails(Collection<ClusterDetails> clusterDetails) {
            this.clusterDetails = ClusterInformationClusterDetailsListCopier.copy(clusterDetails);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder clusterDetails(ClusterDetails ... clusterDetails) {
            this.clusterDetails(Arrays.asList(clusterDetails));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder clusterDetails(Consumer<ClusterDetails.Builder> ... clusterDetails) {
            this.clusterDetails(Stream.of(clusterDetails).map(c -> (ClusterDetails)((ClusterDetails.Builder)ClusterDetails.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public ClusterInformation build() {
            return new ClusterInformation(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ClusterInformation> {
        public Builder clusterArn(String var1);

        public Builder clusterDetails(Collection<ClusterDetails> var1);

        public Builder clusterDetails(ClusterDetails ... var1);

        public Builder clusterDetails(Consumer<ClusterDetails.Builder> ... var1);
    }
}

