/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.inspector2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.inspector2.model.LambdaFunctionSortBy;
import software.amazon.awssdk.services.inspector2.model.MapFilter;
import software.amazon.awssdk.services.inspector2.model.MapFilterListCopier;
import software.amazon.awssdk.services.inspector2.model.SortOrder;
import software.amazon.awssdk.services.inspector2.model.StringFilter;
import software.amazon.awssdk.services.inspector2.model.StringFilterListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class LambdaFunctionAggregation
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, LambdaFunctionAggregation> {
    private static final SdkField<List<StringFilter>> FUNCTION_NAMES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("functionNames").getter(LambdaFunctionAggregation.getter(LambdaFunctionAggregation::functionNames)).setter(LambdaFunctionAggregation.setter(Builder::functionNames)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("functionNames").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(StringFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<MapFilter>> FUNCTION_TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("functionTags").getter(LambdaFunctionAggregation.getter(LambdaFunctionAggregation::functionTags)).setter(LambdaFunctionAggregation.setter(Builder::functionTags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("functionTags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(MapFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<StringFilter>> RESOURCE_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("resourceIds").getter(LambdaFunctionAggregation.getter(LambdaFunctionAggregation::resourceIds)).setter(LambdaFunctionAggregation.setter(Builder::resourceIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(StringFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<StringFilter>> RUNTIMES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("runtimes").getter(LambdaFunctionAggregation.getter(LambdaFunctionAggregation::runtimes)).setter(LambdaFunctionAggregation.setter(Builder::runtimes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("runtimes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(StringFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> SORT_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sortBy").getter(LambdaFunctionAggregation.getter(LambdaFunctionAggregation::sortByAsString)).setter(LambdaFunctionAggregation.setter(Builder::sortBy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sortBy").build()}).build();
    private static final SdkField<String> SORT_ORDER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sortOrder").getter(LambdaFunctionAggregation.getter(LambdaFunctionAggregation::sortOrderAsString)).setter(LambdaFunctionAggregation.setter(Builder::sortOrder)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sortOrder").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FUNCTION_NAMES_FIELD, FUNCTION_TAGS_FIELD, RESOURCE_IDS_FIELD, RUNTIMES_FIELD, SORT_BY_FIELD, SORT_ORDER_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = LambdaFunctionAggregation.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<StringFilter> functionNames;
    private final List<MapFilter> functionTags;
    private final List<StringFilter> resourceIds;
    private final List<StringFilter> runtimes;
    private final String sortBy;
    private final String sortOrder;

    private LambdaFunctionAggregation(BuilderImpl builder) {
        this.functionNames = builder.functionNames;
        this.functionTags = builder.functionTags;
        this.resourceIds = builder.resourceIds;
        this.runtimes = builder.runtimes;
        this.sortBy = builder.sortBy;
        this.sortOrder = builder.sortOrder;
    }

    public final boolean hasFunctionNames() {
        return this.functionNames != null && !(this.functionNames instanceof SdkAutoConstructList);
    }

    public final List<StringFilter> functionNames() {
        return this.functionNames;
    }

    public final boolean hasFunctionTags() {
        return this.functionTags != null && !(this.functionTags instanceof SdkAutoConstructList);
    }

    public final List<MapFilter> functionTags() {
        return this.functionTags;
    }

    public final boolean hasResourceIds() {
        return this.resourceIds != null && !(this.resourceIds instanceof SdkAutoConstructList);
    }

    public final List<StringFilter> resourceIds() {
        return this.resourceIds;
    }

    public final boolean hasRuntimes() {
        return this.runtimes != null && !(this.runtimes instanceof SdkAutoConstructList);
    }

    public final List<StringFilter> runtimes() {
        return this.runtimes;
    }

    public final LambdaFunctionSortBy sortBy() {
        return LambdaFunctionSortBy.fromValue(this.sortBy);
    }

    public final String sortByAsString() {
        return this.sortBy;
    }

    public final SortOrder sortOrder() {
        return SortOrder.fromValue(this.sortOrder);
    }

    public final String sortOrderAsString() {
        return this.sortOrder;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFunctionNames() ? this.functionNames() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFunctionTags() ? this.functionTags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasResourceIds() ? this.resourceIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRuntimes() ? this.runtimes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.sortByAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.sortOrderAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LambdaFunctionAggregation)) {
            return false;
        }
        LambdaFunctionAggregation other = (LambdaFunctionAggregation)obj;
        return this.hasFunctionNames() == other.hasFunctionNames() && Objects.equals(this.functionNames(), other.functionNames()) && this.hasFunctionTags() == other.hasFunctionTags() && Objects.equals(this.functionTags(), other.functionTags()) && this.hasResourceIds() == other.hasResourceIds() && Objects.equals(this.resourceIds(), other.resourceIds()) && this.hasRuntimes() == other.hasRuntimes() && Objects.equals(this.runtimes(), other.runtimes()) && Objects.equals(this.sortByAsString(), other.sortByAsString()) && Objects.equals(this.sortOrderAsString(), other.sortOrderAsString());
    }

    public final String toString() {
        return ToString.builder((String)"LambdaFunctionAggregation").add("FunctionNames", this.hasFunctionNames() ? this.functionNames() : null).add("FunctionTags", this.hasFunctionTags() ? this.functionTags() : null).add("ResourceIds", this.hasResourceIds() ? this.resourceIds() : null).add("Runtimes", this.hasRuntimes() ? this.runtimes() : null).add("SortBy", (Object)this.sortByAsString()).add("SortOrder", (Object)this.sortOrderAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "functionNames": {
                return Optional.ofNullable(clazz.cast(this.functionNames()));
            }
            case "functionTags": {
                return Optional.ofNullable(clazz.cast(this.functionTags()));
            }
            case "resourceIds": {
                return Optional.ofNullable(clazz.cast(this.resourceIds()));
            }
            case "runtimes": {
                return Optional.ofNullable(clazz.cast(this.runtimes()));
            }
            case "sortBy": {
                return Optional.ofNullable(clazz.cast(this.sortByAsString()));
            }
            case "sortOrder": {
                return Optional.ofNullable(clazz.cast(this.sortOrderAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("functionNames", FUNCTION_NAMES_FIELD);
        map.put("functionTags", FUNCTION_TAGS_FIELD);
        map.put("resourceIds", RESOURCE_IDS_FIELD);
        map.put("runtimes", RUNTIMES_FIELD);
        map.put("sortBy", SORT_BY_FIELD);
        map.put("sortOrder", SORT_ORDER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<LambdaFunctionAggregation, T> g) {
        return obj -> g.apply((LambdaFunctionAggregation)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<StringFilter> functionNames = DefaultSdkAutoConstructList.getInstance();
        private List<MapFilter> functionTags = DefaultSdkAutoConstructList.getInstance();
        private List<StringFilter> resourceIds = DefaultSdkAutoConstructList.getInstance();
        private List<StringFilter> runtimes = DefaultSdkAutoConstructList.getInstance();
        private String sortBy;
        private String sortOrder;

        private BuilderImpl() {
        }

        private BuilderImpl(LambdaFunctionAggregation model) {
            this.functionNames(model.functionNames);
            this.functionTags(model.functionTags);
            this.resourceIds(model.resourceIds);
            this.runtimes(model.runtimes);
            this.sortBy(model.sortBy);
            this.sortOrder(model.sortOrder);
        }

        public final List<StringFilter.Builder> getFunctionNames() {
            List<StringFilter.Builder> result = StringFilterListCopier.copyToBuilder(this.functionNames);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFunctionNames(Collection<StringFilter.BuilderImpl> functionNames) {
            this.functionNames = StringFilterListCopier.copyFromBuilder(functionNames);
        }

        @Override
        public final Builder functionNames(Collection<StringFilter> functionNames) {
            this.functionNames = StringFilterListCopier.copy(functionNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder functionNames(StringFilter ... functionNames) {
            this.functionNames(Arrays.asList(functionNames));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder functionNames(Consumer<StringFilter.Builder> ... functionNames) {
            this.functionNames(Stream.of(functionNames).map(c -> (StringFilter)((StringFilter.Builder)StringFilter.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<MapFilter.Builder> getFunctionTags() {
            List<MapFilter.Builder> result = MapFilterListCopier.copyToBuilder(this.functionTags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFunctionTags(Collection<MapFilter.BuilderImpl> functionTags) {
            this.functionTags = MapFilterListCopier.copyFromBuilder(functionTags);
        }

        @Override
        public final Builder functionTags(Collection<MapFilter> functionTags) {
            this.functionTags = MapFilterListCopier.copy(functionTags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder functionTags(MapFilter ... functionTags) {
            this.functionTags(Arrays.asList(functionTags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder functionTags(Consumer<MapFilter.Builder> ... functionTags) {
            this.functionTags(Stream.of(functionTags).map(c -> (MapFilter)((MapFilter.Builder)MapFilter.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<StringFilter.Builder> getResourceIds() {
            List<StringFilter.Builder> result = StringFilterListCopier.copyToBuilder(this.resourceIds);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setResourceIds(Collection<StringFilter.BuilderImpl> resourceIds) {
            this.resourceIds = StringFilterListCopier.copyFromBuilder(resourceIds);
        }

        @Override
        public final Builder resourceIds(Collection<StringFilter> resourceIds) {
            this.resourceIds = StringFilterListCopier.copy(resourceIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceIds(StringFilter ... resourceIds) {
            this.resourceIds(Arrays.asList(resourceIds));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceIds(Consumer<StringFilter.Builder> ... resourceIds) {
            this.resourceIds(Stream.of(resourceIds).map(c -> (StringFilter)((StringFilter.Builder)StringFilter.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<StringFilter.Builder> getRuntimes() {
            List<StringFilter.Builder> result = StringFilterListCopier.copyToBuilder(this.runtimes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRuntimes(Collection<StringFilter.BuilderImpl> runtimes) {
            this.runtimes = StringFilterListCopier.copyFromBuilder(runtimes);
        }

        @Override
        public final Builder runtimes(Collection<StringFilter> runtimes) {
            this.runtimes = StringFilterListCopier.copy(runtimes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder runtimes(StringFilter ... runtimes) {
            this.runtimes(Arrays.asList(runtimes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder runtimes(Consumer<StringFilter.Builder> ... runtimes) {
            this.runtimes(Stream.of(runtimes).map(c -> (StringFilter)((StringFilter.Builder)StringFilter.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getSortBy() {
            return this.sortBy;
        }

        public final void setSortBy(String sortBy) {
            this.sortBy = sortBy;
        }

        @Override
        public final Builder sortBy(String sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        @Override
        public final Builder sortBy(LambdaFunctionSortBy sortBy) {
            this.sortBy(sortBy == null ? null : sortBy.toString());
            return this;
        }

        public final String getSortOrder() {
            return this.sortOrder;
        }

        public final void setSortOrder(String sortOrder) {
            this.sortOrder = sortOrder;
        }

        @Override
        public final Builder sortOrder(String sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        @Override
        public final Builder sortOrder(SortOrder sortOrder) {
            this.sortOrder(sortOrder == null ? null : sortOrder.toString());
            return this;
        }

        public LambdaFunctionAggregation build() {
            return new LambdaFunctionAggregation(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, LambdaFunctionAggregation> {
        public Builder functionNames(Collection<StringFilter> var1);

        public Builder functionNames(StringFilter ... var1);

        public Builder functionNames(Consumer<StringFilter.Builder> ... var1);

        public Builder functionTags(Collection<MapFilter> var1);

        public Builder functionTags(MapFilter ... var1);

        public Builder functionTags(Consumer<MapFilter.Builder> ... var1);

        public Builder resourceIds(Collection<StringFilter> var1);

        public Builder resourceIds(StringFilter ... var1);

        public Builder resourceIds(Consumer<StringFilter.Builder> ... var1);

        public Builder runtimes(Collection<StringFilter> var1);

        public Builder runtimes(StringFilter ... var1);

        public Builder runtimes(Consumer<StringFilter.Builder> ... var1);

        public Builder sortBy(String var1);

        public Builder sortBy(LambdaFunctionSortBy var1);

        public Builder sortOrder(String var1);

        public Builder sortOrder(SortOrder var1);
    }
}

