/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.inspector2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.inspector2.model.Status;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ResourceStatus
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ResourceStatus> {
    private static final SdkField<String> EC2_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ec2").getter(ResourceStatus.getter(ResourceStatus::ec2AsString)).setter(ResourceStatus.setter(Builder::ec2)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ec2").build()}).build();
    private static final SdkField<String> ECR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ecr").getter(ResourceStatus.getter(ResourceStatus::ecrAsString)).setter(ResourceStatus.setter(Builder::ecr)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ecr").build()}).build();
    private static final SdkField<String> LAMBDA_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("lambda").getter(ResourceStatus.getter(ResourceStatus::lambdaAsString)).setter(ResourceStatus.setter(Builder::lambda)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lambda").build()}).build();
    private static final SdkField<String> LAMBDA_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("lambdaCode").getter(ResourceStatus.getter(ResourceStatus::lambdaCodeAsString)).setter(ResourceStatus.setter(Builder::lambdaCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lambdaCode").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EC2_FIELD, ECR_FIELD, LAMBDA_FIELD, LAMBDA_CODE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ResourceStatus.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String ec2;
    private final String ecr;
    private final String lambda;
    private final String lambdaCode;

    private ResourceStatus(BuilderImpl builder) {
        this.ec2 = builder.ec2;
        this.ecr = builder.ecr;
        this.lambda = builder.lambda;
        this.lambdaCode = builder.lambdaCode;
    }

    public final Status ec2() {
        return Status.fromValue(this.ec2);
    }

    public final String ec2AsString() {
        return this.ec2;
    }

    public final Status ecr() {
        return Status.fromValue(this.ecr);
    }

    public final String ecrAsString() {
        return this.ecr;
    }

    public final Status lambda() {
        return Status.fromValue(this.lambda);
    }

    public final String lambdaAsString() {
        return this.lambda;
    }

    public final Status lambdaCode() {
        return Status.fromValue(this.lambdaCode);
    }

    public final String lambdaCodeAsString() {
        return this.lambdaCode;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.ec2AsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.ecrAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.lambdaAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.lambdaCodeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResourceStatus)) {
            return false;
        }
        ResourceStatus other = (ResourceStatus)obj;
        return Objects.equals(this.ec2AsString(), other.ec2AsString()) && Objects.equals(this.ecrAsString(), other.ecrAsString()) && Objects.equals(this.lambdaAsString(), other.lambdaAsString()) && Objects.equals(this.lambdaCodeAsString(), other.lambdaCodeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"ResourceStatus").add("Ec2", (Object)this.ec2AsString()).add("Ecr", (Object)this.ecrAsString()).add("Lambda", (Object)this.lambdaAsString()).add("LambdaCode", (Object)this.lambdaCodeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ec2": {
                return Optional.ofNullable(clazz.cast(this.ec2AsString()));
            }
            case "ecr": {
                return Optional.ofNullable(clazz.cast(this.ecrAsString()));
            }
            case "lambda": {
                return Optional.ofNullable(clazz.cast(this.lambdaAsString()));
            }
            case "lambdaCode": {
                return Optional.ofNullable(clazz.cast(this.lambdaCodeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("ec2", EC2_FIELD);
        map.put("ecr", ECR_FIELD);
        map.put("lambda", LAMBDA_FIELD);
        map.put("lambdaCode", LAMBDA_CODE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ResourceStatus, T> g) {
        return obj -> g.apply((ResourceStatus)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String ec2;
        private String ecr;
        private String lambda;
        private String lambdaCode;

        private BuilderImpl() {
        }

        private BuilderImpl(ResourceStatus model) {
            this.ec2(model.ec2);
            this.ecr(model.ecr);
            this.lambda(model.lambda);
            this.lambdaCode(model.lambdaCode);
        }

        public final String getEc2() {
            return this.ec2;
        }

        public final void setEc2(String ec2) {
            this.ec2 = ec2;
        }

        @Override
        public final Builder ec2(String ec2) {
            this.ec2 = ec2;
            return this;
        }

        @Override
        public final Builder ec2(Status ec2) {
            this.ec2(ec2 == null ? null : ec2.toString());
            return this;
        }

        public final String getEcr() {
            return this.ecr;
        }

        public final void setEcr(String ecr) {
            this.ecr = ecr;
        }

        @Override
        public final Builder ecr(String ecr) {
            this.ecr = ecr;
            return this;
        }

        @Override
        public final Builder ecr(Status ecr) {
            this.ecr(ecr == null ? null : ecr.toString());
            return this;
        }

        public final String getLambda() {
            return this.lambda;
        }

        public final void setLambda(String lambda) {
            this.lambda = lambda;
        }

        @Override
        public final Builder lambda(String lambda) {
            this.lambda = lambda;
            return this;
        }

        @Override
        public final Builder lambda(Status lambda) {
            this.lambda(lambda == null ? null : lambda.toString());
            return this;
        }

        public final String getLambdaCode() {
            return this.lambdaCode;
        }

        public final void setLambdaCode(String lambdaCode) {
            this.lambdaCode = lambdaCode;
        }

        @Override
        public final Builder lambdaCode(String lambdaCode) {
            this.lambdaCode = lambdaCode;
            return this;
        }

        @Override
        public final Builder lambdaCode(Status lambdaCode) {
            this.lambdaCode(lambdaCode == null ? null : lambdaCode.toString());
            return this;
        }

        public ResourceStatus build() {
            return new ResourceStatus(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ResourceStatus> {
        public Builder ec2(String var1);

        public Builder ec2(Status var1);

        public Builder ecr(String var1);

        public Builder ecr(Status var1);

        public Builder lambda(String var1);

        public Builder lambda(Status var1);

        public Builder lambdaCode(String var1);

        public Builder lambdaCode(Status var1);
    }
}

