/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.inspector2.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ScanStatusReason {
    PENDING_INITIAL_SCAN("PENDING_INITIAL_SCAN"),
    ACCESS_DENIED("ACCESS_DENIED"),
    INTERNAL_ERROR("INTERNAL_ERROR"),
    UNMANAGED_EC2_INSTANCE("UNMANAGED_EC2_INSTANCE"),
    UNSUPPORTED_OS("UNSUPPORTED_OS"),
    SCAN_ELIGIBILITY_EXPIRED("SCAN_ELIGIBILITY_EXPIRED"),
    RESOURCE_TERMINATED("RESOURCE_TERMINATED"),
    SUCCESSFUL("SUCCESSFUL"),
    NO_RESOURCES_FOUND("NO_RESOURCES_FOUND"),
    IMAGE_SIZE_EXCEEDED("IMAGE_SIZE_EXCEEDED"),
    SCAN_FREQUENCY_MANUAL("SCAN_FREQUENCY_MANUAL"),
    SCAN_FREQUENCY_SCAN_ON_PUSH("SCAN_FREQUENCY_SCAN_ON_PUSH"),
    EC2_INSTANCE_STOPPED("EC2_INSTANCE_STOPPED"),
    PENDING_DISABLE("PENDING_DISABLE"),
    NO_INVENTORY("NO_INVENTORY"),
    STALE_INVENTORY("STALE_INVENTORY"),
    EXCLUDED_BY_TAG("EXCLUDED_BY_TAG"),
    UNSUPPORTED_RUNTIME("UNSUPPORTED_RUNTIME"),
    UNSUPPORTED_MEDIA_TYPE("UNSUPPORTED_MEDIA_TYPE"),
    UNSUPPORTED_CONFIG_FILE("UNSUPPORTED_CONFIG_FILE"),
    DEEP_INSPECTION_PACKAGE_COLLECTION_LIMIT_EXCEEDED("DEEP_INSPECTION_PACKAGE_COLLECTION_LIMIT_EXCEEDED"),
    DEEP_INSPECTION_DAILY_SSM_INVENTORY_LIMIT_EXCEEDED("DEEP_INSPECTION_DAILY_SSM_INVENTORY_LIMIT_EXCEEDED"),
    DEEP_INSPECTION_COLLECTION_TIME_LIMIT_EXCEEDED("DEEP_INSPECTION_COLLECTION_TIME_LIMIT_EXCEEDED"),
    DEEP_INSPECTION_NO_INVENTORY("DEEP_INSPECTION_NO_INVENTORY"),
    AGENTLESS_INSTANCE_STORAGE_LIMIT_EXCEEDED("AGENTLESS_INSTANCE_STORAGE_LIMIT_EXCEEDED"),
    AGENTLESS_INSTANCE_COLLECTION_TIME_LIMIT_EXCEEDED("AGENTLESS_INSTANCE_COLLECTION_TIME_LIMIT_EXCEEDED"),
    PENDING_REVIVAL_SCAN("PENDING_REVIVAL_SCAN"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ScanStatusReason> VALUE_MAP;
    private final String value;

    private ScanStatusReason(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ScanStatusReason fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ScanStatusReason> knownValues() {
        EnumSet<ScanStatusReason> knownValues = EnumSet.allOf(ScanStatusReason.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ScanStatusReason.class, ScanStatusReason::toString);
    }
}

