/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.inspector2.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.inspector2.model.IpV4AddressListCopier;
import software.amazon.awssdk.services.inspector2.model.IpV6AddressListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AwsEc2InstanceDetails
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AwsEc2InstanceDetails> {
    private static final SdkField<String> IAM_INSTANCE_PROFILE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("iamInstanceProfileArn").getter(AwsEc2InstanceDetails.getter(AwsEc2InstanceDetails::iamInstanceProfileArn)).setter(AwsEc2InstanceDetails.setter(Builder::iamInstanceProfileArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("iamInstanceProfileArn").build()}).build();
    private static final SdkField<String> IMAGE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("imageId").getter(AwsEc2InstanceDetails.getter(AwsEc2InstanceDetails::imageId)).setter(AwsEc2InstanceDetails.setter(Builder::imageId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("imageId").build()}).build();
    private static final SdkField<List<String>> IP_V4_ADDRESSES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ipV4Addresses").getter(AwsEc2InstanceDetails.getter(AwsEc2InstanceDetails::ipV4Addresses)).setter(AwsEc2InstanceDetails.setter(Builder::ipV4Addresses)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ipV4Addresses").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> IP_V6_ADDRESSES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ipV6Addresses").getter(AwsEc2InstanceDetails.getter(AwsEc2InstanceDetails::ipV6Addresses)).setter(AwsEc2InstanceDetails.setter(Builder::ipV6Addresses)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ipV6Addresses").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> KEY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("keyName").getter(AwsEc2InstanceDetails.getter(AwsEc2InstanceDetails::keyName)).setter(AwsEc2InstanceDetails.setter(Builder::keyName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("keyName").build()}).build();
    private static final SdkField<Instant> LAUNCHED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("launchedAt").getter(AwsEc2InstanceDetails.getter(AwsEc2InstanceDetails::launchedAt)).setter(AwsEc2InstanceDetails.setter(Builder::launchedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("launchedAt").build()}).build();
    private static final SdkField<String> PLATFORM_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("platform").getter(AwsEc2InstanceDetails.getter(AwsEc2InstanceDetails::platform)).setter(AwsEc2InstanceDetails.setter(Builder::platform)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("platform").build()}).build();
    private static final SdkField<String> SUBNET_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("subnetId").getter(AwsEc2InstanceDetails.getter(AwsEc2InstanceDetails::subnetId)).setter(AwsEc2InstanceDetails.setter(Builder::subnetId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("subnetId").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("type").getter(AwsEc2InstanceDetails.getter(AwsEc2InstanceDetails::type)).setter(AwsEc2InstanceDetails.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()}).build();
    private static final SdkField<String> VPC_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("vpcId").getter(AwsEc2InstanceDetails.getter(AwsEc2InstanceDetails::vpcId)).setter(AwsEc2InstanceDetails.setter(Builder::vpcId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vpcId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IAM_INSTANCE_PROFILE_ARN_FIELD, IMAGE_ID_FIELD, IP_V4_ADDRESSES_FIELD, IP_V6_ADDRESSES_FIELD, KEY_NAME_FIELD, LAUNCHED_AT_FIELD, PLATFORM_FIELD, SUBNET_ID_FIELD, TYPE_FIELD, VPC_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AwsEc2InstanceDetails.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String iamInstanceProfileArn;
    private final String imageId;
    private final List<String> ipV4Addresses;
    private final List<String> ipV6Addresses;
    private final String keyName;
    private final Instant launchedAt;
    private final String platform;
    private final String subnetId;
    private final String type;
    private final String vpcId;

    private AwsEc2InstanceDetails(BuilderImpl builder) {
        this.iamInstanceProfileArn = builder.iamInstanceProfileArn;
        this.imageId = builder.imageId;
        this.ipV4Addresses = builder.ipV4Addresses;
        this.ipV6Addresses = builder.ipV6Addresses;
        this.keyName = builder.keyName;
        this.launchedAt = builder.launchedAt;
        this.platform = builder.platform;
        this.subnetId = builder.subnetId;
        this.type = builder.type;
        this.vpcId = builder.vpcId;
    }

    public final String iamInstanceProfileArn() {
        return this.iamInstanceProfileArn;
    }

    public final String imageId() {
        return this.imageId;
    }

    public final boolean hasIpV4Addresses() {
        return this.ipV4Addresses != null && !(this.ipV4Addresses instanceof SdkAutoConstructList);
    }

    public final List<String> ipV4Addresses() {
        return this.ipV4Addresses;
    }

    public final boolean hasIpV6Addresses() {
        return this.ipV6Addresses != null && !(this.ipV6Addresses instanceof SdkAutoConstructList);
    }

    public final List<String> ipV6Addresses() {
        return this.ipV6Addresses;
    }

    public final String keyName() {
        return this.keyName;
    }

    public final Instant launchedAt() {
        return this.launchedAt;
    }

    public final String platform() {
        return this.platform;
    }

    public final String subnetId() {
        return this.subnetId;
    }

    public final String type() {
        return this.type;
    }

    public final String vpcId() {
        return this.vpcId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.iamInstanceProfileArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.imageId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasIpV4Addresses() ? this.ipV4Addresses() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasIpV6Addresses() ? this.ipV6Addresses() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.keyName());
        hashCode = 31 * hashCode + Objects.hashCode(this.launchedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.platform());
        hashCode = 31 * hashCode + Objects.hashCode(this.subnetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.type());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsEc2InstanceDetails)) {
            return false;
        }
        AwsEc2InstanceDetails other = (AwsEc2InstanceDetails)obj;
        return Objects.equals(this.iamInstanceProfileArn(), other.iamInstanceProfileArn()) && Objects.equals(this.imageId(), other.imageId()) && this.hasIpV4Addresses() == other.hasIpV4Addresses() && Objects.equals(this.ipV4Addresses(), other.ipV4Addresses()) && this.hasIpV6Addresses() == other.hasIpV6Addresses() && Objects.equals(this.ipV6Addresses(), other.ipV6Addresses()) && Objects.equals(this.keyName(), other.keyName()) && Objects.equals(this.launchedAt(), other.launchedAt()) && Objects.equals(this.platform(), other.platform()) && Objects.equals(this.subnetId(), other.subnetId()) && Objects.equals(this.type(), other.type()) && Objects.equals(this.vpcId(), other.vpcId());
    }

    public final String toString() {
        return ToString.builder((String)"AwsEc2InstanceDetails").add("IamInstanceProfileArn", (Object)this.iamInstanceProfileArn()).add("ImageId", (Object)this.imageId()).add("IpV4Addresses", this.hasIpV4Addresses() ? this.ipV4Addresses() : null).add("IpV6Addresses", this.hasIpV6Addresses() ? this.ipV6Addresses() : null).add("KeyName", (Object)this.keyName()).add("LaunchedAt", (Object)this.launchedAt()).add("Platform", (Object)this.platform()).add("SubnetId", (Object)this.subnetId()).add("Type", (Object)this.type()).add("VpcId", (Object)this.vpcId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "iamInstanceProfileArn": {
                return Optional.ofNullable(clazz.cast(this.iamInstanceProfileArn()));
            }
            case "imageId": {
                return Optional.ofNullable(clazz.cast(this.imageId()));
            }
            case "ipV4Addresses": {
                return Optional.ofNullable(clazz.cast(this.ipV4Addresses()));
            }
            case "ipV6Addresses": {
                return Optional.ofNullable(clazz.cast(this.ipV6Addresses()));
            }
            case "keyName": {
                return Optional.ofNullable(clazz.cast(this.keyName()));
            }
            case "launchedAt": {
                return Optional.ofNullable(clazz.cast(this.launchedAt()));
            }
            case "platform": {
                return Optional.ofNullable(clazz.cast(this.platform()));
            }
            case "subnetId": {
                return Optional.ofNullable(clazz.cast(this.subnetId()));
            }
            case "type": {
                return Optional.ofNullable(clazz.cast(this.type()));
            }
            case "vpcId": {
                return Optional.ofNullable(clazz.cast(this.vpcId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("iamInstanceProfileArn", IAM_INSTANCE_PROFILE_ARN_FIELD);
        map.put("imageId", IMAGE_ID_FIELD);
        map.put("ipV4Addresses", IP_V4_ADDRESSES_FIELD);
        map.put("ipV6Addresses", IP_V6_ADDRESSES_FIELD);
        map.put("keyName", KEY_NAME_FIELD);
        map.put("launchedAt", LAUNCHED_AT_FIELD);
        map.put("platform", PLATFORM_FIELD);
        map.put("subnetId", SUBNET_ID_FIELD);
        map.put("type", TYPE_FIELD);
        map.put("vpcId", VPC_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AwsEc2InstanceDetails, T> g) {
        return obj -> g.apply((AwsEc2InstanceDetails)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String iamInstanceProfileArn;
        private String imageId;
        private List<String> ipV4Addresses = DefaultSdkAutoConstructList.getInstance();
        private List<String> ipV6Addresses = DefaultSdkAutoConstructList.getInstance();
        private String keyName;
        private Instant launchedAt;
        private String platform;
        private String subnetId;
        private String type;
        private String vpcId;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsEc2InstanceDetails model) {
            this.iamInstanceProfileArn(model.iamInstanceProfileArn);
            this.imageId(model.imageId);
            this.ipV4Addresses(model.ipV4Addresses);
            this.ipV6Addresses(model.ipV6Addresses);
            this.keyName(model.keyName);
            this.launchedAt(model.launchedAt);
            this.platform(model.platform);
            this.subnetId(model.subnetId);
            this.type(model.type);
            this.vpcId(model.vpcId);
        }

        public final String getIamInstanceProfileArn() {
            return this.iamInstanceProfileArn;
        }

        public final void setIamInstanceProfileArn(String iamInstanceProfileArn) {
            this.iamInstanceProfileArn = iamInstanceProfileArn;
        }

        @Override
        public final Builder iamInstanceProfileArn(String iamInstanceProfileArn) {
            this.iamInstanceProfileArn = iamInstanceProfileArn;
            return this;
        }

        public final String getImageId() {
            return this.imageId;
        }

        public final void setImageId(String imageId) {
            this.imageId = imageId;
        }

        @Override
        public final Builder imageId(String imageId) {
            this.imageId = imageId;
            return this;
        }

        public final Collection<String> getIpV4Addresses() {
            if (this.ipV4Addresses instanceof SdkAutoConstructList) {
                return null;
            }
            return this.ipV4Addresses;
        }

        public final void setIpV4Addresses(Collection<String> ipV4Addresses) {
            this.ipV4Addresses = IpV4AddressListCopier.copy(ipV4Addresses);
        }

        @Override
        public final Builder ipV4Addresses(Collection<String> ipV4Addresses) {
            this.ipV4Addresses = IpV4AddressListCopier.copy(ipV4Addresses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ipV4Addresses(String ... ipV4Addresses) {
            this.ipV4Addresses(Arrays.asList(ipV4Addresses));
            return this;
        }

        public final Collection<String> getIpV6Addresses() {
            if (this.ipV6Addresses instanceof SdkAutoConstructList) {
                return null;
            }
            return this.ipV6Addresses;
        }

        public final void setIpV6Addresses(Collection<String> ipV6Addresses) {
            this.ipV6Addresses = IpV6AddressListCopier.copy(ipV6Addresses);
        }

        @Override
        public final Builder ipV6Addresses(Collection<String> ipV6Addresses) {
            this.ipV6Addresses = IpV6AddressListCopier.copy(ipV6Addresses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ipV6Addresses(String ... ipV6Addresses) {
            this.ipV6Addresses(Arrays.asList(ipV6Addresses));
            return this;
        }

        public final String getKeyName() {
            return this.keyName;
        }

        public final void setKeyName(String keyName) {
            this.keyName = keyName;
        }

        @Override
        public final Builder keyName(String keyName) {
            this.keyName = keyName;
            return this;
        }

        public final Instant getLaunchedAt() {
            return this.launchedAt;
        }

        public final void setLaunchedAt(Instant launchedAt) {
            this.launchedAt = launchedAt;
        }

        @Override
        public final Builder launchedAt(Instant launchedAt) {
            this.launchedAt = launchedAt;
            return this;
        }

        public final String getPlatform() {
            return this.platform;
        }

        public final void setPlatform(String platform) {
            this.platform = platform;
        }

        @Override
        public final Builder platform(String platform) {
            this.platform = platform;
            return this;
        }

        public final String getSubnetId() {
            return this.subnetId;
        }

        public final void setSubnetId(String subnetId) {
            this.subnetId = subnetId;
        }

        @Override
        public final Builder subnetId(String subnetId) {
            this.subnetId = subnetId;
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        public final String getVpcId() {
            return this.vpcId;
        }

        public final void setVpcId(String vpcId) {
            this.vpcId = vpcId;
        }

        @Override
        public final Builder vpcId(String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        public AwsEc2InstanceDetails build() {
            return new AwsEc2InstanceDetails(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AwsEc2InstanceDetails> {
        public Builder iamInstanceProfileArn(String var1);

        public Builder imageId(String var1);

        public Builder ipV4Addresses(Collection<String> var1);

        public Builder ipV4Addresses(String ... var1);

        public Builder ipV6Addresses(Collection<String> var1);

        public Builder ipV6Addresses(String ... var1);

        public Builder keyName(String var1);

        public Builder launchedAt(Instant var1);

        public Builder platform(String var1);

        public Builder subnetId(String var1);

        public Builder type(String var1);

        public Builder vpcId(String var1);
    }
}

