/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.inspector2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.inspector2.model.CisSecurityLevel;
import software.amazon.awssdk.services.inspector2.model.StatusCounts;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CisCheckAggregation
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CisCheckAggregation> {
    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("accountId").getter(CisCheckAggregation.getter(CisCheckAggregation::accountId)).setter(CisCheckAggregation.setter(Builder::accountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accountId").build()}).build();
    private static final SdkField<String> CHECK_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("checkDescription").getter(CisCheckAggregation.getter(CisCheckAggregation::checkDescription)).setter(CisCheckAggregation.setter(Builder::checkDescription)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("checkDescription").build()}).build();
    private static final SdkField<String> CHECK_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("checkId").getter(CisCheckAggregation.getter(CisCheckAggregation::checkId)).setter(CisCheckAggregation.setter(Builder::checkId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("checkId").build()}).build();
    private static final SdkField<String> LEVEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("level").getter(CisCheckAggregation.getter(CisCheckAggregation::levelAsString)).setter(CisCheckAggregation.setter(Builder::level)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("level").build()}).build();
    private static final SdkField<String> PLATFORM_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("platform").getter(CisCheckAggregation.getter(CisCheckAggregation::platform)).setter(CisCheckAggregation.setter(Builder::platform)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("platform").build()}).build();
    private static final SdkField<String> SCAN_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("scanArn").getter(CisCheckAggregation.getter(CisCheckAggregation::scanArn)).setter(CisCheckAggregation.setter(Builder::scanArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scanArn").build()}).build();
    private static final SdkField<StatusCounts> STATUS_COUNTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("statusCounts").getter(CisCheckAggregation.getter(CisCheckAggregation::statusCounts)).setter(CisCheckAggregation.setter(Builder::statusCounts)).constructor(StatusCounts::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusCounts").build()}).build();
    private static final SdkField<String> TITLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("title").getter(CisCheckAggregation.getter(CisCheckAggregation::title)).setter(CisCheckAggregation.setter(Builder::title)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("title").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_ID_FIELD, CHECK_DESCRIPTION_FIELD, CHECK_ID_FIELD, LEVEL_FIELD, PLATFORM_FIELD, SCAN_ARN_FIELD, STATUS_COUNTS_FIELD, TITLE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CisCheckAggregation.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String accountId;
    private final String checkDescription;
    private final String checkId;
    private final String level;
    private final String platform;
    private final String scanArn;
    private final StatusCounts statusCounts;
    private final String title;

    private CisCheckAggregation(BuilderImpl builder) {
        this.accountId = builder.accountId;
        this.checkDescription = builder.checkDescription;
        this.checkId = builder.checkId;
        this.level = builder.level;
        this.platform = builder.platform;
        this.scanArn = builder.scanArn;
        this.statusCounts = builder.statusCounts;
        this.title = builder.title;
    }

    public final String accountId() {
        return this.accountId;
    }

    public final String checkDescription() {
        return this.checkDescription;
    }

    public final String checkId() {
        return this.checkId;
    }

    public final CisSecurityLevel level() {
        return CisSecurityLevel.fromValue(this.level);
    }

    public final String levelAsString() {
        return this.level;
    }

    public final String platform() {
        return this.platform;
    }

    public final String scanArn() {
        return this.scanArn;
    }

    public final StatusCounts statusCounts() {
        return this.statusCounts;
    }

    public final String title() {
        return this.title;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.accountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.checkDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.checkId());
        hashCode = 31 * hashCode + Objects.hashCode(this.levelAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.platform());
        hashCode = 31 * hashCode + Objects.hashCode(this.scanArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusCounts());
        hashCode = 31 * hashCode + Objects.hashCode(this.title());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CisCheckAggregation)) {
            return false;
        }
        CisCheckAggregation other = (CisCheckAggregation)obj;
        return Objects.equals(this.accountId(), other.accountId()) && Objects.equals(this.checkDescription(), other.checkDescription()) && Objects.equals(this.checkId(), other.checkId()) && Objects.equals(this.levelAsString(), other.levelAsString()) && Objects.equals(this.platform(), other.platform()) && Objects.equals(this.scanArn(), other.scanArn()) && Objects.equals(this.statusCounts(), other.statusCounts()) && Objects.equals(this.title(), other.title());
    }

    public final String toString() {
        return ToString.builder((String)"CisCheckAggregation").add("AccountId", (Object)this.accountId()).add("CheckDescription", (Object)this.checkDescription()).add("CheckId", (Object)this.checkId()).add("Level", (Object)this.levelAsString()).add("Platform", (Object)this.platform()).add("ScanArn", (Object)this.scanArn()).add("StatusCounts", (Object)this.statusCounts()).add("Title", (Object)this.title()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "accountId": {
                return Optional.ofNullable(clazz.cast(this.accountId()));
            }
            case "checkDescription": {
                return Optional.ofNullable(clazz.cast(this.checkDescription()));
            }
            case "checkId": {
                return Optional.ofNullable(clazz.cast(this.checkId()));
            }
            case "level": {
                return Optional.ofNullable(clazz.cast(this.levelAsString()));
            }
            case "platform": {
                return Optional.ofNullable(clazz.cast(this.platform()));
            }
            case "scanArn": {
                return Optional.ofNullable(clazz.cast(this.scanArn()));
            }
            case "statusCounts": {
                return Optional.ofNullable(clazz.cast(this.statusCounts()));
            }
            case "title": {
                return Optional.ofNullable(clazz.cast(this.title()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("accountId", ACCOUNT_ID_FIELD);
        map.put("checkDescription", CHECK_DESCRIPTION_FIELD);
        map.put("checkId", CHECK_ID_FIELD);
        map.put("level", LEVEL_FIELD);
        map.put("platform", PLATFORM_FIELD);
        map.put("scanArn", SCAN_ARN_FIELD);
        map.put("statusCounts", STATUS_COUNTS_FIELD);
        map.put("title", TITLE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CisCheckAggregation, T> g) {
        return obj -> g.apply((CisCheckAggregation)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String accountId;
        private String checkDescription;
        private String checkId;
        private String level;
        private String platform;
        private String scanArn;
        private StatusCounts statusCounts;
        private String title;

        private BuilderImpl() {
        }

        private BuilderImpl(CisCheckAggregation model) {
            this.accountId(model.accountId);
            this.checkDescription(model.checkDescription);
            this.checkId(model.checkId);
            this.level(model.level);
            this.platform(model.platform);
            this.scanArn(model.scanArn);
            this.statusCounts(model.statusCounts);
            this.title(model.title);
        }

        public final String getAccountId() {
            return this.accountId;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final String getCheckDescription() {
            return this.checkDescription;
        }

        public final void setCheckDescription(String checkDescription) {
            this.checkDescription = checkDescription;
        }

        @Override
        public final Builder checkDescription(String checkDescription) {
            this.checkDescription = checkDescription;
            return this;
        }

        public final String getCheckId() {
            return this.checkId;
        }

        public final void setCheckId(String checkId) {
            this.checkId = checkId;
        }

        @Override
        public final Builder checkId(String checkId) {
            this.checkId = checkId;
            return this;
        }

        public final String getLevel() {
            return this.level;
        }

        public final void setLevel(String level) {
            this.level = level;
        }

        @Override
        public final Builder level(String level) {
            this.level = level;
            return this;
        }

        @Override
        public final Builder level(CisSecurityLevel level) {
            this.level(level == null ? null : level.toString());
            return this;
        }

        public final String getPlatform() {
            return this.platform;
        }

        public final void setPlatform(String platform) {
            this.platform = platform;
        }

        @Override
        public final Builder platform(String platform) {
            this.platform = platform;
            return this;
        }

        public final String getScanArn() {
            return this.scanArn;
        }

        public final void setScanArn(String scanArn) {
            this.scanArn = scanArn;
        }

        @Override
        public final Builder scanArn(String scanArn) {
            this.scanArn = scanArn;
            return this;
        }

        public final StatusCounts.Builder getStatusCounts() {
            return this.statusCounts != null ? this.statusCounts.toBuilder() : null;
        }

        public final void setStatusCounts(StatusCounts.BuilderImpl statusCounts) {
            this.statusCounts = statusCounts != null ? statusCounts.build() : null;
        }

        @Override
        public final Builder statusCounts(StatusCounts statusCounts) {
            this.statusCounts = statusCounts;
            return this;
        }

        public final String getTitle() {
            return this.title;
        }

        public final void setTitle(String title) {
            this.title = title;
        }

        @Override
        public final Builder title(String title) {
            this.title = title;
            return this;
        }

        public CisCheckAggregation build() {
            return new CisCheckAggregation(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CisCheckAggregation> {
        public Builder accountId(String var1);

        public Builder checkDescription(String var1);

        public Builder checkId(String var1);

        public Builder level(String var1);

        public Builder level(CisSecurityLevel var1);

        public Builder platform(String var1);

        public Builder scanArn(String var1);

        public Builder statusCounts(StatusCounts var1);

        default public Builder statusCounts(Consumer<StatusCounts.Builder> statusCounts) {
            return this.statusCounts((StatusCounts)((StatusCounts.Builder)StatusCounts.builder().applyMutation(statusCounts)).build());
        }

        public Builder title(String var1);
    }
}

