/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.inspector2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.inspector2.model.CisSecurityLevel;
import software.amazon.awssdk.services.inspector2.model.CisTagMapCopier;
import software.amazon.awssdk.services.inspector2.model.CisTargets;
import software.amazon.awssdk.services.inspector2.model.Schedule;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CisScanConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CisScanConfiguration> {
    private static final SdkField<String> OWNER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ownerId").getter(CisScanConfiguration.getter(CisScanConfiguration::ownerId)).setter(CisScanConfiguration.setter(Builder::ownerId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ownerId").build()}).build();
    private static final SdkField<String> SCAN_CONFIGURATION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("scanConfigurationArn").getter(CisScanConfiguration.getter(CisScanConfiguration::scanConfigurationArn)).setter(CisScanConfiguration.setter(Builder::scanConfigurationArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scanConfigurationArn").build()}).build();
    private static final SdkField<String> SCAN_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("scanName").getter(CisScanConfiguration.getter(CisScanConfiguration::scanName)).setter(CisScanConfiguration.setter(Builder::scanName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scanName").build()}).build();
    private static final SdkField<Schedule> SCHEDULE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("schedule").getter(CisScanConfiguration.getter(CisScanConfiguration::schedule)).setter(CisScanConfiguration.setter(Builder::schedule)).constructor(Schedule::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("schedule").build()}).build();
    private static final SdkField<String> SECURITY_LEVEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("securityLevel").getter(CisScanConfiguration.getter(CisScanConfiguration::securityLevelAsString)).setter(CisScanConfiguration.setter(Builder::securityLevel)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("securityLevel").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(CisScanConfiguration.getter(CisScanConfiguration::tags)).setter(CisScanConfiguration.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<CisTargets> TARGETS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("targets").getter(CisScanConfiguration.getter(CisScanConfiguration::targets)).setter(CisScanConfiguration.setter(Builder::targets)).constructor(CisTargets::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targets").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OWNER_ID_FIELD, SCAN_CONFIGURATION_ARN_FIELD, SCAN_NAME_FIELD, SCHEDULE_FIELD, SECURITY_LEVEL_FIELD, TAGS_FIELD, TARGETS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CisScanConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String ownerId;
    private final String scanConfigurationArn;
    private final String scanName;
    private final Schedule schedule;
    private final String securityLevel;
    private final Map<String, String> tags;
    private final CisTargets targets;

    private CisScanConfiguration(BuilderImpl builder) {
        this.ownerId = builder.ownerId;
        this.scanConfigurationArn = builder.scanConfigurationArn;
        this.scanName = builder.scanName;
        this.schedule = builder.schedule;
        this.securityLevel = builder.securityLevel;
        this.tags = builder.tags;
        this.targets = builder.targets;
    }

    public final String ownerId() {
        return this.ownerId;
    }

    public final String scanConfigurationArn() {
        return this.scanConfigurationArn;
    }

    public final String scanName() {
        return this.scanName;
    }

    public final Schedule schedule() {
        return this.schedule;
    }

    public final CisSecurityLevel securityLevel() {
        return CisSecurityLevel.fromValue(this.securityLevel);
    }

    public final String securityLevelAsString() {
        return this.securityLevel;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public final CisTargets targets() {
        return this.targets;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.ownerId());
        hashCode = 31 * hashCode + Objects.hashCode(this.scanConfigurationArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.scanName());
        hashCode = 31 * hashCode + Objects.hashCode(this.schedule());
        hashCode = 31 * hashCode + Objects.hashCode(this.securityLevelAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.targets());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CisScanConfiguration)) {
            return false;
        }
        CisScanConfiguration other = (CisScanConfiguration)obj;
        return Objects.equals(this.ownerId(), other.ownerId()) && Objects.equals(this.scanConfigurationArn(), other.scanConfigurationArn()) && Objects.equals(this.scanName(), other.scanName()) && Objects.equals(this.schedule(), other.schedule()) && Objects.equals(this.securityLevelAsString(), other.securityLevelAsString()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.targets(), other.targets());
    }

    public final String toString() {
        return ToString.builder((String)"CisScanConfiguration").add("OwnerId", (Object)this.ownerId()).add("ScanConfigurationArn", (Object)this.scanConfigurationArn()).add("ScanName", (Object)this.scanName()).add("Schedule", (Object)this.schedule()).add("SecurityLevel", (Object)this.securityLevelAsString()).add("Tags", this.hasTags() ? this.tags() : null).add("Targets", (Object)this.targets()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ownerId": {
                return Optional.ofNullable(clazz.cast(this.ownerId()));
            }
            case "scanConfigurationArn": {
                return Optional.ofNullable(clazz.cast(this.scanConfigurationArn()));
            }
            case "scanName": {
                return Optional.ofNullable(clazz.cast(this.scanName()));
            }
            case "schedule": {
                return Optional.ofNullable(clazz.cast(this.schedule()));
            }
            case "securityLevel": {
                return Optional.ofNullable(clazz.cast(this.securityLevelAsString()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "targets": {
                return Optional.ofNullable(clazz.cast(this.targets()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ownerId", OWNER_ID_FIELD);
        map.put("scanConfigurationArn", SCAN_CONFIGURATION_ARN_FIELD);
        map.put("scanName", SCAN_NAME_FIELD);
        map.put("schedule", SCHEDULE_FIELD);
        map.put("securityLevel", SECURITY_LEVEL_FIELD);
        map.put("tags", TAGS_FIELD);
        map.put("targets", TARGETS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CisScanConfiguration, T> g) {
        return obj -> g.apply((CisScanConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String ownerId;
        private String scanConfigurationArn;
        private String scanName;
        private Schedule schedule;
        private String securityLevel;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();
        private CisTargets targets;

        private BuilderImpl() {
        }

        private BuilderImpl(CisScanConfiguration model) {
            this.ownerId(model.ownerId);
            this.scanConfigurationArn(model.scanConfigurationArn);
            this.scanName(model.scanName);
            this.schedule(model.schedule);
            this.securityLevel(model.securityLevel);
            this.tags(model.tags);
            this.targets(model.targets);
        }

        public final String getOwnerId() {
            return this.ownerId;
        }

        public final void setOwnerId(String ownerId) {
            this.ownerId = ownerId;
        }

        @Override
        public final Builder ownerId(String ownerId) {
            this.ownerId = ownerId;
            return this;
        }

        public final String getScanConfigurationArn() {
            return this.scanConfigurationArn;
        }

        public final void setScanConfigurationArn(String scanConfigurationArn) {
            this.scanConfigurationArn = scanConfigurationArn;
        }

        @Override
        public final Builder scanConfigurationArn(String scanConfigurationArn) {
            this.scanConfigurationArn = scanConfigurationArn;
            return this;
        }

        public final String getScanName() {
            return this.scanName;
        }

        public final void setScanName(String scanName) {
            this.scanName = scanName;
        }

        @Override
        public final Builder scanName(String scanName) {
            this.scanName = scanName;
            return this;
        }

        public final Schedule.Builder getSchedule() {
            return this.schedule != null ? this.schedule.toBuilder() : null;
        }

        public final void setSchedule(Schedule.BuilderImpl schedule) {
            this.schedule = schedule != null ? schedule.build() : null;
        }

        @Override
        public final Builder schedule(Schedule schedule) {
            this.schedule = schedule;
            return this;
        }

        public final String getSecurityLevel() {
            return this.securityLevel;
        }

        public final void setSecurityLevel(String securityLevel) {
            this.securityLevel = securityLevel;
        }

        @Override
        public final Builder securityLevel(String securityLevel) {
            this.securityLevel = securityLevel;
            return this;
        }

        @Override
        public final Builder securityLevel(CisSecurityLevel securityLevel) {
            this.securityLevel(securityLevel == null ? null : securityLevel.toString());
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = CisTagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = CisTagMapCopier.copy(tags);
            return this;
        }

        public final CisTargets.Builder getTargets() {
            return this.targets != null ? this.targets.toBuilder() : null;
        }

        public final void setTargets(CisTargets.BuilderImpl targets) {
            this.targets = targets != null ? targets.build() : null;
        }

        @Override
        public final Builder targets(CisTargets targets) {
            this.targets = targets;
            return this;
        }

        public CisScanConfiguration build() {
            return new CisScanConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CisScanConfiguration> {
        public Builder ownerId(String var1);

        public Builder scanConfigurationArn(String var1);

        public Builder scanName(String var1);

        public Builder schedule(Schedule var1);

        default public Builder schedule(Consumer<Schedule.Builder> schedule) {
            return this.schedule((Schedule)((Schedule.Builder)Schedule.builder().applyMutation(schedule)).build());
        }

        public Builder securityLevel(String var1);

        public Builder securityLevel(CisSecurityLevel var1);

        public Builder tags(Map<String, String> var1);

        public Builder targets(CisTargets var1);

        default public Builder targets(Consumer<CisTargets.Builder> targets) {
            return this.targets((CisTargets)((CisTargets.Builder)CisTargets.builder().applyMutation(targets)).build());
        }
    }
}

