/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.inspector2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.inspector2.Inspector2Client;
import software.amazon.awssdk.services.inspector2.internal.UserAgentUtils;
import software.amazon.awssdk.services.inspector2.model.CisTargetResourceAggregation;
import software.amazon.awssdk.services.inspector2.model.ListCisScanResultsAggregatedByTargetResourceRequest;
import software.amazon.awssdk.services.inspector2.model.ListCisScanResultsAggregatedByTargetResourceResponse;

public class ListCisScanResultsAggregatedByTargetResourceIterable
implements SdkIterable<ListCisScanResultsAggregatedByTargetResourceResponse> {
    private final Inspector2Client client;
    private final ListCisScanResultsAggregatedByTargetResourceRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListCisScanResultsAggregatedByTargetResourceIterable(Inspector2Client client, ListCisScanResultsAggregatedByTargetResourceRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListCisScanResultsAggregatedByTargetResourceResponseFetcher();
    }

    public Iterator<ListCisScanResultsAggregatedByTargetResourceResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<CisTargetResourceAggregation> targetResourceAggregations() {
        Function<ListCisScanResultsAggregatedByTargetResourceResponse, Iterator> getIterator = response -> {
            if (response != null && response.targetResourceAggregations() != null) {
                return response.targetResourceAggregations().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListCisScanResultsAggregatedByTargetResourceResponseFetcher
    implements SyncPageFetcher<ListCisScanResultsAggregatedByTargetResourceResponse> {
        private ListCisScanResultsAggregatedByTargetResourceResponseFetcher() {
        }

        public boolean hasNextPage(ListCisScanResultsAggregatedByTargetResourceResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListCisScanResultsAggregatedByTargetResourceResponse nextPage(ListCisScanResultsAggregatedByTargetResourceResponse previousPage) {
            if (previousPage == null) {
                return ListCisScanResultsAggregatedByTargetResourceIterable.this.client.listCisScanResultsAggregatedByTargetResource(ListCisScanResultsAggregatedByTargetResourceIterable.this.firstRequest);
            }
            return ListCisScanResultsAggregatedByTargetResourceIterable.this.client.listCisScanResultsAggregatedByTargetResource((ListCisScanResultsAggregatedByTargetResourceRequest)((Object)ListCisScanResultsAggregatedByTargetResourceIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

