/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.inspector2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.inspector2.model.SeverityCounts;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CodeRepositoryAggregationResponse
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CodeRepositoryAggregationResponse> {
    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("accountId").getter(CodeRepositoryAggregationResponse.getter(CodeRepositoryAggregationResponse::accountId)).setter(CodeRepositoryAggregationResponse.setter(Builder::accountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accountId").build()}).build();
    private static final SdkField<Long> EXPLOIT_AVAILABLE_ACTIVE_FINDINGS_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("exploitAvailableActiveFindingsCount").getter(CodeRepositoryAggregationResponse.getter(CodeRepositoryAggregationResponse::exploitAvailableActiveFindingsCount)).setter(CodeRepositoryAggregationResponse.setter(Builder::exploitAvailableActiveFindingsCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("exploitAvailableActiveFindingsCount").build()}).build();
    private static final SdkField<Long> FIX_AVAILABLE_ACTIVE_FINDINGS_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("fixAvailableActiveFindingsCount").getter(CodeRepositoryAggregationResponse.getter(CodeRepositoryAggregationResponse::fixAvailableActiveFindingsCount)).setter(CodeRepositoryAggregationResponse.setter(Builder::fixAvailableActiveFindingsCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fixAvailableActiveFindingsCount").build()}).build();
    private static final SdkField<String> PROJECT_NAMES_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("projectNames").getter(CodeRepositoryAggregationResponse.getter(CodeRepositoryAggregationResponse::projectNames)).setter(CodeRepositoryAggregationResponse.setter(Builder::projectNames)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("projectNames").build()}).build();
    private static final SdkField<String> PROVIDER_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("providerType").getter(CodeRepositoryAggregationResponse.getter(CodeRepositoryAggregationResponse::providerType)).setter(CodeRepositoryAggregationResponse.setter(Builder::providerType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("providerType").build()}).build();
    private static final SdkField<String> RESOURCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("resourceId").getter(CodeRepositoryAggregationResponse.getter(CodeRepositoryAggregationResponse::resourceId)).setter(CodeRepositoryAggregationResponse.setter(Builder::resourceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceId").build()}).build();
    private static final SdkField<SeverityCounts> SEVERITY_COUNTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("severityCounts").getter(CodeRepositoryAggregationResponse.getter(CodeRepositoryAggregationResponse::severityCounts)).setter(CodeRepositoryAggregationResponse.setter(Builder::severityCounts)).constructor(SeverityCounts::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("severityCounts").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_ID_FIELD, EXPLOIT_AVAILABLE_ACTIVE_FINDINGS_COUNT_FIELD, FIX_AVAILABLE_ACTIVE_FINDINGS_COUNT_FIELD, PROJECT_NAMES_FIELD, PROVIDER_TYPE_FIELD, RESOURCE_ID_FIELD, SEVERITY_COUNTS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CodeRepositoryAggregationResponse.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String accountId;
    private final Long exploitAvailableActiveFindingsCount;
    private final Long fixAvailableActiveFindingsCount;
    private final String projectNames;
    private final String providerType;
    private final String resourceId;
    private final SeverityCounts severityCounts;

    private CodeRepositoryAggregationResponse(BuilderImpl builder) {
        this.accountId = builder.accountId;
        this.exploitAvailableActiveFindingsCount = builder.exploitAvailableActiveFindingsCount;
        this.fixAvailableActiveFindingsCount = builder.fixAvailableActiveFindingsCount;
        this.projectNames = builder.projectNames;
        this.providerType = builder.providerType;
        this.resourceId = builder.resourceId;
        this.severityCounts = builder.severityCounts;
    }

    public final String accountId() {
        return this.accountId;
    }

    public final Long exploitAvailableActiveFindingsCount() {
        return this.exploitAvailableActiveFindingsCount;
    }

    public final Long fixAvailableActiveFindingsCount() {
        return this.fixAvailableActiveFindingsCount;
    }

    public final String projectNames() {
        return this.projectNames;
    }

    public final String providerType() {
        return this.providerType;
    }

    public final String resourceId() {
        return this.resourceId;
    }

    public final SeverityCounts severityCounts() {
        return this.severityCounts;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.accountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.exploitAvailableActiveFindingsCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.fixAvailableActiveFindingsCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.projectNames());
        hashCode = 31 * hashCode + Objects.hashCode(this.providerType());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.severityCounts());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CodeRepositoryAggregationResponse)) {
            return false;
        }
        CodeRepositoryAggregationResponse other = (CodeRepositoryAggregationResponse)obj;
        return Objects.equals(this.accountId(), other.accountId()) && Objects.equals(this.exploitAvailableActiveFindingsCount(), other.exploitAvailableActiveFindingsCount()) && Objects.equals(this.fixAvailableActiveFindingsCount(), other.fixAvailableActiveFindingsCount()) && Objects.equals(this.projectNames(), other.projectNames()) && Objects.equals(this.providerType(), other.providerType()) && Objects.equals(this.resourceId(), other.resourceId()) && Objects.equals(this.severityCounts(), other.severityCounts());
    }

    public final String toString() {
        return ToString.builder((String)"CodeRepositoryAggregationResponse").add("AccountId", (Object)this.accountId()).add("ExploitAvailableActiveFindingsCount", (Object)this.exploitAvailableActiveFindingsCount()).add("FixAvailableActiveFindingsCount", (Object)this.fixAvailableActiveFindingsCount()).add("ProjectNames", (Object)this.projectNames()).add("ProviderType", (Object)this.providerType()).add("ResourceId", (Object)this.resourceId()).add("SeverityCounts", (Object)this.severityCounts()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "accountId": {
                return Optional.ofNullable(clazz.cast(this.accountId()));
            }
            case "exploitAvailableActiveFindingsCount": {
                return Optional.ofNullable(clazz.cast(this.exploitAvailableActiveFindingsCount()));
            }
            case "fixAvailableActiveFindingsCount": {
                return Optional.ofNullable(clazz.cast(this.fixAvailableActiveFindingsCount()));
            }
            case "projectNames": {
                return Optional.ofNullable(clazz.cast(this.projectNames()));
            }
            case "providerType": {
                return Optional.ofNullable(clazz.cast(this.providerType()));
            }
            case "resourceId": {
                return Optional.ofNullable(clazz.cast(this.resourceId()));
            }
            case "severityCounts": {
                return Optional.ofNullable(clazz.cast(this.severityCounts()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("accountId", ACCOUNT_ID_FIELD);
        map.put("exploitAvailableActiveFindingsCount", EXPLOIT_AVAILABLE_ACTIVE_FINDINGS_COUNT_FIELD);
        map.put("fixAvailableActiveFindingsCount", FIX_AVAILABLE_ACTIVE_FINDINGS_COUNT_FIELD);
        map.put("projectNames", PROJECT_NAMES_FIELD);
        map.put("providerType", PROVIDER_TYPE_FIELD);
        map.put("resourceId", RESOURCE_ID_FIELD);
        map.put("severityCounts", SEVERITY_COUNTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CodeRepositoryAggregationResponse, T> g) {
        return obj -> g.apply((CodeRepositoryAggregationResponse)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String accountId;
        private Long exploitAvailableActiveFindingsCount;
        private Long fixAvailableActiveFindingsCount;
        private String projectNames;
        private String providerType;
        private String resourceId;
        private SeverityCounts severityCounts;

        private BuilderImpl() {
        }

        private BuilderImpl(CodeRepositoryAggregationResponse model) {
            this.accountId(model.accountId);
            this.exploitAvailableActiveFindingsCount(model.exploitAvailableActiveFindingsCount);
            this.fixAvailableActiveFindingsCount(model.fixAvailableActiveFindingsCount);
            this.projectNames(model.projectNames);
            this.providerType(model.providerType);
            this.resourceId(model.resourceId);
            this.severityCounts(model.severityCounts);
        }

        public final String getAccountId() {
            return this.accountId;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final Long getExploitAvailableActiveFindingsCount() {
            return this.exploitAvailableActiveFindingsCount;
        }

        public final void setExploitAvailableActiveFindingsCount(Long exploitAvailableActiveFindingsCount) {
            this.exploitAvailableActiveFindingsCount = exploitAvailableActiveFindingsCount;
        }

        @Override
        public final Builder exploitAvailableActiveFindingsCount(Long exploitAvailableActiveFindingsCount) {
            this.exploitAvailableActiveFindingsCount = exploitAvailableActiveFindingsCount;
            return this;
        }

        public final Long getFixAvailableActiveFindingsCount() {
            return this.fixAvailableActiveFindingsCount;
        }

        public final void setFixAvailableActiveFindingsCount(Long fixAvailableActiveFindingsCount) {
            this.fixAvailableActiveFindingsCount = fixAvailableActiveFindingsCount;
        }

        @Override
        public final Builder fixAvailableActiveFindingsCount(Long fixAvailableActiveFindingsCount) {
            this.fixAvailableActiveFindingsCount = fixAvailableActiveFindingsCount;
            return this;
        }

        public final String getProjectNames() {
            return this.projectNames;
        }

        public final void setProjectNames(String projectNames) {
            this.projectNames = projectNames;
        }

        @Override
        public final Builder projectNames(String projectNames) {
            this.projectNames = projectNames;
            return this;
        }

        public final String getProviderType() {
            return this.providerType;
        }

        public final void setProviderType(String providerType) {
            this.providerType = providerType;
        }

        @Override
        public final Builder providerType(String providerType) {
            this.providerType = providerType;
            return this;
        }

        public final String getResourceId() {
            return this.resourceId;
        }

        public final void setResourceId(String resourceId) {
            this.resourceId = resourceId;
        }

        @Override
        public final Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            return this;
        }

        public final SeverityCounts.Builder getSeverityCounts() {
            return this.severityCounts != null ? this.severityCounts.toBuilder() : null;
        }

        public final void setSeverityCounts(SeverityCounts.BuilderImpl severityCounts) {
            this.severityCounts = severityCounts != null ? severityCounts.build() : null;
        }

        @Override
        public final Builder severityCounts(SeverityCounts severityCounts) {
            this.severityCounts = severityCounts;
            return this;
        }

        public CodeRepositoryAggregationResponse build() {
            return new CodeRepositoryAggregationResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CodeRepositoryAggregationResponse> {
        public Builder accountId(String var1);

        public Builder exploitAvailableActiveFindingsCount(Long var1);

        public Builder fixAvailableActiveFindingsCount(Long var1);

        public Builder projectNames(String var1);

        public Builder providerType(String var1);

        public Builder resourceId(String var1);

        public Builder severityCounts(SeverityCounts var1);

        default public Builder severityCounts(Consumer<SeverityCounts.Builder> severityCounts) {
            return this.severityCounts((SeverityCounts)((SeverityCounts.Builder)SeverityCounts.builder().applyMutation(severityCounts)).build());
        }
    }
}

