/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.inspector2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.inspector2.model.ContinuousIntegrationScanConfiguration;
import software.amazon.awssdk.services.inspector2.model.PeriodicScanConfiguration;
import software.amazon.awssdk.services.inspector2.model.RuleSetCategoriesCopier;
import software.amazon.awssdk.services.inspector2.model.RuleSetCategory;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CodeSecurityScanConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CodeSecurityScanConfiguration> {
    private static final SdkField<ContinuousIntegrationScanConfiguration> CONTINUOUS_INTEGRATION_SCAN_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("continuousIntegrationScanConfiguration").getter(CodeSecurityScanConfiguration.getter(CodeSecurityScanConfiguration::continuousIntegrationScanConfiguration)).setter(CodeSecurityScanConfiguration.setter(Builder::continuousIntegrationScanConfiguration)).constructor(ContinuousIntegrationScanConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("continuousIntegrationScanConfiguration").build()}).build();
    private static final SdkField<PeriodicScanConfiguration> PERIODIC_SCAN_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("periodicScanConfiguration").getter(CodeSecurityScanConfiguration.getter(CodeSecurityScanConfiguration::periodicScanConfiguration)).setter(CodeSecurityScanConfiguration.setter(Builder::periodicScanConfiguration)).constructor(PeriodicScanConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("periodicScanConfiguration").build()}).build();
    private static final SdkField<List<String>> RULE_SET_CATEGORIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ruleSetCategories").getter(CodeSecurityScanConfiguration.getter(CodeSecurityScanConfiguration::ruleSetCategoriesAsStrings)).setter(CodeSecurityScanConfiguration.setter(Builder::ruleSetCategoriesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ruleSetCategories").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTINUOUS_INTEGRATION_SCAN_CONFIGURATION_FIELD, PERIODIC_SCAN_CONFIGURATION_FIELD, RULE_SET_CATEGORIES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CodeSecurityScanConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final ContinuousIntegrationScanConfiguration continuousIntegrationScanConfiguration;
    private final PeriodicScanConfiguration periodicScanConfiguration;
    private final List<String> ruleSetCategories;

    private CodeSecurityScanConfiguration(BuilderImpl builder) {
        this.continuousIntegrationScanConfiguration = builder.continuousIntegrationScanConfiguration;
        this.periodicScanConfiguration = builder.periodicScanConfiguration;
        this.ruleSetCategories = builder.ruleSetCategories;
    }

    public final ContinuousIntegrationScanConfiguration continuousIntegrationScanConfiguration() {
        return this.continuousIntegrationScanConfiguration;
    }

    public final PeriodicScanConfiguration periodicScanConfiguration() {
        return this.periodicScanConfiguration;
    }

    public final List<RuleSetCategory> ruleSetCategories() {
        return RuleSetCategoriesCopier.copyStringToEnum(this.ruleSetCategories);
    }

    public final boolean hasRuleSetCategories() {
        return this.ruleSetCategories != null && !(this.ruleSetCategories instanceof SdkAutoConstructList);
    }

    public final List<String> ruleSetCategoriesAsStrings() {
        return this.ruleSetCategories;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.continuousIntegrationScanConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.periodicScanConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRuleSetCategories() ? this.ruleSetCategoriesAsStrings() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CodeSecurityScanConfiguration)) {
            return false;
        }
        CodeSecurityScanConfiguration other = (CodeSecurityScanConfiguration)obj;
        return Objects.equals(this.continuousIntegrationScanConfiguration(), other.continuousIntegrationScanConfiguration()) && Objects.equals(this.periodicScanConfiguration(), other.periodicScanConfiguration()) && this.hasRuleSetCategories() == other.hasRuleSetCategories() && Objects.equals(this.ruleSetCategoriesAsStrings(), other.ruleSetCategoriesAsStrings());
    }

    public final String toString() {
        return ToString.builder((String)"CodeSecurityScanConfiguration").add("ContinuousIntegrationScanConfiguration", (Object)this.continuousIntegrationScanConfiguration()).add("PeriodicScanConfiguration", (Object)this.periodicScanConfiguration()).add("RuleSetCategories", this.hasRuleSetCategories() ? this.ruleSetCategoriesAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "continuousIntegrationScanConfiguration": {
                return Optional.ofNullable(clazz.cast(this.continuousIntegrationScanConfiguration()));
            }
            case "periodicScanConfiguration": {
                return Optional.ofNullable(clazz.cast(this.periodicScanConfiguration()));
            }
            case "ruleSetCategories": {
                return Optional.ofNullable(clazz.cast(this.ruleSetCategoriesAsStrings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("continuousIntegrationScanConfiguration", CONTINUOUS_INTEGRATION_SCAN_CONFIGURATION_FIELD);
        map.put("periodicScanConfiguration", PERIODIC_SCAN_CONFIGURATION_FIELD);
        map.put("ruleSetCategories", RULE_SET_CATEGORIES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CodeSecurityScanConfiguration, T> g) {
        return obj -> g.apply((CodeSecurityScanConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private ContinuousIntegrationScanConfiguration continuousIntegrationScanConfiguration;
        private PeriodicScanConfiguration periodicScanConfiguration;
        private List<String> ruleSetCategories = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CodeSecurityScanConfiguration model) {
            this.continuousIntegrationScanConfiguration(model.continuousIntegrationScanConfiguration);
            this.periodicScanConfiguration(model.periodicScanConfiguration);
            this.ruleSetCategoriesWithStrings(model.ruleSetCategories);
        }

        public final ContinuousIntegrationScanConfiguration.Builder getContinuousIntegrationScanConfiguration() {
            return this.continuousIntegrationScanConfiguration != null ? this.continuousIntegrationScanConfiguration.toBuilder() : null;
        }

        public final void setContinuousIntegrationScanConfiguration(ContinuousIntegrationScanConfiguration.BuilderImpl continuousIntegrationScanConfiguration) {
            this.continuousIntegrationScanConfiguration = continuousIntegrationScanConfiguration != null ? continuousIntegrationScanConfiguration.build() : null;
        }

        @Override
        public final Builder continuousIntegrationScanConfiguration(ContinuousIntegrationScanConfiguration continuousIntegrationScanConfiguration) {
            this.continuousIntegrationScanConfiguration = continuousIntegrationScanConfiguration;
            return this;
        }

        public final PeriodicScanConfiguration.Builder getPeriodicScanConfiguration() {
            return this.periodicScanConfiguration != null ? this.periodicScanConfiguration.toBuilder() : null;
        }

        public final void setPeriodicScanConfiguration(PeriodicScanConfiguration.BuilderImpl periodicScanConfiguration) {
            this.periodicScanConfiguration = periodicScanConfiguration != null ? periodicScanConfiguration.build() : null;
        }

        @Override
        public final Builder periodicScanConfiguration(PeriodicScanConfiguration periodicScanConfiguration) {
            this.periodicScanConfiguration = periodicScanConfiguration;
            return this;
        }

        public final Collection<String> getRuleSetCategories() {
            if (this.ruleSetCategories instanceof SdkAutoConstructList) {
                return null;
            }
            return this.ruleSetCategories;
        }

        public final void setRuleSetCategories(Collection<String> ruleSetCategories) {
            this.ruleSetCategories = RuleSetCategoriesCopier.copy(ruleSetCategories);
        }

        @Override
        public final Builder ruleSetCategoriesWithStrings(Collection<String> ruleSetCategories) {
            this.ruleSetCategories = RuleSetCategoriesCopier.copy(ruleSetCategories);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ruleSetCategoriesWithStrings(String ... ruleSetCategories) {
            this.ruleSetCategoriesWithStrings(Arrays.asList(ruleSetCategories));
            return this;
        }

        @Override
        public final Builder ruleSetCategories(Collection<RuleSetCategory> ruleSetCategories) {
            this.ruleSetCategories = RuleSetCategoriesCopier.copyEnumToString(ruleSetCategories);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ruleSetCategories(RuleSetCategory ... ruleSetCategories) {
            this.ruleSetCategories(Arrays.asList(ruleSetCategories));
            return this;
        }

        public CodeSecurityScanConfiguration build() {
            return new CodeSecurityScanConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CodeSecurityScanConfiguration> {
        public Builder continuousIntegrationScanConfiguration(ContinuousIntegrationScanConfiguration var1);

        default public Builder continuousIntegrationScanConfiguration(Consumer<ContinuousIntegrationScanConfiguration.Builder> continuousIntegrationScanConfiguration) {
            return this.continuousIntegrationScanConfiguration((ContinuousIntegrationScanConfiguration)((ContinuousIntegrationScanConfiguration.Builder)ContinuousIntegrationScanConfiguration.builder().applyMutation(continuousIntegrationScanConfiguration)).build());
        }

        public Builder periodicScanConfiguration(PeriodicScanConfiguration var1);

        default public Builder periodicScanConfiguration(Consumer<PeriodicScanConfiguration.Builder> periodicScanConfiguration) {
            return this.periodicScanConfiguration((PeriodicScanConfiguration)((PeriodicScanConfiguration.Builder)PeriodicScanConfiguration.builder().applyMutation(periodicScanConfiguration)).build());
        }

        public Builder ruleSetCategoriesWithStrings(Collection<String> var1);

        public Builder ruleSetCategoriesWithStrings(String ... var1);

        public Builder ruleSetCategories(Collection<RuleSetCategory> var1);

        public Builder ruleSetCategories(RuleSetCategory ... var1);
    }
}

