/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.inspector2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.inspector2.model.CodeRepositoryOnDemandScan;
import software.amazon.awssdk.services.inspector2.model.ProjectCodeSecurityScanConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CodeRepositoryMetadata
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CodeRepositoryMetadata> {
    private static final SdkField<String> PROJECT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("projectName").getter(CodeRepositoryMetadata.getter(CodeRepositoryMetadata::projectName)).setter(CodeRepositoryMetadata.setter(Builder::projectName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("projectName").build()}).build();
    private static final SdkField<String> INTEGRATION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("integrationArn").getter(CodeRepositoryMetadata.getter(CodeRepositoryMetadata::integrationArn)).setter(CodeRepositoryMetadata.setter(Builder::integrationArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("integrationArn").build()}).build();
    private static final SdkField<String> PROVIDER_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("providerType").getter(CodeRepositoryMetadata.getter(CodeRepositoryMetadata::providerType)).setter(CodeRepositoryMetadata.setter(Builder::providerType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("providerType").build()}).build();
    private static final SdkField<String> PROVIDER_TYPE_VISIBILITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("providerTypeVisibility").getter(CodeRepositoryMetadata.getter(CodeRepositoryMetadata::providerTypeVisibility)).setter(CodeRepositoryMetadata.setter(Builder::providerTypeVisibility)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("providerTypeVisibility").build()}).build();
    private static final SdkField<String> LAST_SCANNED_COMMIT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("lastScannedCommitId").getter(CodeRepositoryMetadata.getter(CodeRepositoryMetadata::lastScannedCommitId)).setter(CodeRepositoryMetadata.setter(Builder::lastScannedCommitId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastScannedCommitId").build()}).build();
    private static final SdkField<ProjectCodeSecurityScanConfiguration> SCAN_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("scanConfiguration").getter(CodeRepositoryMetadata.getter(CodeRepositoryMetadata::scanConfiguration)).setter(CodeRepositoryMetadata.setter(Builder::scanConfiguration)).constructor(ProjectCodeSecurityScanConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scanConfiguration").build()}).build();
    private static final SdkField<CodeRepositoryOnDemandScan> ON_DEMAND_SCAN_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("onDemandScan").getter(CodeRepositoryMetadata.getter(CodeRepositoryMetadata::onDemandScan)).setter(CodeRepositoryMetadata.setter(Builder::onDemandScan)).constructor(CodeRepositoryOnDemandScan::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("onDemandScan").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROJECT_NAME_FIELD, INTEGRATION_ARN_FIELD, PROVIDER_TYPE_FIELD, PROVIDER_TYPE_VISIBILITY_FIELD, LAST_SCANNED_COMMIT_ID_FIELD, SCAN_CONFIGURATION_FIELD, ON_DEMAND_SCAN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CodeRepositoryMetadata.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String projectName;
    private final String integrationArn;
    private final String providerType;
    private final String providerTypeVisibility;
    private final String lastScannedCommitId;
    private final ProjectCodeSecurityScanConfiguration scanConfiguration;
    private final CodeRepositoryOnDemandScan onDemandScan;

    private CodeRepositoryMetadata(BuilderImpl builder) {
        this.projectName = builder.projectName;
        this.integrationArn = builder.integrationArn;
        this.providerType = builder.providerType;
        this.providerTypeVisibility = builder.providerTypeVisibility;
        this.lastScannedCommitId = builder.lastScannedCommitId;
        this.scanConfiguration = builder.scanConfiguration;
        this.onDemandScan = builder.onDemandScan;
    }

    public final String projectName() {
        return this.projectName;
    }

    public final String integrationArn() {
        return this.integrationArn;
    }

    public final String providerType() {
        return this.providerType;
    }

    public final String providerTypeVisibility() {
        return this.providerTypeVisibility;
    }

    public final String lastScannedCommitId() {
        return this.lastScannedCommitId;
    }

    public final ProjectCodeSecurityScanConfiguration scanConfiguration() {
        return this.scanConfiguration;
    }

    public final CodeRepositoryOnDemandScan onDemandScan() {
        return this.onDemandScan;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.projectName());
        hashCode = 31 * hashCode + Objects.hashCode(this.integrationArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.providerType());
        hashCode = 31 * hashCode + Objects.hashCode(this.providerTypeVisibility());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastScannedCommitId());
        hashCode = 31 * hashCode + Objects.hashCode(this.scanConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.onDemandScan());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CodeRepositoryMetadata)) {
            return false;
        }
        CodeRepositoryMetadata other = (CodeRepositoryMetadata)obj;
        return Objects.equals(this.projectName(), other.projectName()) && Objects.equals(this.integrationArn(), other.integrationArn()) && Objects.equals(this.providerType(), other.providerType()) && Objects.equals(this.providerTypeVisibility(), other.providerTypeVisibility()) && Objects.equals(this.lastScannedCommitId(), other.lastScannedCommitId()) && Objects.equals(this.scanConfiguration(), other.scanConfiguration()) && Objects.equals(this.onDemandScan(), other.onDemandScan());
    }

    public final String toString() {
        return ToString.builder((String)"CodeRepositoryMetadata").add("ProjectName", (Object)this.projectName()).add("IntegrationArn", (Object)this.integrationArn()).add("ProviderType", (Object)this.providerType()).add("ProviderTypeVisibility", (Object)this.providerTypeVisibility()).add("LastScannedCommitId", (Object)this.lastScannedCommitId()).add("ScanConfiguration", (Object)this.scanConfiguration()).add("OnDemandScan", (Object)this.onDemandScan()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "projectName": {
                return Optional.ofNullable(clazz.cast(this.projectName()));
            }
            case "integrationArn": {
                return Optional.ofNullable(clazz.cast(this.integrationArn()));
            }
            case "providerType": {
                return Optional.ofNullable(clazz.cast(this.providerType()));
            }
            case "providerTypeVisibility": {
                return Optional.ofNullable(clazz.cast(this.providerTypeVisibility()));
            }
            case "lastScannedCommitId": {
                return Optional.ofNullable(clazz.cast(this.lastScannedCommitId()));
            }
            case "scanConfiguration": {
                return Optional.ofNullable(clazz.cast(this.scanConfiguration()));
            }
            case "onDemandScan": {
                return Optional.ofNullable(clazz.cast(this.onDemandScan()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("projectName", PROJECT_NAME_FIELD);
        map.put("integrationArn", INTEGRATION_ARN_FIELD);
        map.put("providerType", PROVIDER_TYPE_FIELD);
        map.put("providerTypeVisibility", PROVIDER_TYPE_VISIBILITY_FIELD);
        map.put("lastScannedCommitId", LAST_SCANNED_COMMIT_ID_FIELD);
        map.put("scanConfiguration", SCAN_CONFIGURATION_FIELD);
        map.put("onDemandScan", ON_DEMAND_SCAN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CodeRepositoryMetadata, T> g) {
        return obj -> g.apply((CodeRepositoryMetadata)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String projectName;
        private String integrationArn;
        private String providerType;
        private String providerTypeVisibility;
        private String lastScannedCommitId;
        private ProjectCodeSecurityScanConfiguration scanConfiguration;
        private CodeRepositoryOnDemandScan onDemandScan;

        private BuilderImpl() {
        }

        private BuilderImpl(CodeRepositoryMetadata model) {
            this.projectName(model.projectName);
            this.integrationArn(model.integrationArn);
            this.providerType(model.providerType);
            this.providerTypeVisibility(model.providerTypeVisibility);
            this.lastScannedCommitId(model.lastScannedCommitId);
            this.scanConfiguration(model.scanConfiguration);
            this.onDemandScan(model.onDemandScan);
        }

        public final String getProjectName() {
            return this.projectName;
        }

        public final void setProjectName(String projectName) {
            this.projectName = projectName;
        }

        @Override
        public final Builder projectName(String projectName) {
            this.projectName = projectName;
            return this;
        }

        public final String getIntegrationArn() {
            return this.integrationArn;
        }

        public final void setIntegrationArn(String integrationArn) {
            this.integrationArn = integrationArn;
        }

        @Override
        public final Builder integrationArn(String integrationArn) {
            this.integrationArn = integrationArn;
            return this;
        }

        public final String getProviderType() {
            return this.providerType;
        }

        public final void setProviderType(String providerType) {
            this.providerType = providerType;
        }

        @Override
        public final Builder providerType(String providerType) {
            this.providerType = providerType;
            return this;
        }

        public final String getProviderTypeVisibility() {
            return this.providerTypeVisibility;
        }

        public final void setProviderTypeVisibility(String providerTypeVisibility) {
            this.providerTypeVisibility = providerTypeVisibility;
        }

        @Override
        public final Builder providerTypeVisibility(String providerTypeVisibility) {
            this.providerTypeVisibility = providerTypeVisibility;
            return this;
        }

        public final String getLastScannedCommitId() {
            return this.lastScannedCommitId;
        }

        public final void setLastScannedCommitId(String lastScannedCommitId) {
            this.lastScannedCommitId = lastScannedCommitId;
        }

        @Override
        public final Builder lastScannedCommitId(String lastScannedCommitId) {
            this.lastScannedCommitId = lastScannedCommitId;
            return this;
        }

        public final ProjectCodeSecurityScanConfiguration.Builder getScanConfiguration() {
            return this.scanConfiguration != null ? this.scanConfiguration.toBuilder() : null;
        }

        public final void setScanConfiguration(ProjectCodeSecurityScanConfiguration.BuilderImpl scanConfiguration) {
            this.scanConfiguration = scanConfiguration != null ? scanConfiguration.build() : null;
        }

        @Override
        public final Builder scanConfiguration(ProjectCodeSecurityScanConfiguration scanConfiguration) {
            this.scanConfiguration = scanConfiguration;
            return this;
        }

        public final CodeRepositoryOnDemandScan.Builder getOnDemandScan() {
            return this.onDemandScan != null ? this.onDemandScan.toBuilder() : null;
        }

        public final void setOnDemandScan(CodeRepositoryOnDemandScan.BuilderImpl onDemandScan) {
            this.onDemandScan = onDemandScan != null ? onDemandScan.build() : null;
        }

        @Override
        public final Builder onDemandScan(CodeRepositoryOnDemandScan onDemandScan) {
            this.onDemandScan = onDemandScan;
            return this;
        }

        public CodeRepositoryMetadata build() {
            return new CodeRepositoryMetadata(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CodeRepositoryMetadata> {
        public Builder projectName(String var1);

        public Builder integrationArn(String var1);

        public Builder providerType(String var1);

        public Builder providerTypeVisibility(String var1);

        public Builder lastScannedCommitId(String var1);

        public Builder scanConfiguration(ProjectCodeSecurityScanConfiguration var1);

        default public Builder scanConfiguration(Consumer<ProjectCodeSecurityScanConfiguration.Builder> scanConfiguration) {
            return this.scanConfiguration((ProjectCodeSecurityScanConfiguration)((ProjectCodeSecurityScanConfiguration.Builder)ProjectCodeSecurityScanConfiguration.builder().applyMutation(scanConfiguration)).build());
        }

        public Builder onDemandScan(CodeRepositoryOnDemandScan var1);

        default public Builder onDemandScan(Consumer<CodeRepositoryOnDemandScan.Builder> onDemandScan) {
            return this.onDemandScan((CodeRepositoryOnDemandScan)((CodeRepositoryOnDemandScan.Builder)CodeRepositoryOnDemandScan.builder().applyMutation(onDemandScan)).build());
        }
    }
}

