/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.inspector2.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ContinuousIntegrationScanEvent {
    PULL_REQUEST("PULL_REQUEST"),
    PUSH("PUSH"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ContinuousIntegrationScanEvent> VALUE_MAP;
    private final String value;

    private ContinuousIntegrationScanEvent(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ContinuousIntegrationScanEvent fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ContinuousIntegrationScanEvent> knownValues() {
        EnumSet<ContinuousIntegrationScanEvent> knownValues = EnumSet.allOf(ContinuousIntegrationScanEvent.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ContinuousIntegrationScanEvent.class, ContinuousIntegrationScanEvent::toString);
    }
}

