/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.inspector2.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.inspector2.model.AtigData;
import software.amazon.awssdk.services.inspector2.model.CisaData;
import software.amazon.awssdk.services.inspector2.model.Cvss2;
import software.amazon.awssdk.services.inspector2.model.Cvss3;
import software.amazon.awssdk.services.inspector2.model.CwesCopier;
import software.amazon.awssdk.services.inspector2.model.DetectionPlatformsCopier;
import software.amazon.awssdk.services.inspector2.model.Epss;
import software.amazon.awssdk.services.inspector2.model.ExploitObserved;
import software.amazon.awssdk.services.inspector2.model.RelatedVulnerabilitiesCopier;
import software.amazon.awssdk.services.inspector2.model.VulnerabilityReferenceUrlsCopier;
import software.amazon.awssdk.services.inspector2.model.VulnerabilitySource;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Vulnerability
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Vulnerability> {
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("id").getter(Vulnerability.getter(Vulnerability::id)).setter(Vulnerability.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()}).build();
    private static final SdkField<List<String>> CWES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("cwes").getter(Vulnerability.getter(Vulnerability::cwes)).setter(Vulnerability.setter(Builder::cwes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cwes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<CisaData> CISA_DATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("cisaData").getter(Vulnerability.getter(Vulnerability::cisaData)).setter(Vulnerability.setter(Builder::cisaData)).constructor(CisaData::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cisaData").build()}).build();
    private static final SdkField<String> SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("source").getter(Vulnerability.getter(Vulnerability::sourceAsString)).setter(Vulnerability.setter(Builder::source)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("source").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(Vulnerability.getter(Vulnerability::description)).setter(Vulnerability.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<AtigData> ATIG_DATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("atigData").getter(Vulnerability.getter(Vulnerability::atigData)).setter(Vulnerability.setter(Builder::atigData)).constructor(AtigData::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("atigData").build()}).build();
    private static final SdkField<String> VENDOR_SEVERITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("vendorSeverity").getter(Vulnerability.getter(Vulnerability::vendorSeverity)).setter(Vulnerability.setter(Builder::vendorSeverity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vendorSeverity").build()}).build();
    private static final SdkField<Cvss3> CVSS3_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("cvss3").getter(Vulnerability.getter(Vulnerability::cvss3)).setter(Vulnerability.setter(Builder::cvss3)).constructor(Cvss3::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cvss3").build()}).build();
    private static final SdkField<List<String>> RELATED_VULNERABILITIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("relatedVulnerabilities").getter(Vulnerability.getter(Vulnerability::relatedVulnerabilities)).setter(Vulnerability.setter(Builder::relatedVulnerabilities)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("relatedVulnerabilities").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Cvss2> CVSS2_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("cvss2").getter(Vulnerability.getter(Vulnerability::cvss2)).setter(Vulnerability.setter(Builder::cvss2)).constructor(Cvss2::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cvss2").build()}).build();
    private static final SdkField<Instant> VENDOR_CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("vendorCreatedAt").getter(Vulnerability.getter(Vulnerability::vendorCreatedAt)).setter(Vulnerability.setter(Builder::vendorCreatedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vendorCreatedAt").build()}).build();
    private static final SdkField<Instant> VENDOR_UPDATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("vendorUpdatedAt").getter(Vulnerability.getter(Vulnerability::vendorUpdatedAt)).setter(Vulnerability.setter(Builder::vendorUpdatedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vendorUpdatedAt").build()}).build();
    private static final SdkField<String> SOURCE_URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sourceUrl").getter(Vulnerability.getter(Vulnerability::sourceUrl)).setter(Vulnerability.setter(Builder::sourceUrl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceUrl").build()}).build();
    private static final SdkField<List<String>> REFERENCE_URLS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("referenceUrls").getter(Vulnerability.getter(Vulnerability::referenceUrls)).setter(Vulnerability.setter(Builder::referenceUrls)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("referenceUrls").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<ExploitObserved> EXPLOIT_OBSERVED_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("exploitObserved").getter(Vulnerability.getter(Vulnerability::exploitObserved)).setter(Vulnerability.setter(Builder::exploitObserved)).constructor(ExploitObserved::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("exploitObserved").build()}).build();
    private static final SdkField<List<String>> DETECTION_PLATFORMS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("detectionPlatforms").getter(Vulnerability.getter(Vulnerability::detectionPlatforms)).setter(Vulnerability.setter(Builder::detectionPlatforms)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("detectionPlatforms").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Epss> EPSS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("epss").getter(Vulnerability.getter(Vulnerability::epss)).setter(Vulnerability.setter(Builder::epss)).constructor(Epss::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("epss").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, CWES_FIELD, CISA_DATA_FIELD, SOURCE_FIELD, DESCRIPTION_FIELD, ATIG_DATA_FIELD, VENDOR_SEVERITY_FIELD, CVSS3_FIELD, RELATED_VULNERABILITIES_FIELD, CVSS2_FIELD, VENDOR_CREATED_AT_FIELD, VENDOR_UPDATED_AT_FIELD, SOURCE_URL_FIELD, REFERENCE_URLS_FIELD, EXPLOIT_OBSERVED_FIELD, DETECTION_PLATFORMS_FIELD, EPSS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Vulnerability.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String id;
    private final List<String> cwes;
    private final CisaData cisaData;
    private final String source;
    private final String description;
    private final AtigData atigData;
    private final String vendorSeverity;
    private final Cvss3 cvss3;
    private final List<String> relatedVulnerabilities;
    private final Cvss2 cvss2;
    private final Instant vendorCreatedAt;
    private final Instant vendorUpdatedAt;
    private final String sourceUrl;
    private final List<String> referenceUrls;
    private final ExploitObserved exploitObserved;
    private final List<String> detectionPlatforms;
    private final Epss epss;

    private Vulnerability(BuilderImpl builder) {
        this.id = builder.id;
        this.cwes = builder.cwes;
        this.cisaData = builder.cisaData;
        this.source = builder.source;
        this.description = builder.description;
        this.atigData = builder.atigData;
        this.vendorSeverity = builder.vendorSeverity;
        this.cvss3 = builder.cvss3;
        this.relatedVulnerabilities = builder.relatedVulnerabilities;
        this.cvss2 = builder.cvss2;
        this.vendorCreatedAt = builder.vendorCreatedAt;
        this.vendorUpdatedAt = builder.vendorUpdatedAt;
        this.sourceUrl = builder.sourceUrl;
        this.referenceUrls = builder.referenceUrls;
        this.exploitObserved = builder.exploitObserved;
        this.detectionPlatforms = builder.detectionPlatforms;
        this.epss = builder.epss;
    }

    public final String id() {
        return this.id;
    }

    public final boolean hasCwes() {
        return this.cwes != null && !(this.cwes instanceof SdkAutoConstructList);
    }

    public final List<String> cwes() {
        return this.cwes;
    }

    public final CisaData cisaData() {
        return this.cisaData;
    }

    public final VulnerabilitySource source() {
        return VulnerabilitySource.fromValue(this.source);
    }

    public final String sourceAsString() {
        return this.source;
    }

    public final String description() {
        return this.description;
    }

    public final AtigData atigData() {
        return this.atigData;
    }

    public final String vendorSeverity() {
        return this.vendorSeverity;
    }

    public final Cvss3 cvss3() {
        return this.cvss3;
    }

    public final boolean hasRelatedVulnerabilities() {
        return this.relatedVulnerabilities != null && !(this.relatedVulnerabilities instanceof SdkAutoConstructList);
    }

    public final List<String> relatedVulnerabilities() {
        return this.relatedVulnerabilities;
    }

    public final Cvss2 cvss2() {
        return this.cvss2;
    }

    public final Instant vendorCreatedAt() {
        return this.vendorCreatedAt;
    }

    public final Instant vendorUpdatedAt() {
        return this.vendorUpdatedAt;
    }

    public final String sourceUrl() {
        return this.sourceUrl;
    }

    public final boolean hasReferenceUrls() {
        return this.referenceUrls != null && !(this.referenceUrls instanceof SdkAutoConstructList);
    }

    public final List<String> referenceUrls() {
        return this.referenceUrls;
    }

    public final ExploitObserved exploitObserved() {
        return this.exploitObserved;
    }

    public final boolean hasDetectionPlatforms() {
        return this.detectionPlatforms != null && !(this.detectionPlatforms instanceof SdkAutoConstructList);
    }

    public final List<String> detectionPlatforms() {
        return this.detectionPlatforms;
    }

    public final Epss epss() {
        return this.epss;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCwes() ? this.cwes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.cisaData());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.atigData());
        hashCode = 31 * hashCode + Objects.hashCode(this.vendorSeverity());
        hashCode = 31 * hashCode + Objects.hashCode(this.cvss3());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRelatedVulnerabilities() ? this.relatedVulnerabilities() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.cvss2());
        hashCode = 31 * hashCode + Objects.hashCode(this.vendorCreatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.vendorUpdatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceUrl());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasReferenceUrls() ? this.referenceUrls() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.exploitObserved());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDetectionPlatforms() ? this.detectionPlatforms() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.epss());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Vulnerability)) {
            return false;
        }
        Vulnerability other = (Vulnerability)obj;
        return Objects.equals(this.id(), other.id()) && this.hasCwes() == other.hasCwes() && Objects.equals(this.cwes(), other.cwes()) && Objects.equals(this.cisaData(), other.cisaData()) && Objects.equals(this.sourceAsString(), other.sourceAsString()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.atigData(), other.atigData()) && Objects.equals(this.vendorSeverity(), other.vendorSeverity()) && Objects.equals(this.cvss3(), other.cvss3()) && this.hasRelatedVulnerabilities() == other.hasRelatedVulnerabilities() && Objects.equals(this.relatedVulnerabilities(), other.relatedVulnerabilities()) && Objects.equals(this.cvss2(), other.cvss2()) && Objects.equals(this.vendorCreatedAt(), other.vendorCreatedAt()) && Objects.equals(this.vendorUpdatedAt(), other.vendorUpdatedAt()) && Objects.equals(this.sourceUrl(), other.sourceUrl()) && this.hasReferenceUrls() == other.hasReferenceUrls() && Objects.equals(this.referenceUrls(), other.referenceUrls()) && Objects.equals(this.exploitObserved(), other.exploitObserved()) && this.hasDetectionPlatforms() == other.hasDetectionPlatforms() && Objects.equals(this.detectionPlatforms(), other.detectionPlatforms()) && Objects.equals(this.epss(), other.epss());
    }

    public final String toString() {
        return ToString.builder((String)"Vulnerability").add("Id", (Object)this.id()).add("Cwes", this.hasCwes() ? this.cwes() : null).add("CisaData", (Object)this.cisaData()).add("Source", (Object)this.sourceAsString()).add("Description", (Object)this.description()).add("AtigData", (Object)this.atigData()).add("VendorSeverity", (Object)this.vendorSeverity()).add("Cvss3", (Object)this.cvss3()).add("RelatedVulnerabilities", this.hasRelatedVulnerabilities() ? this.relatedVulnerabilities() : null).add("Cvss2", (Object)this.cvss2()).add("VendorCreatedAt", (Object)this.vendorCreatedAt()).add("VendorUpdatedAt", (Object)this.vendorUpdatedAt()).add("SourceUrl", (Object)this.sourceUrl()).add("ReferenceUrls", this.hasReferenceUrls() ? this.referenceUrls() : null).add("ExploitObserved", (Object)this.exploitObserved()).add("DetectionPlatforms", this.hasDetectionPlatforms() ? this.detectionPlatforms() : null).add("Epss", (Object)this.epss()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "cwes": {
                return Optional.ofNullable(clazz.cast(this.cwes()));
            }
            case "cisaData": {
                return Optional.ofNullable(clazz.cast(this.cisaData()));
            }
            case "source": {
                return Optional.ofNullable(clazz.cast(this.sourceAsString()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "atigData": {
                return Optional.ofNullable(clazz.cast(this.atigData()));
            }
            case "vendorSeverity": {
                return Optional.ofNullable(clazz.cast(this.vendorSeverity()));
            }
            case "cvss3": {
                return Optional.ofNullable(clazz.cast(this.cvss3()));
            }
            case "relatedVulnerabilities": {
                return Optional.ofNullable(clazz.cast(this.relatedVulnerabilities()));
            }
            case "cvss2": {
                return Optional.ofNullable(clazz.cast(this.cvss2()));
            }
            case "vendorCreatedAt": {
                return Optional.ofNullable(clazz.cast(this.vendorCreatedAt()));
            }
            case "vendorUpdatedAt": {
                return Optional.ofNullable(clazz.cast(this.vendorUpdatedAt()));
            }
            case "sourceUrl": {
                return Optional.ofNullable(clazz.cast(this.sourceUrl()));
            }
            case "referenceUrls": {
                return Optional.ofNullable(clazz.cast(this.referenceUrls()));
            }
            case "exploitObserved": {
                return Optional.ofNullable(clazz.cast(this.exploitObserved()));
            }
            case "detectionPlatforms": {
                return Optional.ofNullable(clazz.cast(this.detectionPlatforms()));
            }
            case "epss": {
                return Optional.ofNullable(clazz.cast(this.epss()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("id", ID_FIELD);
        map.put("cwes", CWES_FIELD);
        map.put("cisaData", CISA_DATA_FIELD);
        map.put("source", SOURCE_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("atigData", ATIG_DATA_FIELD);
        map.put("vendorSeverity", VENDOR_SEVERITY_FIELD);
        map.put("cvss3", CVSS3_FIELD);
        map.put("relatedVulnerabilities", RELATED_VULNERABILITIES_FIELD);
        map.put("cvss2", CVSS2_FIELD);
        map.put("vendorCreatedAt", VENDOR_CREATED_AT_FIELD);
        map.put("vendorUpdatedAt", VENDOR_UPDATED_AT_FIELD);
        map.put("sourceUrl", SOURCE_URL_FIELD);
        map.put("referenceUrls", REFERENCE_URLS_FIELD);
        map.put("exploitObserved", EXPLOIT_OBSERVED_FIELD);
        map.put("detectionPlatforms", DETECTION_PLATFORMS_FIELD);
        map.put("epss", EPSS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Vulnerability, T> g) {
        return obj -> g.apply((Vulnerability)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String id;
        private List<String> cwes = DefaultSdkAutoConstructList.getInstance();
        private CisaData cisaData;
        private String source;
        private String description;
        private AtigData atigData;
        private String vendorSeverity;
        private Cvss3 cvss3;
        private List<String> relatedVulnerabilities = DefaultSdkAutoConstructList.getInstance();
        private Cvss2 cvss2;
        private Instant vendorCreatedAt;
        private Instant vendorUpdatedAt;
        private String sourceUrl;
        private List<String> referenceUrls = DefaultSdkAutoConstructList.getInstance();
        private ExploitObserved exploitObserved;
        private List<String> detectionPlatforms = DefaultSdkAutoConstructList.getInstance();
        private Epss epss;

        private BuilderImpl() {
        }

        private BuilderImpl(Vulnerability model) {
            this.id(model.id);
            this.cwes(model.cwes);
            this.cisaData(model.cisaData);
            this.source(model.source);
            this.description(model.description);
            this.atigData(model.atigData);
            this.vendorSeverity(model.vendorSeverity);
            this.cvss3(model.cvss3);
            this.relatedVulnerabilities(model.relatedVulnerabilities);
            this.cvss2(model.cvss2);
            this.vendorCreatedAt(model.vendorCreatedAt);
            this.vendorUpdatedAt(model.vendorUpdatedAt);
            this.sourceUrl(model.sourceUrl);
            this.referenceUrls(model.referenceUrls);
            this.exploitObserved(model.exploitObserved);
            this.detectionPlatforms(model.detectionPlatforms);
            this.epss(model.epss);
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final Collection<String> getCwes() {
            if (this.cwes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.cwes;
        }

        public final void setCwes(Collection<String> cwes) {
            this.cwes = CwesCopier.copy(cwes);
        }

        @Override
        public final Builder cwes(Collection<String> cwes) {
            this.cwes = CwesCopier.copy(cwes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cwes(String ... cwes) {
            this.cwes(Arrays.asList(cwes));
            return this;
        }

        public final CisaData.Builder getCisaData() {
            return this.cisaData != null ? this.cisaData.toBuilder() : null;
        }

        public final void setCisaData(CisaData.BuilderImpl cisaData) {
            this.cisaData = cisaData != null ? cisaData.build() : null;
        }

        @Override
        public final Builder cisaData(CisaData cisaData) {
            this.cisaData = cisaData;
            return this;
        }

        public final String getSource() {
            return this.source;
        }

        public final void setSource(String source) {
            this.source = source;
        }

        @Override
        public final Builder source(String source) {
            this.source = source;
            return this;
        }

        @Override
        public final Builder source(VulnerabilitySource source) {
            this.source(source == null ? null : source.toString());
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final AtigData.Builder getAtigData() {
            return this.atigData != null ? this.atigData.toBuilder() : null;
        }

        public final void setAtigData(AtigData.BuilderImpl atigData) {
            this.atigData = atigData != null ? atigData.build() : null;
        }

        @Override
        public final Builder atigData(AtigData atigData) {
            this.atigData = atigData;
            return this;
        }

        public final String getVendorSeverity() {
            return this.vendorSeverity;
        }

        public final void setVendorSeverity(String vendorSeverity) {
            this.vendorSeverity = vendorSeverity;
        }

        @Override
        public final Builder vendorSeverity(String vendorSeverity) {
            this.vendorSeverity = vendorSeverity;
            return this;
        }

        public final Cvss3.Builder getCvss3() {
            return this.cvss3 != null ? this.cvss3.toBuilder() : null;
        }

        public final void setCvss3(Cvss3.BuilderImpl cvss3) {
            this.cvss3 = cvss3 != null ? cvss3.build() : null;
        }

        @Override
        public final Builder cvss3(Cvss3 cvss3) {
            this.cvss3 = cvss3;
            return this;
        }

        public final Collection<String> getRelatedVulnerabilities() {
            if (this.relatedVulnerabilities instanceof SdkAutoConstructList) {
                return null;
            }
            return this.relatedVulnerabilities;
        }

        public final void setRelatedVulnerabilities(Collection<String> relatedVulnerabilities) {
            this.relatedVulnerabilities = RelatedVulnerabilitiesCopier.copy(relatedVulnerabilities);
        }

        @Override
        public final Builder relatedVulnerabilities(Collection<String> relatedVulnerabilities) {
            this.relatedVulnerabilities = RelatedVulnerabilitiesCopier.copy(relatedVulnerabilities);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder relatedVulnerabilities(String ... relatedVulnerabilities) {
            this.relatedVulnerabilities(Arrays.asList(relatedVulnerabilities));
            return this;
        }

        public final Cvss2.Builder getCvss2() {
            return this.cvss2 != null ? this.cvss2.toBuilder() : null;
        }

        public final void setCvss2(Cvss2.BuilderImpl cvss2) {
            this.cvss2 = cvss2 != null ? cvss2.build() : null;
        }

        @Override
        public final Builder cvss2(Cvss2 cvss2) {
            this.cvss2 = cvss2;
            return this;
        }

        public final Instant getVendorCreatedAt() {
            return this.vendorCreatedAt;
        }

        public final void setVendorCreatedAt(Instant vendorCreatedAt) {
            this.vendorCreatedAt = vendorCreatedAt;
        }

        @Override
        public final Builder vendorCreatedAt(Instant vendorCreatedAt) {
            this.vendorCreatedAt = vendorCreatedAt;
            return this;
        }

        public final Instant getVendorUpdatedAt() {
            return this.vendorUpdatedAt;
        }

        public final void setVendorUpdatedAt(Instant vendorUpdatedAt) {
            this.vendorUpdatedAt = vendorUpdatedAt;
        }

        @Override
        public final Builder vendorUpdatedAt(Instant vendorUpdatedAt) {
            this.vendorUpdatedAt = vendorUpdatedAt;
            return this;
        }

        public final String getSourceUrl() {
            return this.sourceUrl;
        }

        public final void setSourceUrl(String sourceUrl) {
            this.sourceUrl = sourceUrl;
        }

        @Override
        public final Builder sourceUrl(String sourceUrl) {
            this.sourceUrl = sourceUrl;
            return this;
        }

        public final Collection<String> getReferenceUrls() {
            if (this.referenceUrls instanceof SdkAutoConstructList) {
                return null;
            }
            return this.referenceUrls;
        }

        public final void setReferenceUrls(Collection<String> referenceUrls) {
            this.referenceUrls = VulnerabilityReferenceUrlsCopier.copy(referenceUrls);
        }

        @Override
        public final Builder referenceUrls(Collection<String> referenceUrls) {
            this.referenceUrls = VulnerabilityReferenceUrlsCopier.copy(referenceUrls);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder referenceUrls(String ... referenceUrls) {
            this.referenceUrls(Arrays.asList(referenceUrls));
            return this;
        }

        public final ExploitObserved.Builder getExploitObserved() {
            return this.exploitObserved != null ? this.exploitObserved.toBuilder() : null;
        }

        public final void setExploitObserved(ExploitObserved.BuilderImpl exploitObserved) {
            this.exploitObserved = exploitObserved != null ? exploitObserved.build() : null;
        }

        @Override
        public final Builder exploitObserved(ExploitObserved exploitObserved) {
            this.exploitObserved = exploitObserved;
            return this;
        }

        public final Collection<String> getDetectionPlatforms() {
            if (this.detectionPlatforms instanceof SdkAutoConstructList) {
                return null;
            }
            return this.detectionPlatforms;
        }

        public final void setDetectionPlatforms(Collection<String> detectionPlatforms) {
            this.detectionPlatforms = DetectionPlatformsCopier.copy(detectionPlatforms);
        }

        @Override
        public final Builder detectionPlatforms(Collection<String> detectionPlatforms) {
            this.detectionPlatforms = DetectionPlatformsCopier.copy(detectionPlatforms);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder detectionPlatforms(String ... detectionPlatforms) {
            this.detectionPlatforms(Arrays.asList(detectionPlatforms));
            return this;
        }

        public final Epss.Builder getEpss() {
            return this.epss != null ? this.epss.toBuilder() : null;
        }

        public final void setEpss(Epss.BuilderImpl epss) {
            this.epss = epss != null ? epss.build() : null;
        }

        @Override
        public final Builder epss(Epss epss) {
            this.epss = epss;
            return this;
        }

        public Vulnerability build() {
            return new Vulnerability(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Vulnerability> {
        public Builder id(String var1);

        public Builder cwes(Collection<String> var1);

        public Builder cwes(String ... var1);

        public Builder cisaData(CisaData var1);

        default public Builder cisaData(Consumer<CisaData.Builder> cisaData) {
            return this.cisaData((CisaData)((CisaData.Builder)CisaData.builder().applyMutation(cisaData)).build());
        }

        public Builder source(String var1);

        public Builder source(VulnerabilitySource var1);

        public Builder description(String var1);

        public Builder atigData(AtigData var1);

        default public Builder atigData(Consumer<AtigData.Builder> atigData) {
            return this.atigData((AtigData)((AtigData.Builder)AtigData.builder().applyMutation(atigData)).build());
        }

        public Builder vendorSeverity(String var1);

        public Builder cvss3(Cvss3 var1);

        default public Builder cvss3(Consumer<Cvss3.Builder> cvss3) {
            return this.cvss3((Cvss3)((Cvss3.Builder)Cvss3.builder().applyMutation(cvss3)).build());
        }

        public Builder relatedVulnerabilities(Collection<String> var1);

        public Builder relatedVulnerabilities(String ... var1);

        public Builder cvss2(Cvss2 var1);

        default public Builder cvss2(Consumer<Cvss2.Builder> cvss2) {
            return this.cvss2((Cvss2)((Cvss2.Builder)Cvss2.builder().applyMutation(cvss2)).build());
        }

        public Builder vendorCreatedAt(Instant var1);

        public Builder vendorUpdatedAt(Instant var1);

        public Builder sourceUrl(String var1);

        public Builder referenceUrls(Collection<String> var1);

        public Builder referenceUrls(String ... var1);

        public Builder exploitObserved(ExploitObserved var1);

        default public Builder exploitObserved(Consumer<ExploitObserved.Builder> exploitObserved) {
            return this.exploitObserved((ExploitObserved)((ExploitObserved.Builder)ExploitObserved.builder().applyMutation(exploitObserved)).build());
        }

        public Builder detectionPlatforms(Collection<String> var1);

        public Builder detectionPlatforms(String ... var1);

        public Builder epss(Epss var1);

        default public Builder epss(Consumer<Epss.Builder> epss) {
            return this.epss((Epss)((Epss.Builder)Epss.builder().applyMutation(epss)).build());
        }
    }
}

