/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.inspector2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AutoEnable
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AutoEnable> {
    private static final SdkField<Boolean> CODE_REPOSITORY_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("codeRepository").getter(AutoEnable.getter(AutoEnable::codeRepository)).setter(AutoEnable.setter(Builder::codeRepository)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("codeRepository").build()}).build();
    private static final SdkField<Boolean> EC2_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("ec2").getter(AutoEnable.getter(AutoEnable::ec2)).setter(AutoEnable.setter(Builder::ec2)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ec2").build()}).build();
    private static final SdkField<Boolean> ECR_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("ecr").getter(AutoEnable.getter(AutoEnable::ecr)).setter(AutoEnable.setter(Builder::ecr)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ecr").build()}).build();
    private static final SdkField<Boolean> LAMBDA_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("lambda").getter(AutoEnable.getter(AutoEnable::lambda)).setter(AutoEnable.setter(Builder::lambda)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lambda").build()}).build();
    private static final SdkField<Boolean> LAMBDA_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("lambdaCode").getter(AutoEnable.getter(AutoEnable::lambdaCode)).setter(AutoEnable.setter(Builder::lambdaCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lambdaCode").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CODE_REPOSITORY_FIELD, EC2_FIELD, ECR_FIELD, LAMBDA_FIELD, LAMBDA_CODE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AutoEnable.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Boolean codeRepository;
    private final Boolean ec2;
    private final Boolean ecr;
    private final Boolean lambda;
    private final Boolean lambdaCode;

    private AutoEnable(BuilderImpl builder) {
        this.codeRepository = builder.codeRepository;
        this.ec2 = builder.ec2;
        this.ecr = builder.ecr;
        this.lambda = builder.lambda;
        this.lambdaCode = builder.lambdaCode;
    }

    public final Boolean codeRepository() {
        return this.codeRepository;
    }

    public final Boolean ec2() {
        return this.ec2;
    }

    public final Boolean ecr() {
        return this.ecr;
    }

    public final Boolean lambda() {
        return this.lambda;
    }

    public final Boolean lambdaCode() {
        return this.lambdaCode;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.codeRepository());
        hashCode = 31 * hashCode + Objects.hashCode(this.ec2());
        hashCode = 31 * hashCode + Objects.hashCode(this.ecr());
        hashCode = 31 * hashCode + Objects.hashCode(this.lambda());
        hashCode = 31 * hashCode + Objects.hashCode(this.lambdaCode());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AutoEnable)) {
            return false;
        }
        AutoEnable other = (AutoEnable)obj;
        return Objects.equals(this.codeRepository(), other.codeRepository()) && Objects.equals(this.ec2(), other.ec2()) && Objects.equals(this.ecr(), other.ecr()) && Objects.equals(this.lambda(), other.lambda()) && Objects.equals(this.lambdaCode(), other.lambdaCode());
    }

    public final String toString() {
        return ToString.builder((String)"AutoEnable").add("CodeRepository", (Object)this.codeRepository()).add("Ec2", (Object)this.ec2()).add("Ecr", (Object)this.ecr()).add("Lambda", (Object)this.lambda()).add("LambdaCode", (Object)this.lambdaCode()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "codeRepository": {
                return Optional.ofNullable(clazz.cast(this.codeRepository()));
            }
            case "ec2": {
                return Optional.ofNullable(clazz.cast(this.ec2()));
            }
            case "ecr": {
                return Optional.ofNullable(clazz.cast(this.ecr()));
            }
            case "lambda": {
                return Optional.ofNullable(clazz.cast(this.lambda()));
            }
            case "lambdaCode": {
                return Optional.ofNullable(clazz.cast(this.lambdaCode()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<Boolean>> map = new HashMap<String, SdkField<Boolean>>();
        map.put("codeRepository", CODE_REPOSITORY_FIELD);
        map.put("ec2", EC2_FIELD);
        map.put("ecr", ECR_FIELD);
        map.put("lambda", LAMBDA_FIELD);
        map.put("lambdaCode", LAMBDA_CODE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AutoEnable, T> g) {
        return obj -> g.apply((AutoEnable)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Boolean codeRepository;
        private Boolean ec2;
        private Boolean ecr;
        private Boolean lambda;
        private Boolean lambdaCode;

        private BuilderImpl() {
        }

        private BuilderImpl(AutoEnable model) {
            this.codeRepository(model.codeRepository);
            this.ec2(model.ec2);
            this.ecr(model.ecr);
            this.lambda(model.lambda);
            this.lambdaCode(model.lambdaCode);
        }

        public final Boolean getCodeRepository() {
            return this.codeRepository;
        }

        public final void setCodeRepository(Boolean codeRepository) {
            this.codeRepository = codeRepository;
        }

        @Override
        public final Builder codeRepository(Boolean codeRepository) {
            this.codeRepository = codeRepository;
            return this;
        }

        public final Boolean getEc2() {
            return this.ec2;
        }

        public final void setEc2(Boolean ec2) {
            this.ec2 = ec2;
        }

        @Override
        public final Builder ec2(Boolean ec2) {
            this.ec2 = ec2;
            return this;
        }

        public final Boolean getEcr() {
            return this.ecr;
        }

        public final void setEcr(Boolean ecr) {
            this.ecr = ecr;
        }

        @Override
        public final Builder ecr(Boolean ecr) {
            this.ecr = ecr;
            return this;
        }

        public final Boolean getLambda() {
            return this.lambda;
        }

        public final void setLambda(Boolean lambda) {
            this.lambda = lambda;
        }

        @Override
        public final Builder lambda(Boolean lambda) {
            this.lambda = lambda;
            return this;
        }

        public final Boolean getLambdaCode() {
            return this.lambdaCode;
        }

        public final void setLambdaCode(Boolean lambdaCode) {
            this.lambdaCode = lambdaCode;
        }

        @Override
        public final Builder lambdaCode(Boolean lambdaCode) {
            this.lambdaCode = lambdaCode;
            return this;
        }

        public AutoEnable build() {
            return new AutoEnable(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AutoEnable> {
        public Builder codeRepository(Boolean var1);

        public Builder ec2(Boolean var1);

        public Builder ecr(Boolean var1);

        public Builder lambda(Boolean var1);

        public Builder lambdaCode(Boolean var1);
    }
}

