/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.inspector2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.inspector2.model.CodeRepositorySortBy;
import software.amazon.awssdk.services.inspector2.model.SortOrder;
import software.amazon.awssdk.services.inspector2.model.StringFilter;
import software.amazon.awssdk.services.inspector2.model.StringFilterListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CodeRepositoryAggregation
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CodeRepositoryAggregation> {
    private static final SdkField<List<StringFilter>> PROJECT_NAMES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("projectNames").getter(CodeRepositoryAggregation.getter(CodeRepositoryAggregation::projectNames)).setter(CodeRepositoryAggregation.setter(Builder::projectNames)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("projectNames").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(StringFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<StringFilter>> PROVIDER_TYPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("providerTypes").getter(CodeRepositoryAggregation.getter(CodeRepositoryAggregation::providerTypes)).setter(CodeRepositoryAggregation.setter(Builder::providerTypes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("providerTypes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(StringFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<StringFilter>> RESOURCE_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("resourceIds").getter(CodeRepositoryAggregation.getter(CodeRepositoryAggregation::resourceIds)).setter(CodeRepositoryAggregation.setter(Builder::resourceIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(StringFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> SORT_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sortBy").getter(CodeRepositoryAggregation.getter(CodeRepositoryAggregation::sortByAsString)).setter(CodeRepositoryAggregation.setter(Builder::sortBy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sortBy").build()}).build();
    private static final SdkField<String> SORT_ORDER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sortOrder").getter(CodeRepositoryAggregation.getter(CodeRepositoryAggregation::sortOrderAsString)).setter(CodeRepositoryAggregation.setter(Builder::sortOrder)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sortOrder").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROJECT_NAMES_FIELD, PROVIDER_TYPES_FIELD, RESOURCE_IDS_FIELD, SORT_BY_FIELD, SORT_ORDER_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CodeRepositoryAggregation.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<StringFilter> projectNames;
    private final List<StringFilter> providerTypes;
    private final List<StringFilter> resourceIds;
    private final String sortBy;
    private final String sortOrder;

    private CodeRepositoryAggregation(BuilderImpl builder) {
        this.projectNames = builder.projectNames;
        this.providerTypes = builder.providerTypes;
        this.resourceIds = builder.resourceIds;
        this.sortBy = builder.sortBy;
        this.sortOrder = builder.sortOrder;
    }

    public final boolean hasProjectNames() {
        return this.projectNames != null && !(this.projectNames instanceof SdkAutoConstructList);
    }

    public final List<StringFilter> projectNames() {
        return this.projectNames;
    }

    public final boolean hasProviderTypes() {
        return this.providerTypes != null && !(this.providerTypes instanceof SdkAutoConstructList);
    }

    public final List<StringFilter> providerTypes() {
        return this.providerTypes;
    }

    public final boolean hasResourceIds() {
        return this.resourceIds != null && !(this.resourceIds instanceof SdkAutoConstructList);
    }

    public final List<StringFilter> resourceIds() {
        return this.resourceIds;
    }

    public final CodeRepositorySortBy sortBy() {
        return CodeRepositorySortBy.fromValue(this.sortBy);
    }

    public final String sortByAsString() {
        return this.sortBy;
    }

    public final SortOrder sortOrder() {
        return SortOrder.fromValue(this.sortOrder);
    }

    public final String sortOrderAsString() {
        return this.sortOrder;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasProjectNames() ? this.projectNames() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasProviderTypes() ? this.providerTypes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasResourceIds() ? this.resourceIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.sortByAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.sortOrderAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CodeRepositoryAggregation)) {
            return false;
        }
        CodeRepositoryAggregation other = (CodeRepositoryAggregation)obj;
        return this.hasProjectNames() == other.hasProjectNames() && Objects.equals(this.projectNames(), other.projectNames()) && this.hasProviderTypes() == other.hasProviderTypes() && Objects.equals(this.providerTypes(), other.providerTypes()) && this.hasResourceIds() == other.hasResourceIds() && Objects.equals(this.resourceIds(), other.resourceIds()) && Objects.equals(this.sortByAsString(), other.sortByAsString()) && Objects.equals(this.sortOrderAsString(), other.sortOrderAsString());
    }

    public final String toString() {
        return ToString.builder((String)"CodeRepositoryAggregation").add("ProjectNames", this.hasProjectNames() ? this.projectNames() : null).add("ProviderTypes", this.hasProviderTypes() ? this.providerTypes() : null).add("ResourceIds", this.hasResourceIds() ? this.resourceIds() : null).add("SortBy", (Object)this.sortByAsString()).add("SortOrder", (Object)this.sortOrderAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "projectNames": {
                return Optional.ofNullable(clazz.cast(this.projectNames()));
            }
            case "providerTypes": {
                return Optional.ofNullable(clazz.cast(this.providerTypes()));
            }
            case "resourceIds": {
                return Optional.ofNullable(clazz.cast(this.resourceIds()));
            }
            case "sortBy": {
                return Optional.ofNullable(clazz.cast(this.sortByAsString()));
            }
            case "sortOrder": {
                return Optional.ofNullable(clazz.cast(this.sortOrderAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("projectNames", PROJECT_NAMES_FIELD);
        map.put("providerTypes", PROVIDER_TYPES_FIELD);
        map.put("resourceIds", RESOURCE_IDS_FIELD);
        map.put("sortBy", SORT_BY_FIELD);
        map.put("sortOrder", SORT_ORDER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CodeRepositoryAggregation, T> g) {
        return obj -> g.apply((CodeRepositoryAggregation)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<StringFilter> projectNames = DefaultSdkAutoConstructList.getInstance();
        private List<StringFilter> providerTypes = DefaultSdkAutoConstructList.getInstance();
        private List<StringFilter> resourceIds = DefaultSdkAutoConstructList.getInstance();
        private String sortBy;
        private String sortOrder;

        private BuilderImpl() {
        }

        private BuilderImpl(CodeRepositoryAggregation model) {
            this.projectNames(model.projectNames);
            this.providerTypes(model.providerTypes);
            this.resourceIds(model.resourceIds);
            this.sortBy(model.sortBy);
            this.sortOrder(model.sortOrder);
        }

        public final List<StringFilter.Builder> getProjectNames() {
            List<StringFilter.Builder> result = StringFilterListCopier.copyToBuilder(this.projectNames);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setProjectNames(Collection<StringFilter.BuilderImpl> projectNames) {
            this.projectNames = StringFilterListCopier.copyFromBuilder(projectNames);
        }

        @Override
        public final Builder projectNames(Collection<StringFilter> projectNames) {
            this.projectNames = StringFilterListCopier.copy(projectNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder projectNames(StringFilter ... projectNames) {
            this.projectNames(Arrays.asList(projectNames));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder projectNames(Consumer<StringFilter.Builder> ... projectNames) {
            this.projectNames(Stream.of(projectNames).map(c -> (StringFilter)((StringFilter.Builder)StringFilter.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<StringFilter.Builder> getProviderTypes() {
            List<StringFilter.Builder> result = StringFilterListCopier.copyToBuilder(this.providerTypes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setProviderTypes(Collection<StringFilter.BuilderImpl> providerTypes) {
            this.providerTypes = StringFilterListCopier.copyFromBuilder(providerTypes);
        }

        @Override
        public final Builder providerTypes(Collection<StringFilter> providerTypes) {
            this.providerTypes = StringFilterListCopier.copy(providerTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder providerTypes(StringFilter ... providerTypes) {
            this.providerTypes(Arrays.asList(providerTypes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder providerTypes(Consumer<StringFilter.Builder> ... providerTypes) {
            this.providerTypes(Stream.of(providerTypes).map(c -> (StringFilter)((StringFilter.Builder)StringFilter.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<StringFilter.Builder> getResourceIds() {
            List<StringFilter.Builder> result = StringFilterListCopier.copyToBuilder(this.resourceIds);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setResourceIds(Collection<StringFilter.BuilderImpl> resourceIds) {
            this.resourceIds = StringFilterListCopier.copyFromBuilder(resourceIds);
        }

        @Override
        public final Builder resourceIds(Collection<StringFilter> resourceIds) {
            this.resourceIds = StringFilterListCopier.copy(resourceIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceIds(StringFilter ... resourceIds) {
            this.resourceIds(Arrays.asList(resourceIds));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceIds(Consumer<StringFilter.Builder> ... resourceIds) {
            this.resourceIds(Stream.of(resourceIds).map(c -> (StringFilter)((StringFilter.Builder)StringFilter.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getSortBy() {
            return this.sortBy;
        }

        public final void setSortBy(String sortBy) {
            this.sortBy = sortBy;
        }

        @Override
        public final Builder sortBy(String sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        @Override
        public final Builder sortBy(CodeRepositorySortBy sortBy) {
            this.sortBy(sortBy == null ? null : sortBy.toString());
            return this;
        }

        public final String getSortOrder() {
            return this.sortOrder;
        }

        public final void setSortOrder(String sortOrder) {
            this.sortOrder = sortOrder;
        }

        @Override
        public final Builder sortOrder(String sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        @Override
        public final Builder sortOrder(SortOrder sortOrder) {
            this.sortOrder(sortOrder == null ? null : sortOrder.toString());
            return this;
        }

        public CodeRepositoryAggregation build() {
            return new CodeRepositoryAggregation(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CodeRepositoryAggregation> {
        public Builder projectNames(Collection<StringFilter> var1);

        public Builder projectNames(StringFilter ... var1);

        public Builder projectNames(Consumer<StringFilter.Builder> ... var1);

        public Builder providerTypes(Collection<StringFilter> var1);

        public Builder providerTypes(StringFilter ... var1);

        public Builder providerTypes(Consumer<StringFilter.Builder> ... var1);

        public Builder resourceIds(Collection<StringFilter> var1);

        public Builder resourceIds(StringFilter ... var1);

        public Builder resourceIds(Consumer<StringFilter.Builder> ... var1);

        public Builder sortBy(String var1);

        public Builder sortBy(CodeRepositorySortBy var1);

        public Builder sortOrder(String var1);

        public Builder sortOrder(SortOrder var1);
    }
}

