/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.inspector2.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.inspector2.model.IntegrationStatus;
import software.amazon.awssdk.services.inspector2.model.IntegrationType;
import software.amazon.awssdk.services.inspector2.model.TagMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CodeSecurityIntegrationSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CodeSecurityIntegrationSummary> {
    private static final SdkField<Instant> CREATED_ON_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createdOn").getter(CodeSecurityIntegrationSummary.getter(CodeSecurityIntegrationSummary::createdOn)).setter(CodeSecurityIntegrationSummary.setter(Builder::createdOn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdOn").build()}).build();
    private static final SdkField<String> INTEGRATION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("integrationArn").getter(CodeSecurityIntegrationSummary.getter(CodeSecurityIntegrationSummary::integrationArn)).setter(CodeSecurityIntegrationSummary.setter(Builder::integrationArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("integrationArn").build()}).build();
    private static final SdkField<Instant> LAST_UPDATE_ON_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("lastUpdateOn").getter(CodeSecurityIntegrationSummary.getter(CodeSecurityIntegrationSummary::lastUpdateOn)).setter(CodeSecurityIntegrationSummary.setter(Builder::lastUpdateOn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdateOn").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(CodeSecurityIntegrationSummary.getter(CodeSecurityIntegrationSummary::name)).setter(CodeSecurityIntegrationSummary.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(CodeSecurityIntegrationSummary.getter(CodeSecurityIntegrationSummary::statusAsString)).setter(CodeSecurityIntegrationSummary.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<String> STATUS_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("statusReason").getter(CodeSecurityIntegrationSummary.getter(CodeSecurityIntegrationSummary::statusReason)).setter(CodeSecurityIntegrationSummary.setter(Builder::statusReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusReason").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(CodeSecurityIntegrationSummary.getter(CodeSecurityIntegrationSummary::tags)).setter(CodeSecurityIntegrationSummary.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("type").getter(CodeSecurityIntegrationSummary.getter(CodeSecurityIntegrationSummary::typeAsString)).setter(CodeSecurityIntegrationSummary.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREATED_ON_FIELD, INTEGRATION_ARN_FIELD, LAST_UPDATE_ON_FIELD, NAME_FIELD, STATUS_FIELD, STATUS_REASON_FIELD, TAGS_FIELD, TYPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CodeSecurityIntegrationSummary.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Instant createdOn;
    private final String integrationArn;
    private final Instant lastUpdateOn;
    private final String name;
    private final String status;
    private final String statusReason;
    private final Map<String, String> tags;
    private final String type;

    private CodeSecurityIntegrationSummary(BuilderImpl builder) {
        this.createdOn = builder.createdOn;
        this.integrationArn = builder.integrationArn;
        this.lastUpdateOn = builder.lastUpdateOn;
        this.name = builder.name;
        this.status = builder.status;
        this.statusReason = builder.statusReason;
        this.tags = builder.tags;
        this.type = builder.type;
    }

    public final Instant createdOn() {
        return this.createdOn;
    }

    public final String integrationArn() {
        return this.integrationArn;
    }

    public final Instant lastUpdateOn() {
        return this.lastUpdateOn;
    }

    public final String name() {
        return this.name;
    }

    public final IntegrationStatus status() {
        return IntegrationStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String statusReason() {
        return this.statusReason;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public final IntegrationType type() {
        return IntegrationType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.createdOn());
        hashCode = 31 * hashCode + Objects.hashCode(this.integrationArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdateOn());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusReason());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CodeSecurityIntegrationSummary)) {
            return false;
        }
        CodeSecurityIntegrationSummary other = (CodeSecurityIntegrationSummary)obj;
        return Objects.equals(this.createdOn(), other.createdOn()) && Objects.equals(this.integrationArn(), other.integrationArn()) && Objects.equals(this.lastUpdateOn(), other.lastUpdateOn()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.statusReason(), other.statusReason()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.typeAsString(), other.typeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"CodeSecurityIntegrationSummary").add("CreatedOn", (Object)this.createdOn()).add("IntegrationArn", (Object)this.integrationArn()).add("LastUpdateOn", (Object)this.lastUpdateOn()).add("Name", (Object)this.name()).add("Status", (Object)this.statusAsString()).add("StatusReason", (Object)this.statusReason()).add("Tags", this.hasTags() ? this.tags() : null).add("Type", (Object)this.typeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "createdOn": {
                return Optional.ofNullable(clazz.cast(this.createdOn()));
            }
            case "integrationArn": {
                return Optional.ofNullable(clazz.cast(this.integrationArn()));
            }
            case "lastUpdateOn": {
                return Optional.ofNullable(clazz.cast(this.lastUpdateOn()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "statusReason": {
                return Optional.ofNullable(clazz.cast(this.statusReason()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("createdOn", CREATED_ON_FIELD);
        map.put("integrationArn", INTEGRATION_ARN_FIELD);
        map.put("lastUpdateOn", LAST_UPDATE_ON_FIELD);
        map.put("name", NAME_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("statusReason", STATUS_REASON_FIELD);
        map.put("tags", TAGS_FIELD);
        map.put("type", TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CodeSecurityIntegrationSummary, T> g) {
        return obj -> g.apply((CodeSecurityIntegrationSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Instant createdOn;
        private String integrationArn;
        private Instant lastUpdateOn;
        private String name;
        private String status;
        private String statusReason;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();
        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(CodeSecurityIntegrationSummary model) {
            this.createdOn(model.createdOn);
            this.integrationArn(model.integrationArn);
            this.lastUpdateOn(model.lastUpdateOn);
            this.name(model.name);
            this.status(model.status);
            this.statusReason(model.statusReason);
            this.tags(model.tags);
            this.type(model.type);
        }

        public final Instant getCreatedOn() {
            return this.createdOn;
        }

        public final void setCreatedOn(Instant createdOn) {
            this.createdOn = createdOn;
        }

        @Override
        public final Builder createdOn(Instant createdOn) {
            this.createdOn = createdOn;
            return this;
        }

        public final String getIntegrationArn() {
            return this.integrationArn;
        }

        public final void setIntegrationArn(String integrationArn) {
            this.integrationArn = integrationArn;
        }

        @Override
        public final Builder integrationArn(String integrationArn) {
            this.integrationArn = integrationArn;
            return this;
        }

        public final Instant getLastUpdateOn() {
            return this.lastUpdateOn;
        }

        public final void setLastUpdateOn(Instant lastUpdateOn) {
            this.lastUpdateOn = lastUpdateOn;
        }

        @Override
        public final Builder lastUpdateOn(Instant lastUpdateOn) {
            this.lastUpdateOn = lastUpdateOn;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(IntegrationStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getStatusReason() {
            return this.statusReason;
        }

        public final void setStatusReason(String statusReason) {
            this.statusReason = statusReason;
        }

        @Override
        public final Builder statusReason(String statusReason) {
            this.statusReason = statusReason;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(IntegrationType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public CodeSecurityIntegrationSummary build() {
            return new CodeSecurityIntegrationSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CodeSecurityIntegrationSummary> {
        public Builder createdOn(Instant var1);

        public Builder integrationArn(String var1);

        public Builder lastUpdateOn(Instant var1);

        public Builder name(String var1);

        public Builder status(String var1);

        public Builder status(IntegrationStatus var1);

        public Builder statusReason(String var1);

        public Builder tags(Map<String, String> var1);

        public Builder type(String var1);

        public Builder type(IntegrationType var1);
    }
}

