/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.inspector2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.inspector2.model.CodeSecurityScanConfiguration;
import software.amazon.awssdk.services.inspector2.model.ConfigurationLevel;
import software.amazon.awssdk.services.inspector2.model.Inspector2Request;
import software.amazon.awssdk.services.inspector2.model.ScopeSettings;
import software.amazon.awssdk.services.inspector2.model.TagMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateCodeSecurityScanConfigurationRequest
extends Inspector2Request
implements ToCopyableBuilder<Builder, CreateCodeSecurityScanConfigurationRequest> {
    private static final SdkField<CodeSecurityScanConfiguration> CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("configuration").getter(CreateCodeSecurityScanConfigurationRequest.getter(CreateCodeSecurityScanConfigurationRequest::configuration)).setter(CreateCodeSecurityScanConfigurationRequest.setter(Builder::configuration)).constructor(CodeSecurityScanConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configuration").build()}).build();
    private static final SdkField<String> LEVEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("level").getter(CreateCodeSecurityScanConfigurationRequest.getter(CreateCodeSecurityScanConfigurationRequest::levelAsString)).setter(CreateCodeSecurityScanConfigurationRequest.setter(Builder::level)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("level").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(CreateCodeSecurityScanConfigurationRequest.getter(CreateCodeSecurityScanConfigurationRequest::name)).setter(CreateCodeSecurityScanConfigurationRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<ScopeSettings> SCOPE_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("scopeSettings").getter(CreateCodeSecurityScanConfigurationRequest.getter(CreateCodeSecurityScanConfigurationRequest::scopeSettings)).setter(CreateCodeSecurityScanConfigurationRequest.setter(Builder::scopeSettings)).constructor(ScopeSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scopeSettings").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(CreateCodeSecurityScanConfigurationRequest.getter(CreateCodeSecurityScanConfigurationRequest::tags)).setter(CreateCodeSecurityScanConfigurationRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONFIGURATION_FIELD, LEVEL_FIELD, NAME_FIELD, SCOPE_SETTINGS_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateCodeSecurityScanConfigurationRequest.memberNameToFieldInitializer();
    private final CodeSecurityScanConfiguration configuration;
    private final String level;
    private final String name;
    private final ScopeSettings scopeSettings;
    private final Map<String, String> tags;

    private CreateCodeSecurityScanConfigurationRequest(BuilderImpl builder) {
        super(builder);
        this.configuration = builder.configuration;
        this.level = builder.level;
        this.name = builder.name;
        this.scopeSettings = builder.scopeSettings;
        this.tags = builder.tags;
    }

    public final CodeSecurityScanConfiguration configuration() {
        return this.configuration;
    }

    public final ConfigurationLevel level() {
        return ConfigurationLevel.fromValue(this.level);
    }

    public final String levelAsString() {
        return this.level;
    }

    public final String name() {
        return this.name;
    }

    public final ScopeSettings scopeSettings() {
        return this.scopeSettings;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.configuration());
        hashCode = 31 * hashCode + Objects.hashCode(this.levelAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.scopeSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateCodeSecurityScanConfigurationRequest)) {
            return false;
        }
        CreateCodeSecurityScanConfigurationRequest other = (CreateCodeSecurityScanConfigurationRequest)((Object)obj);
        return Objects.equals(this.configuration(), other.configuration()) && Objects.equals(this.levelAsString(), other.levelAsString()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.scopeSettings(), other.scopeSettings()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"CreateCodeSecurityScanConfigurationRequest").add("Configuration", (Object)this.configuration()).add("Level", (Object)this.levelAsString()).add("Name", (Object)this.name()).add("ScopeSettings", (Object)this.scopeSettings()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "configuration": {
                return Optional.ofNullable(clazz.cast(this.configuration()));
            }
            case "level": {
                return Optional.ofNullable(clazz.cast(this.levelAsString()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "scopeSettings": {
                return Optional.ofNullable(clazz.cast(this.scopeSettings()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("configuration", CONFIGURATION_FIELD);
        map.put("level", LEVEL_FIELD);
        map.put("name", NAME_FIELD);
        map.put("scopeSettings", SCOPE_SETTINGS_FIELD);
        map.put("tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateCodeSecurityScanConfigurationRequest, T> g) {
        return obj -> g.apply((CreateCodeSecurityScanConfigurationRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Inspector2Request.BuilderImpl
    implements Builder {
        private CodeSecurityScanConfiguration configuration;
        private String level;
        private String name;
        private ScopeSettings scopeSettings;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateCodeSecurityScanConfigurationRequest model) {
            super(model);
            this.configuration(model.configuration);
            this.level(model.level);
            this.name(model.name);
            this.scopeSettings(model.scopeSettings);
            this.tags(model.tags);
        }

        public final CodeSecurityScanConfiguration.Builder getConfiguration() {
            return this.configuration != null ? this.configuration.toBuilder() : null;
        }

        public final void setConfiguration(CodeSecurityScanConfiguration.BuilderImpl configuration) {
            this.configuration = configuration != null ? configuration.build() : null;
        }

        @Override
        public final Builder configuration(CodeSecurityScanConfiguration configuration) {
            this.configuration = configuration;
            return this;
        }

        public final String getLevel() {
            return this.level;
        }

        public final void setLevel(String level) {
            this.level = level;
        }

        @Override
        public final Builder level(String level) {
            this.level = level;
            return this;
        }

        @Override
        public final Builder level(ConfigurationLevel level) {
            this.level(level == null ? null : level.toString());
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final ScopeSettings.Builder getScopeSettings() {
            return this.scopeSettings != null ? this.scopeSettings.toBuilder() : null;
        }

        public final void setScopeSettings(ScopeSettings.BuilderImpl scopeSettings) {
            this.scopeSettings = scopeSettings != null ? scopeSettings.build() : null;
        }

        @Override
        public final Builder scopeSettings(ScopeSettings scopeSettings) {
            this.scopeSettings = scopeSettings;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateCodeSecurityScanConfigurationRequest build() {
            return new CreateCodeSecurityScanConfigurationRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends Inspector2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateCodeSecurityScanConfigurationRequest> {
        public Builder configuration(CodeSecurityScanConfiguration var1);

        default public Builder configuration(Consumer<CodeSecurityScanConfiguration.Builder> configuration) {
            return this.configuration((CodeSecurityScanConfiguration)((CodeSecurityScanConfiguration.Builder)CodeSecurityScanConfiguration.builder().applyMutation(configuration)).build());
        }

        public Builder level(String var1);

        public Builder level(ConfigurationLevel var1);

        public Builder name(String var1);

        public Builder scopeSettings(ScopeSettings var1);

        default public Builder scopeSettings(Consumer<ScopeSettings.Builder> scopeSettings) {
            return this.scopeSettings((ScopeSettings)((ScopeSettings.Builder)ScopeSettings.builder().applyMutation(scopeSettings)).build());
        }

        public Builder tags(Map<String, String> var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

