/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.inspector2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.inspector2.model.SeverityCounts;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ImageLayerAggregationResponse
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ImageLayerAggregationResponse> {
    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("accountId").getter(ImageLayerAggregationResponse.getter(ImageLayerAggregationResponse::accountId)).setter(ImageLayerAggregationResponse.setter(Builder::accountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accountId").build()}).build();
    private static final SdkField<String> LAYER_HASH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("layerHash").getter(ImageLayerAggregationResponse.getter(ImageLayerAggregationResponse::layerHash)).setter(ImageLayerAggregationResponse.setter(Builder::layerHash)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("layerHash").build()}).build();
    private static final SdkField<String> REPOSITORY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("repository").getter(ImageLayerAggregationResponse.getter(ImageLayerAggregationResponse::repository)).setter(ImageLayerAggregationResponse.setter(Builder::repository)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("repository").build()}).build();
    private static final SdkField<String> RESOURCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("resourceId").getter(ImageLayerAggregationResponse.getter(ImageLayerAggregationResponse::resourceId)).setter(ImageLayerAggregationResponse.setter(Builder::resourceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceId").build()}).build();
    private static final SdkField<SeverityCounts> SEVERITY_COUNTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("severityCounts").getter(ImageLayerAggregationResponse.getter(ImageLayerAggregationResponse::severityCounts)).setter(ImageLayerAggregationResponse.setter(Builder::severityCounts)).constructor(SeverityCounts::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("severityCounts").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_ID_FIELD, LAYER_HASH_FIELD, REPOSITORY_FIELD, RESOURCE_ID_FIELD, SEVERITY_COUNTS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ImageLayerAggregationResponse.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String accountId;
    private final String layerHash;
    private final String repository;
    private final String resourceId;
    private final SeverityCounts severityCounts;

    private ImageLayerAggregationResponse(BuilderImpl builder) {
        this.accountId = builder.accountId;
        this.layerHash = builder.layerHash;
        this.repository = builder.repository;
        this.resourceId = builder.resourceId;
        this.severityCounts = builder.severityCounts;
    }

    public final String accountId() {
        return this.accountId;
    }

    public final String layerHash() {
        return this.layerHash;
    }

    public final String repository() {
        return this.repository;
    }

    public final String resourceId() {
        return this.resourceId;
    }

    public final SeverityCounts severityCounts() {
        return this.severityCounts;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.accountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.layerHash());
        hashCode = 31 * hashCode + Objects.hashCode(this.repository());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.severityCounts());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ImageLayerAggregationResponse)) {
            return false;
        }
        ImageLayerAggregationResponse other = (ImageLayerAggregationResponse)obj;
        return Objects.equals(this.accountId(), other.accountId()) && Objects.equals(this.layerHash(), other.layerHash()) && Objects.equals(this.repository(), other.repository()) && Objects.equals(this.resourceId(), other.resourceId()) && Objects.equals(this.severityCounts(), other.severityCounts());
    }

    public final String toString() {
        return ToString.builder((String)"ImageLayerAggregationResponse").add("AccountId", (Object)this.accountId()).add("LayerHash", (Object)this.layerHash()).add("Repository", (Object)this.repository()).add("ResourceId", (Object)this.resourceId()).add("SeverityCounts", (Object)this.severityCounts()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "accountId": {
                return Optional.ofNullable(clazz.cast(this.accountId()));
            }
            case "layerHash": {
                return Optional.ofNullable(clazz.cast(this.layerHash()));
            }
            case "repository": {
                return Optional.ofNullable(clazz.cast(this.repository()));
            }
            case "resourceId": {
                return Optional.ofNullable(clazz.cast(this.resourceId()));
            }
            case "severityCounts": {
                return Optional.ofNullable(clazz.cast(this.severityCounts()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("accountId", ACCOUNT_ID_FIELD);
        map.put("layerHash", LAYER_HASH_FIELD);
        map.put("repository", REPOSITORY_FIELD);
        map.put("resourceId", RESOURCE_ID_FIELD);
        map.put("severityCounts", SEVERITY_COUNTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ImageLayerAggregationResponse, T> g) {
        return obj -> g.apply((ImageLayerAggregationResponse)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String accountId;
        private String layerHash;
        private String repository;
        private String resourceId;
        private SeverityCounts severityCounts;

        private BuilderImpl() {
        }

        private BuilderImpl(ImageLayerAggregationResponse model) {
            this.accountId(model.accountId);
            this.layerHash(model.layerHash);
            this.repository(model.repository);
            this.resourceId(model.resourceId);
            this.severityCounts(model.severityCounts);
        }

        public final String getAccountId() {
            return this.accountId;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final String getLayerHash() {
            return this.layerHash;
        }

        public final void setLayerHash(String layerHash) {
            this.layerHash = layerHash;
        }

        @Override
        public final Builder layerHash(String layerHash) {
            this.layerHash = layerHash;
            return this;
        }

        public final String getRepository() {
            return this.repository;
        }

        public final void setRepository(String repository) {
            this.repository = repository;
        }

        @Override
        public final Builder repository(String repository) {
            this.repository = repository;
            return this;
        }

        public final String getResourceId() {
            return this.resourceId;
        }

        public final void setResourceId(String resourceId) {
            this.resourceId = resourceId;
        }

        @Override
        public final Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            return this;
        }

        public final SeverityCounts.Builder getSeverityCounts() {
            return this.severityCounts != null ? this.severityCounts.toBuilder() : null;
        }

        public final void setSeverityCounts(SeverityCounts.BuilderImpl severityCounts) {
            this.severityCounts = severityCounts != null ? severityCounts.build() : null;
        }

        @Override
        public final Builder severityCounts(SeverityCounts severityCounts) {
            this.severityCounts = severityCounts;
            return this;
        }

        public ImageLayerAggregationResponse build() {
            return new ImageLayerAggregationResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ImageLayerAggregationResponse> {
        public Builder accountId(String var1);

        public Builder layerHash(String var1);

        public Builder repository(String var1);

        public Builder resourceId(String var1);

        public Builder severityCounts(SeverityCounts var1);

        default public Builder severityCounts(Consumer<SeverityCounts.Builder> severityCounts) {
            return this.severityCounts((SeverityCounts)((SeverityCounts.Builder)SeverityCounts.builder().applyMutation(severityCounts)).build());
        }
    }
}

