/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.inspector2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.inspector2.model.AggregationRequest;
import software.amazon.awssdk.services.inspector2.model.AggregationType;
import software.amazon.awssdk.services.inspector2.model.Inspector2Request;
import software.amazon.awssdk.services.inspector2.model.StringFilter;
import software.amazon.awssdk.services.inspector2.model.StringFilterListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListFindingAggregationsRequest
extends Inspector2Request
implements ToCopyableBuilder<Builder, ListFindingAggregationsRequest> {
    private static final SdkField<List<StringFilter>> ACCOUNT_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("accountIds").getter(ListFindingAggregationsRequest.getter(ListFindingAggregationsRequest::accountIds)).setter(ListFindingAggregationsRequest.setter(Builder::accountIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accountIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(StringFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<AggregationRequest> AGGREGATION_REQUEST_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("aggregationRequest").getter(ListFindingAggregationsRequest.getter(ListFindingAggregationsRequest::aggregationRequest)).setter(ListFindingAggregationsRequest.setter(Builder::aggregationRequest)).constructor(AggregationRequest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("aggregationRequest").build()}).build();
    private static final SdkField<String> AGGREGATION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("aggregationType").getter(ListFindingAggregationsRequest.getter(ListFindingAggregationsRequest::aggregationTypeAsString)).setter(ListFindingAggregationsRequest.setter(Builder::aggregationType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("aggregationType").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("maxResults").getter(ListFindingAggregationsRequest.getter(ListFindingAggregationsRequest::maxResults)).setter(ListFindingAggregationsRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxResults").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListFindingAggregationsRequest.getter(ListFindingAggregationsRequest::nextToken)).setter(ListFindingAggregationsRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_IDS_FIELD, AGGREGATION_REQUEST_FIELD, AGGREGATION_TYPE_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListFindingAggregationsRequest.memberNameToFieldInitializer();
    private final List<StringFilter> accountIds;
    private final AggregationRequest aggregationRequest;
    private final String aggregationType;
    private final Integer maxResults;
    private final String nextToken;

    private ListFindingAggregationsRequest(BuilderImpl builder) {
        super(builder);
        this.accountIds = builder.accountIds;
        this.aggregationRequest = builder.aggregationRequest;
        this.aggregationType = builder.aggregationType;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasAccountIds() {
        return this.accountIds != null && !(this.accountIds instanceof SdkAutoConstructList);
    }

    public final List<StringFilter> accountIds() {
        return this.accountIds;
    }

    public final AggregationRequest aggregationRequest() {
        return this.aggregationRequest;
    }

    public final AggregationType aggregationType() {
        return AggregationType.fromValue(this.aggregationType);
    }

    public final String aggregationTypeAsString() {
        return this.aggregationType;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAccountIds() ? this.accountIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.aggregationRequest());
        hashCode = 31 * hashCode + Objects.hashCode(this.aggregationTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListFindingAggregationsRequest)) {
            return false;
        }
        ListFindingAggregationsRequest other = (ListFindingAggregationsRequest)((Object)obj);
        return this.hasAccountIds() == other.hasAccountIds() && Objects.equals(this.accountIds(), other.accountIds()) && Objects.equals(this.aggregationRequest(), other.aggregationRequest()) && Objects.equals(this.aggregationTypeAsString(), other.aggregationTypeAsString()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListFindingAggregationsRequest").add("AccountIds", this.hasAccountIds() ? this.accountIds() : null).add("AggregationRequest", (Object)this.aggregationRequest()).add("AggregationType", (Object)this.aggregationTypeAsString()).add("MaxResults", (Object)this.maxResults()).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "accountIds": {
                return Optional.ofNullable(clazz.cast(this.accountIds()));
            }
            case "aggregationRequest": {
                return Optional.ofNullable(clazz.cast(this.aggregationRequest()));
            }
            case "aggregationType": {
                return Optional.ofNullable(clazz.cast(this.aggregationTypeAsString()));
            }
            case "maxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("accountIds", ACCOUNT_IDS_FIELD);
        map.put("aggregationRequest", AGGREGATION_REQUEST_FIELD);
        map.put("aggregationType", AGGREGATION_TYPE_FIELD);
        map.put("maxResults", MAX_RESULTS_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListFindingAggregationsRequest, T> g) {
        return obj -> g.apply((ListFindingAggregationsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Inspector2Request.BuilderImpl
    implements Builder {
        private List<StringFilter> accountIds = DefaultSdkAutoConstructList.getInstance();
        private AggregationRequest aggregationRequest;
        private String aggregationType;
        private Integer maxResults;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListFindingAggregationsRequest model) {
            super(model);
            this.accountIds(model.accountIds);
            this.aggregationRequest(model.aggregationRequest);
            this.aggregationType(model.aggregationType);
            this.maxResults(model.maxResults);
            this.nextToken(model.nextToken);
        }

        public final List<StringFilter.Builder> getAccountIds() {
            List<StringFilter.Builder> result = StringFilterListCopier.copyToBuilder(this.accountIds);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAccountIds(Collection<StringFilter.BuilderImpl> accountIds) {
            this.accountIds = StringFilterListCopier.copyFromBuilder(accountIds);
        }

        @Override
        public final Builder accountIds(Collection<StringFilter> accountIds) {
            this.accountIds = StringFilterListCopier.copy(accountIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accountIds(StringFilter ... accountIds) {
            this.accountIds(Arrays.asList(accountIds));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accountIds(Consumer<StringFilter.Builder> ... accountIds) {
            this.accountIds(Stream.of(accountIds).map(c -> (StringFilter)((StringFilter.Builder)StringFilter.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final AggregationRequest.Builder getAggregationRequest() {
            return this.aggregationRequest != null ? this.aggregationRequest.toBuilder() : null;
        }

        public final void setAggregationRequest(AggregationRequest.BuilderImpl aggregationRequest) {
            this.aggregationRequest = aggregationRequest != null ? aggregationRequest.build() : null;
        }

        @Override
        public final Builder aggregationRequest(AggregationRequest aggregationRequest) {
            this.aggregationRequest = aggregationRequest;
            return this;
        }

        public final String getAggregationType() {
            return this.aggregationType;
        }

        public final void setAggregationType(String aggregationType) {
            this.aggregationType = aggregationType;
        }

        @Override
        public final Builder aggregationType(String aggregationType) {
            this.aggregationType = aggregationType;
            return this;
        }

        @Override
        public final Builder aggregationType(AggregationType aggregationType) {
            this.aggregationType(aggregationType == null ? null : aggregationType.toString());
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListFindingAggregationsRequest build() {
            return new ListFindingAggregationsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends Inspector2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListFindingAggregationsRequest> {
        public Builder accountIds(Collection<StringFilter> var1);

        public Builder accountIds(StringFilter ... var1);

        public Builder accountIds(Consumer<StringFilter.Builder> ... var1);

        public Builder aggregationRequest(AggregationRequest var1);

        default public Builder aggregationRequest(Consumer<AggregationRequest.Builder> aggregationRequest) {
            return this.aggregationRequest((AggregationRequest)((AggregationRequest.Builder)AggregationRequest.builder().applyMutation(aggregationRequest)).build());
        }

        public Builder aggregationType(String var1);

        public Builder aggregationType(AggregationType var1);

        public Builder maxResults(Integer var1);

        public Builder nextToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

