/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.inspector2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.inspector2.model.ContinuousIntegrationScanEvent;
import software.amazon.awssdk.services.inspector2.model.RuleSetCategoriesCopier;
import software.amazon.awssdk.services.inspector2.model.RuleSetCategory;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ProjectContinuousIntegrationScanConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ProjectContinuousIntegrationScanConfiguration> {
    private static final SdkField<List<String>> RULE_SET_CATEGORIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ruleSetCategories").getter(ProjectContinuousIntegrationScanConfiguration.getter(ProjectContinuousIntegrationScanConfiguration::ruleSetCategoriesAsStrings)).setter(ProjectContinuousIntegrationScanConfiguration.setter(Builder::ruleSetCategoriesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ruleSetCategories").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> SUPPORTED_EVENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("supportedEvent").getter(ProjectContinuousIntegrationScanConfiguration.getter(ProjectContinuousIntegrationScanConfiguration::supportedEventAsString)).setter(ProjectContinuousIntegrationScanConfiguration.setter(Builder::supportedEvent)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("supportedEvent").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RULE_SET_CATEGORIES_FIELD, SUPPORTED_EVENT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ProjectContinuousIntegrationScanConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<String> ruleSetCategories;
    private final String supportedEvent;

    private ProjectContinuousIntegrationScanConfiguration(BuilderImpl builder) {
        this.ruleSetCategories = builder.ruleSetCategories;
        this.supportedEvent = builder.supportedEvent;
    }

    public final List<RuleSetCategory> ruleSetCategories() {
        return RuleSetCategoriesCopier.copyStringToEnum(this.ruleSetCategories);
    }

    public final boolean hasRuleSetCategories() {
        return this.ruleSetCategories != null && !(this.ruleSetCategories instanceof SdkAutoConstructList);
    }

    public final List<String> ruleSetCategoriesAsStrings() {
        return this.ruleSetCategories;
    }

    public final ContinuousIntegrationScanEvent supportedEvent() {
        return ContinuousIntegrationScanEvent.fromValue(this.supportedEvent);
    }

    public final String supportedEventAsString() {
        return this.supportedEvent;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRuleSetCategories() ? this.ruleSetCategoriesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.supportedEventAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProjectContinuousIntegrationScanConfiguration)) {
            return false;
        }
        ProjectContinuousIntegrationScanConfiguration other = (ProjectContinuousIntegrationScanConfiguration)obj;
        return this.hasRuleSetCategories() == other.hasRuleSetCategories() && Objects.equals(this.ruleSetCategoriesAsStrings(), other.ruleSetCategoriesAsStrings()) && Objects.equals(this.supportedEventAsString(), other.supportedEventAsString());
    }

    public final String toString() {
        return ToString.builder((String)"ProjectContinuousIntegrationScanConfiguration").add("RuleSetCategories", this.hasRuleSetCategories() ? this.ruleSetCategoriesAsStrings() : null).add("SupportedEvent", (Object)this.supportedEventAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ruleSetCategories": {
                return Optional.ofNullable(clazz.cast(this.ruleSetCategoriesAsStrings()));
            }
            case "supportedEvent": {
                return Optional.ofNullable(clazz.cast(this.supportedEventAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ruleSetCategories", RULE_SET_CATEGORIES_FIELD);
        map.put("supportedEvent", SUPPORTED_EVENT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ProjectContinuousIntegrationScanConfiguration, T> g) {
        return obj -> g.apply((ProjectContinuousIntegrationScanConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> ruleSetCategories = DefaultSdkAutoConstructList.getInstance();
        private String supportedEvent;

        private BuilderImpl() {
        }

        private BuilderImpl(ProjectContinuousIntegrationScanConfiguration model) {
            this.ruleSetCategoriesWithStrings(model.ruleSetCategories);
            this.supportedEvent(model.supportedEvent);
        }

        public final Collection<String> getRuleSetCategories() {
            if (this.ruleSetCategories instanceof SdkAutoConstructList) {
                return null;
            }
            return this.ruleSetCategories;
        }

        public final void setRuleSetCategories(Collection<String> ruleSetCategories) {
            this.ruleSetCategories = RuleSetCategoriesCopier.copy(ruleSetCategories);
        }

        @Override
        public final Builder ruleSetCategoriesWithStrings(Collection<String> ruleSetCategories) {
            this.ruleSetCategories = RuleSetCategoriesCopier.copy(ruleSetCategories);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ruleSetCategoriesWithStrings(String ... ruleSetCategories) {
            this.ruleSetCategoriesWithStrings(Arrays.asList(ruleSetCategories));
            return this;
        }

        @Override
        public final Builder ruleSetCategories(Collection<RuleSetCategory> ruleSetCategories) {
            this.ruleSetCategories = RuleSetCategoriesCopier.copyEnumToString(ruleSetCategories);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ruleSetCategories(RuleSetCategory ... ruleSetCategories) {
            this.ruleSetCategories(Arrays.asList(ruleSetCategories));
            return this;
        }

        public final String getSupportedEvent() {
            return this.supportedEvent;
        }

        public final void setSupportedEvent(String supportedEvent) {
            this.supportedEvent = supportedEvent;
        }

        @Override
        public final Builder supportedEvent(String supportedEvent) {
            this.supportedEvent = supportedEvent;
            return this;
        }

        @Override
        public final Builder supportedEvent(ContinuousIntegrationScanEvent supportedEvent) {
            this.supportedEvent(supportedEvent == null ? null : supportedEvent.toString());
            return this;
        }

        public ProjectContinuousIntegrationScanConfiguration build() {
            return new ProjectContinuousIntegrationScanConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ProjectContinuousIntegrationScanConfiguration> {
        public Builder ruleSetCategoriesWithStrings(Collection<String> var1);

        public Builder ruleSetCategoriesWithStrings(String ... var1);

        public Builder ruleSetCategories(Collection<RuleSetCategory> var1);

        public Builder ruleSetCategories(RuleSetCategory ... var1);

        public Builder supportedEvent(String var1);

        public Builder supportedEvent(ContinuousIntegrationScanEvent var1);
    }
}

