/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.inspector2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.inspector2.model.ContinuousIntegrationScanEvent;
import software.amazon.awssdk.services.inspector2.model.ContinuousIntegrationScanSupportedEventsCopier;
import software.amazon.awssdk.services.inspector2.model.PeriodicScanFrequency;
import software.amazon.awssdk.services.inspector2.model.RuleSetCategoriesCopier;
import software.amazon.awssdk.services.inspector2.model.RuleSetCategory;
import software.amazon.awssdk.services.inspector2.model.ScopeSettings;
import software.amazon.awssdk.services.inspector2.model.TagMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CodeSecurityScanConfigurationSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CodeSecurityScanConfigurationSummary> {
    private static final SdkField<List<String>> CONTINUOUS_INTEGRATION_SCAN_SUPPORTED_EVENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("continuousIntegrationScanSupportedEvents").getter(CodeSecurityScanConfigurationSummary.getter(CodeSecurityScanConfigurationSummary::continuousIntegrationScanSupportedEventsAsStrings)).setter(CodeSecurityScanConfigurationSummary.setter(Builder::continuousIntegrationScanSupportedEventsWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("continuousIntegrationScanSupportedEvents").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> FREQUENCY_EXPRESSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("frequencyExpression").getter(CodeSecurityScanConfigurationSummary.getter(CodeSecurityScanConfigurationSummary::frequencyExpression)).setter(CodeSecurityScanConfigurationSummary.setter(Builder::frequencyExpression)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("frequencyExpression").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(CodeSecurityScanConfigurationSummary.getter(CodeSecurityScanConfigurationSummary::name)).setter(CodeSecurityScanConfigurationSummary.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> OWNER_ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ownerAccountId").getter(CodeSecurityScanConfigurationSummary.getter(CodeSecurityScanConfigurationSummary::ownerAccountId)).setter(CodeSecurityScanConfigurationSummary.setter(Builder::ownerAccountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ownerAccountId").build()}).build();
    private static final SdkField<String> PERIODIC_SCAN_FREQUENCY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("periodicScanFrequency").getter(CodeSecurityScanConfigurationSummary.getter(CodeSecurityScanConfigurationSummary::periodicScanFrequencyAsString)).setter(CodeSecurityScanConfigurationSummary.setter(Builder::periodicScanFrequency)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("periodicScanFrequency").build()}).build();
    private static final SdkField<List<String>> RULE_SET_CATEGORIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ruleSetCategories").getter(CodeSecurityScanConfigurationSummary.getter(CodeSecurityScanConfigurationSummary::ruleSetCategoriesAsStrings)).setter(CodeSecurityScanConfigurationSummary.setter(Builder::ruleSetCategoriesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ruleSetCategories").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> SCAN_CONFIGURATION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("scanConfigurationArn").getter(CodeSecurityScanConfigurationSummary.getter(CodeSecurityScanConfigurationSummary::scanConfigurationArn)).setter(CodeSecurityScanConfigurationSummary.setter(Builder::scanConfigurationArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scanConfigurationArn").build()}).build();
    private static final SdkField<ScopeSettings> SCOPE_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("scopeSettings").getter(CodeSecurityScanConfigurationSummary.getter(CodeSecurityScanConfigurationSummary::scopeSettings)).setter(CodeSecurityScanConfigurationSummary.setter(Builder::scopeSettings)).constructor(ScopeSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scopeSettings").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(CodeSecurityScanConfigurationSummary.getter(CodeSecurityScanConfigurationSummary::tags)).setter(CodeSecurityScanConfigurationSummary.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTINUOUS_INTEGRATION_SCAN_SUPPORTED_EVENTS_FIELD, FREQUENCY_EXPRESSION_FIELD, NAME_FIELD, OWNER_ACCOUNT_ID_FIELD, PERIODIC_SCAN_FREQUENCY_FIELD, RULE_SET_CATEGORIES_FIELD, SCAN_CONFIGURATION_ARN_FIELD, SCOPE_SETTINGS_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CodeSecurityScanConfigurationSummary.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<String> continuousIntegrationScanSupportedEvents;
    private final String frequencyExpression;
    private final String name;
    private final String ownerAccountId;
    private final String periodicScanFrequency;
    private final List<String> ruleSetCategories;
    private final String scanConfigurationArn;
    private final ScopeSettings scopeSettings;
    private final Map<String, String> tags;

    private CodeSecurityScanConfigurationSummary(BuilderImpl builder) {
        this.continuousIntegrationScanSupportedEvents = builder.continuousIntegrationScanSupportedEvents;
        this.frequencyExpression = builder.frequencyExpression;
        this.name = builder.name;
        this.ownerAccountId = builder.ownerAccountId;
        this.periodicScanFrequency = builder.periodicScanFrequency;
        this.ruleSetCategories = builder.ruleSetCategories;
        this.scanConfigurationArn = builder.scanConfigurationArn;
        this.scopeSettings = builder.scopeSettings;
        this.tags = builder.tags;
    }

    public final List<ContinuousIntegrationScanEvent> continuousIntegrationScanSupportedEvents() {
        return ContinuousIntegrationScanSupportedEventsCopier.copyStringToEnum(this.continuousIntegrationScanSupportedEvents);
    }

    public final boolean hasContinuousIntegrationScanSupportedEvents() {
        return this.continuousIntegrationScanSupportedEvents != null && !(this.continuousIntegrationScanSupportedEvents instanceof SdkAutoConstructList);
    }

    public final List<String> continuousIntegrationScanSupportedEventsAsStrings() {
        return this.continuousIntegrationScanSupportedEvents;
    }

    public final String frequencyExpression() {
        return this.frequencyExpression;
    }

    public final String name() {
        return this.name;
    }

    public final String ownerAccountId() {
        return this.ownerAccountId;
    }

    public final PeriodicScanFrequency periodicScanFrequency() {
        return PeriodicScanFrequency.fromValue(this.periodicScanFrequency);
    }

    public final String periodicScanFrequencyAsString() {
        return this.periodicScanFrequency;
    }

    public final List<RuleSetCategory> ruleSetCategories() {
        return RuleSetCategoriesCopier.copyStringToEnum(this.ruleSetCategories);
    }

    public final boolean hasRuleSetCategories() {
        return this.ruleSetCategories != null && !(this.ruleSetCategories instanceof SdkAutoConstructList);
    }

    public final List<String> ruleSetCategoriesAsStrings() {
        return this.ruleSetCategories;
    }

    public final String scanConfigurationArn() {
        return this.scanConfigurationArn;
    }

    public final ScopeSettings scopeSettings() {
        return this.scopeSettings;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasContinuousIntegrationScanSupportedEvents() ? this.continuousIntegrationScanSupportedEventsAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.frequencyExpression());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.ownerAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.periodicScanFrequencyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRuleSetCategories() ? this.ruleSetCategoriesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.scanConfigurationArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.scopeSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CodeSecurityScanConfigurationSummary)) {
            return false;
        }
        CodeSecurityScanConfigurationSummary other = (CodeSecurityScanConfigurationSummary)obj;
        return this.hasContinuousIntegrationScanSupportedEvents() == other.hasContinuousIntegrationScanSupportedEvents() && Objects.equals(this.continuousIntegrationScanSupportedEventsAsStrings(), other.continuousIntegrationScanSupportedEventsAsStrings()) && Objects.equals(this.frequencyExpression(), other.frequencyExpression()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.ownerAccountId(), other.ownerAccountId()) && Objects.equals(this.periodicScanFrequencyAsString(), other.periodicScanFrequencyAsString()) && this.hasRuleSetCategories() == other.hasRuleSetCategories() && Objects.equals(this.ruleSetCategoriesAsStrings(), other.ruleSetCategoriesAsStrings()) && Objects.equals(this.scanConfigurationArn(), other.scanConfigurationArn()) && Objects.equals(this.scopeSettings(), other.scopeSettings()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"CodeSecurityScanConfigurationSummary").add("ContinuousIntegrationScanSupportedEvents", this.hasContinuousIntegrationScanSupportedEvents() ? this.continuousIntegrationScanSupportedEventsAsStrings() : null).add("FrequencyExpression", (Object)this.frequencyExpression()).add("Name", (Object)this.name()).add("OwnerAccountId", (Object)this.ownerAccountId()).add("PeriodicScanFrequency", (Object)this.periodicScanFrequencyAsString()).add("RuleSetCategories", this.hasRuleSetCategories() ? this.ruleSetCategoriesAsStrings() : null).add("ScanConfigurationArn", (Object)this.scanConfigurationArn()).add("ScopeSettings", (Object)this.scopeSettings()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "continuousIntegrationScanSupportedEvents": {
                return Optional.ofNullable(clazz.cast(this.continuousIntegrationScanSupportedEventsAsStrings()));
            }
            case "frequencyExpression": {
                return Optional.ofNullable(clazz.cast(this.frequencyExpression()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "ownerAccountId": {
                return Optional.ofNullable(clazz.cast(this.ownerAccountId()));
            }
            case "periodicScanFrequency": {
                return Optional.ofNullable(clazz.cast(this.periodicScanFrequencyAsString()));
            }
            case "ruleSetCategories": {
                return Optional.ofNullable(clazz.cast(this.ruleSetCategoriesAsStrings()));
            }
            case "scanConfigurationArn": {
                return Optional.ofNullable(clazz.cast(this.scanConfigurationArn()));
            }
            case "scopeSettings": {
                return Optional.ofNullable(clazz.cast(this.scopeSettings()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("continuousIntegrationScanSupportedEvents", CONTINUOUS_INTEGRATION_SCAN_SUPPORTED_EVENTS_FIELD);
        map.put("frequencyExpression", FREQUENCY_EXPRESSION_FIELD);
        map.put("name", NAME_FIELD);
        map.put("ownerAccountId", OWNER_ACCOUNT_ID_FIELD);
        map.put("periodicScanFrequency", PERIODIC_SCAN_FREQUENCY_FIELD);
        map.put("ruleSetCategories", RULE_SET_CATEGORIES_FIELD);
        map.put("scanConfigurationArn", SCAN_CONFIGURATION_ARN_FIELD);
        map.put("scopeSettings", SCOPE_SETTINGS_FIELD);
        map.put("tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CodeSecurityScanConfigurationSummary, T> g) {
        return obj -> g.apply((CodeSecurityScanConfigurationSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> continuousIntegrationScanSupportedEvents = DefaultSdkAutoConstructList.getInstance();
        private String frequencyExpression;
        private String name;
        private String ownerAccountId;
        private String periodicScanFrequency;
        private List<String> ruleSetCategories = DefaultSdkAutoConstructList.getInstance();
        private String scanConfigurationArn;
        private ScopeSettings scopeSettings;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CodeSecurityScanConfigurationSummary model) {
            this.continuousIntegrationScanSupportedEventsWithStrings(model.continuousIntegrationScanSupportedEvents);
            this.frequencyExpression(model.frequencyExpression);
            this.name(model.name);
            this.ownerAccountId(model.ownerAccountId);
            this.periodicScanFrequency(model.periodicScanFrequency);
            this.ruleSetCategoriesWithStrings(model.ruleSetCategories);
            this.scanConfigurationArn(model.scanConfigurationArn);
            this.scopeSettings(model.scopeSettings);
            this.tags(model.tags);
        }

        public final Collection<String> getContinuousIntegrationScanSupportedEvents() {
            if (this.continuousIntegrationScanSupportedEvents instanceof SdkAutoConstructList) {
                return null;
            }
            return this.continuousIntegrationScanSupportedEvents;
        }

        public final void setContinuousIntegrationScanSupportedEvents(Collection<String> continuousIntegrationScanSupportedEvents) {
            this.continuousIntegrationScanSupportedEvents = ContinuousIntegrationScanSupportedEventsCopier.copy(continuousIntegrationScanSupportedEvents);
        }

        @Override
        public final Builder continuousIntegrationScanSupportedEventsWithStrings(Collection<String> continuousIntegrationScanSupportedEvents) {
            this.continuousIntegrationScanSupportedEvents = ContinuousIntegrationScanSupportedEventsCopier.copy(continuousIntegrationScanSupportedEvents);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder continuousIntegrationScanSupportedEventsWithStrings(String ... continuousIntegrationScanSupportedEvents) {
            this.continuousIntegrationScanSupportedEventsWithStrings(Arrays.asList(continuousIntegrationScanSupportedEvents));
            return this;
        }

        @Override
        public final Builder continuousIntegrationScanSupportedEvents(Collection<ContinuousIntegrationScanEvent> continuousIntegrationScanSupportedEvents) {
            this.continuousIntegrationScanSupportedEvents = ContinuousIntegrationScanSupportedEventsCopier.copyEnumToString(continuousIntegrationScanSupportedEvents);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder continuousIntegrationScanSupportedEvents(ContinuousIntegrationScanEvent ... continuousIntegrationScanSupportedEvents) {
            this.continuousIntegrationScanSupportedEvents(Arrays.asList(continuousIntegrationScanSupportedEvents));
            return this;
        }

        public final String getFrequencyExpression() {
            return this.frequencyExpression;
        }

        public final void setFrequencyExpression(String frequencyExpression) {
            this.frequencyExpression = frequencyExpression;
        }

        @Override
        public final Builder frequencyExpression(String frequencyExpression) {
            this.frequencyExpression = frequencyExpression;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getOwnerAccountId() {
            return this.ownerAccountId;
        }

        public final void setOwnerAccountId(String ownerAccountId) {
            this.ownerAccountId = ownerAccountId;
        }

        @Override
        public final Builder ownerAccountId(String ownerAccountId) {
            this.ownerAccountId = ownerAccountId;
            return this;
        }

        public final String getPeriodicScanFrequency() {
            return this.periodicScanFrequency;
        }

        public final void setPeriodicScanFrequency(String periodicScanFrequency) {
            this.periodicScanFrequency = periodicScanFrequency;
        }

        @Override
        public final Builder periodicScanFrequency(String periodicScanFrequency) {
            this.periodicScanFrequency = periodicScanFrequency;
            return this;
        }

        @Override
        public final Builder periodicScanFrequency(PeriodicScanFrequency periodicScanFrequency) {
            this.periodicScanFrequency(periodicScanFrequency == null ? null : periodicScanFrequency.toString());
            return this;
        }

        public final Collection<String> getRuleSetCategories() {
            if (this.ruleSetCategories instanceof SdkAutoConstructList) {
                return null;
            }
            return this.ruleSetCategories;
        }

        public final void setRuleSetCategories(Collection<String> ruleSetCategories) {
            this.ruleSetCategories = RuleSetCategoriesCopier.copy(ruleSetCategories);
        }

        @Override
        public final Builder ruleSetCategoriesWithStrings(Collection<String> ruleSetCategories) {
            this.ruleSetCategories = RuleSetCategoriesCopier.copy(ruleSetCategories);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ruleSetCategoriesWithStrings(String ... ruleSetCategories) {
            this.ruleSetCategoriesWithStrings(Arrays.asList(ruleSetCategories));
            return this;
        }

        @Override
        public final Builder ruleSetCategories(Collection<RuleSetCategory> ruleSetCategories) {
            this.ruleSetCategories = RuleSetCategoriesCopier.copyEnumToString(ruleSetCategories);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ruleSetCategories(RuleSetCategory ... ruleSetCategories) {
            this.ruleSetCategories(Arrays.asList(ruleSetCategories));
            return this;
        }

        public final String getScanConfigurationArn() {
            return this.scanConfigurationArn;
        }

        public final void setScanConfigurationArn(String scanConfigurationArn) {
            this.scanConfigurationArn = scanConfigurationArn;
        }

        @Override
        public final Builder scanConfigurationArn(String scanConfigurationArn) {
            this.scanConfigurationArn = scanConfigurationArn;
            return this;
        }

        public final ScopeSettings.Builder getScopeSettings() {
            return this.scopeSettings != null ? this.scopeSettings.toBuilder() : null;
        }

        public final void setScopeSettings(ScopeSettings.BuilderImpl scopeSettings) {
            this.scopeSettings = scopeSettings != null ? scopeSettings.build() : null;
        }

        @Override
        public final Builder scopeSettings(ScopeSettings scopeSettings) {
            this.scopeSettings = scopeSettings;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public CodeSecurityScanConfigurationSummary build() {
            return new CodeSecurityScanConfigurationSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CodeSecurityScanConfigurationSummary> {
        public Builder continuousIntegrationScanSupportedEventsWithStrings(Collection<String> var1);

        public Builder continuousIntegrationScanSupportedEventsWithStrings(String ... var1);

        public Builder continuousIntegrationScanSupportedEvents(Collection<ContinuousIntegrationScanEvent> var1);

        public Builder continuousIntegrationScanSupportedEvents(ContinuousIntegrationScanEvent ... var1);

        public Builder frequencyExpression(String var1);

        public Builder name(String var1);

        public Builder ownerAccountId(String var1);

        public Builder periodicScanFrequency(String var1);

        public Builder periodicScanFrequency(PeriodicScanFrequency var1);

        public Builder ruleSetCategoriesWithStrings(Collection<String> var1);

        public Builder ruleSetCategoriesWithStrings(String ... var1);

        public Builder ruleSetCategories(Collection<RuleSetCategory> var1);

        public Builder ruleSetCategories(RuleSetCategory ... var1);

        public Builder scanConfigurationArn(String var1);

        public Builder scopeSettings(ScopeSettings var1);

        default public Builder scopeSettings(Consumer<ScopeSettings.Builder> scopeSettings) {
            return this.scopeSettings((ScopeSettings)((ScopeSettings.Builder)ScopeSettings.builder().applyMutation(scopeSettings)).build());
        }

        public Builder tags(Map<String, String> var1);
    }
}

