/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.inspector2.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ResourceScanType {
    EC2("EC2"),
    ECR("ECR"),
    LAMBDA("LAMBDA"),
    LAMBDA_CODE("LAMBDA_CODE"),
    CODE_REPOSITORY("CODE_REPOSITORY"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ResourceScanType> VALUE_MAP;
    private final String value;

    private ResourceScanType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ResourceScanType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ResourceScanType> knownValues() {
        EnumSet<ResourceScanType> knownValues = EnumSet.allOf(ResourceScanType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ResourceScanType.class, ResourceScanType::toString);
    }
}

