/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.inspector2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.inspector2.model.CodeLine;
import software.amazon.awssdk.services.inspector2.model.CodeLineListCopier;
import software.amazon.awssdk.services.inspector2.model.SuggestedFix;
import software.amazon.awssdk.services.inspector2.model.SuggestedFixesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CodeSnippetResult
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CodeSnippetResult> {
    private static final SdkField<String> FINDING_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("findingArn").getter(CodeSnippetResult.getter(CodeSnippetResult::findingArn)).setter(CodeSnippetResult.setter(Builder::findingArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("findingArn").build()}).build();
    private static final SdkField<Integer> START_LINE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("startLine").getter(CodeSnippetResult.getter(CodeSnippetResult::startLine)).setter(CodeSnippetResult.setter(Builder::startLine)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startLine").build()}).build();
    private static final SdkField<Integer> END_LINE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("endLine").getter(CodeSnippetResult.getter(CodeSnippetResult::endLine)).setter(CodeSnippetResult.setter(Builder::endLine)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endLine").build()}).build();
    private static final SdkField<List<CodeLine>> CODE_SNIPPET_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("codeSnippet").getter(CodeSnippetResult.getter(CodeSnippetResult::codeSnippet)).setter(CodeSnippetResult.setter(Builder::codeSnippet)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("codeSnippet").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CodeLine::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<SuggestedFix>> SUGGESTED_FIXES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("suggestedFixes").getter(CodeSnippetResult.getter(CodeSnippetResult::suggestedFixes)).setter(CodeSnippetResult.setter(Builder::suggestedFixes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("suggestedFixes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SuggestedFix::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FINDING_ARN_FIELD, START_LINE_FIELD, END_LINE_FIELD, CODE_SNIPPET_FIELD, SUGGESTED_FIXES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CodeSnippetResult.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String findingArn;
    private final Integer startLine;
    private final Integer endLine;
    private final List<CodeLine> codeSnippet;
    private final List<SuggestedFix> suggestedFixes;

    private CodeSnippetResult(BuilderImpl builder) {
        this.findingArn = builder.findingArn;
        this.startLine = builder.startLine;
        this.endLine = builder.endLine;
        this.codeSnippet = builder.codeSnippet;
        this.suggestedFixes = builder.suggestedFixes;
    }

    public final String findingArn() {
        return this.findingArn;
    }

    public final Integer startLine() {
        return this.startLine;
    }

    public final Integer endLine() {
        return this.endLine;
    }

    public final boolean hasCodeSnippet() {
        return this.codeSnippet != null && !(this.codeSnippet instanceof SdkAutoConstructList);
    }

    public final List<CodeLine> codeSnippet() {
        return this.codeSnippet;
    }

    public final boolean hasSuggestedFixes() {
        return this.suggestedFixes != null && !(this.suggestedFixes instanceof SdkAutoConstructList);
    }

    public final List<SuggestedFix> suggestedFixes() {
        return this.suggestedFixes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.findingArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.startLine());
        hashCode = 31 * hashCode + Objects.hashCode(this.endLine());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCodeSnippet() ? this.codeSnippet() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSuggestedFixes() ? this.suggestedFixes() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CodeSnippetResult)) {
            return false;
        }
        CodeSnippetResult other = (CodeSnippetResult)obj;
        return Objects.equals(this.findingArn(), other.findingArn()) && Objects.equals(this.startLine(), other.startLine()) && Objects.equals(this.endLine(), other.endLine()) && this.hasCodeSnippet() == other.hasCodeSnippet() && Objects.equals(this.codeSnippet(), other.codeSnippet()) && this.hasSuggestedFixes() == other.hasSuggestedFixes() && Objects.equals(this.suggestedFixes(), other.suggestedFixes());
    }

    public final String toString() {
        return ToString.builder((String)"CodeSnippetResult").add("FindingArn", (Object)this.findingArn()).add("StartLine", (Object)this.startLine()).add("EndLine", (Object)this.endLine()).add("CodeSnippet", this.hasCodeSnippet() ? this.codeSnippet() : null).add("SuggestedFixes", this.hasSuggestedFixes() ? this.suggestedFixes() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "findingArn": {
                return Optional.ofNullable(clazz.cast(this.findingArn()));
            }
            case "startLine": {
                return Optional.ofNullable(clazz.cast(this.startLine()));
            }
            case "endLine": {
                return Optional.ofNullable(clazz.cast(this.endLine()));
            }
            case "codeSnippet": {
                return Optional.ofNullable(clazz.cast(this.codeSnippet()));
            }
            case "suggestedFixes": {
                return Optional.ofNullable(clazz.cast(this.suggestedFixes()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("findingArn", FINDING_ARN_FIELD);
        map.put("startLine", START_LINE_FIELD);
        map.put("endLine", END_LINE_FIELD);
        map.put("codeSnippet", CODE_SNIPPET_FIELD);
        map.put("suggestedFixes", SUGGESTED_FIXES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CodeSnippetResult, T> g) {
        return obj -> g.apply((CodeSnippetResult)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String findingArn;
        private Integer startLine;
        private Integer endLine;
        private List<CodeLine> codeSnippet = DefaultSdkAutoConstructList.getInstance();
        private List<SuggestedFix> suggestedFixes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CodeSnippetResult model) {
            this.findingArn(model.findingArn);
            this.startLine(model.startLine);
            this.endLine(model.endLine);
            this.codeSnippet(model.codeSnippet);
            this.suggestedFixes(model.suggestedFixes);
        }

        public final String getFindingArn() {
            return this.findingArn;
        }

        public final void setFindingArn(String findingArn) {
            this.findingArn = findingArn;
        }

        @Override
        public final Builder findingArn(String findingArn) {
            this.findingArn = findingArn;
            return this;
        }

        public final Integer getStartLine() {
            return this.startLine;
        }

        public final void setStartLine(Integer startLine) {
            this.startLine = startLine;
        }

        @Override
        public final Builder startLine(Integer startLine) {
            this.startLine = startLine;
            return this;
        }

        public final Integer getEndLine() {
            return this.endLine;
        }

        public final void setEndLine(Integer endLine) {
            this.endLine = endLine;
        }

        @Override
        public final Builder endLine(Integer endLine) {
            this.endLine = endLine;
            return this;
        }

        public final List<CodeLine.Builder> getCodeSnippet() {
            List<CodeLine.Builder> result = CodeLineListCopier.copyToBuilder(this.codeSnippet);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCodeSnippet(Collection<CodeLine.BuilderImpl> codeSnippet) {
            this.codeSnippet = CodeLineListCopier.copyFromBuilder(codeSnippet);
        }

        @Override
        public final Builder codeSnippet(Collection<CodeLine> codeSnippet) {
            this.codeSnippet = CodeLineListCopier.copy(codeSnippet);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder codeSnippet(CodeLine ... codeSnippet) {
            this.codeSnippet(Arrays.asList(codeSnippet));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder codeSnippet(Consumer<CodeLine.Builder> ... codeSnippet) {
            this.codeSnippet(Stream.of(codeSnippet).map(c -> (CodeLine)((CodeLine.Builder)CodeLine.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<SuggestedFix.Builder> getSuggestedFixes() {
            List<SuggestedFix.Builder> result = SuggestedFixesCopier.copyToBuilder(this.suggestedFixes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSuggestedFixes(Collection<SuggestedFix.BuilderImpl> suggestedFixes) {
            this.suggestedFixes = SuggestedFixesCopier.copyFromBuilder(suggestedFixes);
        }

        @Override
        public final Builder suggestedFixes(Collection<SuggestedFix> suggestedFixes) {
            this.suggestedFixes = SuggestedFixesCopier.copy(suggestedFixes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder suggestedFixes(SuggestedFix ... suggestedFixes) {
            this.suggestedFixes(Arrays.asList(suggestedFixes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder suggestedFixes(Consumer<SuggestedFix.Builder> ... suggestedFixes) {
            this.suggestedFixes(Stream.of(suggestedFixes).map(c -> (SuggestedFix)((SuggestedFix.Builder)SuggestedFix.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public CodeSnippetResult build() {
            return new CodeSnippetResult(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CodeSnippetResult> {
        public Builder findingArn(String var1);

        public Builder startLine(Integer var1);

        public Builder endLine(Integer var1);

        public Builder codeSnippet(Collection<CodeLine> var1);

        public Builder codeSnippet(CodeLine ... var1);

        public Builder codeSnippet(Consumer<CodeLine.Builder> ... var1);

        public Builder suggestedFixes(Collection<SuggestedFix> var1);

        public Builder suggestedFixes(SuggestedFix ... var1);

        public Builder suggestedFixes(Consumer<SuggestedFix.Builder> ... var1);
    }
}

