/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.inspector2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.inspector2.Inspector2AsyncClient;
import software.amazon.awssdk.services.inspector2.internal.UserAgentUtils;
import software.amazon.awssdk.services.inspector2.model.CisScanResultDetails;
import software.amazon.awssdk.services.inspector2.model.GetCisScanResultDetailsRequest;
import software.amazon.awssdk.services.inspector2.model.GetCisScanResultDetailsResponse;

public class GetCisScanResultDetailsPublisher
implements SdkPublisher<GetCisScanResultDetailsResponse> {
    private final Inspector2AsyncClient client;
    private final GetCisScanResultDetailsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public GetCisScanResultDetailsPublisher(Inspector2AsyncClient client, GetCisScanResultDetailsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private GetCisScanResultDetailsPublisher(Inspector2AsyncClient client, GetCisScanResultDetailsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new GetCisScanResultDetailsResponseFetcher();
    }

    public void subscribe(Subscriber<? super GetCisScanResultDetailsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<CisScanResultDetails> scanResultDetails() {
        Function<GetCisScanResultDetailsResponse, Iterator> getIterator = response -> {
            if (response != null && response.scanResultDetails() != null) {
                return response.scanResultDetails().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new GetCisScanResultDetailsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class GetCisScanResultDetailsResponseFetcher
    implements AsyncPageFetcher<GetCisScanResultDetailsResponse> {
        private GetCisScanResultDetailsResponseFetcher() {
        }

        public boolean hasNextPage(GetCisScanResultDetailsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<GetCisScanResultDetailsResponse> nextPage(GetCisScanResultDetailsResponse previousPage) {
            if (previousPage == null) {
                return GetCisScanResultDetailsPublisher.this.client.getCisScanResultDetails(GetCisScanResultDetailsPublisher.this.firstRequest);
            }
            return GetCisScanResultDetailsPublisher.this.client.getCisScanResultDetails((GetCisScanResultDetailsRequest)((Object)GetCisScanResultDetailsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

