/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.inspector2;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.services.inspector2.model.AccessDeniedException;
import software.amazon.awssdk.services.inspector2.model.AssociateMemberRequest;
import software.amazon.awssdk.services.inspector2.model.AssociateMemberResponse;
import software.amazon.awssdk.services.inspector2.model.BadRequestException;
import software.amazon.awssdk.services.inspector2.model.BatchAssociateCodeSecurityScanConfigurationRequest;
import software.amazon.awssdk.services.inspector2.model.BatchAssociateCodeSecurityScanConfigurationResponse;
import software.amazon.awssdk.services.inspector2.model.BatchDisassociateCodeSecurityScanConfigurationRequest;
import software.amazon.awssdk.services.inspector2.model.BatchDisassociateCodeSecurityScanConfigurationResponse;
import software.amazon.awssdk.services.inspector2.model.BatchGetAccountStatusRequest;
import software.amazon.awssdk.services.inspector2.model.BatchGetAccountStatusResponse;
import software.amazon.awssdk.services.inspector2.model.BatchGetCodeSnippetRequest;
import software.amazon.awssdk.services.inspector2.model.BatchGetCodeSnippetResponse;
import software.amazon.awssdk.services.inspector2.model.BatchGetFindingDetailsRequest;
import software.amazon.awssdk.services.inspector2.model.BatchGetFindingDetailsResponse;
import software.amazon.awssdk.services.inspector2.model.BatchGetFreeTrialInfoRequest;
import software.amazon.awssdk.services.inspector2.model.BatchGetFreeTrialInfoResponse;
import software.amazon.awssdk.services.inspector2.model.BatchGetMemberEc2DeepInspectionStatusRequest;
import software.amazon.awssdk.services.inspector2.model.BatchGetMemberEc2DeepInspectionStatusResponse;
import software.amazon.awssdk.services.inspector2.model.BatchUpdateMemberEc2DeepInspectionStatusRequest;
import software.amazon.awssdk.services.inspector2.model.BatchUpdateMemberEc2DeepInspectionStatusResponse;
import software.amazon.awssdk.services.inspector2.model.CancelFindingsReportRequest;
import software.amazon.awssdk.services.inspector2.model.CancelFindingsReportResponse;
import software.amazon.awssdk.services.inspector2.model.CancelSbomExportRequest;
import software.amazon.awssdk.services.inspector2.model.CancelSbomExportResponse;
import software.amazon.awssdk.services.inspector2.model.ConflictException;
import software.amazon.awssdk.services.inspector2.model.CreateCisScanConfigurationRequest;
import software.amazon.awssdk.services.inspector2.model.CreateCisScanConfigurationResponse;
import software.amazon.awssdk.services.inspector2.model.CreateCodeSecurityIntegrationRequest;
import software.amazon.awssdk.services.inspector2.model.CreateCodeSecurityIntegrationResponse;
import software.amazon.awssdk.services.inspector2.model.CreateCodeSecurityScanConfigurationRequest;
import software.amazon.awssdk.services.inspector2.model.CreateCodeSecurityScanConfigurationResponse;
import software.amazon.awssdk.services.inspector2.model.CreateFilterRequest;
import software.amazon.awssdk.services.inspector2.model.CreateFilterResponse;
import software.amazon.awssdk.services.inspector2.model.CreateFindingsReportRequest;
import software.amazon.awssdk.services.inspector2.model.CreateFindingsReportResponse;
import software.amazon.awssdk.services.inspector2.model.CreateSbomExportRequest;
import software.amazon.awssdk.services.inspector2.model.CreateSbomExportResponse;
import software.amazon.awssdk.services.inspector2.model.DeleteCisScanConfigurationRequest;
import software.amazon.awssdk.services.inspector2.model.DeleteCisScanConfigurationResponse;
import software.amazon.awssdk.services.inspector2.model.DeleteCodeSecurityIntegrationRequest;
import software.amazon.awssdk.services.inspector2.model.DeleteCodeSecurityIntegrationResponse;
import software.amazon.awssdk.services.inspector2.model.DeleteCodeSecurityScanConfigurationRequest;
import software.amazon.awssdk.services.inspector2.model.DeleteCodeSecurityScanConfigurationResponse;
import software.amazon.awssdk.services.inspector2.model.DeleteFilterRequest;
import software.amazon.awssdk.services.inspector2.model.DeleteFilterResponse;
import software.amazon.awssdk.services.inspector2.model.DescribeOrganizationConfigurationRequest;
import software.amazon.awssdk.services.inspector2.model.DescribeOrganizationConfigurationResponse;
import software.amazon.awssdk.services.inspector2.model.DisableDelegatedAdminAccountRequest;
import software.amazon.awssdk.services.inspector2.model.DisableDelegatedAdminAccountResponse;
import software.amazon.awssdk.services.inspector2.model.DisableRequest;
import software.amazon.awssdk.services.inspector2.model.DisableResponse;
import software.amazon.awssdk.services.inspector2.model.DisassociateMemberRequest;
import software.amazon.awssdk.services.inspector2.model.DisassociateMemberResponse;
import software.amazon.awssdk.services.inspector2.model.EnableDelegatedAdminAccountRequest;
import software.amazon.awssdk.services.inspector2.model.EnableDelegatedAdminAccountResponse;
import software.amazon.awssdk.services.inspector2.model.EnableRequest;
import software.amazon.awssdk.services.inspector2.model.EnableResponse;
import software.amazon.awssdk.services.inspector2.model.GetCisScanReportRequest;
import software.amazon.awssdk.services.inspector2.model.GetCisScanReportResponse;
import software.amazon.awssdk.services.inspector2.model.GetCisScanResultDetailsRequest;
import software.amazon.awssdk.services.inspector2.model.GetCisScanResultDetailsResponse;
import software.amazon.awssdk.services.inspector2.model.GetClustersForImageRequest;
import software.amazon.awssdk.services.inspector2.model.GetClustersForImageResponse;
import software.amazon.awssdk.services.inspector2.model.GetCodeSecurityIntegrationRequest;
import software.amazon.awssdk.services.inspector2.model.GetCodeSecurityIntegrationResponse;
import software.amazon.awssdk.services.inspector2.model.GetCodeSecurityScanConfigurationRequest;
import software.amazon.awssdk.services.inspector2.model.GetCodeSecurityScanConfigurationResponse;
import software.amazon.awssdk.services.inspector2.model.GetCodeSecurityScanRequest;
import software.amazon.awssdk.services.inspector2.model.GetCodeSecurityScanResponse;
import software.amazon.awssdk.services.inspector2.model.GetConfigurationRequest;
import software.amazon.awssdk.services.inspector2.model.GetConfigurationResponse;
import software.amazon.awssdk.services.inspector2.model.GetDelegatedAdminAccountRequest;
import software.amazon.awssdk.services.inspector2.model.GetDelegatedAdminAccountResponse;
import software.amazon.awssdk.services.inspector2.model.GetEc2DeepInspectionConfigurationRequest;
import software.amazon.awssdk.services.inspector2.model.GetEc2DeepInspectionConfigurationResponse;
import software.amazon.awssdk.services.inspector2.model.GetEncryptionKeyRequest;
import software.amazon.awssdk.services.inspector2.model.GetEncryptionKeyResponse;
import software.amazon.awssdk.services.inspector2.model.GetFindingsReportStatusRequest;
import software.amazon.awssdk.services.inspector2.model.GetFindingsReportStatusResponse;
import software.amazon.awssdk.services.inspector2.model.GetMemberRequest;
import software.amazon.awssdk.services.inspector2.model.GetMemberResponse;
import software.amazon.awssdk.services.inspector2.model.GetSbomExportRequest;
import software.amazon.awssdk.services.inspector2.model.GetSbomExportResponse;
import software.amazon.awssdk.services.inspector2.model.Inspector2Exception;
import software.amazon.awssdk.services.inspector2.model.InternalServerException;
import software.amazon.awssdk.services.inspector2.model.ListAccountPermissionsRequest;
import software.amazon.awssdk.services.inspector2.model.ListAccountPermissionsResponse;
import software.amazon.awssdk.services.inspector2.model.ListCisScanConfigurationsRequest;
import software.amazon.awssdk.services.inspector2.model.ListCisScanConfigurationsResponse;
import software.amazon.awssdk.services.inspector2.model.ListCisScanResultsAggregatedByChecksRequest;
import software.amazon.awssdk.services.inspector2.model.ListCisScanResultsAggregatedByChecksResponse;
import software.amazon.awssdk.services.inspector2.model.ListCisScanResultsAggregatedByTargetResourceRequest;
import software.amazon.awssdk.services.inspector2.model.ListCisScanResultsAggregatedByTargetResourceResponse;
import software.amazon.awssdk.services.inspector2.model.ListCisScansRequest;
import software.amazon.awssdk.services.inspector2.model.ListCisScansResponse;
import software.amazon.awssdk.services.inspector2.model.ListCodeSecurityIntegrationsRequest;
import software.amazon.awssdk.services.inspector2.model.ListCodeSecurityIntegrationsResponse;
import software.amazon.awssdk.services.inspector2.model.ListCodeSecurityScanConfigurationAssociationsRequest;
import software.amazon.awssdk.services.inspector2.model.ListCodeSecurityScanConfigurationAssociationsResponse;
import software.amazon.awssdk.services.inspector2.model.ListCodeSecurityScanConfigurationsRequest;
import software.amazon.awssdk.services.inspector2.model.ListCodeSecurityScanConfigurationsResponse;
import software.amazon.awssdk.services.inspector2.model.ListCoverageRequest;
import software.amazon.awssdk.services.inspector2.model.ListCoverageResponse;
import software.amazon.awssdk.services.inspector2.model.ListCoverageStatisticsRequest;
import software.amazon.awssdk.services.inspector2.model.ListCoverageStatisticsResponse;
import software.amazon.awssdk.services.inspector2.model.ListDelegatedAdminAccountsRequest;
import software.amazon.awssdk.services.inspector2.model.ListDelegatedAdminAccountsResponse;
import software.amazon.awssdk.services.inspector2.model.ListFiltersRequest;
import software.amazon.awssdk.services.inspector2.model.ListFiltersResponse;
import software.amazon.awssdk.services.inspector2.model.ListFindingAggregationsRequest;
import software.amazon.awssdk.services.inspector2.model.ListFindingAggregationsResponse;
import software.amazon.awssdk.services.inspector2.model.ListFindingsRequest;
import software.amazon.awssdk.services.inspector2.model.ListFindingsResponse;
import software.amazon.awssdk.services.inspector2.model.ListMembersRequest;
import software.amazon.awssdk.services.inspector2.model.ListMembersResponse;
import software.amazon.awssdk.services.inspector2.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.inspector2.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.inspector2.model.ListUsageTotalsRequest;
import software.amazon.awssdk.services.inspector2.model.ListUsageTotalsResponse;
import software.amazon.awssdk.services.inspector2.model.ResetEncryptionKeyRequest;
import software.amazon.awssdk.services.inspector2.model.ResetEncryptionKeyResponse;
import software.amazon.awssdk.services.inspector2.model.ResourceNotFoundException;
import software.amazon.awssdk.services.inspector2.model.SearchVulnerabilitiesRequest;
import software.amazon.awssdk.services.inspector2.model.SearchVulnerabilitiesResponse;
import software.amazon.awssdk.services.inspector2.model.SendCisSessionHealthRequest;
import software.amazon.awssdk.services.inspector2.model.SendCisSessionHealthResponse;
import software.amazon.awssdk.services.inspector2.model.SendCisSessionTelemetryRequest;
import software.amazon.awssdk.services.inspector2.model.SendCisSessionTelemetryResponse;
import software.amazon.awssdk.services.inspector2.model.ServiceQuotaExceededException;
import software.amazon.awssdk.services.inspector2.model.StartCisSessionRequest;
import software.amazon.awssdk.services.inspector2.model.StartCisSessionResponse;
import software.amazon.awssdk.services.inspector2.model.StartCodeSecurityScanRequest;
import software.amazon.awssdk.services.inspector2.model.StartCodeSecurityScanResponse;
import software.amazon.awssdk.services.inspector2.model.StopCisSessionRequest;
import software.amazon.awssdk.services.inspector2.model.StopCisSessionResponse;
import software.amazon.awssdk.services.inspector2.model.TagResourceRequest;
import software.amazon.awssdk.services.inspector2.model.TagResourceResponse;
import software.amazon.awssdk.services.inspector2.model.ThrottlingException;
import software.amazon.awssdk.services.inspector2.model.UntagResourceRequest;
import software.amazon.awssdk.services.inspector2.model.UntagResourceResponse;
import software.amazon.awssdk.services.inspector2.model.UpdateCisScanConfigurationRequest;
import software.amazon.awssdk.services.inspector2.model.UpdateCisScanConfigurationResponse;
import software.amazon.awssdk.services.inspector2.model.UpdateCodeSecurityIntegrationRequest;
import software.amazon.awssdk.services.inspector2.model.UpdateCodeSecurityIntegrationResponse;
import software.amazon.awssdk.services.inspector2.model.UpdateCodeSecurityScanConfigurationRequest;
import software.amazon.awssdk.services.inspector2.model.UpdateCodeSecurityScanConfigurationResponse;
import software.amazon.awssdk.services.inspector2.model.UpdateConfigurationRequest;
import software.amazon.awssdk.services.inspector2.model.UpdateConfigurationResponse;
import software.amazon.awssdk.services.inspector2.model.UpdateEc2DeepInspectionConfigurationRequest;
import software.amazon.awssdk.services.inspector2.model.UpdateEc2DeepInspectionConfigurationResponse;
import software.amazon.awssdk.services.inspector2.model.UpdateEncryptionKeyRequest;
import software.amazon.awssdk.services.inspector2.model.UpdateEncryptionKeyResponse;
import software.amazon.awssdk.services.inspector2.model.UpdateFilterRequest;
import software.amazon.awssdk.services.inspector2.model.UpdateFilterResponse;
import software.amazon.awssdk.services.inspector2.model.UpdateOrgEc2DeepInspectionConfigurationRequest;
import software.amazon.awssdk.services.inspector2.model.UpdateOrgEc2DeepInspectionConfigurationResponse;
import software.amazon.awssdk.services.inspector2.model.UpdateOrganizationConfigurationRequest;
import software.amazon.awssdk.services.inspector2.model.UpdateOrganizationConfigurationResponse;
import software.amazon.awssdk.services.inspector2.model.ValidationException;
import software.amazon.awssdk.services.inspector2.paginators.GetCisScanResultDetailsIterable;
import software.amazon.awssdk.services.inspector2.paginators.GetClustersForImageIterable;
import software.amazon.awssdk.services.inspector2.paginators.ListAccountPermissionsIterable;
import software.amazon.awssdk.services.inspector2.paginators.ListCisScanConfigurationsIterable;
import software.amazon.awssdk.services.inspector2.paginators.ListCisScanResultsAggregatedByChecksIterable;
import software.amazon.awssdk.services.inspector2.paginators.ListCisScanResultsAggregatedByTargetResourceIterable;
import software.amazon.awssdk.services.inspector2.paginators.ListCisScansIterable;
import software.amazon.awssdk.services.inspector2.paginators.ListCoverageIterable;
import software.amazon.awssdk.services.inspector2.paginators.ListCoverageStatisticsIterable;
import software.amazon.awssdk.services.inspector2.paginators.ListDelegatedAdminAccountsIterable;
import software.amazon.awssdk.services.inspector2.paginators.ListFiltersIterable;
import software.amazon.awssdk.services.inspector2.paginators.ListFindingAggregationsIterable;
import software.amazon.awssdk.services.inspector2.paginators.ListFindingsIterable;
import software.amazon.awssdk.services.inspector2.paginators.ListMembersIterable;
import software.amazon.awssdk.services.inspector2.paginators.ListUsageTotalsIterable;
import software.amazon.awssdk.services.inspector2.paginators.SearchVulnerabilitiesIterable;

/**
 * Service client for accessing Inspector2. This can be created using the static {@link #builder()} method.
 *
 * <p>
 * Amazon Inspector is a vulnerability discovery service that automates continuous scanning for security vulnerabilities
 * within your Amazon EC2, Amazon ECR, and Amazon Web Services Lambda environments.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface Inspector2Client extends AwsClient {
    String SERVICE_NAME = "inspector2";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "inspector2";

    /**
     * <p>
     * Associates an Amazon Web Services account with an Amazon Inspector delegated administrator. An HTTP 200 response
     * indicates the association was successfully started, but doesn’t indicate whether it was completed. You can check
     * if the association completed by using <a
     * href="https://docs.aws.amazon.com/inspector/v2/APIReference/API_ListMembers.html">ListMembers</a> for multiple
     * accounts or <a href="https://docs.aws.amazon.com/inspector/v2/APIReference/API_GetMember.html">GetMembers</a> for
     * a single account.
     * </p>
     *
     * @param associateMemberRequest
     * @return Result of the AssociateMember operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         You have exceeded your service quota. To perform the requested action, remove some of the relevant
     *         resources, or use Service Quotas to request a service quota increase.
     * @throws ValidationException
     *         The request has failed validation due to missing required fields or having invalid inputs.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.</p>
     *         <p>
     *         For <code>Enable</code>, you receive this error if you attempt to use a feature in an unsupported Amazon
     *         Web Services Region.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws InternalServerException
     *         The request has failed due to an internal failure of the Amazon Inspector service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Inspector2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Inspector2Client.AssociateMember
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/AssociateMember" target="_top">AWS
     *      API Documentation</a>
     */
    default AssociateMemberResponse associateMember(AssociateMemberRequest associateMemberRequest)
            throws ServiceQuotaExceededException, ValidationException, AccessDeniedException, ThrottlingException,
            InternalServerException, AwsServiceException, SdkClientException, Inspector2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Associates an Amazon Web Services account with an Amazon Inspector delegated administrator. An HTTP 200 response
     * indicates the association was successfully started, but doesn’t indicate whether it was completed. You can check
     * if the association completed by using <a
     * href="https://docs.aws.amazon.com/inspector/v2/APIReference/API_ListMembers.html">ListMembers</a> for multiple
     * accounts or <a href="https://docs.aws.amazon.com/inspector/v2/APIReference/API_GetMember.html">GetMembers</a> for
     * a single account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AssociateMemberRequest.Builder} avoiding the need
     * to create one manually via {@link AssociateMemberRequest#builder()}
     * </p>
     *
     * @param associateMemberRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.inspector2.model.AssociateMemberRequest.Builder} to create a
     *        request.
     * @return Result of the AssociateMember operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         You have exceeded your service quota. To perform the requested action, remove some of the relevant
     *         resources, or use Service Quotas to request a service quota increase.
     * @throws ValidationException
     *         The request has failed validation due to missing required fields or having invalid inputs.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.</p>
     *         <p>
     *         For <code>Enable</code>, you receive this error if you attempt to use a feature in an unsupported Amazon
     *         Web Services Region.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws InternalServerException
     *         The request has failed due to an internal failure of the Amazon Inspector service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Inspector2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Inspector2Client.AssociateMember
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/AssociateMember" target="_top">AWS
     *      API Documentation</a>
     */
    default AssociateMemberResponse associateMember(Consumer<AssociateMemberRequest.Builder> associateMemberRequest)
            throws ServiceQuotaExceededException, ValidationException, AccessDeniedException, ThrottlingException,
            InternalServerException, AwsServiceException, SdkClientException, Inspector2Exception {
        return associateMember(AssociateMemberRequest.builder().applyMutation(associateMemberRequest).build());
    }

    /**
     * <p>
     * Associates multiple code repositories with an Amazon Inspector code security scan configuration.
     * </p>
     *
     * @param batchAssociateCodeSecurityScanConfigurationRequest
     * @return Result of the BatchAssociateCodeSecurityScanConfiguration operation returned by the service.
     * @throws ConflictException
     *         A conflict occurred. This exception occurs when the same resource is being modified by concurrent
     *         requests.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.</p>
     *         <p>
     *         For <code>Enable</code>, you receive this error if you attempt to use a feature in an unsupported Amazon
     *         Web Services Region.
     * @throws ValidationException
     *         The request has failed validation due to missing required fields or having invalid inputs.
     * @throws ResourceNotFoundException
     *         The operation tried to access an invalid resource. Make sure the resource is specified correctly.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws InternalServerException
     *         The request has failed due to an internal failure of the Amazon Inspector service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Inspector2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Inspector2Client.BatchAssociateCodeSecurityScanConfiguration
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/BatchAssociateCodeSecurityScanConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default BatchAssociateCodeSecurityScanConfigurationResponse batchAssociateCodeSecurityScanConfiguration(
            BatchAssociateCodeSecurityScanConfigurationRequest batchAssociateCodeSecurityScanConfigurationRequest)
            throws ConflictException, AccessDeniedException, ValidationException, ResourceNotFoundException, ThrottlingException,
            InternalServerException, AwsServiceException, SdkClientException, Inspector2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Associates multiple code repositories with an Amazon Inspector code security scan configuration.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link BatchAssociateCodeSecurityScanConfigurationRequest.Builder} avoiding the need to create one manually via
     * {@link BatchAssociateCodeSecurityScanConfigurationRequest#builder()}
     * </p>
     *
     * @param batchAssociateCodeSecurityScanConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.inspector2.model.BatchAssociateCodeSecurityScanConfigurationRequest.Builder}
     *        to create a request.
     * @return Result of the BatchAssociateCodeSecurityScanConfiguration operation returned by the service.
     * @throws ConflictException
     *         A conflict occurred. This exception occurs when the same resource is being modified by concurrent
     *         requests.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.</p>
     *         <p>
     *         For <code>Enable</code>, you receive this error if you attempt to use a feature in an unsupported Amazon
     *         Web Services Region.
     * @throws ValidationException
     *         The request has failed validation due to missing required fields or having invalid inputs.
     * @throws ResourceNotFoundException
     *         The operation tried to access an invalid resource. Make sure the resource is specified correctly.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws InternalServerException
     *         The request has failed due to an internal failure of the Amazon Inspector service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Inspector2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Inspector2Client.BatchAssociateCodeSecurityScanConfiguration
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/BatchAssociateCodeSecurityScanConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default BatchAssociateCodeSecurityScanConfigurationResponse batchAssociateCodeSecurityScanConfiguration(
            Consumer<BatchAssociateCodeSecurityScanConfigurationRequest.Builder> batchAssociateCodeSecurityScanConfigurationRequest)
            throws ConflictException, AccessDeniedException, ValidationException, ResourceNotFoundException, ThrottlingException,
            InternalServerException, AwsServiceException, SdkClientException, Inspector2Exception {
        return batchAssociateCodeSecurityScanConfiguration(BatchAssociateCodeSecurityScanConfigurationRequest.builder()
                .applyMutation(batchAssociateCodeSecurityScanConfigurationRequest).build());
    }

    /**
     * <p>
     * Disassociates multiple code repositories from an Amazon Inspector code security scan configuration.
     * </p>
     *
     * @param batchDisassociateCodeSecurityScanConfigurationRequest
     * @return Result of the BatchDisassociateCodeSecurityScanConfiguration operation returned by the service.
     * @throws ConflictException
     *         A conflict occurred. This exception occurs when the same resource is being modified by concurrent
     *         requests.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.</p>
     *         <p>
     *         For <code>Enable</code>, you receive this error if you attempt to use a feature in an unsupported Amazon
     *         Web Services Region.
     * @throws ValidationException
     *         The request has failed validation due to missing required fields or having invalid inputs.
     * @throws ResourceNotFoundException
     *         The operation tried to access an invalid resource. Make sure the resource is specified correctly.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws InternalServerException
     *         The request has failed due to an internal failure of the Amazon Inspector service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Inspector2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Inspector2Client.BatchDisassociateCodeSecurityScanConfiguration
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/BatchDisassociateCodeSecurityScanConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default BatchDisassociateCodeSecurityScanConfigurationResponse batchDisassociateCodeSecurityScanConfiguration(
            BatchDisassociateCodeSecurityScanConfigurationRequest batchDisassociateCodeSecurityScanConfigurationRequest)
            throws ConflictException, AccessDeniedException, ValidationException, ResourceNotFoundException, ThrottlingException,
            InternalServerException, AwsServiceException, SdkClientException, Inspector2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Disassociates multiple code repositories from an Amazon Inspector code security scan configuration.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link BatchDisassociateCodeSecurityScanConfigurationRequest.Builder} avoiding the need to create one manually
     * via {@link BatchDisassociateCodeSecurityScanConfigurationRequest#builder()}
     * </p>
     *
     * @param batchDisassociateCodeSecurityScanConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.inspector2.model.BatchDisassociateCodeSecurityScanConfigurationRequest.Builder}
     *        to create a request.
     * @return Result of the BatchDisassociateCodeSecurityScanConfiguration operation returned by the service.
     * @throws ConflictException
     *         A conflict occurred. This exception occurs when the same resource is being modified by concurrent
     *         requests.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.</p>
     *         <p>
     *         For <code>Enable</code>, you receive this error if you attempt to use a feature in an unsupported Amazon
     *         Web Services Region.
     * @throws ValidationException
     *         The request has failed validation due to missing required fields or having invalid inputs.
     * @throws ResourceNotFoundException
     *         The operation tried to access an invalid resource. Make sure the resource is specified correctly.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws InternalServerException
     *         The request has failed due to an internal failure of the Amazon Inspector service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Inspector2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Inspector2Client.BatchDisassociateCodeSecurityScanConfiguration
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/BatchDisassociateCodeSecurityScanConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default BatchDisassociateCodeSecurityScanConfigurationResponse batchDisassociateCodeSecurityScanConfiguration(
            Consumer<BatchDisassociateCodeSecurityScanConfigurationRequest.Builder> batchDisassociateCodeSecurityScanConfigurationRequest)
            throws ConflictException, AccessDeniedException, ValidationException, ResourceNotFoundException, ThrottlingException,
            InternalServerException, AwsServiceException, SdkClientException, Inspector2Exception {
        return batchDisassociateCodeSecurityScanConfiguration(BatchDisassociateCodeSecurityScanConfigurationRequest.builder()
                .applyMutation(batchDisassociateCodeSecurityScanConfigurationRequest).build());
    }

    /**
     * <p>
     * Retrieves the Amazon Inspector status of multiple Amazon Web Services accounts within your environment.
     * </p>
     *
     * @param batchGetAccountStatusRequest
     * @return Result of the BatchGetAccountStatus operation returned by the service.
     * @throws ValidationException
     *         The request has failed validation due to missing required fields or having invalid inputs.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.</p>
     *         <p>
     *         For <code>Enable</code>, you receive this error if you attempt to use a feature in an unsupported Amazon
     *         Web Services Region.
     * @throws ResourceNotFoundException
     *         The operation tried to access an invalid resource. Make sure the resource is specified correctly.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws InternalServerException
     *         The request has failed due to an internal failure of the Amazon Inspector service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Inspector2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Inspector2Client.BatchGetAccountStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/BatchGetAccountStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default BatchGetAccountStatusResponse batchGetAccountStatus(BatchGetAccountStatusRequest batchGetAccountStatusRequest)
            throws ValidationException, AccessDeniedException, ResourceNotFoundException, ThrottlingException,
            InternalServerException, AwsServiceException, SdkClientException, Inspector2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the Amazon Inspector status of multiple Amazon Web Services accounts within your environment.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link BatchGetAccountStatusRequest.Builder} avoiding the
     * need to create one manually via {@link BatchGetAccountStatusRequest#builder()}
     * </p>
     *
     * @param batchGetAccountStatusRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.inspector2.model.BatchGetAccountStatusRequest.Builder} to create a
     *        request.
     * @return Result of the BatchGetAccountStatus operation returned by the service.
     * @throws ValidationException
     *         The request has failed validation due to missing required fields or having invalid inputs.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.</p>
     *         <p>
     *         For <code>Enable</code>, you receive this error if you attempt to use a feature in an unsupported Amazon
     *         Web Services Region.
     * @throws ResourceNotFoundException
     *         The operation tried to access an invalid resource. Make sure the resource is specified correctly.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws InternalServerException
     *         The request has failed due to an internal failure of the Amazon Inspector service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Inspector2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Inspector2Client.BatchGetAccountStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/BatchGetAccountStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default BatchGetAccountStatusResponse batchGetAccountStatus(
            Consumer<BatchGetAccountStatusRequest.Builder> batchGetAccountStatusRequest) throws ValidationException,
            AccessDeniedException, ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, Inspector2Exception {
        return batchGetAccountStatus(BatchGetAccountStatusRequest.builder().applyMutation(batchGetAccountStatusRequest).build());
    }

    /**
     * <p>
     * Retrieves code snippets from findings that Amazon Inspector detected code vulnerabilities in.
     * </p>
     *
     * @param batchGetCodeSnippetRequest
     * @return Result of the BatchGetCodeSnippet operation returned by the service.
     * @throws ValidationException
     *         The request has failed validation due to missing required fields or having invalid inputs.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.</p>
     *         <p>
     *         For <code>Enable</code>, you receive this error if you attempt to use a feature in an unsupported Amazon
     *         Web Services Region.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws InternalServerException
     *         The request has failed due to an internal failure of the Amazon Inspector service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Inspector2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Inspector2Client.BatchGetCodeSnippet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/BatchGetCodeSnippet"
     *      target="_top">AWS API Documentation</a>
     */
    default BatchGetCodeSnippetResponse batchGetCodeSnippet(BatchGetCodeSnippetRequest batchGetCodeSnippetRequest)
            throws ValidationException, AccessDeniedException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, Inspector2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves code snippets from findings that Amazon Inspector detected code vulnerabilities in.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link BatchGetCodeSnippetRequest.Builder} avoiding the
     * need to create one manually via {@link BatchGetCodeSnippetRequest#builder()}
     * </p>
     *
     * @param batchGetCodeSnippetRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.inspector2.model.BatchGetCodeSnippetRequest.Builder} to create a
     *        request.
     * @return Result of the BatchGetCodeSnippet operation returned by the service.
     * @throws ValidationException
     *         The request has failed validation due to missing required fields or having invalid inputs.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.</p>
     *         <p>
     *         For <code>Enable</code>, you receive this error if you attempt to use a feature in an unsupported Amazon
     *         Web Services Region.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws InternalServerException
     *         The request has failed due to an internal failure of the Amazon Inspector service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Inspector2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Inspector2Client.BatchGetCodeSnippet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/BatchGetCodeSnippet"
     *      target="_top">AWS API Documentation</a>
     */
    default BatchGetCodeSnippetResponse batchGetCodeSnippet(
            Consumer<BatchGetCodeSnippetRequest.Builder> batchGetCodeSnippetRequest) throws ValidationException,
            AccessDeniedException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException,
            Inspector2Exception {
        return batchGetCodeSnippet(BatchGetCodeSnippetRequest.builder().applyMutation(batchGetCodeSnippetRequest).build());
    }

    /**
     * <p>
     * Gets vulnerability details for findings.
     * </p>
     *
     * @param batchGetFindingDetailsRequest
     * @return Result of the BatchGetFindingDetails operation returned by the service.
     * @throws ValidationException
     *         The request has failed validation due to missing required fields or having invalid inputs.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.</p>
     *         <p>
     *         For <code>Enable</code>, you receive this error if you attempt to use a feature in an unsupported Amazon
     *         Web Services Region.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws InternalServerException
     *         The request has failed due to an internal failure of the Amazon Inspector service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Inspector2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Inspector2Client.BatchGetFindingDetails
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/BatchGetFindingDetails"
     *      target="_top">AWS API Documentation</a>
     */
    default BatchGetFindingDetailsResponse batchGetFindingDetails(BatchGetFindingDetailsRequest batchGetFindingDetailsRequest)
            throws ValidationException, AccessDeniedException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, Inspector2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets vulnerability details for findings.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link BatchGetFindingDetailsRequest.Builder} avoiding the
     * need to create one manually via {@link BatchGetFindingDetailsRequest#builder()}
     * </p>
     *
     * @param batchGetFindingDetailsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.inspector2.model.BatchGetFindingDetailsRequest.Builder} to create a
     *        request.
     * @return Result of the BatchGetFindingDetails operation returned by the service.
     * @throws ValidationException
     *         The request has failed validation due to missing required fields or having invalid inputs.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.</p>
     *         <p>
     *         For <code>Enable</code>, you receive this error if you attempt to use a feature in an unsupported Amazon
     *         Web Services Region.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws InternalServerException
     *         The request has failed due to an internal failure of the Amazon Inspector service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Inspector2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Inspector2Client.BatchGetFindingDetails
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/BatchGetFindingDetails"
     *      target="_top">AWS API Documentation</a>
     */
    default BatchGetFindingDetailsResponse batchGetFindingDetails(
            Consumer<BatchGetFindingDetailsRequest.Builder> batchGetFindingDetailsRequest) throws ValidationException,
            AccessDeniedException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException,
            Inspector2Exception {
        return batchGetFindingDetails(BatchGetFindingDetailsRequest.builder().applyMutation(batchGetFindingDetailsRequest)
                .build());
    }

    /**
     * <p>
     * Gets free trial status for multiple Amazon Web Services accounts.
     * </p>
     *
     * @param batchGetFreeTrialInfoRequest
     * @return Result of the BatchGetFreeTrialInfo operation returned by the service.
     * @throws ValidationException
     *         The request has failed validation due to missing required fields or having invalid inputs.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.</p>
     *         <p>
     *         For <code>Enable</code>, you receive this error if you attempt to use a feature in an unsupported Amazon
     *         Web Services Region.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws InternalServerException
     *         The request has failed due to an internal failure of the Amazon Inspector service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Inspector2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Inspector2Client.BatchGetFreeTrialInfo
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/BatchGetFreeTrialInfo"
     *      target="_top">AWS API Documentation</a>
     */
    default BatchGetFreeTrialInfoResponse batchGetFreeTrialInfo(BatchGetFreeTrialInfoRequest batchGetFreeTrialInfoRequest)
            throws ValidationException, AccessDeniedException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, Inspector2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets free trial status for multiple Amazon Web Services accounts.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link BatchGetFreeTrialInfoRequest.Builder} avoiding the
     * need to create one manually via {@link BatchGetFreeTrialInfoRequest#builder()}
     * </p>
     *
     * @param batchGetFreeTrialInfoRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.inspector2.model.BatchGetFreeTrialInfoRequest.Builder} to create a
     *        request.
     * @return Result of the BatchGetFreeTrialInfo operation returned by the service.
     * @throws ValidationException
     *         The request has failed validation due to missing required fields or having invalid inputs.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.</p>
     *         <p>
     *         For <code>Enable</code>, you receive this error if you attempt to use a feature in an unsupported Amazon
     *         Web Services Region.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws InternalServerException
     *         The request has failed due to an internal failure of the Amazon Inspector service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Inspector2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Inspector2Client.BatchGetFreeTrialInfo
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/BatchGetFreeTrialInfo"
     *      target="_top">AWS API Documentation</a>
     */
    default BatchGetFreeTrialInfoResponse batchGetFreeTrialInfo(
            Consumer<BatchGetFreeTrialInfoRequest.Builder> batchGetFreeTrialInfoRequest) throws ValidationException,
            AccessDeniedException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException,
            Inspector2Exception {
        return batchGetFreeTrialInfo(BatchGetFreeTrialInfoRequest.builder().applyMutation(batchGetFreeTrialInfoRequest).build());
    }

    /**
     * <p>
     * Retrieves Amazon Inspector deep inspection activation status of multiple member accounts within your
     * organization. You must be the delegated administrator of an organization in Amazon Inspector to use this API.
     * </p>
     *
     * @param batchGetMemberEc2DeepInspectionStatusRequest
     * @return Result of the BatchGetMemberEc2DeepInspectionStatus operation returned by the service.
     * @throws ValidationException
     *         The request has failed validation due to missing required fields or having invalid inputs.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.</p>
     *         <p>
     *         For <code>Enable</code>, you receive this error if you attempt to use a feature in an unsupported Amazon
     *         Web Services Region.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws InternalServerException
     *         The request has failed due to an internal failure of the Amazon Inspector service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Inspector2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Inspector2Client.BatchGetMemberEc2DeepInspectionStatus
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/BatchGetMemberEc2DeepInspectionStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default BatchGetMemberEc2DeepInspectionStatusResponse batchGetMemberEc2DeepInspectionStatus(
            BatchGetMemberEc2DeepInspectionStatusRequest batchGetMemberEc2DeepInspectionStatusRequest)
            throws ValidationException, AccessDeniedException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, Inspector2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves Amazon Inspector deep inspection activation status of multiple member accounts within your
     * organization. You must be the delegated administrator of an organization in Amazon Inspector to use this API.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link BatchGetMemberEc2DeepInspectionStatusRequest.Builder} avoiding the need to create one manually via
     * {@link BatchGetMemberEc2DeepInspectionStatusRequest#builder()}
     * </p>
     *
     * @param batchGetMemberEc2DeepInspectionStatusRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.inspector2.model.BatchGetMemberEc2DeepInspectionStatusRequest.Builder}
     *        to create a request.
     * @return Result of the BatchGetMemberEc2DeepInspectionStatus operation returned by the service.
     * @throws ValidationException
     *         The request has failed validation due to missing required fields or having invalid inputs.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.</p>
     *         <p>
     *         For <code>Enable</code>, you receive this error if you attempt to use a feature in an unsupported Amazon
     *         Web Services Region.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws InternalServerException
     *         The request has failed due to an internal failure of the Amazon Inspector service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Inspector2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Inspector2Client.BatchGetMemberEc2DeepInspectionStatus
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/BatchGetMemberEc2DeepInspectionStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default BatchGetMemberEc2DeepInspectionStatusResponse batchGetMemberEc2DeepInspectionStatus(
            Consumer<BatchGetMemberEc2DeepInspectionStatusRequest.Builder> batchGetMemberEc2DeepInspectionStatusRequest)
            throws ValidationException, AccessDeniedException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, Inspector2Exception {
        return batchGetMemberEc2DeepInspectionStatus(BatchGetMemberEc2DeepInspectionStatusRequest.builder()
                .applyMutation(batchGetMemberEc2DeepInspectionStatusRequest).build());
    }

    /**
     * <p>
     * Activates or deactivates Amazon Inspector deep inspection for the provided member accounts in your organization.
     * You must be the delegated administrator of an organization in Amazon Inspector to use this API.
     * </p>
     *
     * @param batchUpdateMemberEc2DeepInspectionStatusRequest
     * @return Result of the BatchUpdateMemberEc2DeepInspectionStatus operation returned by the service.
     * @throws ValidationException
     *         The request has failed validation due to missing required fields or having invalid inputs.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.</p>
     *         <p>
     *         For <code>Enable</code>, you receive this error if you attempt to use a feature in an unsupported Amazon
     *         Web Services Region.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws InternalServerException
     *         The request has failed due to an internal failure of the Amazon Inspector service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Inspector2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Inspector2Client.BatchUpdateMemberEc2DeepInspectionStatus
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/BatchUpdateMemberEc2DeepInspectionStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default BatchUpdateMemberEc2DeepInspectionStatusResponse batchUpdateMemberEc2DeepInspectionStatus(
            BatchUpdateMemberEc2DeepInspectionStatusRequest batchUpdateMemberEc2DeepInspectionStatusRequest)
            throws ValidationException, AccessDeniedException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, Inspector2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Activates or deactivates Amazon Inspector deep inspection for the provided member accounts in your organization.
     * You must be the delegated administrator of an organization in Amazon Inspector to use this API.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link BatchUpdateMemberEc2DeepInspectionStatusRequest.Builder} avoiding the need to create one manually via
     * {@link BatchUpdateMemberEc2DeepInspectionStatusRequest#builder()}
     * </p>
     *
     * @param batchUpdateMemberEc2DeepInspectionStatusRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.inspector2.model.BatchUpdateMemberEc2DeepInspectionStatusRequest.Builder}
     *        to create a request.
     * @return Result of the BatchUpdateMemberEc2DeepInspectionStatus operation returned by the service.
     * @throws ValidationException
     *         The request has failed validation due to missing required fields or having invalid inputs.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.</p>
     *         <p>
     *         For <code>Enable</code>, you receive this error if you attempt to use a feature in an unsupported Amazon
     *         Web Services Region.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws InternalServerException
     *         The request has failed due to an internal failure of the Amazon Inspector service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Inspector2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Inspector2Client.BatchUpdateMemberEc2DeepInspectionStatus
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/BatchUpdateMemberEc2DeepInspectionStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default BatchUpdateMemberEc2DeepInspectionStatusResponse batchUpdateMemberEc2DeepInspectionStatus(
            Consumer<BatchUpdateMemberEc2DeepInspectionStatusRequest.Builder> batchUpdateMemberEc2DeepInspectionStatusRequest)
            throws ValidationException, AccessDeniedException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, Inspector2Exception {
        return batchUpdateMemberEc2DeepInspectionStatus(BatchUpdateMemberEc2DeepInspectionStatusRequest.builder()
                .applyMutation(batchUpdateMemberEc2DeepInspectionStatusRequest).build());
    }

    /**
     * <p>
     * Cancels the given findings report.
     * </p>
     *
     * @param cancelFindingsReportRequest
     * @return Result of the CancelFindingsReport operation returned by the service.
     * @throws ValidationException
     *         The request has failed validation due to missing required fields or having invalid inputs.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.</p>
     *         <p>
     *         For <code>Enable</code>, you receive this error if you attempt to use a feature in an unsupported Amazon
     *         Web Services Region.
     * @throws ResourceNotFoundException
     *         The operation tried to access an invalid resource. Make sure the resource is specified correctly.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws InternalServerException
     *         The request has failed due to an internal failure of the Amazon Inspector service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Inspector2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Inspector2Client.CancelFindingsReport
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/CancelFindingsReport"
     *      target="_top">AWS API Documentation</a>
     */
    default CancelFindingsReportResponse cancelFindingsReport(CancelFindingsReportRequest cancelFindingsReportRequest)
            throws ValidationException, AccessDeniedException, ResourceNotFoundException, ThrottlingException,
            InternalServerException, AwsServiceException, SdkClientException, Inspector2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Cancels the given findings report.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CancelFindingsReportRequest.Builder} avoiding the
     * need to create one manually via {@link CancelFindingsReportRequest#builder()}
     * </p>
     *
     * @param cancelFindingsReportRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.inspector2.model.CancelFindingsReportRequest.Builder} to create a
     *        request.
     * @return Result of the CancelFindingsReport operation returned by the service.
     * @throws ValidationException
     *         The request has failed validation due to missing required fields or having invalid inputs.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.</p>
     *         <p>
     *         For <code>Enable</code>, you receive this error if you attempt to use a feature in an unsupported Amazon
     *         Web Services Region.
     * @throws ResourceNotFoundException
     *         The operation tried to access an invalid resource. Make sure the resource is specified correctly.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws InternalServerException
     *         The request has failed due to an internal failure of the Amazon Inspector service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Inspector2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Inspector2Client.CancelFindingsReport
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/CancelFindingsReport"
     *      target="_top">AWS API Documentation</a>
     */
    default CancelFindingsReportResponse cancelFindingsReport(
            Consumer<CancelFindingsReportRequest.Builder> cancelFindingsReportRequest) throws ValidationException,
            AccessDeniedException, ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, Inspector2Exception {
        return cancelFindingsReport(CancelFindingsReportRequest.builder().applyMutation(cancelFindingsReportRequest).build());
    }

    /**
     * <p>
     * Cancels a software bill of materials (SBOM) report.
     * </p>
     *
     * @param cancelSbomExportRequest
     * @return Result of the CancelSbomExport operation returned by the service.
     * @throws ValidationException
     *         The request has failed validation due to missing required fields or having invalid inputs.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.</p>
     *         <p>
     *         For <code>Enable</code>, you receive this error if you attempt to use a feature in an unsupported Amazon
     *         Web Services Region.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws ResourceNotFoundException
     *         The operation tried to access an invalid resource. Make sure the resource is specified correctly.
     * @throws InternalServerException
     *         The request has failed due to an internal failure of the Amazon Inspector service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Inspector2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Inspector2Client.CancelSbomExport
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/CancelSbomExport" target="_top">AWS
     *      API Documentation</a>
     */
    default CancelSbomExportResponse cancelSbomExport(CancelSbomExportRequest cancelSbomExportRequest)
            throws ValidationException, AccessDeniedException, ThrottlingException, ResourceNotFoundException,
            InternalServerException, AwsServiceException, SdkClientException, Inspector2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Cancels a software bill of materials (SBOM) report.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CancelSbomExportRequest.Builder} avoiding the need
     * to create one manually via {@link CancelSbomExportRequest#builder()}
     * </p>
     *
     * @param cancelSbomExportRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.inspector2.model.CancelSbomExportRequest.Builder} to create a
     *        request.
     * @return Result of the CancelSbomExport operation returned by the service.
     * @throws ValidationException
     *         The request has failed validation due to missing required fields or having invalid inputs.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.</p>
     *         <p>
     *         For <code>Enable</code>, you receive this error if you attempt to use a feature in an unsupported Amazon
     *         Web Services Region.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws ResourceNotFoundException
     *         The operation tried to access an invalid resource. Make sure the resource is specified correctly.
     * @throws InternalServerException
     *         The request has failed due to an internal failure of the Amazon Inspector service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Inspector2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Inspector2Client.CancelSbomExport
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/CancelSbomExport" target="_top">AWS
     *      API Documentation</a>
     */
    default CancelSbomExportResponse cancelSbomExport(Consumer<CancelSbomExportRequest.Builder> cancelSbomExportRequest)
            throws ValidationException, AccessDeniedException, ThrottlingException, ResourceNotFoundException,
            InternalServerException, AwsServiceException, SdkClientException, Inspector2Exception {
        return cancelSbomExport(CancelSbomExportRequest.builder().applyMutation(cancelSbomExportRequest).build());
    }

    /**
     * <p>
     * Creates a CIS scan configuration.
     * </p>
     *
     * @param createCisScanConfigurationRequest
     * @return Result of the CreateCisScanConfiguration operation returned by the service.
     * @throws ValidationException
     *         The request has failed validation due to missing required fields or having invalid inputs.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.</p>
     *         <p>
     *         For <code>Enable</code>, you receive this error if you attempt to use a feature in an unsupported Amazon
     *         Web Services Region.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws InternalServerException
     *         The request has failed due to an internal failure of the Amazon Inspector service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Inspector2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Inspector2Client.CreateCisScanConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/CreateCisScanConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateCisScanConfigurationResponse createCisScanConfiguration(
            CreateCisScanConfigurationRequest createCisScanConfigurationRequest) throws ValidationException,
            AccessDeniedException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException,
            Inspector2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a CIS scan configuration.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateCisScanConfigurationRequest.Builder} avoiding
     * the need to create one manually via {@link CreateCisScanConfigurationRequest#builder()}
     * </p>
     *
     * @param createCisScanConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.inspector2.model.CreateCisScanConfigurationRequest.Builder} to
     *        create a request.
     * @return Result of the CreateCisScanConfiguration operation returned by the service.
     * @throws ValidationException
     *         The request has failed validation due to missing required fields or having invalid inputs.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.</p>
     *         <p>
     *         For <code>Enable</code>, you receive this error if you attempt to use a feature in an unsupported Amazon
     *         Web Services Region.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws InternalServerException
     *         The request has failed due to an internal failure of the Amazon Inspector service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Inspector2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Inspector2Client.CreateCisScanConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/CreateCisScanConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateCisScanConfigurationResponse createCisScanConfiguration(
            Consumer<CreateCisScanConfigurationRequest.Builder> createCisScanConfigurationRequest) throws ValidationException,
            AccessDeniedException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException,
            Inspector2Exception {
        return createCisScanConfiguration(CreateCisScanConfigurationRequest.builder()
                .applyMutation(createCisScanConfigurationRequest).build());
    }

    /**
     * <p>
     * Creates a code security integration with a source code repository provider.
     * </p>
     * <p>
     * After calling the <code>CreateCodeSecurityIntegration</code> operation, you complete authentication and
     * authorization with your provider. Next you call the <code>UpdateCodeSecurityIntegration</code> operation to
     * provide the <code>details</code> to complete the integration setup
     * </p>
     *
     * @param createCodeSecurityIntegrationRequest
     * @return Result of the CreateCodeSecurityIntegration operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         You have exceeded your service quota. To perform the requested action, remove some of the relevant
     *         resources, or use Service Quotas to request a service quota increase.
     * @throws ConflictException
     *         A conflict occurred. This exception occurs when the same resource is being modified by concurrent
     *         requests.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.</p>
     *         <p>
     *         For <code>Enable</code>, you receive this error if you attempt to use a feature in an unsupported Amazon
     *         Web Services Region.
     * @throws ValidationException
     *         The request has failed validation due to missing required fields or having invalid inputs.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws InternalServerException
     *         The request has failed due to an internal failure of the Amazon Inspector service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Inspector2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Inspector2Client.CreateCodeSecurityIntegration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/CreateCodeSecurityIntegration"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateCodeSecurityIntegrationResponse createCodeSecurityIntegration(
            CreateCodeSecurityIntegrationRequest createCodeSecurityIntegrationRequest) throws ServiceQuotaExceededException,
            ConflictException, AccessDeniedException, ValidationException, ThrottlingException, InternalServerException,
            AwsServiceException, SdkClientException, Inspector2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a code security integration with a source code repository provider.
     * </p>
     * <p>
     * After calling the <code>CreateCodeSecurityIntegration</code> operation, you complete authentication and
     * authorization with your provider. Next you call the <code>UpdateCodeSecurityIntegration</code> operation to
     * provide the <code>details</code> to complete the integration setup
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateCodeSecurityIntegrationRequest.Builder}
     * avoiding the need to create one manually via {@link CreateCodeSecurityIntegrationRequest#builder()}
     * </p>
     *
     * @param createCodeSecurityIntegrationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.inspector2.model.CreateCodeSecurityIntegrationRequest.Builder} to
     *        create a request.
     * @return Result of the CreateCodeSecurityIntegration operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         You have exceeded your service quota. To perform the requested action, remove some of the relevant
     *         resources, or use Service Quotas to request a service quota increase.
     * @throws ConflictException
     *         A conflict occurred. This exception occurs when the same resource is being modified by concurrent
     *         requests.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.</p>
     *         <p>
     *         For <code>Enable</code>, you receive this error if you attempt to use a feature in an unsupported Amazon
     *         Web Services Region.
     * @throws ValidationException
     *         The request has failed validation due to missing required fields or having invalid inputs.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws InternalServerException
     *         The request has failed due to an internal failure of the Amazon Inspector service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Inspector2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Inspector2Client.CreateCodeSecurityIntegration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/CreateCodeSecurityIntegration"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateCodeSecurityIntegrationResponse createCodeSecurityIntegration(
            Consumer<CreateCodeSecurityIntegrationRequest.Builder> createCodeSecurityIntegrationRequest)
            throws ServiceQuotaExceededException, ConflictException, AccessDeniedException, ValidationException,
            ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, Inspector2Exception {
        return createCodeSecurityIntegration(CreateCodeSecurityIntegrationRequest.builder()
                .applyMutation(createCodeSecurityIntegrationRequest).build());
    }

    /**
     * <p>
     * Creates a scan configuration for code security scanning.
     * </p>
     *
     * @param createCodeSecurityScanConfigurationRequest
     * @return Result of the CreateCodeSecurityScanConfiguration operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         You have exceeded your service quota. To perform the requested action, remove some of the relevant
     *         resources, or use Service Quotas to request a service quota increase.
     * @throws ConflictException
     *         A conflict occurred. This exception occurs when the same resource is being modified by concurrent
     *         requests.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.</p>
     *         <p>
     *         For <code>Enable</code>, you receive this error if you attempt to use a feature in an unsupported Amazon
     *         Web Services Region.
     * @throws ValidationException
     *         The request has failed validation due to missing required fields or having invalid inputs.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws InternalServerException
     *         The request has failed due to an internal failure of the Amazon Inspector service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Inspector2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Inspector2Client.CreateCodeSecurityScanConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/CreateCodeSecurityScanConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateCodeSecurityScanConfigurationResponse createCodeSecurityScanConfiguration(
            CreateCodeSecurityScanConfigurationRequest createCodeSecurityScanConfigurationRequest)
            throws ServiceQuotaExceededException, ConflictException, AccessDeniedException, ValidationException,
            ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, Inspector2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a scan configuration for code security scanning.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateCodeSecurityScanConfigurationRequest.Builder}
     * avoiding the need to create one manually via {@link CreateCodeSecurityScanConfigurationRequest#builder()}
     * </p>
     *
     * @param createCodeSecurityScanConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.inspector2.model.CreateCodeSecurityScanConfigurationRequest.Builder}
     *        to create a request.
     * @return Result of the CreateCodeSecurityScanConfiguration operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         You have exceeded your service quota. To perform the requested action, remove some of the relevant
     *         resources, or use Service Quotas to request a service quota increase.
     * @throws ConflictException
     *         A conflict occurred. This exception occurs when the same resource is being modified by concurrent
     *         requests.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.</p>
     *         <p>
     *         For <code>Enable</code>, you receive this error if you attempt to use a feature in an unsupported Amazon
     *         Web Services Region.
     * @throws ValidationException
     *         The request has failed validation due to missing required fields or having invalid inputs.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws InternalServerException
     *         The request has failed due to an internal failure of the Amazon Inspector service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Inspector2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Inspector2Client.CreateCodeSecurityScanConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/CreateCodeSecurityScanConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateCodeSecurityScanConfigurationResponse createCodeSecurityScanConfiguration(
            Consumer<CreateCodeSecurityScanConfigurationRequest.Builder> createCodeSecurityScanConfigurationRequest)
            throws ServiceQuotaExceededException, ConflictException, AccessDeniedException, ValidationException,
            ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, Inspector2Exception {
        return createCodeSecurityScanConfiguration(CreateCodeSecurityScanConfigurationRequest.builder()
                .applyMutation(createCodeSecurityScanConfigurationRequest).build());
    }

    /**
     * <p>
     * Creates a filter resource using specified filter criteria. When the filter action is set to <code>SUPPRESS</code>
     * this action creates a suppression rule.
     * </p>
     *
     * @param createFilterRequest
     * @return Result of the CreateFilter operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         You have exceeded your service quota. To perform the requested action, remove some of the relevant
     *         resources, or use Service Quotas to request a service quota increase.
     * @throws BadRequestException
     *         One or more tags submitted as part of the request is not valid.
     * @throws ValidationException
     *         The request has failed validation due to missing required fields or having invalid inputs.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.</p>
     *         <p>
     *         For <code>Enable</code>, you receive this error if you attempt to use a feature in an unsupported Amazon
     *         Web Services Region.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws InternalServerException
     *         The request has failed due to an internal failure of the Amazon Inspector service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Inspector2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Inspector2Client.CreateFilter
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/CreateFilter" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateFilterResponse createFilter(CreateFilterRequest createFilterRequest) throws ServiceQuotaExceededException,
            BadRequestException, ValidationException, AccessDeniedException, ThrottlingException, InternalServerException,
            AwsServiceException, SdkClientException, Inspector2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a filter resource using specified filter criteria. When the filter action is set to <code>SUPPRESS</code>
     * this action creates a suppression rule.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateFilterRequest.Builder} avoiding the need to
     * create one manually via {@link CreateFilterRequest#builder()}
     * </p>
     *
     * @param createFilterRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.inspector2.model.CreateFilterRequest.Builder} to create a request.
     * @return Result of the CreateFilter operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         You have exceeded your service quota. To perform the requested action, remove some of the relevant
     *         resources, or use Service Quotas to request a service quota increase.
     * @throws BadRequestException
     *         One or more tags submitted as part of the request is not valid.
     * @throws ValidationException
     *         The request has failed validation due to missing required fields or having invalid inputs.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.</p>
     *         <p>
     *         For <code>Enable</code>, you receive this error if you attempt to use a feature in an unsupported Amazon
     *         Web Services Region.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws InternalServerException
     *         The request has failed due to an internal failure of the Amazon Inspector service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Inspector2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Inspector2Client.CreateFilter
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/CreateFilter" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateFilterResponse createFilter(Consumer<CreateFilterRequest.Builder> createFilterRequest)
            throws ServiceQuotaExceededException, BadRequestException, ValidationException, AccessDeniedException,
            ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, Inspector2Exception {
        return createFilter(CreateFilterRequest.builder().applyMutation(createFilterRequest).build());
    }

    /**
     * <p>
     * Creates a finding report. By default only <code>ACTIVE</code> findings are returned in the report. To see
     * <code>SUPRESSED</code> or <code>CLOSED</code> findings you must specify a value for the
     * <code>findingStatus</code> filter criteria.
     * </p>
     *
     * @param createFindingsReportRequest
     * @return Result of the CreateFindingsReport operation returned by the service.
     * @throws ValidationException
     *         The request has failed validation due to missing required fields or having invalid inputs.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.</p>
     *         <p>
     *         For <code>Enable</code>, you receive this error if you attempt to use a feature in an unsupported Amazon
     *         Web Services Region.
     * @throws ResourceNotFoundException
     *         The operation tried to access an invalid resource. Make sure the resource is specified correctly.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws InternalServerException
     *         The request has failed due to an internal failure of the Amazon Inspector service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Inspector2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Inspector2Client.CreateFindingsReport
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/CreateFindingsReport"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateFindingsReportResponse createFindingsReport(CreateFindingsReportRequest createFindingsReportRequest)
            throws ValidationException, AccessDeniedException, ResourceNotFoundException, ThrottlingException,
            InternalServerException, AwsServiceException, SdkClientException, Inspector2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a finding report. By default only <code>ACTIVE</code> findings are returned in the report. To see
     * <code>SUPRESSED</code> or <code>CLOSED</code> findings you must specify a value for the
     * <code>findingStatus</code> filter criteria.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateFindingsReportRequest.Builder} avoiding the
     * need to create one manually via {@link CreateFindingsReportRequest#builder()}
     * </p>
     *
     * @param createFindingsReportRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.inspector2.model.CreateFindingsReportRequest.Builder} to create a
     *        request.
     * @return Result of the CreateFindingsReport operation returned by the service.
     * @throws ValidationException
     *         The request has failed validation due to missing required fields or having invalid inputs.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.</p>
     *         <p>
     *         For <code>Enable</code>, you receive this error if you attempt to use a feature in an unsupported Amazon
     *         Web Services Region.
     * @throws ResourceNotFoundException
     *         The operation tried to access an invalid resource. Make sure the resource is specified correctly.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws InternalServerException
     *         The request has failed due to an internal failure of the Amazon Inspector service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Inspector2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Inspector2Client.CreateFindingsReport
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/CreateFindingsReport"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateFindingsReportResponse createFindingsReport(
            Consumer<CreateFindingsReportRequest.Builder> createFindingsReportRequest) throws ValidationException,
            AccessDeniedException, ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, Inspector2Exception {
        return createFindingsReport(CreateFindingsReportRequest.builder().applyMutation(createFindingsReportRequest).build());
    }

    /**
     * <p>
     * Creates a software bill of materials (SBOM) report.
     * </p>
     *
     * @param createSbomExportRequest
     * @return Result of the CreateSbomExport operation returned by the service.
     * @throws ValidationException
     *         The request has failed validation due to missing required fields or having invalid inputs.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.</p>
     *         <p>
     *         For <code>Enable</code>, you receive this error if you attempt to use a feature in an unsupported Amazon
     *         Web Services Region.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws ResourceNotFoundException
     *         The operation tried to access an invalid resource. Make sure the resource is specified correctly.
     * @throws InternalServerException
     *         The request has failed due to an internal failure of the Amazon Inspector service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Inspector2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Inspector2Client.CreateSbomExport
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/CreateSbomExport" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateSbomExportResponse createSbomExport(CreateSbomExportRequest createSbomExportRequest)
            throws ValidationException, AccessDeniedException, ThrottlingException, ResourceNotFoundException,
            InternalServerException, AwsServiceException, SdkClientException, Inspector2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a software bill of materials (SBOM) report.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateSbomExportRequest.Builder} avoiding the need
     * to create one manually via {@link CreateSbomExportRequest#builder()}
     * </p>
     *
     * @param createSbomExportRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.inspector2.model.CreateSbomExportRequest.Builder} to create a
     *        request.
     * @return Result of the CreateSbomExport operation returned by the service.
     * @throws ValidationException
     *         The request has failed validation due to missing required fields or having invalid inputs.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.</p>
     *         <p>
     *         For <code>Enable</code>, you receive this error if you attempt to use a feature in an unsupported Amazon
     *         Web Services Region.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws ResourceNotFoundException
     *         The operation tried to access an invalid resource. Make sure the resource is specified correctly.
     * @throws InternalServerException
     *         The request has failed due to an internal failure of the Amazon Inspector service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Inspector2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Inspector2Client.CreateSbomExport
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/CreateSbomExport" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateSbomExportResponse createSbomExport(Consumer<CreateSbomExportRequest.Builder> createSbomExportRequest)
            throws ValidationException, AccessDeniedException, ThrottlingException, ResourceNotFoundException,
            InternalServerException, AwsServiceException, SdkClientException, Inspector2Exception {
        return createSbomExport(CreateSbomExportRequest.builder().applyMutation(createSbomExportRequest).build());
    }

    /**
     * <p>
     * Deletes a CIS scan configuration.
     * </p>
     *
     * @param deleteCisScanConfigurationRequest
     * @return Result of the DeleteCisScanConfiguration operation returned by the service.
     * @throws ValidationException
     *         The request has failed validation due to missing required fields or having invalid inputs.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.</p>
     *         <p>
     *         For <code>Enable</code>, you receive this error if you attempt to use a feature in an unsupported Amazon
     *         Web Services Region.
     * @throws ResourceNotFoundException
     *         The operation tried to access an invalid resource. Make sure the resource is specified correctly.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws InternalServerException
     *         The request has failed due to an internal failure of the Amazon Inspector service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Inspector2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Inspector2Client.DeleteCisScanConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/DeleteCisScanConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteCisScanConfigurationResponse deleteCisScanConfiguration(
            DeleteCisScanConfigurationRequest deleteCisScanConfigurationRequest) throws ValidationException,
            AccessDeniedException, ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, Inspector2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a CIS scan configuration.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteCisScanConfigurationRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteCisScanConfigurationRequest#builder()}
     * </p>
     *
     * @param deleteCisScanConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.inspector2.model.DeleteCisScanConfigurationRequest.Builder} to
     *        create a request.
     * @return Result of the DeleteCisScanConfiguration operation returned by the service.
     * @throws ValidationException
     *         The request has failed validation due to missing required fields or having invalid inputs.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.</p>
     *         <p>
     *         For <code>Enable</code>, you receive this error if you attempt to use a feature in an unsupported Amazon
     *         Web Services Region.
     * @throws ResourceNotFoundException
     *         The operation tried to access an invalid resource. Make sure the resource is specified correctly.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws InternalServerException
     *         The request has failed due to an internal failure of the Amazon Inspector service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Inspector2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Inspector2Client.DeleteCisScanConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/DeleteCisScanConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteCisScanConfigurationResponse deleteCisScanConfiguration(
            Consumer<DeleteCisScanConfigurationRequest.Builder> deleteCisScanConfigurationRequest) throws ValidationException,
            AccessDeniedException, ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, Inspector2Exception {
        return deleteCisScanConfiguration(DeleteCisScanConfigurationRequest.builder()
                .applyMutation(deleteCisScanConfigurationRequest).build());
    }

    /**
     * <p>
     * Deletes a code security integration.
     * </p>
     *
     * @param deleteCodeSecurityIntegrationRequest
     * @return Result of the DeleteCodeSecurityIntegration operation returned by the service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.</p>
     *         <p>
     *         For <code>Enable</code>, you receive this error if you attempt to use a feature in an unsupported Amazon
     *         Web Services Region.
     * @throws ValidationException
     *         The request has failed validation due to missing required fields or having invalid inputs.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws ResourceNotFoundException
     *         The operation tried to access an invalid resource. Make sure the resource is specified correctly.
     * @throws InternalServerException
     *         The request has failed due to an internal failure of the Amazon Inspector service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Inspector2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Inspector2Client.DeleteCodeSecurityIntegration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/DeleteCodeSecurityIntegration"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteCodeSecurityIntegrationResponse deleteCodeSecurityIntegration(
            DeleteCodeSecurityIntegrationRequest deleteCodeSecurityIntegrationRequest) throws AccessDeniedException,
            ValidationException, ThrottlingException, ResourceNotFoundException, InternalServerException, AwsServiceException,
            SdkClientException, Inspector2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a code security integration.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteCodeSecurityIntegrationRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteCodeSecurityIntegrationRequest#builder()}
     * </p>
     *
     * @param deleteCodeSecurityIntegrationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.inspector2.model.DeleteCodeSecurityIntegrationRequest.Builder} to
     *        create a request.
     * @return Result of the DeleteCodeSecurityIntegration operation returned by the service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.</p>
     *         <p>
     *         For <code>Enable</code>, you receive this error if you attempt to use a feature in an unsupported Amazon
     *         Web Services Region.
     * @throws ValidationException
     *         The request has failed validation due to missing required fields or having invalid inputs.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws ResourceNotFoundException
     *         The operation tried to access an invalid resource. Make sure the resource is specified correctly.
     * @throws InternalServerException
     *         The request has failed due to an internal failure of the Amazon Inspector service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Inspector2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Inspector2Client.DeleteCodeSecurityIntegration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/DeleteCodeSecurityIntegration"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteCodeSecurityIntegrationResponse deleteCodeSecurityIntegration(
            Consumer<DeleteCodeSecurityIntegrationRequest.Builder> deleteCodeSecurityIntegrationRequest)
            throws AccessDeniedException, ValidationException, ThrottlingException, ResourceNotFoundException,
            InternalServerException, AwsServiceException, SdkClientException, Inspector2Exception {
        return deleteCodeSecurityIntegration(DeleteCodeSecurityIntegrationRequest.builder()
                .applyMutation(deleteCodeSecurityIntegrationRequest).build());
    }

    /**
     * <p>
     * Deletes a code security scan configuration.
     * </p>
     *
     * @param deleteCodeSecurityScanConfigurationRequest
     * @return Result of the DeleteCodeSecurityScanConfiguration operation returned by the service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.</p>
     *         <p>
     *         For <code>Enable</code>, you receive this error if you attempt to use a feature in an unsupported Amazon
     *         Web Services Region.
     * @throws ValidationException
     *         The request has failed validation due to missing required fields or having invalid inputs.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws ResourceNotFoundException
     *         The operation tried to access an invalid resource. Make sure the resource is specified correctly.
     * @throws InternalServerException
     *         The request has failed due to an internal failure of the Amazon Inspector service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Inspector2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Inspector2Client.DeleteCodeSecurityScanConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/DeleteCodeSecurityScanConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteCodeSecurityScanConfigurationResponse deleteCodeSecurityScanConfiguration(
            DeleteCodeSecurityScanConfigurationRequest deleteCodeSecurityScanConfigurationRequest) throws AccessDeniedException,
            ValidationException, ThrottlingException, ResourceNotFoundException, InternalServerException, AwsServiceException,
            SdkClientException, Inspector2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a code security scan configuration.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteCodeSecurityScanConfigurationRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteCodeSecurityScanConfigurationRequest#builder()}
     * </p>
     *
     * @param deleteCodeSecurityScanConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.inspector2.model.DeleteCodeSecurityScanConfigurationRequest.Builder}
     *        to create a request.
     * @return Result of the DeleteCodeSecurityScanConfiguration operation returned by the service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.</p>
     *         <p>
     *         For <code>Enable</code>, you receive this error if you attempt to use a feature in an unsupported Amazon
     *         Web Services Region.
     * @throws ValidationException
     *         The request has failed validation due to missing required fields or having invalid inputs.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws ResourceNotFoundException
     *         The operation tried to access an invalid resource. Make sure the resource is specified correctly.
     * @throws InternalServerException
     *         The request has failed due to an internal failure of the Amazon Inspector service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Inspector2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Inspector2Client.DeleteCodeSecurityScanConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/DeleteCodeSecurityScanConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteCodeSecurityScanConfigurationResponse deleteCodeSecurityScanConfiguration(
            Consumer<DeleteCodeSecurityScanConfigurationRequest.Builder> deleteCodeSecurityScanConfigurationRequest)
            throws AccessDeniedException, ValidationException, ThrottlingException, ResourceNotFoundException,
            InternalServerException, AwsServiceException, SdkClientException, Inspector2Exception {
        return deleteCodeSecurityScanConfiguration(DeleteCodeSecurityScanConfigurationRequest.builder()
                .applyMutation(deleteCodeSecurityScanConfigurationRequest).build());
    }

    /**
     * <p>
     * Deletes a filter resource.
     * </p>
     *
     * @param deleteFilterRequest
     * @return Result of the DeleteFilter operation returned by the service.
     * @throws ValidationException
     *         The request has failed validation due to missing required fields or having invalid inputs.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.</p>
     *         <p>
     *         For <code>Enable</code>, you receive this error if you attempt to use a feature in an unsupported Amazon
     *         Web Services Region.
     * @throws ResourceNotFoundException
     *         The operation tried to access an invalid resource. Make sure the resource is specified correctly.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws InternalServerException
     *         The request has failed due to an internal failure of the Amazon Inspector service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Inspector2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Inspector2Client.DeleteFilter
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/DeleteFilter" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteFilterResponse deleteFilter(DeleteFilterRequest deleteFilterRequest) throws ValidationException,
            AccessDeniedException, ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, Inspector2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a filter resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteFilterRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteFilterRequest#builder()}
     * </p>
     *
     * @param deleteFilterRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.inspector2.model.DeleteFilterRequest.Builder} to create a request.
     * @return Result of the DeleteFilter operation returned by the service.
     * @throws ValidationException
     *         The request has failed validation due to missing required fields or having invalid inputs.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.</p>
     *         <p>
     *         For <code>Enable</code>, you receive this error if you attempt to use a feature in an unsupported Amazon
     *         Web Services Region.
     * @throws ResourceNotFoundException
     *         The operation tried to access an invalid resource. Make sure the resource is specified correctly.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws InternalServerException
     *         The request has failed due to an internal failure of the Amazon Inspector service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Inspector2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Inspector2Client.DeleteFilter
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/DeleteFilter" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteFilterResponse deleteFilter(Consumer<DeleteFilterRequest.Builder> deleteFilterRequest)
            throws ValidationException, AccessDeniedException, ResourceNotFoundException, ThrottlingException,
            InternalServerException, AwsServiceException, SdkClientException, Inspector2Exception {
        return deleteFilter(DeleteFilterRequest.builder().applyMutation(deleteFilterRequest).build());
    }

    /**
     * <p>
     * Describe Amazon Inspector configuration settings for an Amazon Web Services organization.
     * </p>
     *
     * @param describeOrganizationConfigurationRequest
     * @return Result of the DescribeOrganizationConfiguration operation returned by the service.
     * @throws ValidationException
     *         The request has failed validation due to missing required fields or having invalid inputs.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.</p>
     *         <p>
     *         For <code>Enable</code>, you receive this error if you attempt to use a feature in an unsupported Amazon
     *         Web Services Region.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws InternalServerException
     *         The request has failed due to an internal failure of the Amazon Inspector service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Inspector2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Inspector2Client.DescribeOrganizationConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/DescribeOrganizationConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeOrganizationConfigurationResponse describeOrganizationConfiguration(
            DescribeOrganizationConfigurationRequest describeOrganizationConfigurationRequest) throws ValidationException,
            AccessDeniedException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException,
            Inspector2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describe Amazon Inspector configuration settings for an Amazon Web Services organization.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeOrganizationConfigurationRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeOrganizationConfigurationRequest#builder()}
     * </p>
     *
     * @param describeOrganizationConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.inspector2.model.DescribeOrganizationConfigurationRequest.Builder}
     *        to create a request.
     * @return Result of the DescribeOrganizationConfiguration operation returned by the service.
     * @throws ValidationException
     *         The request has failed validation due to missing required fields or having invalid inputs.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.</p>
     *         <p>
     *         For <code>Enable</code>, you receive this error if you attempt to use a feature in an unsupported Amazon
     *         Web Services Region.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws InternalServerException
     *         The request has failed due to an internal failure of the Amazon Inspector service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Inspector2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Inspector2Client.DescribeOrganizationConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/DescribeOrganizationConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeOrganizationConfigurationResponse describeOrganizationConfiguration(
            Consumer<DescribeOrganizationConfigurationRequest.Builder> describeOrganizationConfigurationRequest)
            throws ValidationException, AccessDeniedException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, Inspector2Exception {
        return describeOrganizationConfiguration(DescribeOrganizationConfigurationRequest.builder()
                .applyMutation(describeOrganizationConfigurationRequest).build());
    }

    /**
     * <p>
     * Disables Amazon Inspector scans for one or more Amazon Web Services accounts. Disabling all scan types in an
     * account disables the Amazon Inspector service.
     * </p>
     *
     * @param disableRequest
     * @return Result of the Disable operation returned by the service.
     * @throws ValidationException
     *         The request has failed validation due to missing required fields or having invalid inputs.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.</p>
     *         <p>
     *         For <code>Enable</code>, you receive this error if you attempt to use a feature in an unsupported Amazon
     *         Web Services Region.
     * @throws ResourceNotFoundException
     *         The operation tried to access an invalid resource. Make sure the resource is specified correctly.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws InternalServerException
     *         The request has failed due to an internal failure of the Amazon Inspector service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Inspector2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Inspector2Client.Disable
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/Disable" target="_top">AWS API
     *      Documentation</a>
     */
    default DisableResponse disable(DisableRequest disableRequest) throws ValidationException, AccessDeniedException,
            ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException,
            Inspector2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Disables Amazon Inspector scans for one or more Amazon Web Services accounts. Disabling all scan types in an
     * account disables the Amazon Inspector service.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DisableRequest.Builder} avoiding the need to create
     * one manually via {@link DisableRequest#builder()}
     * </p>
     *
     * @param disableRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.inspector2.model.DisableRequest.Builder} to create a request.
     * @return Result of the Disable operation returned by the service.
     * @throws ValidationException
     *         The request has failed validation due to missing required fields or having invalid inputs.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.</p>
     *         <p>
     *         For <code>Enable</code>, you receive this error if you attempt to use a feature in an unsupported Amazon
     *         Web Services Region.
     * @throws ResourceNotFoundException
     *         The operation tried to access an invalid resource. Make sure the resource is specified correctly.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws InternalServerException
     *         The request has failed due to an internal failure of the Amazon Inspector service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Inspector2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Inspector2Client.Disable
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/Disable" target="_top">AWS API
     *      Documentation</a>
     */
    default DisableResponse disable(Consumer<DisableRequest.Builder> disableRequest) throws ValidationException,
            AccessDeniedException, ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, Inspector2Exception {
        return disable(DisableRequest.builder().applyMutation(disableRequest).build());
    }

    /**
     * <p>
     * Disables the Amazon Inspector delegated administrator for your organization.
     * </p>
     *
     * @param disableDelegatedAdminAccountRequest
     * @return Result of the DisableDelegatedAdminAccount operation returned by the service.
     * @throws ConflictException
     *         A conflict occurred. This exception occurs when the same resource is being modified by concurrent
     *         requests.
     * @throws ValidationException
     *         The request has failed validation due to missing required fields or having invalid inputs.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.</p>
     *         <p>
     *         For <code>Enable</code>, you receive this error if you attempt to use a feature in an unsupported Amazon
     *         Web Services Region.
     * @throws ResourceNotFoundException
     *         The operation tried to access an invalid resource. Make sure the resource is specified correctly.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws InternalServerException
     *         The request has failed due to an internal failure of the Amazon Inspector service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Inspector2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Inspector2Client.DisableDelegatedAdminAccount
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/DisableDelegatedAdminAccount"
     *      target="_top">AWS API Documentation</a>
     */
    default DisableDelegatedAdminAccountResponse disableDelegatedAdminAccount(
            DisableDelegatedAdminAccountRequest disableDelegatedAdminAccountRequest) throws ConflictException,
            ValidationException, AccessDeniedException, ResourceNotFoundException, ThrottlingException, InternalServerException,
            AwsServiceException, SdkClientException, Inspector2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Disables the Amazon Inspector delegated administrator for your organization.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DisableDelegatedAdminAccountRequest.Builder}
     * avoiding the need to create one manually via {@link DisableDelegatedAdminAccountRequest#builder()}
     * </p>
     *
     * @param disableDelegatedAdminAccountRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.inspector2.model.DisableDelegatedAdminAccountRequest.Builder} to
     *        create a request.
     * @return Result of the DisableDelegatedAdminAccount operation returned by the service.
     * @throws ConflictException
     *         A conflict occurred. This exception occurs when the same resource is being modified by concurrent
     *         requests.
     * @throws ValidationException
     *         The request has failed validation due to missing required fields or having invalid inputs.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.</p>
     *         <p>
     *         For <code>Enable</code>, you receive this error if you attempt to use a feature in an unsupported Amazon
     *         Web Services Region.
     * @throws ResourceNotFoundException
     *         The operation tried to access an invalid resource. Make sure the resource is specified correctly.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws InternalServerException
     *         The request has failed due to an internal failure of the Amazon Inspector service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Inspector2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Inspector2Client.DisableDelegatedAdminAccount
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/DisableDelegatedAdminAccount"
     *      target="_top">AWS API Documentation</a>
     */
    default DisableDelegatedAdminAccountResponse disableDelegatedAdminAccount(
            Consumer<DisableDelegatedAdminAccountRequest.Builder> disableDelegatedAdminAccountRequest) throws ConflictException,
            ValidationException, AccessDeniedException, ResourceNotFoundException, ThrottlingException, InternalServerException,
            AwsServiceException, SdkClientException, Inspector2Exception {
        return disableDelegatedAdminAccount(DisableDelegatedAdminAccountRequest.builder()
                .applyMutation(disableDelegatedAdminAccountRequest).build());
    }

    /**
     * <p>
     * Disassociates a member account from an Amazon Inspector delegated administrator.
     * </p>
     *
     * @param disassociateMemberRequest
     * @return Result of the DisassociateMember operation returned by the service.
     * @throws ValidationException
     *         The request has failed validation due to missing required fields or having invalid inputs.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.</p>
     *         <p>
     *         For <code>Enable</code>, you receive this error if you attempt to use a feature in an unsupported Amazon
     *         Web Services Region.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws InternalServerException
     *         The request has failed due to an internal failure of the Amazon Inspector service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Inspector2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Inspector2Client.DisassociateMember
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/DisassociateMember" target="_top">AWS
     *      API Documentation</a>
     */
    default DisassociateMemberResponse disassociateMember(DisassociateMemberRequest disassociateMemberRequest)
            throws ValidationException, AccessDeniedException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, Inspector2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Disassociates a member account from an Amazon Inspector delegated administrator.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DisassociateMemberRequest.Builder} avoiding the
     * need to create one manually via {@link DisassociateMemberRequest#builder()}
     * </p>
     *
     * @param disassociateMemberRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.inspector2.model.DisassociateMemberRequest.Builder} to create a
     *        request.
     * @return Result of the DisassociateMember operation returned by the service.
     * @throws ValidationException
     *         The request has failed validation due to missing required fields or having invalid inputs.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.</p>
     *         <p>
     *         For <code>Enable</code>, you receive this error if you attempt to use a feature in an unsupported Amazon
     *         Web Services Region.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws InternalServerException
     *         The request has failed due to an internal failure of the Amazon Inspector service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Inspector2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Inspector2Client.DisassociateMember
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/DisassociateMember" target="_top">AWS
     *      API Documentation</a>
     */
    default DisassociateMemberResponse disassociateMember(Consumer<DisassociateMemberRequest.Builder> disassociateMemberRequest)
            throws ValidationException, AccessDeniedException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, Inspector2Exception {
        return disassociateMember(DisassociateMemberRequest.builder().applyMutation(disassociateMemberRequest).build());
    }

    /**
     * <p>
     * Enables Amazon Inspector scans for one or more Amazon Web Services accounts.
     * </p>
     *
     * @param enableRequest
     * @return Result of the Enable operation returned by the service.
     * @throws ValidationException
     *         The request has failed validation due to missing required fields or having invalid inputs.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.</p>
     *         <p>
     *         For <code>Enable</code>, you receive this error if you attempt to use a feature in an unsupported Amazon
     *         Web Services Region.
     * @throws ResourceNotFoundException
     *         The operation tried to access an invalid resource. Make sure the resource is specified correctly.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws InternalServerException
     *         The request has failed due to an internal failure of the Amazon Inspector service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Inspector2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Inspector2Client.Enable
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/Enable" target="_top">AWS API
     *      Documentation</a>
     */
    default EnableResponse enable(EnableRequest enableRequest) throws ValidationException, AccessDeniedException,
            ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException,
            Inspector2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Enables Amazon Inspector scans for one or more Amazon Web Services accounts.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link EnableRequest.Builder} avoiding the need to create
     * one manually via {@link EnableRequest#builder()}
     * </p>
     *
     * @param enableRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.inspector2.model.EnableRequest.Builder} to create a request.
     * @return Result of the Enable operation returned by the service.
     * @throws ValidationException
     *         The request has failed validation due to missing required fields or having invalid inputs.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.</p>
     *         <p>
     *         For <code>Enable</code>, you receive this error if you attempt to use a feature in an unsupported Amazon
     *         Web Services Region.
     * @throws ResourceNotFoundException
     *         The operation tried to access an invalid resource. Make sure the resource is specified correctly.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws InternalServerException
     *         The request has failed due to an internal failure of the Amazon Inspector service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Inspector2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Inspector2Client.Enable
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/Enable" target="_top">AWS API
     *      Documentation</a>
     */
    default EnableResponse enable(Consumer<EnableRequest.Builder> enableRequest) throws ValidationException,
            AccessDeniedException, ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, Inspector2Exception {
        return enable(EnableRequest.builder().applyMutation(enableRequest).build());
    }

    /**
     * <p>
     * Enables the Amazon Inspector delegated administrator for your Organizations organization.
     * </p>
     *
     * @param enableDelegatedAdminAccountRequest
     * @return Result of the EnableDelegatedAdminAccount operation returned by the service.
     * @throws ConflictException
     *         A conflict occurred. This exception occurs when the same resource is being modified by concurrent
     *         requests.
     * @throws ValidationException
     *         The request has failed validation due to missing required fields or having invalid inputs.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.</p>
     *         <p>
     *         For <code>Enable</code>, you receive this error if you attempt to use a feature in an unsupported Amazon
     *         Web Services Region.
     * @throws ResourceNotFoundException
     *         The operation tried to access an invalid resource. Make sure the resource is specified correctly.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws InternalServerException
     *         The request has failed due to an internal failure of the Amazon Inspector service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Inspector2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Inspector2Client.EnableDelegatedAdminAccount
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/EnableDelegatedAdminAccount"
     *      target="_top">AWS API Documentation</a>
     */
    default EnableDelegatedAdminAccountResponse enableDelegatedAdminAccount(
            EnableDelegatedAdminAccountRequest enableDelegatedAdminAccountRequest) throws ConflictException, ValidationException,
            AccessDeniedException, ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, Inspector2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Enables the Amazon Inspector delegated administrator for your Organizations organization.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link EnableDelegatedAdminAccountRequest.Builder}
     * avoiding the need to create one manually via {@link EnableDelegatedAdminAccountRequest#builder()}
     * </p>
     *
     * @param enableDelegatedAdminAccountRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.inspector2.model.EnableDelegatedAdminAccountRequest.Builder} to
     *        create a request.
     * @return Result of the EnableDelegatedAdminAccount operation returned by the service.
     * @throws ConflictException
     *         A conflict occurred. This exception occurs when the same resource is being modified by concurrent
     *         requests.
     * @throws ValidationException
     *         The request has failed validation due to missing required fields or having invalid inputs.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.</p>
     *         <p>
     *         For <code>Enable</code>, you receive this error if you attempt to use a feature in an unsupported Amazon
     *         Web Services Region.
     * @throws ResourceNotFoundException
     *         The operation tried to access an invalid resource. Make sure the resource is specified correctly.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws InternalServerException
     *         The request has failed due to an internal failure of the Amazon Inspector service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Inspector2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Inspector2Client.EnableDelegatedAdminAccount
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/EnableDelegatedAdminAccount"
     *      target="_top">AWS API Documentation</a>
     */
    default EnableDelegatedAdminAccountResponse enableDelegatedAdminAccount(
            Consumer<EnableDelegatedAdminAccountRequest.Builder> enableDelegatedAdminAccountRequest) throws ConflictException,
            ValidationException, AccessDeniedException, ResourceNotFoundException, ThrottlingException, InternalServerException,
            AwsServiceException, SdkClientException, Inspector2Exception {
        return enableDelegatedAdminAccount(EnableDelegatedAdminAccountRequest.builder()
                .applyMutation(enableDelegatedAdminAccountRequest).build());
    }

    /**
     * <p>
     * Retrieves a CIS scan report.
     * </p>
     *
     * @param getCisScanReportRequest
     * @return Result of the GetCisScanReport operation returned by the service.
     * @throws ValidationException
     *         The request has failed validation due to missing required fields or having invalid inputs.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.</p>
     *         <p>
     *         For <code>Enable</code>, you receive this error if you attempt to use a feature in an unsupported Amazon
     *         Web Services Region.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws ResourceNotFoundException
     *         The operation tried to access an invalid resource. Make sure the resource is specified correctly.
     * @throws InternalServerException
     *         The request has failed due to an internal failure of the Amazon Inspector service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Inspector2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Inspector2Client.GetCisScanReport
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/GetCisScanReport" target="_top">AWS
     *      API Documentation</a>
     */
    default GetCisScanReportResponse getCisScanReport(GetCisScanReportRequest getCisScanReportRequest)
            throws ValidationException, AccessDeniedException, ThrottlingException, ResourceNotFoundException,
            InternalServerException, AwsServiceException, SdkClientException, Inspector2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a CIS scan report.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetCisScanReportRequest.Builder} avoiding the need
     * to create one manually via {@link GetCisScanReportRequest#builder()}
     * </p>
     *
     * @param getCisScanReportRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.inspector2.model.GetCisScanReportRequest.Builder} to create a
     *        request.
     * @return Result of the GetCisScanReport operation returned by the service.
     * @throws ValidationException
     *         The request has failed validation due to missing required fields or having invalid inputs.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.</p>
     *         <p>
     *         For <code>Enable</code>, you receive this error if you attempt to use a feature in an unsupported Amazon
     *         Web Services Region.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws ResourceNotFoundException
     *         The operation tried to access an invalid resource. Make sure the resource is specified correctly.
     * @throws InternalServerException
     *         The request has failed due to an internal failure of the Amazon Inspector service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Inspector2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Inspector2Client.GetCisScanReport
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/GetCisScanReport" target="_top">AWS
     *      API Documentation</a>
     */
    default GetCisScanReportResponse getCisScanReport(Consumer<GetCisScanReportRequest.Builder> getCisScanReportRequest)
            throws ValidationException, AccessDeniedException, ThrottlingException, ResourceNotFoundException,
            InternalServerException, AwsServiceException, SdkClientException, Inspector2Exception {
        return getCisScanReport(GetCisScanReportRequest.builder().applyMutation(getCisScanReportRequest).build());
    }

    /**
     * <p>
     * Retrieves CIS scan result details.
     * </p>
     *
     * @param getCisScanResultDetailsRequest
     * @return Result of the GetCisScanResultDetails operation returned by the service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.</p>
     *         <p>
     *         For <code>Enable</code>, you receive this error if you attempt to use a feature in an unsupported Amazon
     *         Web Services Region.
     * @throws ValidationException
     *         The request has failed validation due to missing required fields or having invalid inputs.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws InternalServerException
     *         The request has failed due to an internal failure of the Amazon Inspector service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Inspector2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Inspector2Client.GetCisScanResultDetails
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/GetCisScanResultDetails"
     *      target="_top">AWS API Documentation</a>
     */
    default GetCisScanResultDetailsResponse getCisScanResultDetails(GetCisScanResultDetailsRequest getCisScanResultDetailsRequest)
            throws AccessDeniedException, ValidationException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, Inspector2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves CIS scan result details.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetCisScanResultDetailsRequest.Builder} avoiding
     * the need to create one manually via {@link GetCisScanResultDetailsRequest#builder()}
     * </p>
     *
     * @param getCisScanResultDetailsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.inspector2.model.GetCisScanResultDetailsRequest.Builder} to create
     *        a request.
     * @return Result of the GetCisScanResultDetails operation returned by the service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.</p>
     *         <p>
     *         For <code>Enable</code>, you receive this error if you attempt to use a feature in an unsupported Amazon
     *         Web Services Region.
     * @throws ValidationException
     *         The request has failed validation due to missing required fields or having invalid inputs.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws InternalServerException
     *         The request has failed due to an internal failure of the Amazon Inspector service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Inspector2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Inspector2Client.GetCisScanResultDetails
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/GetCisScanResultDetails"
     *      target="_top">AWS API Documentation</a>
     */
    default GetCisScanResultDetailsResponse getCisScanResultDetails(
            Consumer<GetCisScanResultDetailsRequest.Builder> getCisScanResultDetailsRequest) throws AccessDeniedException,
            ValidationException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException,
            Inspector2Exception {
        return getCisScanResultDetails(GetCisScanResultDetailsRequest.builder().applyMutation(getCisScanResultDetailsRequest)
                .build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #getCisScanResultDetails(software.amazon.awssdk.services.inspector2.model.GetCisScanResultDetailsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.inspector2.paginators.GetCisScanResultDetailsIterable responses = client.getCisScanResultDetailsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.inspector2.paginators.GetCisScanResultDetailsIterable responses = client
     *             .getCisScanResultDetailsPaginator(request);
     *     for (software.amazon.awssdk.services.inspector2.model.GetCisScanResultDetailsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.inspector2.paginators.GetCisScanResultDetailsIterable responses = client.getCisScanResultDetailsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getCisScanResultDetails(software.amazon.awssdk.services.inspector2.model.GetCisScanResultDetailsRequest)}
     * operation.</b>
     * </p>
     *
     * @param getCisScanResultDetailsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.</p>
     *         <p>
     *         For <code>Enable</code>, you receive this error if you attempt to use a feature in an unsupported Amazon
     *         Web Services Region.
     * @throws ValidationException
     *         The request has failed validation due to missing required fields or having invalid inputs.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws InternalServerException
     *         The request has failed due to an internal failure of the Amazon Inspector service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Inspector2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Inspector2Client.GetCisScanResultDetails
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/GetCisScanResultDetails"
     *      target="_top">AWS API Documentation</a>
     */
    default GetCisScanResultDetailsIterable getCisScanResultDetailsPaginator(
            GetCisScanResultDetailsRequest getCisScanResultDetailsRequest) throws AccessDeniedException, ValidationException,
            ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, Inspector2Exception {
        return new GetCisScanResultDetailsIterable(this, getCisScanResultDetailsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #getCisScanResultDetails(software.amazon.awssdk.services.inspector2.model.GetCisScanResultDetailsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.inspector2.paginators.GetCisScanResultDetailsIterable responses = client.getCisScanResultDetailsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.inspector2.paginators.GetCisScanResultDetailsIterable responses = client
     *             .getCisScanResultDetailsPaginator(request);
     *     for (software.amazon.awssdk.services.inspector2.model.GetCisScanResultDetailsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.inspector2.paginators.GetCisScanResultDetailsIterable responses = client.getCisScanResultDetailsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getCisScanResultDetails(software.amazon.awssdk.services.inspector2.model.GetCisScanResultDetailsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetCisScanResultDetailsRequest.Builder} avoiding
     * the need to create one manually via {@link GetCisScanResultDetailsRequest#builder()}
     * </p>
     *
     * @param getCisScanResultDetailsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.inspector2.model.GetCisScanResultDetailsRequest.Builder} to create
     *        a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.</p>
     *         <p>
     *         For <code>Enable</code>, you receive this error if you attempt to use a feature in an unsupported Amazon
     *         Web Services Region.
     * @throws ValidationException
     *         The request has failed validation due to missing required fields or having invalid inputs.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws InternalServerException
     *         The request has failed due to an internal failure of the Amazon Inspector service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Inspector2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Inspector2Client.GetCisScanResultDetails
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/GetCisScanResultDetails"
     *      target="_top">AWS API Documentation</a>
     */
    default GetCisScanResultDetailsIterable getCisScanResultDetailsPaginator(
            Consumer<GetCisScanResultDetailsRequest.Builder> getCisScanResultDetailsRequest) throws AccessDeniedException,
            ValidationException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException,
            Inspector2Exception {
        return getCisScanResultDetailsPaginator(GetCisScanResultDetailsRequest.builder()
                .applyMutation(getCisScanResultDetailsRequest).build());
    }

    /**
     * <p>
     * Returns a list of clusters and metadata associated with an image.
     * </p>
     *
     * @param getClustersForImageRequest
     * @return Result of the GetClustersForImage operation returned by the service.
     * @throws ValidationException
     *         The request has failed validation due to missing required fields or having invalid inputs.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.</p>
     *         <p>
     *         For <code>Enable</code>, you receive this error if you attempt to use a feature in an unsupported Amazon
     *         Web Services Region.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws InternalServerException
     *         The request has failed due to an internal failure of the Amazon Inspector service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Inspector2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Inspector2Client.GetClustersForImage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/GetClustersForImage"
     *      target="_top">AWS API Documentation</a>
     */
    default GetClustersForImageResponse getClustersForImage(GetClustersForImageRequest getClustersForImageRequest)
            throws ValidationException, AccessDeniedException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, Inspector2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of clusters and metadata associated with an image.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetClustersForImageRequest.Builder} avoiding the
     * need to create one manually via {@link GetClustersForImageRequest#builder()}
     * </p>
     *
     * @param getClustersForImageRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.inspector2.model.GetClustersForImageRequest.Builder} to create a
     *        request.
     * @return Result of the GetClustersForImage operation returned by the service.
     * @throws ValidationException
     *         The request has failed validation due to missing required fields or having invalid inputs.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.</p>
     *         <p>
     *         For <code>Enable</code>, you receive this error if you attempt to use a feature in an unsupported Amazon
     *         Web Services Region.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws InternalServerException
     *         The request has failed due to an internal failure of the Amazon Inspector service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Inspector2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Inspector2Client.GetClustersForImage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/GetClustersForImage"
     *      target="_top">AWS API Documentation</a>
     */
    default GetClustersForImageResponse getClustersForImage(
            Consumer<GetClustersForImageRequest.Builder> getClustersForImageRequest) throws ValidationException,
            AccessDeniedException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException,
            Inspector2Exception {
        return getClustersForImage(GetClustersForImageRequest.builder().applyMutation(getClustersForImageRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #getClustersForImage(software.amazon.awssdk.services.inspector2.model.GetClustersForImageRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.inspector2.paginators.GetClustersForImageIterable responses = client.getClustersForImagePaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.inspector2.paginators.GetClustersForImageIterable responses = client
     *             .getClustersForImagePaginator(request);
     *     for (software.amazon.awssdk.services.inspector2.model.GetClustersForImageResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.inspector2.paginators.GetClustersForImageIterable responses = client.getClustersForImagePaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getClustersForImage(software.amazon.awssdk.services.inspector2.model.GetClustersForImageRequest)}
     * operation.</b>
     * </p>
     *
     * @param getClustersForImageRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The request has failed validation due to missing required fields or having invalid inputs.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.</p>
     *         <p>
     *         For <code>Enable</code>, you receive this error if you attempt to use a feature in an unsupported Amazon
     *         Web Services Region.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws InternalServerException
     *         The request has failed due to an internal failure of the Amazon Inspector service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Inspector2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Inspector2Client.GetClustersForImage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/GetClustersForImage"
     *      target="_top">AWS API Documentation</a>
     */
    default GetClustersForImageIterable getClustersForImagePaginator(GetClustersForImageRequest getClustersForImageRequest)
            throws ValidationException, AccessDeniedException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, Inspector2Exception {
        return new GetClustersForImageIterable(this, getClustersForImageRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #getClustersForImage(software.amazon.awssdk.services.inspector2.model.GetClustersForImageRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.inspector2.paginators.GetClustersForImageIterable responses = client.getClustersForImagePaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.inspector2.paginators.GetClustersForImageIterable responses = client
     *             .getClustersForImagePaginator(request);
     *     for (software.amazon.awssdk.services.inspector2.model.GetClustersForImageResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.inspector2.paginators.GetClustersForImageIterable responses = client.getClustersForImagePaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getClustersForImage(software.amazon.awssdk.services.inspector2.model.GetClustersForImageRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetClustersForImageRequest.Builder} avoiding the
     * need to create one manually via {@link GetClustersForImageRequest#builder()}
     * </p>
     *
     * @param getClustersForImageRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.inspector2.model.GetClustersForImageRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The request has failed validation due to missing required fields or having invalid inputs.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.</p>
     *         <p>
     *         For <code>Enable</code>, you receive this error if you attempt to use a feature in an unsupported Amazon
     *         Web Services Region.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws InternalServerException
     *         The request has failed due to an internal failure of the Amazon Inspector service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Inspector2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Inspector2Client.GetClustersForImage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/GetClustersForImage"
     *      target="_top">AWS API Documentation</a>
     */
    default GetClustersForImageIterable getClustersForImagePaginator(
            Consumer<GetClustersForImageRequest.Builder> getClustersForImageRequest) throws ValidationException,
            AccessDeniedException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException,
            Inspector2Exception {
        return getClustersForImagePaginator(GetClustersForImageRequest.builder().applyMutation(getClustersForImageRequest)
                .build());
    }

    /**
     * <p>
     * Retrieves information about a code security integration.
     * </p>
     *
     * @param getCodeSecurityIntegrationRequest
     * @return Result of the GetCodeSecurityIntegration operation returned by the service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.</p>
     *         <p>
     *         For <code>Enable</code>, you receive this error if you attempt to use a feature in an unsupported Amazon
     *         Web Services Region.
     * @throws ValidationException
     *         The request has failed validation due to missing required fields or having invalid inputs.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws ResourceNotFoundException
     *         The operation tried to access an invalid resource. Make sure the resource is specified correctly.
     * @throws InternalServerException
     *         The request has failed due to an internal failure of the Amazon Inspector service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Inspector2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Inspector2Client.GetCodeSecurityIntegration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/GetCodeSecurityIntegration"
     *      target="_top">AWS API Documentation</a>
     */
    default GetCodeSecurityIntegrationResponse getCodeSecurityIntegration(
            GetCodeSecurityIntegrationRequest getCodeSecurityIntegrationRequest) throws AccessDeniedException,
            ValidationException, ThrottlingException, ResourceNotFoundException, InternalServerException, AwsServiceException,
            SdkClientException, Inspector2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves information about a code security integration.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetCodeSecurityIntegrationRequest.Builder} avoiding
     * the need to create one manually via {@link GetCodeSecurityIntegrationRequest#builder()}
     * </p>
     *
     * @param getCodeSecurityIntegrationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.inspector2.model.GetCodeSecurityIntegrationRequest.Builder} to
     *        create a request.
     * @return Result of the GetCodeSecurityIntegration operation returned by the service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.</p>
     *         <p>
     *         For <code>Enable</code>, you receive this error if you attempt to use a feature in an unsupported Amazon
     *         Web Services Region.
     * @throws ValidationException
     *         The request has failed validation due to missing required fields or having invalid inputs.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws ResourceNotFoundException
     *         The operation tried to access an invalid resource. Make sure the resource is specified correctly.
     * @throws InternalServerException
     *         The request has failed due to an internal failure of the Amazon Inspector service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Inspector2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Inspector2Client.GetCodeSecurityIntegration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/GetCodeSecurityIntegration"
     *      target="_top">AWS API Documentation</a>
     */
    default GetCodeSecurityIntegrationResponse getCodeSecurityIntegration(
            Consumer<GetCodeSecurityIntegrationRequest.Builder> getCodeSecurityIntegrationRequest) throws AccessDeniedException,
            ValidationException, ThrottlingException, ResourceNotFoundException, InternalServerException, AwsServiceException,
            SdkClientException, Inspector2Exception {
        return getCodeSecurityIntegration(GetCodeSecurityIntegrationRequest.builder()
                .applyMutation(getCodeSecurityIntegrationRequest).build());
    }

    /**
     * <p>
     * Retrieves information about a specific code security scan.
     * </p>
     *
     * @param getCodeSecurityScanRequest
     * @return Result of the GetCodeSecurityScan operation returned by the service.
     * @throws ConflictException
     *         A conflict occurred. This exception occurs when the same resource is being modified by concurrent
     *         requests.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.</p>
     *         <p>
     *         For <code>Enable</code>, you receive this error if you attempt to use a feature in an unsupported Amazon
     *         Web Services Region.
     * @throws ValidationException
     *         The request has failed validation due to missing required fields or having invalid inputs.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws ResourceNotFoundException
     *         The operation tried to access an invalid resource. Make sure the resource is specified correctly.
     * @throws InternalServerException
     *         The request has failed due to an internal failure of the Amazon Inspector service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Inspector2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Inspector2Client.GetCodeSecurityScan
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/GetCodeSecurityScan"
     *      target="_top">AWS API Documentation</a>
     */
    default GetCodeSecurityScanResponse getCodeSecurityScan(GetCodeSecurityScanRequest getCodeSecurityScanRequest)
            throws ConflictException, AccessDeniedException, ValidationException, ThrottlingException, ResourceNotFoundException,
            InternalServerException, AwsServiceException, SdkClientException, Inspector2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves information about a specific code security scan.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetCodeSecurityScanRequest.Builder} avoiding the
     * need to create one manually via {@link GetCodeSecurityScanRequest#builder()}
     * </p>
     *
     * @param getCodeSecurityScanRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.inspector2.model.GetCodeSecurityScanRequest.Builder} to create a
     *        request.
     * @return Result of the GetCodeSecurityScan operation returned by the service.
     * @throws ConflictException
     *         A conflict occurred. This exception occurs when the same resource is being modified by concurrent
     *         requests.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.</p>
     *         <p>
     *         For <code>Enable</code>, you receive this error if you attempt to use a feature in an unsupported Amazon
     *         Web Services Region.
     * @throws ValidationException
     *         The request has failed validation due to missing required fields or having invalid inputs.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws ResourceNotFoundException
     *         The operation tried to access an invalid resource. Make sure the resource is specified correctly.
     * @throws InternalServerException
     *         The request has failed due to an internal failure of the Amazon Inspector service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Inspector2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Inspector2Client.GetCodeSecurityScan
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/GetCodeSecurityScan"
     *      target="_top">AWS API Documentation</a>
     */
    default GetCodeSecurityScanResponse getCodeSecurityScan(
            Consumer<GetCodeSecurityScanRequest.Builder> getCodeSecurityScanRequest) throws ConflictException,
            AccessDeniedException, ValidationException, ThrottlingException, ResourceNotFoundException, InternalServerException,
            AwsServiceException, SdkClientException, Inspector2Exception {
        return getCodeSecurityScan(GetCodeSecurityScanRequest.builder().applyMutation(getCodeSecurityScanRequest).build());
    }

    /**
     * <p>
     * Retrieves information about a code security scan configuration.
     * </p>
     *
     * @param getCodeSecurityScanConfigurationRequest
     * @return Result of the GetCodeSecurityScanConfiguration operation returned by the service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.</p>
     *         <p>
     *         For <code>Enable</code>, you receive this error if you attempt to use a feature in an unsupported Amazon
     *         Web Services Region.
     * @throws ValidationException
     *         The request has failed validation due to missing required fields or having invalid inputs.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws ResourceNotFoundException
     *         The operation tried to access an invalid resource. Make sure the resource is specified correctly.
     * @throws InternalServerException
     *         The request has failed due to an internal failure of the Amazon Inspector service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Inspector2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Inspector2Client.GetCodeSecurityScanConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/GetCodeSecurityScanConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default GetCodeSecurityScanConfigurationResponse getCodeSecurityScanConfiguration(
            GetCodeSecurityScanConfigurationRequest getCodeSecurityScanConfigurationRequest) throws AccessDeniedException,
            ValidationException, ThrottlingException, ResourceNotFoundException, InternalServerException, AwsServiceException,
            SdkClientException, Inspector2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves information about a code security scan configuration.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetCodeSecurityScanConfigurationRequest.Builder}
     * avoiding the need to create one manually via {@link GetCodeSecurityScanConfigurationRequest#builder()}
     * </p>
     *
     * @param getCodeSecurityScanConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.inspector2.model.GetCodeSecurityScanConfigurationRequest.Builder}
     *        to create a request.
     * @return Result of the GetCodeSecurityScanConfiguration operation returned by the service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.</p>
     *         <p>
     *         For <code>Enable</code>, you receive this error if you attempt to use a feature in an unsupported Amazon
     *         Web Services Region.
     * @throws ValidationException
     *         The request has failed validation due to missing required fields or having invalid inputs.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws ResourceNotFoundException
     *         The operation tried to access an invalid resource. Make sure the resource is specified correctly.
     * @throws InternalServerException
     *         The request has failed due to an internal failure of the Amazon Inspector service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Inspector2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Inspector2Client.GetCodeSecurityScanConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/GetCodeSecurityScanConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default GetCodeSecurityScanConfigurationResponse getCodeSecurityScanConfiguration(
            Consumer<GetCodeSecurityScanConfigurationRequest.Builder> getCodeSecurityScanConfigurationRequest)
            throws AccessDeniedException, ValidationException, ThrottlingException, ResourceNotFoundException,
            InternalServerException, AwsServiceException, SdkClientException, Inspector2Exception {
        return getCodeSecurityScanConfiguration(GetCodeSecurityScanConfigurationRequest.builder()
                .applyMutation(getCodeSecurityScanConfigurationRequest).build());
    }

    /**
     * <p>
     * Retrieves setting configurations for Inspector scans.
     * </p>
     *
     * @param getConfigurationRequest
     * @return Result of the GetConfiguration operation returned by the service.
     * @throws ResourceNotFoundException
     *         The operation tried to access an invalid resource. Make sure the resource is specified correctly.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws InternalServerException
     *         The request has failed due to an internal failure of the Amazon Inspector service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Inspector2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Inspector2Client.GetConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/GetConfiguration" target="_top">AWS
     *      API Documentation</a>
     */
    default GetConfigurationResponse getConfiguration(GetConfigurationRequest getConfigurationRequest)
            throws ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, Inspector2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves setting configurations for Inspector scans.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetConfigurationRequest.Builder} avoiding the need
     * to create one manually via {@link GetConfigurationRequest#builder()}
     * </p>
     *
     * @param getConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.inspector2.model.GetConfigurationRequest.Builder} to create a
     *        request.
     * @return Result of the GetConfiguration operation returned by the service.
     * @throws ResourceNotFoundException
     *         The operation tried to access an invalid resource. Make sure the resource is specified correctly.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws InternalServerException
     *         The request has failed due to an internal failure of the Amazon Inspector service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Inspector2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Inspector2Client.GetConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/GetConfiguration" target="_top">AWS
     *      API Documentation</a>
     */
    default GetConfigurationResponse getConfiguration(Consumer<GetConfigurationRequest.Builder> getConfigurationRequest)
            throws ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, Inspector2Exception {
        return getConfiguration(GetConfigurationRequest.builder().applyMutation(getConfigurationRequest).build());
    }

    /**
     * <p>
     * Retrieves information about the Amazon Inspector delegated administrator for your organization.
     * </p>
     *
     * @param getDelegatedAdminAccountRequest
     * @return Result of the GetDelegatedAdminAccount operation returned by the service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.</p>
     *         <p>
     *         For <code>Enable</code>, you receive this error if you attempt to use a feature in an unsupported Amazon
     *         Web Services Region.
     * @throws ValidationException
     *         The request has failed validation due to missing required fields or having invalid inputs.
     * @throws ResourceNotFoundException
     *         The operation tried to access an invalid resource. Make sure the resource is specified correctly.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws InternalServerException
     *         The request has failed due to an internal failure of the Amazon Inspector service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Inspector2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Inspector2Client.GetDelegatedAdminAccount
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/GetDelegatedAdminAccount"
     *      target="_top">AWS API Documentation</a>
     */
    default GetDelegatedAdminAccountResponse getDelegatedAdminAccount(
            GetDelegatedAdminAccountRequest getDelegatedAdminAccountRequest) throws AccessDeniedException, ValidationException,
            ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException,
            Inspector2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves information about the Amazon Inspector delegated administrator for your organization.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetDelegatedAdminAccountRequest.Builder} avoiding
     * the need to create one manually via {@link GetDelegatedAdminAccountRequest#builder()}
     * </p>
     *
     * @param getDelegatedAdminAccountRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.inspector2.model.GetDelegatedAdminAccountRequest.Builder} to create
     *        a request.
     * @return Result of the GetDelegatedAdminAccount operation returned by the service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.</p>
     *         <p>
     *         For <code>Enable</code>, you receive this error if you attempt to use a feature in an unsupported Amazon
     *         Web Services Region.
     * @throws ValidationException
     *         The request has failed validation due to missing required fields or having invalid inputs.
     * @throws ResourceNotFoundException
     *         The operation tried to access an invalid resource. Make sure the resource is specified correctly.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws InternalServerException
     *         The request has failed due to an internal failure of the Amazon Inspector service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Inspector2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Inspector2Client.GetDelegatedAdminAccount
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/GetDelegatedAdminAccount"
     *      target="_top">AWS API Documentation</a>
     */
    default GetDelegatedAdminAccountResponse getDelegatedAdminAccount(
            Consumer<GetDelegatedAdminAccountRequest.Builder> getDelegatedAdminAccountRequest) throws AccessDeniedException,
            ValidationException, ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, Inspector2Exception {
        return getDelegatedAdminAccount(GetDelegatedAdminAccountRequest.builder().applyMutation(getDelegatedAdminAccountRequest)
                .build());
    }

    /**
     * <p>
     * Retrieves the activation status of Amazon Inspector deep inspection and custom paths associated with your
     * account.
     * </p>
     *
     * @param getEc2DeepInspectionConfigurationRequest
     * @return Result of the GetEc2DeepInspectionConfiguration operation returned by the service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.</p>
     *         <p>
     *         For <code>Enable</code>, you receive this error if you attempt to use a feature in an unsupported Amazon
     *         Web Services Region.
     * @throws ResourceNotFoundException
     *         The operation tried to access an invalid resource. Make sure the resource is specified correctly.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws InternalServerException
     *         The request has failed due to an internal failure of the Amazon Inspector service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Inspector2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Inspector2Client.GetEc2DeepInspectionConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/GetEc2DeepInspectionConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default GetEc2DeepInspectionConfigurationResponse getEc2DeepInspectionConfiguration(
            GetEc2DeepInspectionConfigurationRequest getEc2DeepInspectionConfigurationRequest) throws AccessDeniedException,
            ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException,
            Inspector2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the activation status of Amazon Inspector deep inspection and custom paths associated with your
     * account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetEc2DeepInspectionConfigurationRequest.Builder}
     * avoiding the need to create one manually via {@link GetEc2DeepInspectionConfigurationRequest#builder()}
     * </p>
     *
     * @param getEc2DeepInspectionConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.inspector2.model.GetEc2DeepInspectionConfigurationRequest.Builder}
     *        to create a request.
     * @return Result of the GetEc2DeepInspectionConfiguration operation returned by the service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.</p>
     *         <p>
     *         For <code>Enable</code>, you receive this error if you attempt to use a feature in an unsupported Amazon
     *         Web Services Region.
     * @throws ResourceNotFoundException
     *         The operation tried to access an invalid resource. Make sure the resource is specified correctly.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws InternalServerException
     *         The request has failed due to an internal failure of the Amazon Inspector service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Inspector2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Inspector2Client.GetEc2DeepInspectionConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/GetEc2DeepInspectionConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default GetEc2DeepInspectionConfigurationResponse getEc2DeepInspectionConfiguration(
            Consumer<GetEc2DeepInspectionConfigurationRequest.Builder> getEc2DeepInspectionConfigurationRequest)
            throws AccessDeniedException, ResourceNotFoundException, ThrottlingException, InternalServerException,
            AwsServiceException, SdkClientException, Inspector2Exception {
        return getEc2DeepInspectionConfiguration(GetEc2DeepInspectionConfigurationRequest.builder()
                .applyMutation(getEc2DeepInspectionConfigurationRequest).build());
    }

    /**
     * <p>
     * Gets an encryption key.
     * </p>
     *
     * @param getEncryptionKeyRequest
     * @return Result of the GetEncryptionKey operation returned by the service.
     * @throws ValidationException
     *         The request has failed validation due to missing required fields or having invalid inputs.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.</p>
     *         <p>
     *         For <code>Enable</code>, you receive this error if you attempt to use a feature in an unsupported Amazon
     *         Web Services Region.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws ResourceNotFoundException
     *         The operation tried to access an invalid resource. Make sure the resource is specified correctly.
     * @throws InternalServerException
     *         The request has failed due to an internal failure of the Amazon Inspector service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Inspector2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Inspector2Client.GetEncryptionKey
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/GetEncryptionKey" target="_top">AWS
     *      API Documentation</a>
     */
    default GetEncryptionKeyResponse getEncryptionKey(GetEncryptionKeyRequest getEncryptionKeyRequest)
            throws ValidationException, AccessDeniedException, ThrottlingException, ResourceNotFoundException,
            InternalServerException, AwsServiceException, SdkClientException, Inspector2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets an encryption key.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetEncryptionKeyRequest.Builder} avoiding the need
     * to create one manually via {@link GetEncryptionKeyRequest#builder()}
     * </p>
     *
     * @param getEncryptionKeyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.inspector2.model.GetEncryptionKeyRequest.Builder} to create a
     *        request.
     * @return Result of the GetEncryptionKey operation returned by the service.
     * @throws ValidationException
     *         The request has failed validation due to missing required fields or having invalid inputs.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.</p>
     *         <p>
     *         For <code>Enable</code>, you receive this error if you attempt to use a feature in an unsupported Amazon
     *         Web Services Region.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws ResourceNotFoundException
     *         The operation tried to access an invalid resource. Make sure the resource is specified correctly.
     * @throws InternalServerException
     *         The request has failed due to an internal failure of the Amazon Inspector service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Inspector2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Inspector2Client.GetEncryptionKey
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/GetEncryptionKey" target="_top">AWS
     *      API Documentation</a>
     */
    default GetEncryptionKeyResponse getEncryptionKey(Consumer<GetEncryptionKeyRequest.Builder> getEncryptionKeyRequest)
            throws ValidationException, AccessDeniedException, ThrottlingException, ResourceNotFoundException,
            InternalServerException, AwsServiceException, SdkClientException, Inspector2Exception {
        return getEncryptionKey(GetEncryptionKeyRequest.builder().applyMutation(getEncryptionKeyRequest).build());
    }

    /**
     * <p>
     * Gets the status of a findings report.
     * </p>
     *
     * @param getFindingsReportStatusRequest
     * @return Result of the GetFindingsReportStatus operation returned by the service.
     * @throws ValidationException
     *         The request has failed validation due to missing required fields or having invalid inputs.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.</p>
     *         <p>
     *         For <code>Enable</code>, you receive this error if you attempt to use a feature in an unsupported Amazon
     *         Web Services Region.
     * @throws ResourceNotFoundException
     *         The operation tried to access an invalid resource. Make sure the resource is specified correctly.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws InternalServerException
     *         The request has failed due to an internal failure of the Amazon Inspector service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Inspector2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Inspector2Client.GetFindingsReportStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/GetFindingsReportStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default GetFindingsReportStatusResponse getFindingsReportStatus(GetFindingsReportStatusRequest getFindingsReportStatusRequest)
            throws ValidationException, AccessDeniedException, ResourceNotFoundException, ThrottlingException,
            InternalServerException, AwsServiceException, SdkClientException, Inspector2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the status of a findings report.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetFindingsReportStatusRequest.Builder} avoiding
     * the need to create one manually via {@link GetFindingsReportStatusRequest#builder()}
     * </p>
     *
     * @param getFindingsReportStatusRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.inspector2.model.GetFindingsReportStatusRequest.Builder} to create
     *        a request.
     * @return Result of the GetFindingsReportStatus operation returned by the service.
     * @throws ValidationException
     *         The request has failed validation due to missing required fields or having invalid inputs.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.</p>
     *         <p>
     *         For <code>Enable</code>, you receive this error if you attempt to use a feature in an unsupported Amazon
     *         Web Services Region.
     * @throws ResourceNotFoundException
     *         The operation tried to access an invalid resource. Make sure the resource is specified correctly.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws InternalServerException
     *         The request has failed due to an internal failure of the Amazon Inspector service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Inspector2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Inspector2Client.GetFindingsReportStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/GetFindingsReportStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default GetFindingsReportStatusResponse getFindingsReportStatus(
            Consumer<GetFindingsReportStatusRequest.Builder> getFindingsReportStatusRequest) throws ValidationException,
            AccessDeniedException, ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, Inspector2Exception {
        return getFindingsReportStatus(GetFindingsReportStatusRequest.builder().applyMutation(getFindingsReportStatusRequest)
                .build());
    }

    /**
     * <p>
     * Gets member information for your organization.
     * </p>
     *
     * @param getMemberRequest
     * @return Result of the GetMember operation returned by the service.
     * @throws ValidationException
     *         The request has failed validation due to missing required fields or having invalid inputs.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.</p>
     *         <p>
     *         For <code>Enable</code>, you receive this error if you attempt to use a feature in an unsupported Amazon
     *         Web Services Region.
     * @throws ResourceNotFoundException
     *         The operation tried to access an invalid resource. Make sure the resource is specified correctly.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws InternalServerException
     *         The request has failed due to an internal failure of the Amazon Inspector service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Inspector2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Inspector2Client.GetMember
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/GetMember" target="_top">AWS API
     *      Documentation</a>
     */
    default GetMemberResponse getMember(GetMemberRequest getMemberRequest) throws ValidationException, AccessDeniedException,
            ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException,
            Inspector2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets member information for your organization.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetMemberRequest.Builder} avoiding the need to
     * create one manually via {@link GetMemberRequest#builder()}
     * </p>
     *
     * @param getMemberRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.inspector2.model.GetMemberRequest.Builder} to create a request.
     * @return Result of the GetMember operation returned by the service.
     * @throws ValidationException
     *         The request has failed validation due to missing required fields or having invalid inputs.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.</p>
     *         <p>
     *         For <code>Enable</code>, you receive this error if you attempt to use a feature in an unsupported Amazon
     *         Web Services Region.
     * @throws ResourceNotFoundException
     *         The operation tried to access an invalid resource. Make sure the resource is specified correctly.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws InternalServerException
     *         The request has failed due to an internal failure of the Amazon Inspector service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Inspector2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Inspector2Client.GetMember
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/GetMember" target="_top">AWS API
     *      Documentation</a>
     */
    default GetMemberResponse getMember(Consumer<GetMemberRequest.Builder> getMemberRequest) throws ValidationException,
            AccessDeniedException, ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, Inspector2Exception {
        return getMember(GetMemberRequest.builder().applyMutation(getMemberRequest).build());
    }

    /**
     * <p>
     * Gets details of a software bill of materials (SBOM) report.
     * </p>
     *
     * @param getSbomExportRequest
     * @return Result of the GetSbomExport operation returned by the service.
     * @throws ValidationException
     *         The request has failed validation due to missing required fields or having invalid inputs.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.</p>
     *         <p>
     *         For <code>Enable</code>, you receive this error if you attempt to use a feature in an unsupported Amazon
     *         Web Services Region.
     * @throws ResourceNotFoundException
     *         The operation tried to access an invalid resource. Make sure the resource is specified correctly.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws InternalServerException
     *         The request has failed due to an internal failure of the Amazon Inspector service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Inspector2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Inspector2Client.GetSbomExport
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/GetSbomExport" target="_top">AWS API
     *      Documentation</a>
     */
    default GetSbomExportResponse getSbomExport(GetSbomExportRequest getSbomExportRequest) throws ValidationException,
            AccessDeniedException, ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, Inspector2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets details of a software bill of materials (SBOM) report.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetSbomExportRequest.Builder} avoiding the need to
     * create one manually via {@link GetSbomExportRequest#builder()}
     * </p>
     *
     * @param getSbomExportRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.inspector2.model.GetSbomExportRequest.Builder} to create a request.
     * @return Result of the GetSbomExport operation returned by the service.
     * @throws ValidationException
     *         The request has failed validation due to missing required fields or having invalid inputs.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.</p>
     *         <p>
     *         For <code>Enable</code>, you receive this error if you attempt to use a feature in an unsupported Amazon
     *         Web Services Region.
     * @throws ResourceNotFoundException
     *         The operation tried to access an invalid resource. Make sure the resource is specified correctly.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws InternalServerException
     *         The request has failed due to an internal failure of the Amazon Inspector service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Inspector2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Inspector2Client.GetSbomExport
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/GetSbomExport" target="_top">AWS API
     *      Documentation</a>
     */
    default GetSbomExportResponse getSbomExport(Consumer<GetSbomExportRequest.Builder> getSbomExportRequest)
            throws ValidationException, AccessDeniedException, ResourceNotFoundException, ThrottlingException,
            InternalServerException, AwsServiceException, SdkClientException, Inspector2Exception {
        return getSbomExport(GetSbomExportRequest.builder().applyMutation(getSbomExportRequest).build());
    }

    /**
     * <p>
     * Lists the permissions an account has to configure Amazon Inspector.
     * </p>
     *
     * @param listAccountPermissionsRequest
     * @return Result of the ListAccountPermissions operation returned by the service.
     * @throws ValidationException
     *         The request has failed validation due to missing required fields or having invalid inputs.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.</p>
     *         <p>
     *         For <code>Enable</code>, you receive this error if you attempt to use a feature in an unsupported Amazon
     *         Web Services Region.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws InternalServerException
     *         The request has failed due to an internal failure of the Amazon Inspector service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Inspector2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Inspector2Client.ListAccountPermissions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/ListAccountPermissions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAccountPermissionsResponse listAccountPermissions(ListAccountPermissionsRequest listAccountPermissionsRequest)
            throws ValidationException, AccessDeniedException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, Inspector2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the permissions an account has to configure Amazon Inspector.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAccountPermissionsRequest.Builder} avoiding the
     * need to create one manually via {@link ListAccountPermissionsRequest#builder()}
     * </p>
     *
     * @param listAccountPermissionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.inspector2.model.ListAccountPermissionsRequest.Builder} to create a
     *        request.
     * @return Result of the ListAccountPermissions operation returned by the service.
     * @throws ValidationException
     *         The request has failed validation due to missing required fields or having invalid inputs.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.</p>
     *         <p>
     *         For <code>Enable</code>, you receive this error if you attempt to use a feature in an unsupported Amazon
     *         Web Services Region.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws InternalServerException
     *         The request has failed due to an internal failure of the Amazon Inspector service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Inspector2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Inspector2Client.ListAccountPermissions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/ListAccountPermissions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAccountPermissionsResponse listAccountPermissions(
            Consumer<ListAccountPermissionsRequest.Builder> listAccountPermissionsRequest) throws ValidationException,
            AccessDeniedException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException,
            Inspector2Exception {
        return listAccountPermissions(ListAccountPermissionsRequest.builder().applyMutation(listAccountPermissionsRequest)
                .build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listAccountPermissions(software.amazon.awssdk.services.inspector2.model.ListAccountPermissionsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.inspector2.paginators.ListAccountPermissionsIterable responses = client.listAccountPermissionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.inspector2.paginators.ListAccountPermissionsIterable responses = client
     *             .listAccountPermissionsPaginator(request);
     *     for (software.amazon.awssdk.services.inspector2.model.ListAccountPermissionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.inspector2.paginators.ListAccountPermissionsIterable responses = client.listAccountPermissionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAccountPermissions(software.amazon.awssdk.services.inspector2.model.ListAccountPermissionsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listAccountPermissionsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The request has failed validation due to missing required fields or having invalid inputs.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.</p>
     *         <p>
     *         For <code>Enable</code>, you receive this error if you attempt to use a feature in an unsupported Amazon
     *         Web Services Region.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws InternalServerException
     *         The request has failed due to an internal failure of the Amazon Inspector service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Inspector2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Inspector2Client.ListAccountPermissions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/ListAccountPermissions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAccountPermissionsIterable listAccountPermissionsPaginator(
            ListAccountPermissionsRequest listAccountPermissionsRequest) throws ValidationException, AccessDeniedException,
            ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, Inspector2Exception {
        return new ListAccountPermissionsIterable(this, listAccountPermissionsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listAccountPermissions(software.amazon.awssdk.services.inspector2.model.ListAccountPermissionsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.inspector2.paginators.ListAccountPermissionsIterable responses = client.listAccountPermissionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.inspector2.paginators.ListAccountPermissionsIterable responses = client
     *             .listAccountPermissionsPaginator(request);
     *     for (software.amazon.awssdk.services.inspector2.model.ListAccountPermissionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.inspector2.paginators.ListAccountPermissionsIterable responses = client.listAccountPermissionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAccountPermissions(software.amazon.awssdk.services.inspector2.model.ListAccountPermissionsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAccountPermissionsRequest.Builder} avoiding the
     * need to create one manually via {@link ListAccountPermissionsRequest#builder()}
     * </p>
     *
     * @param listAccountPermissionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.inspector2.model.ListAccountPermissionsRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The request has failed validation due to missing required fields or having invalid inputs.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.</p>
     *         <p>
     *         For <code>Enable</code>, you receive this error if you attempt to use a feature in an unsupported Amazon
     *         Web Services Region.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws InternalServerException
     *         The request has failed due to an internal failure of the Amazon Inspector service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Inspector2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Inspector2Client.ListAccountPermissions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/ListAccountPermissions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAccountPermissionsIterable listAccountPermissionsPaginator(
            Consumer<ListAccountPermissionsRequest.Builder> listAccountPermissionsRequest) throws ValidationException,
            AccessDeniedException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException,
            Inspector2Exception {
        return listAccountPermissionsPaginator(ListAccountPermissionsRequest.builder()
                .applyMutation(listAccountPermissionsRequest).build());
    }

    /**
     * <p>
     * Lists CIS scan configurations.
     * </p>
     *
     * @param listCisScanConfigurationsRequest
     * @return Result of the ListCisScanConfigurations operation returned by the service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.</p>
     *         <p>
     *         For <code>Enable</code>, you receive this error if you attempt to use a feature in an unsupported Amazon
     *         Web Services Region.
     * @throws ValidationException
     *         The request has failed validation due to missing required fields or having invalid inputs.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws InternalServerException
     *         The request has failed due to an internal failure of the Amazon Inspector service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Inspector2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Inspector2Client.ListCisScanConfigurations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/ListCisScanConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListCisScanConfigurationsResponse listCisScanConfigurations(
            ListCisScanConfigurationsRequest listCisScanConfigurationsRequest) throws AccessDeniedException, ValidationException,
            ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, Inspector2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists CIS scan configurations.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListCisScanConfigurationsRequest.Builder} avoiding
     * the need to create one manually via {@link ListCisScanConfigurationsRequest#builder()}
     * </p>
     *
     * @param listCisScanConfigurationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.inspector2.model.ListCisScanConfigurationsRequest.Builder} to
     *        create a request.
     * @return Result of the ListCisScanConfigurations operation returned by the service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.</p>
     *         <p>
     *         For <code>Enable</code>, you receive this error if you attempt to use a feature in an unsupported Amazon
     *         Web Services Region.
     * @throws ValidationException
     *         The request has failed validation due to missing required fields or having invalid inputs.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws InternalServerException
     *         The request has failed due to an internal failure of the Amazon Inspector service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Inspector2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Inspector2Client.ListCisScanConfigurations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/ListCisScanConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListCisScanConfigurationsResponse listCisScanConfigurations(
            Consumer<ListCisScanConfigurationsRequest.Builder> listCisScanConfigurationsRequest) throws AccessDeniedException,
            ValidationException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException,
            Inspector2Exception {
        return listCisScanConfigurations(ListCisScanConfigurationsRequest.builder()
                .applyMutation(listCisScanConfigurationsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listCisScanConfigurations(software.amazon.awssdk.services.inspector2.model.ListCisScanConfigurationsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.inspector2.paginators.ListCisScanConfigurationsIterable responses = client.listCisScanConfigurationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.inspector2.paginators.ListCisScanConfigurationsIterable responses = client
     *             .listCisScanConfigurationsPaginator(request);
     *     for (software.amazon.awssdk.services.inspector2.model.ListCisScanConfigurationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.inspector2.paginators.ListCisScanConfigurationsIterable responses = client.listCisScanConfigurationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listCisScanConfigurations(software.amazon.awssdk.services.inspector2.model.ListCisScanConfigurationsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listCisScanConfigurationsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.</p>
     *         <p>
     *         For <code>Enable</code>, you receive this error if you attempt to use a feature in an unsupported Amazon
     *         Web Services Region.
     * @throws ValidationException
     *         The request has failed validation due to missing required fields or having invalid inputs.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws InternalServerException
     *         The request has failed due to an internal failure of the Amazon Inspector service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Inspector2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Inspector2Client.ListCisScanConfigurations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/ListCisScanConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListCisScanConfigurationsIterable listCisScanConfigurationsPaginator(
            ListCisScanConfigurationsRequest listCisScanConfigurationsRequest) throws AccessDeniedException, ValidationException,
            ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, Inspector2Exception {
        return new ListCisScanConfigurationsIterable(this, listCisScanConfigurationsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listCisScanConfigurations(software.amazon.awssdk.services.inspector2.model.ListCisScanConfigurationsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.inspector2.paginators.ListCisScanConfigurationsIterable responses = client.listCisScanConfigurationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.inspector2.paginators.ListCisScanConfigurationsIterable responses = client
     *             .listCisScanConfigurationsPaginator(request);
     *     for (software.amazon.awssdk.services.inspector2.model.ListCisScanConfigurationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.inspector2.paginators.ListCisScanConfigurationsIterable responses = client.listCisScanConfigurationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listCisScanConfigurations(software.amazon.awssdk.services.inspector2.model.ListCisScanConfigurationsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListCisScanConfigurationsRequest.Builder} avoiding
     * the need to create one manually via {@link ListCisScanConfigurationsRequest#builder()}
     * </p>
     *
     * @param listCisScanConfigurationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.inspector2.model.ListCisScanConfigurationsRequest.Builder} to
     *        create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.</p>
     *         <p>
     *         For <code>Enable</code>, you receive this error if you attempt to use a feature in an unsupported Amazon
     *         Web Services Region.
     * @throws ValidationException
     *         The request has failed validation due to missing required fields or having invalid inputs.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws InternalServerException
     *         The request has failed due to an internal failure of the Amazon Inspector service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Inspector2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Inspector2Client.ListCisScanConfigurations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/ListCisScanConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListCisScanConfigurationsIterable listCisScanConfigurationsPaginator(
            Consumer<ListCisScanConfigurationsRequest.Builder> listCisScanConfigurationsRequest) throws AccessDeniedException,
            ValidationException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException,
            Inspector2Exception {
        return listCisScanConfigurationsPaginator(ListCisScanConfigurationsRequest.builder()
                .applyMutation(listCisScanConfigurationsRequest).build());
    }

    /**
     * <p>
     * Lists scan results aggregated by checks.
     * </p>
     *
     * @param listCisScanResultsAggregatedByChecksRequest
     * @return Result of the ListCisScanResultsAggregatedByChecks operation returned by the service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.</p>
     *         <p>
     *         For <code>Enable</code>, you receive this error if you attempt to use a feature in an unsupported Amazon
     *         Web Services Region.
     * @throws ValidationException
     *         The request has failed validation due to missing required fields or having invalid inputs.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws InternalServerException
     *         The request has failed due to an internal failure of the Amazon Inspector service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Inspector2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Inspector2Client.ListCisScanResultsAggregatedByChecks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/ListCisScanResultsAggregatedByChecks"
     *      target="_top">AWS API Documentation</a>
     */
    default ListCisScanResultsAggregatedByChecksResponse listCisScanResultsAggregatedByChecks(
            ListCisScanResultsAggregatedByChecksRequest listCisScanResultsAggregatedByChecksRequest)
            throws AccessDeniedException, ValidationException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, Inspector2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists scan results aggregated by checks.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link ListCisScanResultsAggregatedByChecksRequest.Builder} avoiding the need to create one manually via
     * {@link ListCisScanResultsAggregatedByChecksRequest#builder()}
     * </p>
     *
     * @param listCisScanResultsAggregatedByChecksRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.inspector2.model.ListCisScanResultsAggregatedByChecksRequest.Builder}
     *        to create a request.
     * @return Result of the ListCisScanResultsAggregatedByChecks operation returned by the service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.</p>
     *         <p>
     *         For <code>Enable</code>, you receive this error if you attempt to use a feature in an unsupported Amazon
     *         Web Services Region.
     * @throws ValidationException
     *         The request has failed validation due to missing required fields or having invalid inputs.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws InternalServerException
     *         The request has failed due to an internal failure of the Amazon Inspector service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Inspector2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Inspector2Client.ListCisScanResultsAggregatedByChecks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/ListCisScanResultsAggregatedByChecks"
     *      target="_top">AWS API Documentation</a>
     */
    default ListCisScanResultsAggregatedByChecksResponse listCisScanResultsAggregatedByChecks(
            Consumer<ListCisScanResultsAggregatedByChecksRequest.Builder> listCisScanResultsAggregatedByChecksRequest)
            throws AccessDeniedException, ValidationException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, Inspector2Exception {
        return listCisScanResultsAggregatedByChecks(ListCisScanResultsAggregatedByChecksRequest.builder()
                .applyMutation(listCisScanResultsAggregatedByChecksRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listCisScanResultsAggregatedByChecks(software.amazon.awssdk.services.inspector2.model.ListCisScanResultsAggregatedByChecksRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.inspector2.paginators.ListCisScanResultsAggregatedByChecksIterable responses = client.listCisScanResultsAggregatedByChecksPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.inspector2.paginators.ListCisScanResultsAggregatedByChecksIterable responses = client
     *             .listCisScanResultsAggregatedByChecksPaginator(request);
     *     for (software.amazon.awssdk.services.inspector2.model.ListCisScanResultsAggregatedByChecksResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.inspector2.paginators.ListCisScanResultsAggregatedByChecksIterable responses = client.listCisScanResultsAggregatedByChecksPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listCisScanResultsAggregatedByChecks(software.amazon.awssdk.services.inspector2.model.ListCisScanResultsAggregatedByChecksRequest)}
     * operation.</b>
     * </p>
     *
     * @param listCisScanResultsAggregatedByChecksRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.</p>
     *         <p>
     *         For <code>Enable</code>, you receive this error if you attempt to use a feature in an unsupported Amazon
     *         Web Services Region.
     * @throws ValidationException
     *         The request has failed validation due to missing required fields or having invalid inputs.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws InternalServerException
     *         The request has failed due to an internal failure of the Amazon Inspector service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Inspector2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Inspector2Client.ListCisScanResultsAggregatedByChecks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/ListCisScanResultsAggregatedByChecks"
     *      target="_top">AWS API Documentation</a>
     */
    default ListCisScanResultsAggregatedByChecksIterable listCisScanResultsAggregatedByChecksPaginator(
            ListCisScanResultsAggregatedByChecksRequest listCisScanResultsAggregatedByChecksRequest)
            throws AccessDeniedException, ValidationException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, Inspector2Exception {
        return new ListCisScanResultsAggregatedByChecksIterable(this, listCisScanResultsAggregatedByChecksRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listCisScanResultsAggregatedByChecks(software.amazon.awssdk.services.inspector2.model.ListCisScanResultsAggregatedByChecksRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.inspector2.paginators.ListCisScanResultsAggregatedByChecksIterable responses = client.listCisScanResultsAggregatedByChecksPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.inspector2.paginators.ListCisScanResultsAggregatedByChecksIterable responses = client
     *             .listCisScanResultsAggregatedByChecksPaginator(request);
     *     for (software.amazon.awssdk.services.inspector2.model.ListCisScanResultsAggregatedByChecksResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.inspector2.paginators.ListCisScanResultsAggregatedByChecksIterable responses = client.listCisScanResultsAggregatedByChecksPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listCisScanResultsAggregatedByChecks(software.amazon.awssdk.services.inspector2.model.ListCisScanResultsAggregatedByChecksRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link ListCisScanResultsAggregatedByChecksRequest.Builder} avoiding the need to create one manually via
     * {@link ListCisScanResultsAggregatedByChecksRequest#builder()}
     * </p>
     *
     * @param listCisScanResultsAggregatedByChecksRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.inspector2.model.ListCisScanResultsAggregatedByChecksRequest.Builder}
     *        to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.</p>
     *         <p>
     *         For <code>Enable</code>, you receive this error if you attempt to use a feature in an unsupported Amazon
     *         Web Services Region.
     * @throws ValidationException
     *         The request has failed validation due to missing required fields or having invalid inputs.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws InternalServerException
     *         The request has failed due to an internal failure of the Amazon Inspector service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Inspector2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Inspector2Client.ListCisScanResultsAggregatedByChecks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/ListCisScanResultsAggregatedByChecks"
     *      target="_top">AWS API Documentation</a>
     */
    default ListCisScanResultsAggregatedByChecksIterable listCisScanResultsAggregatedByChecksPaginator(
            Consumer<ListCisScanResultsAggregatedByChecksRequest.Builder> listCisScanResultsAggregatedByChecksRequest)
            throws AccessDeniedException, ValidationException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, Inspector2Exception {
        return listCisScanResultsAggregatedByChecksPaginator(ListCisScanResultsAggregatedByChecksRequest.builder()
                .applyMutation(listCisScanResultsAggregatedByChecksRequest).build());
    }

    /**
     * <p>
     * Lists scan results aggregated by a target resource.
     * </p>
     *
     * @param listCisScanResultsAggregatedByTargetResourceRequest
     * @return Result of the ListCisScanResultsAggregatedByTargetResource operation returned by the service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.</p>
     *         <p>
     *         For <code>Enable</code>, you receive this error if you attempt to use a feature in an unsupported Amazon
     *         Web Services Region.
     * @throws ValidationException
     *         The request has failed validation due to missing required fields or having invalid inputs.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws InternalServerException
     *         The request has failed due to an internal failure of the Amazon Inspector service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Inspector2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Inspector2Client.ListCisScanResultsAggregatedByTargetResource
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/ListCisScanResultsAggregatedByTargetResource"
     *      target="_top">AWS API Documentation</a>
     */
    default ListCisScanResultsAggregatedByTargetResourceResponse listCisScanResultsAggregatedByTargetResource(
            ListCisScanResultsAggregatedByTargetResourceRequest listCisScanResultsAggregatedByTargetResourceRequest)
            throws AccessDeniedException, ValidationException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, Inspector2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists scan results aggregated by a target resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link ListCisScanResultsAggregatedByTargetResourceRequest.Builder} avoiding the need to create one manually via
     * {@link ListCisScanResultsAggregatedByTargetResourceRequest#builder()}
     * </p>
     *
     * @param listCisScanResultsAggregatedByTargetResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.inspector2.model.ListCisScanResultsAggregatedByTargetResourceRequest.Builder}
     *        to create a request.
     * @return Result of the ListCisScanResultsAggregatedByTargetResource operation returned by the service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.</p>
     *         <p>
     *         For <code>Enable</code>, you receive this error if you attempt to use a feature in an unsupported Amazon
     *         Web Services Region.
     * @throws ValidationException
     *         The request has failed validation due to missing required fields or having invalid inputs.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws InternalServerException
     *         The request has failed due to an internal failure of the Amazon Inspector service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Inspector2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Inspector2Client.ListCisScanResultsAggregatedByTargetResource
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/ListCisScanResultsAggregatedByTargetResource"
     *      target="_top">AWS API Documentation</a>
     */
    default ListCisScanResultsAggregatedByTargetResourceResponse listCisScanResultsAggregatedByTargetResource(
            Consumer<ListCisScanResultsAggregatedByTargetResourceRequest.Builder> listCisScanResultsAggregatedByTargetResourceRequest)
            throws AccessDeniedException, ValidationException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, Inspector2Exception {
        return listCisScanResultsAggregatedByTargetResource(ListCisScanResultsAggregatedByTargetResourceRequest.builder()
                .applyMutation(listCisScanResultsAggregatedByTargetResourceRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listCisScanResultsAggregatedByTargetResource(software.amazon.awssdk.services.inspector2.model.ListCisScanResultsAggregatedByTargetResourceRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.inspector2.paginators.ListCisScanResultsAggregatedByTargetResourceIterable responses = client.listCisScanResultsAggregatedByTargetResourcePaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.inspector2.paginators.ListCisScanResultsAggregatedByTargetResourceIterable responses = client
     *             .listCisScanResultsAggregatedByTargetResourcePaginator(request);
     *     for (software.amazon.awssdk.services.inspector2.model.ListCisScanResultsAggregatedByTargetResourceResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.inspector2.paginators.ListCisScanResultsAggregatedByTargetResourceIterable responses = client.listCisScanResultsAggregatedByTargetResourcePaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listCisScanResultsAggregatedByTargetResource(software.amazon.awssdk.services.inspector2.model.ListCisScanResultsAggregatedByTargetResourceRequest)}
     * operation.</b>
     * </p>
     *
     * @param listCisScanResultsAggregatedByTargetResourceRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.</p>
     *         <p>
     *         For <code>Enable</code>, you receive this error if you attempt to use a feature in an unsupported Amazon
     *         Web Services Region.
     * @throws ValidationException
     *         The request has failed validation due to missing required fields or having invalid inputs.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws InternalServerException
     *         The request has failed due to an internal failure of the Amazon Inspector service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Inspector2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Inspector2Client.ListCisScanResultsAggregatedByTargetResource
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/ListCisScanResultsAggregatedByTargetResource"
     *      target="_top">AWS API Documentation</a>
     */
    default ListCisScanResultsAggregatedByTargetResourceIterable listCisScanResultsAggregatedByTargetResourcePaginator(
            ListCisScanResultsAggregatedByTargetResourceRequest listCisScanResultsAggregatedByTargetResourceRequest)
            throws AccessDeniedException, ValidationException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, Inspector2Exception {
        return new ListCisScanResultsAggregatedByTargetResourceIterable(this, listCisScanResultsAggregatedByTargetResourceRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listCisScanResultsAggregatedByTargetResource(software.amazon.awssdk.services.inspector2.model.ListCisScanResultsAggregatedByTargetResourceRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.inspector2.paginators.ListCisScanResultsAggregatedByTargetResourceIterable responses = client.listCisScanResultsAggregatedByTargetResourcePaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.inspector2.paginators.ListCisScanResultsAggregatedByTargetResourceIterable responses = client
     *             .listCisScanResultsAggregatedByTargetResourcePaginator(request);
     *     for (software.amazon.awssdk.services.inspector2.model.ListCisScanResultsAggregatedByTargetResourceResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.inspector2.paginators.ListCisScanResultsAggregatedByTargetResourceIterable responses = client.listCisScanResultsAggregatedByTargetResourcePaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listCisScanResultsAggregatedByTargetResource(software.amazon.awssdk.services.inspector2.model.ListCisScanResultsAggregatedByTargetResourceRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link ListCisScanResultsAggregatedByTargetResourceRequest.Builder} avoiding the need to create one manually via
     * {@link ListCisScanResultsAggregatedByTargetResourceRequest#builder()}
     * </p>
     *
     * @param listCisScanResultsAggregatedByTargetResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.inspector2.model.ListCisScanResultsAggregatedByTargetResourceRequest.Builder}
     *        to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.</p>
     *         <p>
     *         For <code>Enable</code>, you receive this error if you attempt to use a feature in an unsupported Amazon
     *         Web Services Region.
     * @throws ValidationException
     *         The request has failed validation due to missing required fields or having invalid inputs.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws InternalServerException
     *         The request has failed due to an internal failure of the Amazon Inspector service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Inspector2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Inspector2Client.ListCisScanResultsAggregatedByTargetResource
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/ListCisScanResultsAggregatedByTargetResource"
     *      target="_top">AWS API Documentation</a>
     */
    default ListCisScanResultsAggregatedByTargetResourceIterable listCisScanResultsAggregatedByTargetResourcePaginator(
            Consumer<ListCisScanResultsAggregatedByTargetResourceRequest.Builder> listCisScanResultsAggregatedByTargetResourceRequest)
            throws AccessDeniedException, ValidationException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, Inspector2Exception {
        return listCisScanResultsAggregatedByTargetResourcePaginator(ListCisScanResultsAggregatedByTargetResourceRequest
                .builder().applyMutation(listCisScanResultsAggregatedByTargetResourceRequest).build());
    }

    /**
     * <p>
     * Returns a CIS scan list.
     * </p>
     *
     * @param listCisScansRequest
     * @return Result of the ListCisScans operation returned by the service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.</p>
     *         <p>
     *         For <code>Enable</code>, you receive this error if you attempt to use a feature in an unsupported Amazon
     *         Web Services Region.
     * @throws ValidationException
     *         The request has failed validation due to missing required fields or having invalid inputs.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws InternalServerException
     *         The request has failed due to an internal failure of the Amazon Inspector service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Inspector2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Inspector2Client.ListCisScans
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/ListCisScans" target="_top">AWS API
     *      Documentation</a>
     */
    default ListCisScansResponse listCisScans(ListCisScansRequest listCisScansRequest) throws AccessDeniedException,
            ValidationException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException,
            Inspector2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a CIS scan list.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListCisScansRequest.Builder} avoiding the need to
     * create one manually via {@link ListCisScansRequest#builder()}
     * </p>
     *
     * @param listCisScansRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.inspector2.model.ListCisScansRequest.Builder} to create a request.
     * @return Result of the ListCisScans operation returned by the service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.</p>
     *         <p>
     *         For <code>Enable</code>, you receive this error if you attempt to use a feature in an unsupported Amazon
     *         Web Services Region.
     * @throws ValidationException
     *         The request has failed validation due to missing required fields or having invalid inputs.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws InternalServerException
     *         The request has failed due to an internal failure of the Amazon Inspector service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Inspector2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Inspector2Client.ListCisScans
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/ListCisScans" target="_top">AWS API
     *      Documentation</a>
     */
    default ListCisScansResponse listCisScans(Consumer<ListCisScansRequest.Builder> listCisScansRequest)
            throws AccessDeniedException, ValidationException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, Inspector2Exception {
        return listCisScans(ListCisScansRequest.builder().applyMutation(listCisScansRequest).build());
    }

    /**
     * <p>
     * This is a variant of {@link #listCisScans(software.amazon.awssdk.services.inspector2.model.ListCisScansRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.inspector2.paginators.ListCisScansIterable responses = client.listCisScansPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.inspector2.paginators.ListCisScansIterable responses = client.listCisScansPaginator(request);
     *     for (software.amazon.awssdk.services.inspector2.model.ListCisScansResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.inspector2.paginators.ListCisScansIterable responses = client.listCisScansPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listCisScans(software.amazon.awssdk.services.inspector2.model.ListCisScansRequest)} operation.</b>
     * </p>
     *
     * @param listCisScansRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.</p>
     *         <p>
     *         For <code>Enable</code>, you receive this error if you attempt to use a feature in an unsupported Amazon
     *         Web Services Region.
     * @throws ValidationException
     *         The request has failed validation due to missing required fields or having invalid inputs.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws InternalServerException
     *         The request has failed due to an internal failure of the Amazon Inspector service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Inspector2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Inspector2Client.ListCisScans
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/ListCisScans" target="_top">AWS API
     *      Documentation</a>
     */
    default ListCisScansIterable listCisScansPaginator(ListCisScansRequest listCisScansRequest) throws AccessDeniedException,
            ValidationException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException,
            Inspector2Exception {
        return new ListCisScansIterable(this, listCisScansRequest);
    }

    /**
     * <p>
     * This is a variant of {@link #listCisScans(software.amazon.awssdk.services.inspector2.model.ListCisScansRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.inspector2.paginators.ListCisScansIterable responses = client.listCisScansPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.inspector2.paginators.ListCisScansIterable responses = client.listCisScansPaginator(request);
     *     for (software.amazon.awssdk.services.inspector2.model.ListCisScansResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.inspector2.paginators.ListCisScansIterable responses = client.listCisScansPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listCisScans(software.amazon.awssdk.services.inspector2.model.ListCisScansRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListCisScansRequest.Builder} avoiding the need to
     * create one manually via {@link ListCisScansRequest#builder()}
     * </p>
     *
     * @param listCisScansRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.inspector2.model.ListCisScansRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.</p>
     *         <p>
     *         For <code>Enable</code>, you receive this error if you attempt to use a feature in an unsupported Amazon
     *         Web Services Region.
     * @throws ValidationException
     *         The request has failed validation due to missing required fields or having invalid inputs.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws InternalServerException
     *         The request has failed due to an internal failure of the Amazon Inspector service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Inspector2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Inspector2Client.ListCisScans
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/ListCisScans" target="_top">AWS API
     *      Documentation</a>
     */
    default ListCisScansIterable listCisScansPaginator(Consumer<ListCisScansRequest.Builder> listCisScansRequest)
            throws AccessDeniedException, ValidationException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, Inspector2Exception {
        return listCisScansPaginator(ListCisScansRequest.builder().applyMutation(listCisScansRequest).build());
    }

    /**
     * <p>
     * Lists all code security integrations in your account.
     * </p>
     *
     * @param listCodeSecurityIntegrationsRequest
     * @return Result of the ListCodeSecurityIntegrations operation returned by the service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.</p>
     *         <p>
     *         For <code>Enable</code>, you receive this error if you attempt to use a feature in an unsupported Amazon
     *         Web Services Region.
     * @throws ValidationException
     *         The request has failed validation due to missing required fields or having invalid inputs.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws InternalServerException
     *         The request has failed due to an internal failure of the Amazon Inspector service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Inspector2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Inspector2Client.ListCodeSecurityIntegrations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/ListCodeSecurityIntegrations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListCodeSecurityIntegrationsResponse listCodeSecurityIntegrations(
            ListCodeSecurityIntegrationsRequest listCodeSecurityIntegrationsRequest) throws AccessDeniedException,
            ValidationException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException,
            Inspector2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all code security integrations in your account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListCodeSecurityIntegrationsRequest.Builder}
     * avoiding the need to create one manually via {@link ListCodeSecurityIntegrationsRequest#builder()}
     * </p>
     *
     * @param listCodeSecurityIntegrationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.inspector2.model.ListCodeSecurityIntegrationsRequest.Builder} to
     *        create a request.
     * @return Result of the ListCodeSecurityIntegrations operation returned by the service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.</p>
     *         <p>
     *         For <code>Enable</code>, you receive this error if you attempt to use a feature in an unsupported Amazon
     *         Web Services Region.
     * @throws ValidationException
     *         The request has failed validation due to missing required fields or having invalid inputs.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws InternalServerException
     *         The request has failed due to an internal failure of the Amazon Inspector service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Inspector2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Inspector2Client.ListCodeSecurityIntegrations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/ListCodeSecurityIntegrations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListCodeSecurityIntegrationsResponse listCodeSecurityIntegrations(
            Consumer<ListCodeSecurityIntegrationsRequest.Builder> listCodeSecurityIntegrationsRequest)
            throws AccessDeniedException, ValidationException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, Inspector2Exception {
        return listCodeSecurityIntegrations(ListCodeSecurityIntegrationsRequest.builder()
                .applyMutation(listCodeSecurityIntegrationsRequest).build());
    }

    /**
     * <p>
     * Lists the associations between code repositories and Amazon Inspector code security scan configurations.
     * </p>
     *
     * @param listCodeSecurityScanConfigurationAssociationsRequest
     * @return Result of the ListCodeSecurityScanConfigurationAssociations operation returned by the service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.</p>
     *         <p>
     *         For <code>Enable</code>, you receive this error if you attempt to use a feature in an unsupported Amazon
     *         Web Services Region.
     * @throws ValidationException
     *         The request has failed validation due to missing required fields or having invalid inputs.
     * @throws ResourceNotFoundException
     *         The operation tried to access an invalid resource. Make sure the resource is specified correctly.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws InternalServerException
     *         The request has failed due to an internal failure of the Amazon Inspector service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Inspector2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Inspector2Client.ListCodeSecurityScanConfigurationAssociations
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/ListCodeSecurityScanConfigurationAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListCodeSecurityScanConfigurationAssociationsResponse listCodeSecurityScanConfigurationAssociations(
            ListCodeSecurityScanConfigurationAssociationsRequest listCodeSecurityScanConfigurationAssociationsRequest)
            throws AccessDeniedException, ValidationException, ResourceNotFoundException, ThrottlingException,
            InternalServerException, AwsServiceException, SdkClientException, Inspector2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the associations between code repositories and Amazon Inspector code security scan configurations.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link ListCodeSecurityScanConfigurationAssociationsRequest.Builder} avoiding the need to create one manually via
     * {@link ListCodeSecurityScanConfigurationAssociationsRequest#builder()}
     * </p>
     *
     * @param listCodeSecurityScanConfigurationAssociationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.inspector2.model.ListCodeSecurityScanConfigurationAssociationsRequest.Builder}
     *        to create a request.
     * @return Result of the ListCodeSecurityScanConfigurationAssociations operation returned by the service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.</p>
     *         <p>
     *         For <code>Enable</code>, you receive this error if you attempt to use a feature in an unsupported Amazon
     *         Web Services Region.
     * @throws ValidationException
     *         The request has failed validation due to missing required fields or having invalid inputs.
     * @throws ResourceNotFoundException
     *         The operation tried to access an invalid resource. Make sure the resource is specified correctly.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws InternalServerException
     *         The request has failed due to an internal failure of the Amazon Inspector service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Inspector2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Inspector2Client.ListCodeSecurityScanConfigurationAssociations
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/ListCodeSecurityScanConfigurationAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListCodeSecurityScanConfigurationAssociationsResponse listCodeSecurityScanConfigurationAssociations(
            Consumer<ListCodeSecurityScanConfigurationAssociationsRequest.Builder> listCodeSecurityScanConfigurationAssociationsRequest)
            throws AccessDeniedException, ValidationException, ResourceNotFoundException, ThrottlingException,
            InternalServerException, AwsServiceException, SdkClientException, Inspector2Exception {
        return listCodeSecurityScanConfigurationAssociations(ListCodeSecurityScanConfigurationAssociationsRequest.builder()
                .applyMutation(listCodeSecurityScanConfigurationAssociationsRequest).build());
    }

    /**
     * <p>
     * Lists all code security scan configurations in your account.
     * </p>
     *
     * @param listCodeSecurityScanConfigurationsRequest
     * @return Result of the ListCodeSecurityScanConfigurations operation returned by the service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.</p>
     *         <p>
     *         For <code>Enable</code>, you receive this error if you attempt to use a feature in an unsupported Amazon
     *         Web Services Region.
     * @throws ValidationException
     *         The request has failed validation due to missing required fields or having invalid inputs.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws ResourceNotFoundException
     *         The operation tried to access an invalid resource. Make sure the resource is specified correctly.
     * @throws InternalServerException
     *         The request has failed due to an internal failure of the Amazon Inspector service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Inspector2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Inspector2Client.ListCodeSecurityScanConfigurations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/ListCodeSecurityScanConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListCodeSecurityScanConfigurationsResponse listCodeSecurityScanConfigurations(
            ListCodeSecurityScanConfigurationsRequest listCodeSecurityScanConfigurationsRequest) throws AccessDeniedException,
            ValidationException, ThrottlingException, ResourceNotFoundException, InternalServerException, AwsServiceException,
            SdkClientException, Inspector2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all code security scan configurations in your account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListCodeSecurityScanConfigurationsRequest.Builder}
     * avoiding the need to create one manually via {@link ListCodeSecurityScanConfigurationsRequest#builder()}
     * </p>
     *
     * @param listCodeSecurityScanConfigurationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.inspector2.model.ListCodeSecurityScanConfigurationsRequest.Builder}
     *        to create a request.
     * @return Result of the ListCodeSecurityScanConfigurations operation returned by the service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.</p>
     *         <p>
     *         For <code>Enable</code>, you receive this error if you attempt to use a feature in an unsupported Amazon
     *         Web Services Region.
     * @throws ValidationException
     *         The request has failed validation due to missing required fields or having invalid inputs.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws ResourceNotFoundException
     *         The operation tried to access an invalid resource. Make sure the resource is specified correctly.
     * @throws InternalServerException
     *         The request has failed due to an internal failure of the Amazon Inspector service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Inspector2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Inspector2Client.ListCodeSecurityScanConfigurations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/ListCodeSecurityScanConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListCodeSecurityScanConfigurationsResponse listCodeSecurityScanConfigurations(
            Consumer<ListCodeSecurityScanConfigurationsRequest.Builder> listCodeSecurityScanConfigurationsRequest)
            throws AccessDeniedException, ValidationException, ThrottlingException, ResourceNotFoundException,
            InternalServerException, AwsServiceException, SdkClientException, Inspector2Exception {
        return listCodeSecurityScanConfigurations(ListCodeSecurityScanConfigurationsRequest.builder()
                .applyMutation(listCodeSecurityScanConfigurationsRequest).build());
    }

    /**
     * <p>
     * Lists coverage details for your environment.
     * </p>
     *
     * @param listCoverageRequest
     * @return Result of the ListCoverage operation returned by the service.
     * @throws ValidationException
     *         The request has failed validation due to missing required fields or having invalid inputs.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws InternalServerException
     *         The request has failed due to an internal failure of the Amazon Inspector service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Inspector2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Inspector2Client.ListCoverage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/ListCoverage" target="_top">AWS API
     *      Documentation</a>
     */
    default ListCoverageResponse listCoverage(ListCoverageRequest listCoverageRequest) throws ValidationException,
            ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, Inspector2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists coverage details for your environment.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListCoverageRequest.Builder} avoiding the need to
     * create one manually via {@link ListCoverageRequest#builder()}
     * </p>
     *
     * @param listCoverageRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.inspector2.model.ListCoverageRequest.Builder} to create a request.
     * @return Result of the ListCoverage operation returned by the service.
     * @throws ValidationException
     *         The request has failed validation due to missing required fields or having invalid inputs.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws InternalServerException
     *         The request has failed due to an internal failure of the Amazon Inspector service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Inspector2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Inspector2Client.ListCoverage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/ListCoverage" target="_top">AWS API
     *      Documentation</a>
     */
    default ListCoverageResponse listCoverage(Consumer<ListCoverageRequest.Builder> listCoverageRequest)
            throws ValidationException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException,
            Inspector2Exception {
        return listCoverage(ListCoverageRequest.builder().applyMutation(listCoverageRequest).build());
    }

    /**
     * <p>
     * This is a variant of {@link #listCoverage(software.amazon.awssdk.services.inspector2.model.ListCoverageRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.inspector2.paginators.ListCoverageIterable responses = client.listCoveragePaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.inspector2.paginators.ListCoverageIterable responses = client.listCoveragePaginator(request);
     *     for (software.amazon.awssdk.services.inspector2.model.ListCoverageResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.inspector2.paginators.ListCoverageIterable responses = client.listCoveragePaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listCoverage(software.amazon.awssdk.services.inspector2.model.ListCoverageRequest)} operation.</b>
     * </p>
     *
     * @param listCoverageRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The request has failed validation due to missing required fields or having invalid inputs.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws InternalServerException
     *         The request has failed due to an internal failure of the Amazon Inspector service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Inspector2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Inspector2Client.ListCoverage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/ListCoverage" target="_top">AWS API
     *      Documentation</a>
     */
    default ListCoverageIterable listCoveragePaginator(ListCoverageRequest listCoverageRequest) throws ValidationException,
            ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, Inspector2Exception {
        return new ListCoverageIterable(this, listCoverageRequest);
    }

    /**
     * <p>
     * This is a variant of {@link #listCoverage(software.amazon.awssdk.services.inspector2.model.ListCoverageRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.inspector2.paginators.ListCoverageIterable responses = client.listCoveragePaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.inspector2.paginators.ListCoverageIterable responses = client.listCoveragePaginator(request);
     *     for (software.amazon.awssdk.services.inspector2.model.ListCoverageResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.inspector2.paginators.ListCoverageIterable responses = client.listCoveragePaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listCoverage(software.amazon.awssdk.services.inspector2.model.ListCoverageRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListCoverageRequest.Builder} avoiding the need to
     * create one manually via {@link ListCoverageRequest#builder()}
     * </p>
     *
     * @param listCoverageRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.inspector2.model.ListCoverageRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The request has failed validation due to missing required fields or having invalid inputs.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws InternalServerException
     *         The request has failed due to an internal failure of the Amazon Inspector service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Inspector2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Inspector2Client.ListCoverage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/ListCoverage" target="_top">AWS API
     *      Documentation</a>
     */
    default ListCoverageIterable listCoveragePaginator(Consumer<ListCoverageRequest.Builder> listCoverageRequest)
            throws ValidationException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException,
            Inspector2Exception {
        return listCoveragePaginator(ListCoverageRequest.builder().applyMutation(listCoverageRequest).build());
    }

    /**
     * <p>
     * Lists Amazon Inspector coverage statistics for your environment.
     * </p>
     *
     * @param listCoverageStatisticsRequest
     * @return Result of the ListCoverageStatistics operation returned by the service.
     * @throws ValidationException
     *         The request has failed validation due to missing required fields or having invalid inputs.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws InternalServerException
     *         The request has failed due to an internal failure of the Amazon Inspector service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Inspector2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Inspector2Client.ListCoverageStatistics
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/ListCoverageStatistics"
     *      target="_top">AWS API Documentation</a>
     */
    default ListCoverageStatisticsResponse listCoverageStatistics(ListCoverageStatisticsRequest listCoverageStatisticsRequest)
            throws ValidationException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException,
            Inspector2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists Amazon Inspector coverage statistics for your environment.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListCoverageStatisticsRequest.Builder} avoiding the
     * need to create one manually via {@link ListCoverageStatisticsRequest#builder()}
     * </p>
     *
     * @param listCoverageStatisticsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.inspector2.model.ListCoverageStatisticsRequest.Builder} to create a
     *        request.
     * @return Result of the ListCoverageStatistics operation returned by the service.
     * @throws ValidationException
     *         The request has failed validation due to missing required fields or having invalid inputs.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws InternalServerException
     *         The request has failed due to an internal failure of the Amazon Inspector service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Inspector2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Inspector2Client.ListCoverageStatistics
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/ListCoverageStatistics"
     *      target="_top">AWS API Documentation</a>
     */
    default ListCoverageStatisticsResponse listCoverageStatistics(
            Consumer<ListCoverageStatisticsRequest.Builder> listCoverageStatisticsRequest) throws ValidationException,
            ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, Inspector2Exception {
        return listCoverageStatistics(ListCoverageStatisticsRequest.builder().applyMutation(listCoverageStatisticsRequest)
                .build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listCoverageStatistics(software.amazon.awssdk.services.inspector2.model.ListCoverageStatisticsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.inspector2.paginators.ListCoverageStatisticsIterable responses = client.listCoverageStatisticsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.inspector2.paginators.ListCoverageStatisticsIterable responses = client
     *             .listCoverageStatisticsPaginator(request);
     *     for (software.amazon.awssdk.services.inspector2.model.ListCoverageStatisticsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.inspector2.paginators.ListCoverageStatisticsIterable responses = client.listCoverageStatisticsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listCoverageStatistics(software.amazon.awssdk.services.inspector2.model.ListCoverageStatisticsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listCoverageStatisticsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The request has failed validation due to missing required fields or having invalid inputs.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws InternalServerException
     *         The request has failed due to an internal failure of the Amazon Inspector service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Inspector2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Inspector2Client.ListCoverageStatistics
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/ListCoverageStatistics"
     *      target="_top">AWS API Documentation</a>
     */
    default ListCoverageStatisticsIterable listCoverageStatisticsPaginator(
            ListCoverageStatisticsRequest listCoverageStatisticsRequest) throws ValidationException, ThrottlingException,
            InternalServerException, AwsServiceException, SdkClientException, Inspector2Exception {
        return new ListCoverageStatisticsIterable(this, listCoverageStatisticsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listCoverageStatistics(software.amazon.awssdk.services.inspector2.model.ListCoverageStatisticsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.inspector2.paginators.ListCoverageStatisticsIterable responses = client.listCoverageStatisticsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.inspector2.paginators.ListCoverageStatisticsIterable responses = client
     *             .listCoverageStatisticsPaginator(request);
     *     for (software.amazon.awssdk.services.inspector2.model.ListCoverageStatisticsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.inspector2.paginators.ListCoverageStatisticsIterable responses = client.listCoverageStatisticsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listCoverageStatistics(software.amazon.awssdk.services.inspector2.model.ListCoverageStatisticsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListCoverageStatisticsRequest.Builder} avoiding the
     * need to create one manually via {@link ListCoverageStatisticsRequest#builder()}
     * </p>
     *
     * @param listCoverageStatisticsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.inspector2.model.ListCoverageStatisticsRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The request has failed validation due to missing required fields or having invalid inputs.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws InternalServerException
     *         The request has failed due to an internal failure of the Amazon Inspector service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Inspector2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Inspector2Client.ListCoverageStatistics
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/ListCoverageStatistics"
     *      target="_top">AWS API Documentation</a>
     */
    default ListCoverageStatisticsIterable listCoverageStatisticsPaginator(
            Consumer<ListCoverageStatisticsRequest.Builder> listCoverageStatisticsRequest) throws ValidationException,
            ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, Inspector2Exception {
        return listCoverageStatisticsPaginator(ListCoverageStatisticsRequest.builder()
                .applyMutation(listCoverageStatisticsRequest).build());
    }

    /**
     * <p>
     * Lists information about the Amazon Inspector delegated administrator of your organization.
     * </p>
     *
     * @param listDelegatedAdminAccountsRequest
     * @return Result of the ListDelegatedAdminAccounts operation returned by the service.
     * @throws ValidationException
     *         The request has failed validation due to missing required fields or having invalid inputs.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.</p>
     *         <p>
     *         For <code>Enable</code>, you receive this error if you attempt to use a feature in an unsupported Amazon
     *         Web Services Region.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws InternalServerException
     *         The request has failed due to an internal failure of the Amazon Inspector service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Inspector2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Inspector2Client.ListDelegatedAdminAccounts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/ListDelegatedAdminAccounts"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDelegatedAdminAccountsResponse listDelegatedAdminAccounts(
            ListDelegatedAdminAccountsRequest listDelegatedAdminAccountsRequest) throws ValidationException,
            AccessDeniedException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException,
            Inspector2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists information about the Amazon Inspector delegated administrator of your organization.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDelegatedAdminAccountsRequest.Builder} avoiding
     * the need to create one manually via {@link ListDelegatedAdminAccountsRequest#builder()}
     * </p>
     *
     * @param listDelegatedAdminAccountsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.inspector2.model.ListDelegatedAdminAccountsRequest.Builder} to
     *        create a request.
     * @return Result of the ListDelegatedAdminAccounts operation returned by the service.
     * @throws ValidationException
     *         The request has failed validation due to missing required fields or having invalid inputs.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.</p>
     *         <p>
     *         For <code>Enable</code>, you receive this error if you attempt to use a feature in an unsupported Amazon
     *         Web Services Region.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws InternalServerException
     *         The request has failed due to an internal failure of the Amazon Inspector service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Inspector2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Inspector2Client.ListDelegatedAdminAccounts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/ListDelegatedAdminAccounts"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDelegatedAdminAccountsResponse listDelegatedAdminAccounts(
            Consumer<ListDelegatedAdminAccountsRequest.Builder> listDelegatedAdminAccountsRequest) throws ValidationException,
            AccessDeniedException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException,
            Inspector2Exception {
        return listDelegatedAdminAccounts(ListDelegatedAdminAccountsRequest.builder()
                .applyMutation(listDelegatedAdminAccountsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listDelegatedAdminAccounts(software.amazon.awssdk.services.inspector2.model.ListDelegatedAdminAccountsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.inspector2.paginators.ListDelegatedAdminAccountsIterable responses = client.listDelegatedAdminAccountsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.inspector2.paginators.ListDelegatedAdminAccountsIterable responses = client
     *             .listDelegatedAdminAccountsPaginator(request);
     *     for (software.amazon.awssdk.services.inspector2.model.ListDelegatedAdminAccountsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.inspector2.paginators.ListDelegatedAdminAccountsIterable responses = client.listDelegatedAdminAccountsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDelegatedAdminAccounts(software.amazon.awssdk.services.inspector2.model.ListDelegatedAdminAccountsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listDelegatedAdminAccountsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The request has failed validation due to missing required fields or having invalid inputs.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.</p>
     *         <p>
     *         For <code>Enable</code>, you receive this error if you attempt to use a feature in an unsupported Amazon
     *         Web Services Region.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws InternalServerException
     *         The request has failed due to an internal failure of the Amazon Inspector service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Inspector2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Inspector2Client.ListDelegatedAdminAccounts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/ListDelegatedAdminAccounts"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDelegatedAdminAccountsIterable listDelegatedAdminAccountsPaginator(
            ListDelegatedAdminAccountsRequest listDelegatedAdminAccountsRequest) throws ValidationException,
            AccessDeniedException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException,
            Inspector2Exception {
        return new ListDelegatedAdminAccountsIterable(this, listDelegatedAdminAccountsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listDelegatedAdminAccounts(software.amazon.awssdk.services.inspector2.model.ListDelegatedAdminAccountsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.inspector2.paginators.ListDelegatedAdminAccountsIterable responses = client.listDelegatedAdminAccountsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.inspector2.paginators.ListDelegatedAdminAccountsIterable responses = client
     *             .listDelegatedAdminAccountsPaginator(request);
     *     for (software.amazon.awssdk.services.inspector2.model.ListDelegatedAdminAccountsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.inspector2.paginators.ListDelegatedAdminAccountsIterable responses = client.listDelegatedAdminAccountsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDelegatedAdminAccounts(software.amazon.awssdk.services.inspector2.model.ListDelegatedAdminAccountsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDelegatedAdminAccountsRequest.Builder} avoiding
     * the need to create one manually via {@link ListDelegatedAdminAccountsRequest#builder()}
     * </p>
     *
     * @param listDelegatedAdminAccountsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.inspector2.model.ListDelegatedAdminAccountsRequest.Builder} to
     *        create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The request has failed validation due to missing required fields or having invalid inputs.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.</p>
     *         <p>
     *         For <code>Enable</code>, you receive this error if you attempt to use a feature in an unsupported Amazon
     *         Web Services Region.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws InternalServerException
     *         The request has failed due to an internal failure of the Amazon Inspector service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Inspector2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Inspector2Client.ListDelegatedAdminAccounts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/ListDelegatedAdminAccounts"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDelegatedAdminAccountsIterable listDelegatedAdminAccountsPaginator(
            Consumer<ListDelegatedAdminAccountsRequest.Builder> listDelegatedAdminAccountsRequest) throws ValidationException,
            AccessDeniedException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException,
            Inspector2Exception {
        return listDelegatedAdminAccountsPaginator(ListDelegatedAdminAccountsRequest.builder()
                .applyMutation(listDelegatedAdminAccountsRequest).build());
    }

    /**
     * <p>
     * Lists the filters associated with your account.
     * </p>
     *
     * @param listFiltersRequest
     * @return Result of the ListFilters operation returned by the service.
     * @throws ValidationException
     *         The request has failed validation due to missing required fields or having invalid inputs.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.</p>
     *         <p>
     *         For <code>Enable</code>, you receive this error if you attempt to use a feature in an unsupported Amazon
     *         Web Services Region.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws InternalServerException
     *         The request has failed due to an internal failure of the Amazon Inspector service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Inspector2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Inspector2Client.ListFilters
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/ListFilters" target="_top">AWS API
     *      Documentation</a>
     */
    default ListFiltersResponse listFilters(ListFiltersRequest listFiltersRequest) throws ValidationException,
            AccessDeniedException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException,
            Inspector2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the filters associated with your account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListFiltersRequest.Builder} avoiding the need to
     * create one manually via {@link ListFiltersRequest#builder()}
     * </p>
     *
     * @param listFiltersRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.inspector2.model.ListFiltersRequest.Builder} to create a request.
     * @return Result of the ListFilters operation returned by the service.
     * @throws ValidationException
     *         The request has failed validation due to missing required fields or having invalid inputs.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.</p>
     *         <p>
     *         For <code>Enable</code>, you receive this error if you attempt to use a feature in an unsupported Amazon
     *         Web Services Region.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws InternalServerException
     *         The request has failed due to an internal failure of the Amazon Inspector service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Inspector2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Inspector2Client.ListFilters
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/ListFilters" target="_top">AWS API
     *      Documentation</a>
     */
    default ListFiltersResponse listFilters(Consumer<ListFiltersRequest.Builder> listFiltersRequest) throws ValidationException,
            AccessDeniedException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException,
            Inspector2Exception {
        return listFilters(ListFiltersRequest.builder().applyMutation(listFiltersRequest).build());
    }

    /**
     * <p>
     * This is a variant of {@link #listFilters(software.amazon.awssdk.services.inspector2.model.ListFiltersRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.inspector2.paginators.ListFiltersIterable responses = client.listFiltersPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.inspector2.paginators.ListFiltersIterable responses = client.listFiltersPaginator(request);
     *     for (software.amazon.awssdk.services.inspector2.model.ListFiltersResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.inspector2.paginators.ListFiltersIterable responses = client.listFiltersPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listFilters(software.amazon.awssdk.services.inspector2.model.ListFiltersRequest)} operation.</b>
     * </p>
     *
     * @param listFiltersRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The request has failed validation due to missing required fields or having invalid inputs.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.</p>
     *         <p>
     *         For <code>Enable</code>, you receive this error if you attempt to use a feature in an unsupported Amazon
     *         Web Services Region.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws InternalServerException
     *         The request has failed due to an internal failure of the Amazon Inspector service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Inspector2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Inspector2Client.ListFilters
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/ListFilters" target="_top">AWS API
     *      Documentation</a>
     */
    default ListFiltersIterable listFiltersPaginator(ListFiltersRequest listFiltersRequest) throws ValidationException,
            AccessDeniedException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException,
            Inspector2Exception {
        return new ListFiltersIterable(this, listFiltersRequest);
    }

    /**
     * <p>
     * This is a variant of {@link #listFilters(software.amazon.awssdk.services.inspector2.model.ListFiltersRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.inspector2.paginators.ListFiltersIterable responses = client.listFiltersPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.inspector2.paginators.ListFiltersIterable responses = client.listFiltersPaginator(request);
     *     for (software.amazon.awssdk.services.inspector2.model.ListFiltersResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.inspector2.paginators.ListFiltersIterable responses = client.listFiltersPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listFilters(software.amazon.awssdk.services.inspector2.model.ListFiltersRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListFiltersRequest.Builder} avoiding the need to
     * create one manually via {@link ListFiltersRequest#builder()}
     * </p>
     *
     * @param listFiltersRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.inspector2.model.ListFiltersRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The request has failed validation due to missing required fields or having invalid inputs.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.</p>
     *         <p>
     *         For <code>Enable</code>, you receive this error if you attempt to use a feature in an unsupported Amazon
     *         Web Services Region.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws InternalServerException
     *         The request has failed due to an internal failure of the Amazon Inspector service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Inspector2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Inspector2Client.ListFilters
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/ListFilters" target="_top">AWS API
     *      Documentation</a>
     */
    default ListFiltersIterable listFiltersPaginator(Consumer<ListFiltersRequest.Builder> listFiltersRequest)
            throws ValidationException, AccessDeniedException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, Inspector2Exception {
        return listFiltersPaginator(ListFiltersRequest.builder().applyMutation(listFiltersRequest).build());
    }

    /**
     * <p>
     * Lists aggregated finding data for your environment based on specific criteria.
     * </p>
     *
     * @param listFindingAggregationsRequest
     * @return Result of the ListFindingAggregations operation returned by the service.
     * @throws ValidationException
     *         The request has failed validation due to missing required fields or having invalid inputs.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws InternalServerException
     *         The request has failed due to an internal failure of the Amazon Inspector service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Inspector2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Inspector2Client.ListFindingAggregations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/ListFindingAggregations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListFindingAggregationsResponse listFindingAggregations(ListFindingAggregationsRequest listFindingAggregationsRequest)
            throws ValidationException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException,
            Inspector2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists aggregated finding data for your environment based on specific criteria.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListFindingAggregationsRequest.Builder} avoiding
     * the need to create one manually via {@link ListFindingAggregationsRequest#builder()}
     * </p>
     *
     * @param listFindingAggregationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.inspector2.model.ListFindingAggregationsRequest.Builder} to create
     *        a request.
     * @return Result of the ListFindingAggregations operation returned by the service.
     * @throws ValidationException
     *         The request has failed validation due to missing required fields or having invalid inputs.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws InternalServerException
     *         The request has failed due to an internal failure of the Amazon Inspector service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Inspector2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Inspector2Client.ListFindingAggregations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/ListFindingAggregations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListFindingAggregationsResponse listFindingAggregations(
            Consumer<ListFindingAggregationsRequest.Builder> listFindingAggregationsRequest) throws ValidationException,
            ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, Inspector2Exception {
        return listFindingAggregations(ListFindingAggregationsRequest.builder().applyMutation(listFindingAggregationsRequest)
                .build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listFindingAggregations(software.amazon.awssdk.services.inspector2.model.ListFindingAggregationsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.inspector2.paginators.ListFindingAggregationsIterable responses = client.listFindingAggregationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.inspector2.paginators.ListFindingAggregationsIterable responses = client
     *             .listFindingAggregationsPaginator(request);
     *     for (software.amazon.awssdk.services.inspector2.model.ListFindingAggregationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.inspector2.paginators.ListFindingAggregationsIterable responses = client.listFindingAggregationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listFindingAggregations(software.amazon.awssdk.services.inspector2.model.ListFindingAggregationsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listFindingAggregationsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The request has failed validation due to missing required fields or having invalid inputs.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws InternalServerException
     *         The request has failed due to an internal failure of the Amazon Inspector service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Inspector2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Inspector2Client.ListFindingAggregations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/ListFindingAggregations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListFindingAggregationsIterable listFindingAggregationsPaginator(
            ListFindingAggregationsRequest listFindingAggregationsRequest) throws ValidationException, ThrottlingException,
            InternalServerException, AwsServiceException, SdkClientException, Inspector2Exception {
        return new ListFindingAggregationsIterable(this, listFindingAggregationsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listFindingAggregations(software.amazon.awssdk.services.inspector2.model.ListFindingAggregationsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.inspector2.paginators.ListFindingAggregationsIterable responses = client.listFindingAggregationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.inspector2.paginators.ListFindingAggregationsIterable responses = client
     *             .listFindingAggregationsPaginator(request);
     *     for (software.amazon.awssdk.services.inspector2.model.ListFindingAggregationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.inspector2.paginators.ListFindingAggregationsIterable responses = client.listFindingAggregationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listFindingAggregations(software.amazon.awssdk.services.inspector2.model.ListFindingAggregationsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListFindingAggregationsRequest.Builder} avoiding
     * the need to create one manually via {@link ListFindingAggregationsRequest#builder()}
     * </p>
     *
     * @param listFindingAggregationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.inspector2.model.ListFindingAggregationsRequest.Builder} to create
     *        a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The request has failed validation due to missing required fields or having invalid inputs.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws InternalServerException
     *         The request has failed due to an internal failure of the Amazon Inspector service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Inspector2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Inspector2Client.ListFindingAggregations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/ListFindingAggregations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListFindingAggregationsIterable listFindingAggregationsPaginator(
            Consumer<ListFindingAggregationsRequest.Builder> listFindingAggregationsRequest) throws ValidationException,
            ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, Inspector2Exception {
        return listFindingAggregationsPaginator(ListFindingAggregationsRequest.builder()
                .applyMutation(listFindingAggregationsRequest).build());
    }

    /**
     * <p>
     * Lists findings for your environment.
     * </p>
     *
     * @param listFindingsRequest
     * @return Result of the ListFindings operation returned by the service.
     * @throws ValidationException
     *         The request has failed validation due to missing required fields or having invalid inputs.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws InternalServerException
     *         The request has failed due to an internal failure of the Amazon Inspector service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Inspector2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Inspector2Client.ListFindings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/ListFindings" target="_top">AWS API
     *      Documentation</a>
     */
    default ListFindingsResponse listFindings(ListFindingsRequest listFindingsRequest) throws ValidationException,
            ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, Inspector2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists findings for your environment.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListFindingsRequest.Builder} avoiding the need to
     * create one manually via {@link ListFindingsRequest#builder()}
     * </p>
     *
     * @param listFindingsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.inspector2.model.ListFindingsRequest.Builder} to create a request.
     * @return Result of the ListFindings operation returned by the service.
     * @throws ValidationException
     *         The request has failed validation due to missing required fields or having invalid inputs.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws InternalServerException
     *         The request has failed due to an internal failure of the Amazon Inspector service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Inspector2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Inspector2Client.ListFindings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/ListFindings" target="_top">AWS API
     *      Documentation</a>
     */
    default ListFindingsResponse listFindings(Consumer<ListFindingsRequest.Builder> listFindingsRequest)
            throws ValidationException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException,
            Inspector2Exception {
        return listFindings(ListFindingsRequest.builder().applyMutation(listFindingsRequest).build());
    }

    /**
     * <p>
     * This is a variant of {@link #listFindings(software.amazon.awssdk.services.inspector2.model.ListFindingsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.inspector2.paginators.ListFindingsIterable responses = client.listFindingsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.inspector2.paginators.ListFindingsIterable responses = client.listFindingsPaginator(request);
     *     for (software.amazon.awssdk.services.inspector2.model.ListFindingsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.inspector2.paginators.ListFindingsIterable responses = client.listFindingsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listFindings(software.amazon.awssdk.services.inspector2.model.ListFindingsRequest)} operation.</b>
     * </p>
     *
     * @param listFindingsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The request has failed validation due to missing required fields or having invalid inputs.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws InternalServerException
     *         The request has failed due to an internal failure of the Amazon Inspector service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Inspector2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Inspector2Client.ListFindings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/ListFindings" target="_top">AWS API
     *      Documentation</a>
     */
    default ListFindingsIterable listFindingsPaginator(ListFindingsRequest listFindingsRequest) throws ValidationException,
            ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, Inspector2Exception {
        return new ListFindingsIterable(this, listFindingsRequest);
    }

    /**
     * <p>
     * This is a variant of {@link #listFindings(software.amazon.awssdk.services.inspector2.model.ListFindingsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.inspector2.paginators.ListFindingsIterable responses = client.listFindingsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.inspector2.paginators.ListFindingsIterable responses = client.listFindingsPaginator(request);
     *     for (software.amazon.awssdk.services.inspector2.model.ListFindingsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.inspector2.paginators.ListFindingsIterable responses = client.listFindingsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listFindings(software.amazon.awssdk.services.inspector2.model.ListFindingsRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListFindingsRequest.Builder} avoiding the need to
     * create one manually via {@link ListFindingsRequest#builder()}
     * </p>
     *
     * @param listFindingsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.inspector2.model.ListFindingsRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The request has failed validation due to missing required fields or having invalid inputs.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws InternalServerException
     *         The request has failed due to an internal failure of the Amazon Inspector service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Inspector2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Inspector2Client.ListFindings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/ListFindings" target="_top">AWS API
     *      Documentation</a>
     */
    default ListFindingsIterable listFindingsPaginator(Consumer<ListFindingsRequest.Builder> listFindingsRequest)
            throws ValidationException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException,
            Inspector2Exception {
        return listFindingsPaginator(ListFindingsRequest.builder().applyMutation(listFindingsRequest).build());
    }

    /**
     * <p>
     * List members associated with the Amazon Inspector delegated administrator for your organization.
     * </p>
     *
     * @param listMembersRequest
     * @return Result of the ListMembers operation returned by the service.
     * @throws ValidationException
     *         The request has failed validation due to missing required fields or having invalid inputs.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.</p>
     *         <p>
     *         For <code>Enable</code>, you receive this error if you attempt to use a feature in an unsupported Amazon
     *         Web Services Region.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws InternalServerException
     *         The request has failed due to an internal failure of the Amazon Inspector service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Inspector2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Inspector2Client.ListMembers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/ListMembers" target="_top">AWS API
     *      Documentation</a>
     */
    default ListMembersResponse listMembers(ListMembersRequest listMembersRequest) throws ValidationException,
            AccessDeniedException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException,
            Inspector2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List members associated with the Amazon Inspector delegated administrator for your organization.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListMembersRequest.Builder} avoiding the need to
     * create one manually via {@link ListMembersRequest#builder()}
     * </p>
     *
     * @param listMembersRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.inspector2.model.ListMembersRequest.Builder} to create a request.
     * @return Result of the ListMembers operation returned by the service.
     * @throws ValidationException
     *         The request has failed validation due to missing required fields or having invalid inputs.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.</p>
     *         <p>
     *         For <code>Enable</code>, you receive this error if you attempt to use a feature in an unsupported Amazon
     *         Web Services Region.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws InternalServerException
     *         The request has failed due to an internal failure of the Amazon Inspector service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Inspector2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Inspector2Client.ListMembers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/ListMembers" target="_top">AWS API
     *      Documentation</a>
     */
    default ListMembersResponse listMembers(Consumer<ListMembersRequest.Builder> listMembersRequest) throws ValidationException,
            AccessDeniedException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException,
            Inspector2Exception {
        return listMembers(ListMembersRequest.builder().applyMutation(listMembersRequest).build());
    }

    /**
     * <p>
     * This is a variant of {@link #listMembers(software.amazon.awssdk.services.inspector2.model.ListMembersRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.inspector2.paginators.ListMembersIterable responses = client.listMembersPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.inspector2.paginators.ListMembersIterable responses = client.listMembersPaginator(request);
     *     for (software.amazon.awssdk.services.inspector2.model.ListMembersResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.inspector2.paginators.ListMembersIterable responses = client.listMembersPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listMembers(software.amazon.awssdk.services.inspector2.model.ListMembersRequest)} operation.</b>
     * </p>
     *
     * @param listMembersRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The request has failed validation due to missing required fields or having invalid inputs.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.</p>
     *         <p>
     *         For <code>Enable</code>, you receive this error if you attempt to use a feature in an unsupported Amazon
     *         Web Services Region.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws InternalServerException
     *         The request has failed due to an internal failure of the Amazon Inspector service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Inspector2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Inspector2Client.ListMembers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/ListMembers" target="_top">AWS API
     *      Documentation</a>
     */
    default ListMembersIterable listMembersPaginator(ListMembersRequest listMembersRequest) throws ValidationException,
            AccessDeniedException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException,
            Inspector2Exception {
        return new ListMembersIterable(this, listMembersRequest);
    }

    /**
     * <p>
     * This is a variant of {@link #listMembers(software.amazon.awssdk.services.inspector2.model.ListMembersRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.inspector2.paginators.ListMembersIterable responses = client.listMembersPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.inspector2.paginators.ListMembersIterable responses = client.listMembersPaginator(request);
     *     for (software.amazon.awssdk.services.inspector2.model.ListMembersResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.inspector2.paginators.ListMembersIterable responses = client.listMembersPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listMembers(software.amazon.awssdk.services.inspector2.model.ListMembersRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListMembersRequest.Builder} avoiding the need to
     * create one manually via {@link ListMembersRequest#builder()}
     * </p>
     *
     * @param listMembersRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.inspector2.model.ListMembersRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The request has failed validation due to missing required fields or having invalid inputs.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.</p>
     *         <p>
     *         For <code>Enable</code>, you receive this error if you attempt to use a feature in an unsupported Amazon
     *         Web Services Region.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws InternalServerException
     *         The request has failed due to an internal failure of the Amazon Inspector service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Inspector2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Inspector2Client.ListMembers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/ListMembers" target="_top">AWS API
     *      Documentation</a>
     */
    default ListMembersIterable listMembersPaginator(Consumer<ListMembersRequest.Builder> listMembersRequest)
            throws ValidationException, AccessDeniedException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, Inspector2Exception {
        return listMembersPaginator(ListMembersRequest.builder().applyMutation(listMembersRequest).build());
    }

    /**
     * <p>
     * Lists all tags attached to a given resource.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws ValidationException
     *         The request has failed validation due to missing required fields or having invalid inputs.
     * @throws ResourceNotFoundException
     *         The operation tried to access an invalid resource. Make sure the resource is specified correctly.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws InternalServerException
     *         The request has failed due to an internal failure of the Amazon Inspector service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Inspector2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Inspector2Client.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest)
            throws ValidationException, ResourceNotFoundException, ThrottlingException, InternalServerException,
            AwsServiceException, SdkClientException, Inspector2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all tags attached to a given resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.inspector2.model.ListTagsForResourceRequest.Builder} to create a
     *        request.
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws ValidationException
     *         The request has failed validation due to missing required fields or having invalid inputs.
     * @throws ResourceNotFoundException
     *         The operation tried to access an invalid resource. Make sure the resource is specified correctly.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws InternalServerException
     *         The request has failed due to an internal failure of the Amazon Inspector service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Inspector2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Inspector2Client.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTagsForResourceResponse listTagsForResource(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) throws ValidationException,
            ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException,
            Inspector2Exception {
        return listTagsForResource(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest).build());
    }

    /**
     * <p>
     * Lists the Amazon Inspector usage totals over the last 30 days.
     * </p>
     *
     * @param listUsageTotalsRequest
     * @return Result of the ListUsageTotals operation returned by the service.
     * @throws ValidationException
     *         The request has failed validation due to missing required fields or having invalid inputs.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.</p>
     *         <p>
     *         For <code>Enable</code>, you receive this error if you attempt to use a feature in an unsupported Amazon
     *         Web Services Region.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws InternalServerException
     *         The request has failed due to an internal failure of the Amazon Inspector service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Inspector2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Inspector2Client.ListUsageTotals
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/ListUsageTotals" target="_top">AWS
     *      API Documentation</a>
     */
    default ListUsageTotalsResponse listUsageTotals(ListUsageTotalsRequest listUsageTotalsRequest) throws ValidationException,
            AccessDeniedException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException,
            Inspector2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the Amazon Inspector usage totals over the last 30 days.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListUsageTotalsRequest.Builder} avoiding the need
     * to create one manually via {@link ListUsageTotalsRequest#builder()}
     * </p>
     *
     * @param listUsageTotalsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.inspector2.model.ListUsageTotalsRequest.Builder} to create a
     *        request.
     * @return Result of the ListUsageTotals operation returned by the service.
     * @throws ValidationException
     *         The request has failed validation due to missing required fields or having invalid inputs.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.</p>
     *         <p>
     *         For <code>Enable</code>, you receive this error if you attempt to use a feature in an unsupported Amazon
     *         Web Services Region.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws InternalServerException
     *         The request has failed due to an internal failure of the Amazon Inspector service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Inspector2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Inspector2Client.ListUsageTotals
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/ListUsageTotals" target="_top">AWS
     *      API Documentation</a>
     */
    default ListUsageTotalsResponse listUsageTotals(Consumer<ListUsageTotalsRequest.Builder> listUsageTotalsRequest)
            throws ValidationException, AccessDeniedException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, Inspector2Exception {
        return listUsageTotals(ListUsageTotalsRequest.builder().applyMutation(listUsageTotalsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listUsageTotals(software.amazon.awssdk.services.inspector2.model.ListUsageTotalsRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.inspector2.paginators.ListUsageTotalsIterable responses = client.listUsageTotalsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.inspector2.paginators.ListUsageTotalsIterable responses = client
     *             .listUsageTotalsPaginator(request);
     *     for (software.amazon.awssdk.services.inspector2.model.ListUsageTotalsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.inspector2.paginators.ListUsageTotalsIterable responses = client.listUsageTotalsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listUsageTotals(software.amazon.awssdk.services.inspector2.model.ListUsageTotalsRequest)} operation.</b>
     * </p>
     *
     * @param listUsageTotalsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The request has failed validation due to missing required fields or having invalid inputs.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.</p>
     *         <p>
     *         For <code>Enable</code>, you receive this error if you attempt to use a feature in an unsupported Amazon
     *         Web Services Region.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws InternalServerException
     *         The request has failed due to an internal failure of the Amazon Inspector service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Inspector2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Inspector2Client.ListUsageTotals
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/ListUsageTotals" target="_top">AWS
     *      API Documentation</a>
     */
    default ListUsageTotalsIterable listUsageTotalsPaginator(ListUsageTotalsRequest listUsageTotalsRequest)
            throws ValidationException, AccessDeniedException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, Inspector2Exception {
        return new ListUsageTotalsIterable(this, listUsageTotalsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listUsageTotals(software.amazon.awssdk.services.inspector2.model.ListUsageTotalsRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.inspector2.paginators.ListUsageTotalsIterable responses = client.listUsageTotalsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.inspector2.paginators.ListUsageTotalsIterable responses = client
     *             .listUsageTotalsPaginator(request);
     *     for (software.amazon.awssdk.services.inspector2.model.ListUsageTotalsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.inspector2.paginators.ListUsageTotalsIterable responses = client.listUsageTotalsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listUsageTotals(software.amazon.awssdk.services.inspector2.model.ListUsageTotalsRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListUsageTotalsRequest.Builder} avoiding the need
     * to create one manually via {@link ListUsageTotalsRequest#builder()}
     * </p>
     *
     * @param listUsageTotalsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.inspector2.model.ListUsageTotalsRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The request has failed validation due to missing required fields or having invalid inputs.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.</p>
     *         <p>
     *         For <code>Enable</code>, you receive this error if you attempt to use a feature in an unsupported Amazon
     *         Web Services Region.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws InternalServerException
     *         The request has failed due to an internal failure of the Amazon Inspector service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Inspector2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Inspector2Client.ListUsageTotals
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/ListUsageTotals" target="_top">AWS
     *      API Documentation</a>
     */
    default ListUsageTotalsIterable listUsageTotalsPaginator(Consumer<ListUsageTotalsRequest.Builder> listUsageTotalsRequest)
            throws ValidationException, AccessDeniedException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, Inspector2Exception {
        return listUsageTotalsPaginator(ListUsageTotalsRequest.builder().applyMutation(listUsageTotalsRequest).build());
    }

    /**
     * <p>
     * Resets an encryption key. After the key is reset your resources will be encrypted by an Amazon Web Services owned
     * key.
     * </p>
     *
     * @param resetEncryptionKeyRequest
     * @return Result of the ResetEncryptionKey operation returned by the service.
     * @throws ValidationException
     *         The request has failed validation due to missing required fields or having invalid inputs.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.</p>
     *         <p>
     *         For <code>Enable</code>, you receive this error if you attempt to use a feature in an unsupported Amazon
     *         Web Services Region.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws ResourceNotFoundException
     *         The operation tried to access an invalid resource. Make sure the resource is specified correctly.
     * @throws InternalServerException
     *         The request has failed due to an internal failure of the Amazon Inspector service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Inspector2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Inspector2Client.ResetEncryptionKey
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/ResetEncryptionKey" target="_top">AWS
     *      API Documentation</a>
     */
    default ResetEncryptionKeyResponse resetEncryptionKey(ResetEncryptionKeyRequest resetEncryptionKeyRequest)
            throws ValidationException, AccessDeniedException, ThrottlingException, ResourceNotFoundException,
            InternalServerException, AwsServiceException, SdkClientException, Inspector2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Resets an encryption key. After the key is reset your resources will be encrypted by an Amazon Web Services owned
     * key.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ResetEncryptionKeyRequest.Builder} avoiding the
     * need to create one manually via {@link ResetEncryptionKeyRequest#builder()}
     * </p>
     *
     * @param resetEncryptionKeyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.inspector2.model.ResetEncryptionKeyRequest.Builder} to create a
     *        request.
     * @return Result of the ResetEncryptionKey operation returned by the service.
     * @throws ValidationException
     *         The request has failed validation due to missing required fields or having invalid inputs.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.</p>
     *         <p>
     *         For <code>Enable</code>, you receive this error if you attempt to use a feature in an unsupported Amazon
     *         Web Services Region.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws ResourceNotFoundException
     *         The operation tried to access an invalid resource. Make sure the resource is specified correctly.
     * @throws InternalServerException
     *         The request has failed due to an internal failure of the Amazon Inspector service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Inspector2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Inspector2Client.ResetEncryptionKey
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/ResetEncryptionKey" target="_top">AWS
     *      API Documentation</a>
     */
    default ResetEncryptionKeyResponse resetEncryptionKey(Consumer<ResetEncryptionKeyRequest.Builder> resetEncryptionKeyRequest)
            throws ValidationException, AccessDeniedException, ThrottlingException, ResourceNotFoundException,
            InternalServerException, AwsServiceException, SdkClientException, Inspector2Exception {
        return resetEncryptionKey(ResetEncryptionKeyRequest.builder().applyMutation(resetEncryptionKeyRequest).build());
    }

    /**
     * <p>
     * Lists Amazon Inspector coverage details for a specific vulnerability.
     * </p>
     *
     * @param searchVulnerabilitiesRequest
     * @return Result of the SearchVulnerabilities operation returned by the service.
     * @throws ValidationException
     *         The request has failed validation due to missing required fields or having invalid inputs.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.</p>
     *         <p>
     *         For <code>Enable</code>, you receive this error if you attempt to use a feature in an unsupported Amazon
     *         Web Services Region.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws InternalServerException
     *         The request has failed due to an internal failure of the Amazon Inspector service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Inspector2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Inspector2Client.SearchVulnerabilities
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/SearchVulnerabilities"
     *      target="_top">AWS API Documentation</a>
     */
    default SearchVulnerabilitiesResponse searchVulnerabilities(SearchVulnerabilitiesRequest searchVulnerabilitiesRequest)
            throws ValidationException, AccessDeniedException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, Inspector2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists Amazon Inspector coverage details for a specific vulnerability.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link SearchVulnerabilitiesRequest.Builder} avoiding the
     * need to create one manually via {@link SearchVulnerabilitiesRequest#builder()}
     * </p>
     *
     * @param searchVulnerabilitiesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.inspector2.model.SearchVulnerabilitiesRequest.Builder} to create a
     *        request.
     * @return Result of the SearchVulnerabilities operation returned by the service.
     * @throws ValidationException
     *         The request has failed validation due to missing required fields or having invalid inputs.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.</p>
     *         <p>
     *         For <code>Enable</code>, you receive this error if you attempt to use a feature in an unsupported Amazon
     *         Web Services Region.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws InternalServerException
     *         The request has failed due to an internal failure of the Amazon Inspector service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Inspector2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Inspector2Client.SearchVulnerabilities
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/SearchVulnerabilities"
     *      target="_top">AWS API Documentation</a>
     */
    default SearchVulnerabilitiesResponse searchVulnerabilities(
            Consumer<SearchVulnerabilitiesRequest.Builder> searchVulnerabilitiesRequest) throws ValidationException,
            AccessDeniedException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException,
            Inspector2Exception {
        return searchVulnerabilities(SearchVulnerabilitiesRequest.builder().applyMutation(searchVulnerabilitiesRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #searchVulnerabilities(software.amazon.awssdk.services.inspector2.model.SearchVulnerabilitiesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.inspector2.paginators.SearchVulnerabilitiesIterable responses = client.searchVulnerabilitiesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.inspector2.paginators.SearchVulnerabilitiesIterable responses = client
     *             .searchVulnerabilitiesPaginator(request);
     *     for (software.amazon.awssdk.services.inspector2.model.SearchVulnerabilitiesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.inspector2.paginators.SearchVulnerabilitiesIterable responses = client.searchVulnerabilitiesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #searchVulnerabilities(software.amazon.awssdk.services.inspector2.model.SearchVulnerabilitiesRequest)}
     * operation.</b>
     * </p>
     *
     * @param searchVulnerabilitiesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The request has failed validation due to missing required fields or having invalid inputs.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.</p>
     *         <p>
     *         For <code>Enable</code>, you receive this error if you attempt to use a feature in an unsupported Amazon
     *         Web Services Region.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws InternalServerException
     *         The request has failed due to an internal failure of the Amazon Inspector service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Inspector2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Inspector2Client.SearchVulnerabilities
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/SearchVulnerabilities"
     *      target="_top">AWS API Documentation</a>
     */
    default SearchVulnerabilitiesIterable searchVulnerabilitiesPaginator(SearchVulnerabilitiesRequest searchVulnerabilitiesRequest)
            throws ValidationException, AccessDeniedException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, Inspector2Exception {
        return new SearchVulnerabilitiesIterable(this, searchVulnerabilitiesRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #searchVulnerabilities(software.amazon.awssdk.services.inspector2.model.SearchVulnerabilitiesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.inspector2.paginators.SearchVulnerabilitiesIterable responses = client.searchVulnerabilitiesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.inspector2.paginators.SearchVulnerabilitiesIterable responses = client
     *             .searchVulnerabilitiesPaginator(request);
     *     for (software.amazon.awssdk.services.inspector2.model.SearchVulnerabilitiesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.inspector2.paginators.SearchVulnerabilitiesIterable responses = client.searchVulnerabilitiesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #searchVulnerabilities(software.amazon.awssdk.services.inspector2.model.SearchVulnerabilitiesRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link SearchVulnerabilitiesRequest.Builder} avoiding the
     * need to create one manually via {@link SearchVulnerabilitiesRequest#builder()}
     * </p>
     *
     * @param searchVulnerabilitiesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.inspector2.model.SearchVulnerabilitiesRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The request has failed validation due to missing required fields or having invalid inputs.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.</p>
     *         <p>
     *         For <code>Enable</code>, you receive this error if you attempt to use a feature in an unsupported Amazon
     *         Web Services Region.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws InternalServerException
     *         The request has failed due to an internal failure of the Amazon Inspector service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Inspector2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Inspector2Client.SearchVulnerabilities
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/SearchVulnerabilities"
     *      target="_top">AWS API Documentation</a>
     */
    default SearchVulnerabilitiesIterable searchVulnerabilitiesPaginator(
            Consumer<SearchVulnerabilitiesRequest.Builder> searchVulnerabilitiesRequest) throws ValidationException,
            AccessDeniedException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException,
            Inspector2Exception {
        return searchVulnerabilitiesPaginator(SearchVulnerabilitiesRequest.builder().applyMutation(searchVulnerabilitiesRequest)
                .build());
    }

    /**
     * <p>
     * Sends a CIS session health. This API is used by the Amazon Inspector SSM plugin to communicate with the Amazon
     * Inspector service. The Amazon Inspector SSM plugin calls this API to start a CIS scan session for the scan ID
     * supplied by the service.
     * </p>
     *
     * @param sendCisSessionHealthRequest
     * @return Result of the SendCisSessionHealth operation returned by the service.
     * @throws ConflictException
     *         A conflict occurred. This exception occurs when the same resource is being modified by concurrent
     *         requests.
     * @throws ValidationException
     *         The request has failed validation due to missing required fields or having invalid inputs.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.</p>
     *         <p>
     *         For <code>Enable</code>, you receive this error if you attempt to use a feature in an unsupported Amazon
     *         Web Services Region.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws InternalServerException
     *         The request has failed due to an internal failure of the Amazon Inspector service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Inspector2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Inspector2Client.SendCisSessionHealth
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/SendCisSessionHealth"
     *      target="_top">AWS API Documentation</a>
     */
    default SendCisSessionHealthResponse sendCisSessionHealth(SendCisSessionHealthRequest sendCisSessionHealthRequest)
            throws ConflictException, ValidationException, AccessDeniedException, ThrottlingException, InternalServerException,
            AwsServiceException, SdkClientException, Inspector2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Sends a CIS session health. This API is used by the Amazon Inspector SSM plugin to communicate with the Amazon
     * Inspector service. The Amazon Inspector SSM plugin calls this API to start a CIS scan session for the scan ID
     * supplied by the service.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link SendCisSessionHealthRequest.Builder} avoiding the
     * need to create one manually via {@link SendCisSessionHealthRequest#builder()}
     * </p>
     *
     * @param sendCisSessionHealthRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.inspector2.model.SendCisSessionHealthRequest.Builder} to create a
     *        request.
     * @return Result of the SendCisSessionHealth operation returned by the service.
     * @throws ConflictException
     *         A conflict occurred. This exception occurs when the same resource is being modified by concurrent
     *         requests.
     * @throws ValidationException
     *         The request has failed validation due to missing required fields or having invalid inputs.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.</p>
     *         <p>
     *         For <code>Enable</code>, you receive this error if you attempt to use a feature in an unsupported Amazon
     *         Web Services Region.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws InternalServerException
     *         The request has failed due to an internal failure of the Amazon Inspector service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Inspector2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Inspector2Client.SendCisSessionHealth
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/SendCisSessionHealth"
     *      target="_top">AWS API Documentation</a>
     */
    default SendCisSessionHealthResponse sendCisSessionHealth(
            Consumer<SendCisSessionHealthRequest.Builder> sendCisSessionHealthRequest) throws ConflictException,
            ValidationException, AccessDeniedException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, Inspector2Exception {
        return sendCisSessionHealth(SendCisSessionHealthRequest.builder().applyMutation(sendCisSessionHealthRequest).build());
    }

    /**
     * <p>
     * Sends a CIS session telemetry. This API is used by the Amazon Inspector SSM plugin to communicate with the Amazon
     * Inspector service. The Amazon Inspector SSM plugin calls this API to start a CIS scan session for the scan ID
     * supplied by the service.
     * </p>
     *
     * @param sendCisSessionTelemetryRequest
     * @return Result of the SendCisSessionTelemetry operation returned by the service.
     * @throws ConflictException
     *         A conflict occurred. This exception occurs when the same resource is being modified by concurrent
     *         requests.
     * @throws ValidationException
     *         The request has failed validation due to missing required fields or having invalid inputs.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.</p>
     *         <p>
     *         For <code>Enable</code>, you receive this error if you attempt to use a feature in an unsupported Amazon
     *         Web Services Region.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws InternalServerException
     *         The request has failed due to an internal failure of the Amazon Inspector service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Inspector2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Inspector2Client.SendCisSessionTelemetry
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/SendCisSessionTelemetry"
     *      target="_top">AWS API Documentation</a>
     */
    default SendCisSessionTelemetryResponse sendCisSessionTelemetry(SendCisSessionTelemetryRequest sendCisSessionTelemetryRequest)
            throws ConflictException, ValidationException, AccessDeniedException, ThrottlingException, InternalServerException,
            AwsServiceException, SdkClientException, Inspector2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Sends a CIS session telemetry. This API is used by the Amazon Inspector SSM plugin to communicate with the Amazon
     * Inspector service. The Amazon Inspector SSM plugin calls this API to start a CIS scan session for the scan ID
     * supplied by the service.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link SendCisSessionTelemetryRequest.Builder} avoiding
     * the need to create one manually via {@link SendCisSessionTelemetryRequest#builder()}
     * </p>
     *
     * @param sendCisSessionTelemetryRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.inspector2.model.SendCisSessionTelemetryRequest.Builder} to create
     *        a request.
     * @return Result of the SendCisSessionTelemetry operation returned by the service.
     * @throws ConflictException
     *         A conflict occurred. This exception occurs when the same resource is being modified by concurrent
     *         requests.
     * @throws ValidationException
     *         The request has failed validation due to missing required fields or having invalid inputs.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.</p>
     *         <p>
     *         For <code>Enable</code>, you receive this error if you attempt to use a feature in an unsupported Amazon
     *         Web Services Region.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws InternalServerException
     *         The request has failed due to an internal failure of the Amazon Inspector service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Inspector2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Inspector2Client.SendCisSessionTelemetry
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/SendCisSessionTelemetry"
     *      target="_top">AWS API Documentation</a>
     */
    default SendCisSessionTelemetryResponse sendCisSessionTelemetry(
            Consumer<SendCisSessionTelemetryRequest.Builder> sendCisSessionTelemetryRequest) throws ConflictException,
            ValidationException, AccessDeniedException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, Inspector2Exception {
        return sendCisSessionTelemetry(SendCisSessionTelemetryRequest.builder().applyMutation(sendCisSessionTelemetryRequest)
                .build());
    }

    /**
     * <p>
     * Starts a CIS session. This API is used by the Amazon Inspector SSM plugin to communicate with the Amazon
     * Inspector service. The Amazon Inspector SSM plugin calls this API to start a CIS scan session for the scan ID
     * supplied by the service.
     * </p>
     *
     * @param startCisSessionRequest
     * @return Result of the StartCisSession operation returned by the service.
     * @throws ConflictException
     *         A conflict occurred. This exception occurs when the same resource is being modified by concurrent
     *         requests.
     * @throws ValidationException
     *         The request has failed validation due to missing required fields or having invalid inputs.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.</p>
     *         <p>
     *         For <code>Enable</code>, you receive this error if you attempt to use a feature in an unsupported Amazon
     *         Web Services Region.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws InternalServerException
     *         The request has failed due to an internal failure of the Amazon Inspector service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Inspector2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Inspector2Client.StartCisSession
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/StartCisSession" target="_top">AWS
     *      API Documentation</a>
     */
    default StartCisSessionResponse startCisSession(StartCisSessionRequest startCisSessionRequest) throws ConflictException,
            ValidationException, AccessDeniedException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, Inspector2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Starts a CIS session. This API is used by the Amazon Inspector SSM plugin to communicate with the Amazon
     * Inspector service. The Amazon Inspector SSM plugin calls this API to start a CIS scan session for the scan ID
     * supplied by the service.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartCisSessionRequest.Builder} avoiding the need
     * to create one manually via {@link StartCisSessionRequest#builder()}
     * </p>
     *
     * @param startCisSessionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.inspector2.model.StartCisSessionRequest.Builder} to create a
     *        request.
     * @return Result of the StartCisSession operation returned by the service.
     * @throws ConflictException
     *         A conflict occurred. This exception occurs when the same resource is being modified by concurrent
     *         requests.
     * @throws ValidationException
     *         The request has failed validation due to missing required fields or having invalid inputs.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.</p>
     *         <p>
     *         For <code>Enable</code>, you receive this error if you attempt to use a feature in an unsupported Amazon
     *         Web Services Region.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws InternalServerException
     *         The request has failed due to an internal failure of the Amazon Inspector service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Inspector2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Inspector2Client.StartCisSession
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/StartCisSession" target="_top">AWS
     *      API Documentation</a>
     */
    default StartCisSessionResponse startCisSession(Consumer<StartCisSessionRequest.Builder> startCisSessionRequest)
            throws ConflictException, ValidationException, AccessDeniedException, ThrottlingException, InternalServerException,
            AwsServiceException, SdkClientException, Inspector2Exception {
        return startCisSession(StartCisSessionRequest.builder().applyMutation(startCisSessionRequest).build());
    }

    /**
     * <p>
     * Initiates a code security scan on a specified repository.
     * </p>
     *
     * @param startCodeSecurityScanRequest
     * @return Result of the StartCodeSecurityScan operation returned by the service.
     * @throws ConflictException
     *         A conflict occurred. This exception occurs when the same resource is being modified by concurrent
     *         requests.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.</p>
     *         <p>
     *         For <code>Enable</code>, you receive this error if you attempt to use a feature in an unsupported Amazon
     *         Web Services Region.
     * @throws ValidationException
     *         The request has failed validation due to missing required fields or having invalid inputs.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws ResourceNotFoundException
     *         The operation tried to access an invalid resource. Make sure the resource is specified correctly.
     * @throws InternalServerException
     *         The request has failed due to an internal failure of the Amazon Inspector service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Inspector2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Inspector2Client.StartCodeSecurityScan
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/StartCodeSecurityScan"
     *      target="_top">AWS API Documentation</a>
     */
    default StartCodeSecurityScanResponse startCodeSecurityScan(StartCodeSecurityScanRequest startCodeSecurityScanRequest)
            throws ConflictException, AccessDeniedException, ValidationException, ThrottlingException, ResourceNotFoundException,
            InternalServerException, AwsServiceException, SdkClientException, Inspector2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Initiates a code security scan on a specified repository.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartCodeSecurityScanRequest.Builder} avoiding the
     * need to create one manually via {@link StartCodeSecurityScanRequest#builder()}
     * </p>
     *
     * @param startCodeSecurityScanRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.inspector2.model.StartCodeSecurityScanRequest.Builder} to create a
     *        request.
     * @return Result of the StartCodeSecurityScan operation returned by the service.
     * @throws ConflictException
     *         A conflict occurred. This exception occurs when the same resource is being modified by concurrent
     *         requests.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.</p>
     *         <p>
     *         For <code>Enable</code>, you receive this error if you attempt to use a feature in an unsupported Amazon
     *         Web Services Region.
     * @throws ValidationException
     *         The request has failed validation due to missing required fields or having invalid inputs.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws ResourceNotFoundException
     *         The operation tried to access an invalid resource. Make sure the resource is specified correctly.
     * @throws InternalServerException
     *         The request has failed due to an internal failure of the Amazon Inspector service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Inspector2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Inspector2Client.StartCodeSecurityScan
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/StartCodeSecurityScan"
     *      target="_top">AWS API Documentation</a>
     */
    default StartCodeSecurityScanResponse startCodeSecurityScan(
            Consumer<StartCodeSecurityScanRequest.Builder> startCodeSecurityScanRequest) throws ConflictException,
            AccessDeniedException, ValidationException, ThrottlingException, ResourceNotFoundException, InternalServerException,
            AwsServiceException, SdkClientException, Inspector2Exception {
        return startCodeSecurityScan(StartCodeSecurityScanRequest.builder().applyMutation(startCodeSecurityScanRequest).build());
    }

    /**
     * <p>
     * Stops a CIS session. This API is used by the Amazon Inspector SSM plugin to communicate with the Amazon Inspector
     * service. The Amazon Inspector SSM plugin calls this API to stop a CIS scan session for the scan ID supplied by
     * the service.
     * </p>
     *
     * @param stopCisSessionRequest
     * @return Result of the StopCisSession operation returned by the service.
     * @throws ConflictException
     *         A conflict occurred. This exception occurs when the same resource is being modified by concurrent
     *         requests.
     * @throws ValidationException
     *         The request has failed validation due to missing required fields or having invalid inputs.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.</p>
     *         <p>
     *         For <code>Enable</code>, you receive this error if you attempt to use a feature in an unsupported Amazon
     *         Web Services Region.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws InternalServerException
     *         The request has failed due to an internal failure of the Amazon Inspector service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Inspector2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Inspector2Client.StopCisSession
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/StopCisSession" target="_top">AWS API
     *      Documentation</a>
     */
    default StopCisSessionResponse stopCisSession(StopCisSessionRequest stopCisSessionRequest) throws ConflictException,
            ValidationException, AccessDeniedException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, Inspector2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Stops a CIS session. This API is used by the Amazon Inspector SSM plugin to communicate with the Amazon Inspector
     * service. The Amazon Inspector SSM plugin calls this API to stop a CIS scan session for the scan ID supplied by
     * the service.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StopCisSessionRequest.Builder} avoiding the need to
     * create one manually via {@link StopCisSessionRequest#builder()}
     * </p>
     *
     * @param stopCisSessionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.inspector2.model.StopCisSessionRequest.Builder} to create a
     *        request.
     * @return Result of the StopCisSession operation returned by the service.
     * @throws ConflictException
     *         A conflict occurred. This exception occurs when the same resource is being modified by concurrent
     *         requests.
     * @throws ValidationException
     *         The request has failed validation due to missing required fields or having invalid inputs.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.</p>
     *         <p>
     *         For <code>Enable</code>, you receive this error if you attempt to use a feature in an unsupported Amazon
     *         Web Services Region.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws InternalServerException
     *         The request has failed due to an internal failure of the Amazon Inspector service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Inspector2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Inspector2Client.StopCisSession
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/StopCisSession" target="_top">AWS API
     *      Documentation</a>
     */
    default StopCisSessionResponse stopCisSession(Consumer<StopCisSessionRequest.Builder> stopCisSessionRequest)
            throws ConflictException, ValidationException, AccessDeniedException, ThrottlingException, InternalServerException,
            AwsServiceException, SdkClientException, Inspector2Exception {
        return stopCisSession(StopCisSessionRequest.builder().applyMutation(stopCisSessionRequest).build());
    }

    /**
     * <p>
     * Adds tags to a resource.
     * </p>
     *
     * @param tagResourceRequest
     * @return Result of the TagResource operation returned by the service.
     * @throws BadRequestException
     *         One or more tags submitted as part of the request is not valid.
     * @throws ValidationException
     *         The request has failed validation due to missing required fields or having invalid inputs.
     * @throws ResourceNotFoundException
     *         The operation tried to access an invalid resource. Make sure the resource is specified correctly.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws InternalServerException
     *         The request has failed due to an internal failure of the Amazon Inspector service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Inspector2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Inspector2Client.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws BadRequestException,
            ValidationException, ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, Inspector2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds tags to a resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link TagResourceRequest#builder()}
     * </p>
     *
     * @param tagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.inspector2.model.TagResourceRequest.Builder} to create a request.
     * @return Result of the TagResource operation returned by the service.
     * @throws BadRequestException
     *         One or more tags submitted as part of the request is not valid.
     * @throws ValidationException
     *         The request has failed validation due to missing required fields or having invalid inputs.
     * @throws ResourceNotFoundException
     *         The operation tried to access an invalid resource. Make sure the resource is specified correctly.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws InternalServerException
     *         The request has failed due to an internal failure of the Amazon Inspector service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Inspector2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Inspector2Client.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default TagResourceResponse tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest) throws BadRequestException,
            ValidationException, ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, Inspector2Exception {
        return tagResource(TagResourceRequest.builder().applyMutation(tagResourceRequest).build());
    }

    /**
     * <p>
     * Removes tags from a resource.
     * </p>
     *
     * @param untagResourceRequest
     * @return Result of the UntagResource operation returned by the service.
     * @throws ValidationException
     *         The request has failed validation due to missing required fields or having invalid inputs.
     * @throws ResourceNotFoundException
     *         The operation tried to access an invalid resource. Make sure the resource is specified correctly.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws InternalServerException
     *         The request has failed due to an internal failure of the Amazon Inspector service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Inspector2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Inspector2Client.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws ValidationException,
            ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException,
            Inspector2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes tags from a resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UntagResourceRequest#builder()}
     * </p>
     *
     * @param untagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.inspector2.model.UntagResourceRequest.Builder} to create a request.
     * @return Result of the UntagResource operation returned by the service.
     * @throws ValidationException
     *         The request has failed validation due to missing required fields or having invalid inputs.
     * @throws ResourceNotFoundException
     *         The operation tried to access an invalid resource. Make sure the resource is specified correctly.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws InternalServerException
     *         The request has failed due to an internal failure of the Amazon Inspector service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Inspector2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Inspector2Client.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default UntagResourceResponse untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest)
            throws ValidationException, ResourceNotFoundException, ThrottlingException, InternalServerException,
            AwsServiceException, SdkClientException, Inspector2Exception {
        return untagResource(UntagResourceRequest.builder().applyMutation(untagResourceRequest).build());
    }

    /**
     * <p>
     * Updates a CIS scan configuration.
     * </p>
     *
     * @param updateCisScanConfigurationRequest
     * @return Result of the UpdateCisScanConfiguration operation returned by the service.
     * @throws ValidationException
     *         The request has failed validation due to missing required fields or having invalid inputs.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.</p>
     *         <p>
     *         For <code>Enable</code>, you receive this error if you attempt to use a feature in an unsupported Amazon
     *         Web Services Region.
     * @throws ResourceNotFoundException
     *         The operation tried to access an invalid resource. Make sure the resource is specified correctly.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws InternalServerException
     *         The request has failed due to an internal failure of the Amazon Inspector service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Inspector2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Inspector2Client.UpdateCisScanConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/UpdateCisScanConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateCisScanConfigurationResponse updateCisScanConfiguration(
            UpdateCisScanConfigurationRequest updateCisScanConfigurationRequest) throws ValidationException,
            AccessDeniedException, ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, Inspector2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates a CIS scan configuration.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateCisScanConfigurationRequest.Builder} avoiding
     * the need to create one manually via {@link UpdateCisScanConfigurationRequest#builder()}
     * </p>
     *
     * @param updateCisScanConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.inspector2.model.UpdateCisScanConfigurationRequest.Builder} to
     *        create a request.
     * @return Result of the UpdateCisScanConfiguration operation returned by the service.
     * @throws ValidationException
     *         The request has failed validation due to missing required fields or having invalid inputs.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.</p>
     *         <p>
     *         For <code>Enable</code>, you receive this error if you attempt to use a feature in an unsupported Amazon
     *         Web Services Region.
     * @throws ResourceNotFoundException
     *         The operation tried to access an invalid resource. Make sure the resource is specified correctly.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws InternalServerException
     *         The request has failed due to an internal failure of the Amazon Inspector service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Inspector2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Inspector2Client.UpdateCisScanConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/UpdateCisScanConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateCisScanConfigurationResponse updateCisScanConfiguration(
            Consumer<UpdateCisScanConfigurationRequest.Builder> updateCisScanConfigurationRequest) throws ValidationException,
            AccessDeniedException, ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, Inspector2Exception {
        return updateCisScanConfiguration(UpdateCisScanConfigurationRequest.builder()
                .applyMutation(updateCisScanConfigurationRequest).build());
    }

    /**
     * <p>
     * Updates an existing code security integration.
     * </p>
     * <p>
     * After calling the <code>CreateCodeSecurityIntegration</code> operation, you complete authentication and
     * authorization with your provider. Next you call the <code>UpdateCodeSecurityIntegration</code> operation to
     * provide the <code>details</code> to complete the integration setup
     * </p>
     *
     * @param updateCodeSecurityIntegrationRequest
     * @return Result of the UpdateCodeSecurityIntegration operation returned by the service.
     * @throws ConflictException
     *         A conflict occurred. This exception occurs when the same resource is being modified by concurrent
     *         requests.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.</p>
     *         <p>
     *         For <code>Enable</code>, you receive this error if you attempt to use a feature in an unsupported Amazon
     *         Web Services Region.
     * @throws ValidationException
     *         The request has failed validation due to missing required fields or having invalid inputs.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws ResourceNotFoundException
     *         The operation tried to access an invalid resource. Make sure the resource is specified correctly.
     * @throws InternalServerException
     *         The request has failed due to an internal failure of the Amazon Inspector service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Inspector2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Inspector2Client.UpdateCodeSecurityIntegration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/UpdateCodeSecurityIntegration"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateCodeSecurityIntegrationResponse updateCodeSecurityIntegration(
            UpdateCodeSecurityIntegrationRequest updateCodeSecurityIntegrationRequest) throws ConflictException,
            AccessDeniedException, ValidationException, ThrottlingException, ResourceNotFoundException, InternalServerException,
            AwsServiceException, SdkClientException, Inspector2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates an existing code security integration.
     * </p>
     * <p>
     * After calling the <code>CreateCodeSecurityIntegration</code> operation, you complete authentication and
     * authorization with your provider. Next you call the <code>UpdateCodeSecurityIntegration</code> operation to
     * provide the <code>details</code> to complete the integration setup
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateCodeSecurityIntegrationRequest.Builder}
     * avoiding the need to create one manually via {@link UpdateCodeSecurityIntegrationRequest#builder()}
     * </p>
     *
     * @param updateCodeSecurityIntegrationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.inspector2.model.UpdateCodeSecurityIntegrationRequest.Builder} to
     *        create a request.
     * @return Result of the UpdateCodeSecurityIntegration operation returned by the service.
     * @throws ConflictException
     *         A conflict occurred. This exception occurs when the same resource is being modified by concurrent
     *         requests.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.</p>
     *         <p>
     *         For <code>Enable</code>, you receive this error if you attempt to use a feature in an unsupported Amazon
     *         Web Services Region.
     * @throws ValidationException
     *         The request has failed validation due to missing required fields or having invalid inputs.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws ResourceNotFoundException
     *         The operation tried to access an invalid resource. Make sure the resource is specified correctly.
     * @throws InternalServerException
     *         The request has failed due to an internal failure of the Amazon Inspector service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Inspector2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Inspector2Client.UpdateCodeSecurityIntegration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/UpdateCodeSecurityIntegration"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateCodeSecurityIntegrationResponse updateCodeSecurityIntegration(
            Consumer<UpdateCodeSecurityIntegrationRequest.Builder> updateCodeSecurityIntegrationRequest)
            throws ConflictException, AccessDeniedException, ValidationException, ThrottlingException, ResourceNotFoundException,
            InternalServerException, AwsServiceException, SdkClientException, Inspector2Exception {
        return updateCodeSecurityIntegration(UpdateCodeSecurityIntegrationRequest.builder()
                .applyMutation(updateCodeSecurityIntegrationRequest).build());
    }

    /**
     * <p>
     * Updates an existing code security scan configuration.
     * </p>
     *
     * @param updateCodeSecurityScanConfigurationRequest
     * @return Result of the UpdateCodeSecurityScanConfiguration operation returned by the service.
     * @throws ConflictException
     *         A conflict occurred. This exception occurs when the same resource is being modified by concurrent
     *         requests.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.</p>
     *         <p>
     *         For <code>Enable</code>, you receive this error if you attempt to use a feature in an unsupported Amazon
     *         Web Services Region.
     * @throws ValidationException
     *         The request has failed validation due to missing required fields or having invalid inputs.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws ResourceNotFoundException
     *         The operation tried to access an invalid resource. Make sure the resource is specified correctly.
     * @throws InternalServerException
     *         The request has failed due to an internal failure of the Amazon Inspector service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Inspector2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Inspector2Client.UpdateCodeSecurityScanConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/UpdateCodeSecurityScanConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateCodeSecurityScanConfigurationResponse updateCodeSecurityScanConfiguration(
            UpdateCodeSecurityScanConfigurationRequest updateCodeSecurityScanConfigurationRequest) throws ConflictException,
            AccessDeniedException, ValidationException, ThrottlingException, ResourceNotFoundException, InternalServerException,
            AwsServiceException, SdkClientException, Inspector2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates an existing code security scan configuration.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateCodeSecurityScanConfigurationRequest.Builder}
     * avoiding the need to create one manually via {@link UpdateCodeSecurityScanConfigurationRequest#builder()}
     * </p>
     *
     * @param updateCodeSecurityScanConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.inspector2.model.UpdateCodeSecurityScanConfigurationRequest.Builder}
     *        to create a request.
     * @return Result of the UpdateCodeSecurityScanConfiguration operation returned by the service.
     * @throws ConflictException
     *         A conflict occurred. This exception occurs when the same resource is being modified by concurrent
     *         requests.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.</p>
     *         <p>
     *         For <code>Enable</code>, you receive this error if you attempt to use a feature in an unsupported Amazon
     *         Web Services Region.
     * @throws ValidationException
     *         The request has failed validation due to missing required fields or having invalid inputs.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws ResourceNotFoundException
     *         The operation tried to access an invalid resource. Make sure the resource is specified correctly.
     * @throws InternalServerException
     *         The request has failed due to an internal failure of the Amazon Inspector service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Inspector2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Inspector2Client.UpdateCodeSecurityScanConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/UpdateCodeSecurityScanConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateCodeSecurityScanConfigurationResponse updateCodeSecurityScanConfiguration(
            Consumer<UpdateCodeSecurityScanConfigurationRequest.Builder> updateCodeSecurityScanConfigurationRequest)
            throws ConflictException, AccessDeniedException, ValidationException, ThrottlingException, ResourceNotFoundException,
            InternalServerException, AwsServiceException, SdkClientException, Inspector2Exception {
        return updateCodeSecurityScanConfiguration(UpdateCodeSecurityScanConfigurationRequest.builder()
                .applyMutation(updateCodeSecurityScanConfigurationRequest).build());
    }

    /**
     * <p>
     * Updates setting configurations for your Amazon Inspector account. When you use this API as an Amazon Inspector
     * delegated administrator this updates the setting for all accounts you manage. Member accounts in an organization
     * cannot update this setting.
     * </p>
     *
     * @param updateConfigurationRequest
     * @return Result of the UpdateConfiguration operation returned by the service.
     * @throws ValidationException
     *         The request has failed validation due to missing required fields or having invalid inputs.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.</p>
     *         <p>
     *         For <code>Enable</code>, you receive this error if you attempt to use a feature in an unsupported Amazon
     *         Web Services Region.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws InternalServerException
     *         The request has failed due to an internal failure of the Amazon Inspector service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Inspector2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Inspector2Client.UpdateConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/UpdateConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateConfigurationResponse updateConfiguration(UpdateConfigurationRequest updateConfigurationRequest)
            throws ValidationException, AccessDeniedException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, Inspector2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates setting configurations for your Amazon Inspector account. When you use this API as an Amazon Inspector
     * delegated administrator this updates the setting for all accounts you manage. Member accounts in an organization
     * cannot update this setting.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateConfigurationRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateConfigurationRequest#builder()}
     * </p>
     *
     * @param updateConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.inspector2.model.UpdateConfigurationRequest.Builder} to create a
     *        request.
     * @return Result of the UpdateConfiguration operation returned by the service.
     * @throws ValidationException
     *         The request has failed validation due to missing required fields or having invalid inputs.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.</p>
     *         <p>
     *         For <code>Enable</code>, you receive this error if you attempt to use a feature in an unsupported Amazon
     *         Web Services Region.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws InternalServerException
     *         The request has failed due to an internal failure of the Amazon Inspector service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Inspector2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Inspector2Client.UpdateConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/UpdateConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateConfigurationResponse updateConfiguration(
            Consumer<UpdateConfigurationRequest.Builder> updateConfigurationRequest) throws ValidationException,
            AccessDeniedException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException,
            Inspector2Exception {
        return updateConfiguration(UpdateConfigurationRequest.builder().applyMutation(updateConfigurationRequest).build());
    }

    /**
     * <p>
     * Activates, deactivates Amazon Inspector deep inspection, or updates custom paths for your account.
     * </p>
     *
     * @param updateEc2DeepInspectionConfigurationRequest
     * @return Result of the UpdateEc2DeepInspectionConfiguration operation returned by the service.
     * @throws ValidationException
     *         The request has failed validation due to missing required fields or having invalid inputs.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.</p>
     *         <p>
     *         For <code>Enable</code>, you receive this error if you attempt to use a feature in an unsupported Amazon
     *         Web Services Region.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws InternalServerException
     *         The request has failed due to an internal failure of the Amazon Inspector service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Inspector2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Inspector2Client.UpdateEc2DeepInspectionConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/UpdateEc2DeepInspectionConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateEc2DeepInspectionConfigurationResponse updateEc2DeepInspectionConfiguration(
            UpdateEc2DeepInspectionConfigurationRequest updateEc2DeepInspectionConfigurationRequest) throws ValidationException,
            AccessDeniedException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException,
            Inspector2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Activates, deactivates Amazon Inspector deep inspection, or updates custom paths for your account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link UpdateEc2DeepInspectionConfigurationRequest.Builder} avoiding the need to create one manually via
     * {@link UpdateEc2DeepInspectionConfigurationRequest#builder()}
     * </p>
     *
     * @param updateEc2DeepInspectionConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.inspector2.model.UpdateEc2DeepInspectionConfigurationRequest.Builder}
     *        to create a request.
     * @return Result of the UpdateEc2DeepInspectionConfiguration operation returned by the service.
     * @throws ValidationException
     *         The request has failed validation due to missing required fields or having invalid inputs.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.</p>
     *         <p>
     *         For <code>Enable</code>, you receive this error if you attempt to use a feature in an unsupported Amazon
     *         Web Services Region.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws InternalServerException
     *         The request has failed due to an internal failure of the Amazon Inspector service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Inspector2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Inspector2Client.UpdateEc2DeepInspectionConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/UpdateEc2DeepInspectionConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateEc2DeepInspectionConfigurationResponse updateEc2DeepInspectionConfiguration(
            Consumer<UpdateEc2DeepInspectionConfigurationRequest.Builder> updateEc2DeepInspectionConfigurationRequest)
            throws ValidationException, AccessDeniedException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, Inspector2Exception {
        return updateEc2DeepInspectionConfiguration(UpdateEc2DeepInspectionConfigurationRequest.builder()
                .applyMutation(updateEc2DeepInspectionConfigurationRequest).build());
    }

    /**
     * <p>
     * Updates an encryption key. A <code>ResourceNotFoundException</code> means that an Amazon Web Services owned key
     * is being used for encryption.
     * </p>
     *
     * @param updateEncryptionKeyRequest
     * @return Result of the UpdateEncryptionKey operation returned by the service.
     * @throws ValidationException
     *         The request has failed validation due to missing required fields or having invalid inputs.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.</p>
     *         <p>
     *         For <code>Enable</code>, you receive this error if you attempt to use a feature in an unsupported Amazon
     *         Web Services Region.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws ResourceNotFoundException
     *         The operation tried to access an invalid resource. Make sure the resource is specified correctly.
     * @throws InternalServerException
     *         The request has failed due to an internal failure of the Amazon Inspector service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Inspector2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Inspector2Client.UpdateEncryptionKey
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/UpdateEncryptionKey"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateEncryptionKeyResponse updateEncryptionKey(UpdateEncryptionKeyRequest updateEncryptionKeyRequest)
            throws ValidationException, AccessDeniedException, ThrottlingException, ResourceNotFoundException,
            InternalServerException, AwsServiceException, SdkClientException, Inspector2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates an encryption key. A <code>ResourceNotFoundException</code> means that an Amazon Web Services owned key
     * is being used for encryption.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateEncryptionKeyRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateEncryptionKeyRequest#builder()}
     * </p>
     *
     * @param updateEncryptionKeyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.inspector2.model.UpdateEncryptionKeyRequest.Builder} to create a
     *        request.
     * @return Result of the UpdateEncryptionKey operation returned by the service.
     * @throws ValidationException
     *         The request has failed validation due to missing required fields or having invalid inputs.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.</p>
     *         <p>
     *         For <code>Enable</code>, you receive this error if you attempt to use a feature in an unsupported Amazon
     *         Web Services Region.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws ResourceNotFoundException
     *         The operation tried to access an invalid resource. Make sure the resource is specified correctly.
     * @throws InternalServerException
     *         The request has failed due to an internal failure of the Amazon Inspector service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Inspector2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Inspector2Client.UpdateEncryptionKey
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/UpdateEncryptionKey"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateEncryptionKeyResponse updateEncryptionKey(
            Consumer<UpdateEncryptionKeyRequest.Builder> updateEncryptionKeyRequest) throws ValidationException,
            AccessDeniedException, ThrottlingException, ResourceNotFoundException, InternalServerException, AwsServiceException,
            SdkClientException, Inspector2Exception {
        return updateEncryptionKey(UpdateEncryptionKeyRequest.builder().applyMutation(updateEncryptionKeyRequest).build());
    }

    /**
     * <p>
     * Specifies the action that is to be applied to the findings that match the filter.
     * </p>
     *
     * @param updateFilterRequest
     * @return Result of the UpdateFilter operation returned by the service.
     * @throws ValidationException
     *         The request has failed validation due to missing required fields or having invalid inputs.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.</p>
     *         <p>
     *         For <code>Enable</code>, you receive this error if you attempt to use a feature in an unsupported Amazon
     *         Web Services Region.
     * @throws ResourceNotFoundException
     *         The operation tried to access an invalid resource. Make sure the resource is specified correctly.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws InternalServerException
     *         The request has failed due to an internal failure of the Amazon Inspector service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Inspector2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Inspector2Client.UpdateFilter
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/UpdateFilter" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateFilterResponse updateFilter(UpdateFilterRequest updateFilterRequest) throws ValidationException,
            AccessDeniedException, ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, Inspector2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Specifies the action that is to be applied to the findings that match the filter.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateFilterRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateFilterRequest#builder()}
     * </p>
     *
     * @param updateFilterRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.inspector2.model.UpdateFilterRequest.Builder} to create a request.
     * @return Result of the UpdateFilter operation returned by the service.
     * @throws ValidationException
     *         The request has failed validation due to missing required fields or having invalid inputs.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.</p>
     *         <p>
     *         For <code>Enable</code>, you receive this error if you attempt to use a feature in an unsupported Amazon
     *         Web Services Region.
     * @throws ResourceNotFoundException
     *         The operation tried to access an invalid resource. Make sure the resource is specified correctly.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws InternalServerException
     *         The request has failed due to an internal failure of the Amazon Inspector service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Inspector2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Inspector2Client.UpdateFilter
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/UpdateFilter" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateFilterResponse updateFilter(Consumer<UpdateFilterRequest.Builder> updateFilterRequest)
            throws ValidationException, AccessDeniedException, ResourceNotFoundException, ThrottlingException,
            InternalServerException, AwsServiceException, SdkClientException, Inspector2Exception {
        return updateFilter(UpdateFilterRequest.builder().applyMutation(updateFilterRequest).build());
    }

    /**
     * <p>
     * Updates the Amazon Inspector deep inspection custom paths for your organization. You must be an Amazon Inspector
     * delegated administrator to use this API.
     * </p>
     *
     * @param updateOrgEc2DeepInspectionConfigurationRequest
     * @return Result of the UpdateOrgEc2DeepInspectionConfiguration operation returned by the service.
     * @throws ValidationException
     *         The request has failed validation due to missing required fields or having invalid inputs.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.</p>
     *         <p>
     *         For <code>Enable</code>, you receive this error if you attempt to use a feature in an unsupported Amazon
     *         Web Services Region.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws InternalServerException
     *         The request has failed due to an internal failure of the Amazon Inspector service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Inspector2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Inspector2Client.UpdateOrgEc2DeepInspectionConfiguration
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/UpdateOrgEc2DeepInspectionConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateOrgEc2DeepInspectionConfigurationResponse updateOrgEc2DeepInspectionConfiguration(
            UpdateOrgEc2DeepInspectionConfigurationRequest updateOrgEc2DeepInspectionConfigurationRequest)
            throws ValidationException, AccessDeniedException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, Inspector2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the Amazon Inspector deep inspection custom paths for your organization. You must be an Amazon Inspector
     * delegated administrator to use this API.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link UpdateOrgEc2DeepInspectionConfigurationRequest.Builder} avoiding the need to create one manually via
     * {@link UpdateOrgEc2DeepInspectionConfigurationRequest#builder()}
     * </p>
     *
     * @param updateOrgEc2DeepInspectionConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.inspector2.model.UpdateOrgEc2DeepInspectionConfigurationRequest.Builder}
     *        to create a request.
     * @return Result of the UpdateOrgEc2DeepInspectionConfiguration operation returned by the service.
     * @throws ValidationException
     *         The request has failed validation due to missing required fields or having invalid inputs.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.</p>
     *         <p>
     *         For <code>Enable</code>, you receive this error if you attempt to use a feature in an unsupported Amazon
     *         Web Services Region.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws InternalServerException
     *         The request has failed due to an internal failure of the Amazon Inspector service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Inspector2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Inspector2Client.UpdateOrgEc2DeepInspectionConfiguration
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/UpdateOrgEc2DeepInspectionConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateOrgEc2DeepInspectionConfigurationResponse updateOrgEc2DeepInspectionConfiguration(
            Consumer<UpdateOrgEc2DeepInspectionConfigurationRequest.Builder> updateOrgEc2DeepInspectionConfigurationRequest)
            throws ValidationException, AccessDeniedException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, Inspector2Exception {
        return updateOrgEc2DeepInspectionConfiguration(UpdateOrgEc2DeepInspectionConfigurationRequest.builder()
                .applyMutation(updateOrgEc2DeepInspectionConfigurationRequest).build());
    }

    /**
     * <p>
     * Updates the configurations for your Amazon Inspector organization.
     * </p>
     *
     * @param updateOrganizationConfigurationRequest
     * @return Result of the UpdateOrganizationConfiguration operation returned by the service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.</p>
     *         <p>
     *         For <code>Enable</code>, you receive this error if you attempt to use a feature in an unsupported Amazon
     *         Web Services Region.
     * @throws ValidationException
     *         The request has failed validation due to missing required fields or having invalid inputs.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws InternalServerException
     *         The request has failed due to an internal failure of the Amazon Inspector service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Inspector2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Inspector2Client.UpdateOrganizationConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/UpdateOrganizationConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateOrganizationConfigurationResponse updateOrganizationConfiguration(
            UpdateOrganizationConfigurationRequest updateOrganizationConfigurationRequest) throws AccessDeniedException,
            ValidationException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException,
            Inspector2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the configurations for your Amazon Inspector organization.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateOrganizationConfigurationRequest.Builder}
     * avoiding the need to create one manually via {@link UpdateOrganizationConfigurationRequest#builder()}
     * </p>
     *
     * @param updateOrganizationConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.inspector2.model.UpdateOrganizationConfigurationRequest.Builder} to
     *        create a request.
     * @return Result of the UpdateOrganizationConfiguration operation returned by the service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.</p>
     *         <p>
     *         For <code>Enable</code>, you receive this error if you attempt to use a feature in an unsupported Amazon
     *         Web Services Region.
     * @throws ValidationException
     *         The request has failed validation due to missing required fields or having invalid inputs.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws InternalServerException
     *         The request has failed due to an internal failure of the Amazon Inspector service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Inspector2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Inspector2Client.UpdateOrganizationConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/UpdateOrganizationConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateOrganizationConfigurationResponse updateOrganizationConfiguration(
            Consumer<UpdateOrganizationConfigurationRequest.Builder> updateOrganizationConfigurationRequest)
            throws AccessDeniedException, ValidationException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, Inspector2Exception {
        return updateOrganizationConfiguration(UpdateOrganizationConfigurationRequest.builder()
                .applyMutation(updateOrganizationConfigurationRequest).build());
    }

    /**
     * Create a {@link Inspector2Client} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static Inspector2Client create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link Inspector2Client}.
     */
    static Inspector2ClientBuilder builder() {
        return new DefaultInspector2ClientBuilder();
    }

    static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of(SERVICE_METADATA_ID);
    }

    @Override
    default Inspector2ServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }
}
